/* 
 * $Id: db_mod.c,v 1.11 2002/09/19 12:23:54 jku Rel $ 
 *
 * MySQL module interface
 *
 * Copyright (C) 2001-2003 Fhg Fokus
 *
 * This file is part of ser, a free SIP server.
 *
 * ser is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * For a license to use the ser software under conditions
 * other than those described here, or to purchase support for this
 * software, please contact iptel.org by e-mail at the following addresses:
 *    info@iptel.org
 *
 * ser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "../../sr_module.h"
#include <stdio.h>
#include "dbase.h"


static int mod_init(void);


/*
 * MySQL database module interface
 */

struct module_exports exports = {	
	"mysql",
	(char*[]) {
		"~db_use_table",
		"~db_init",
		"~db_close",
		"~db_query",
		"~db_free_query",
		"~db_insert",
		"~db_delete",
		"~db_update"
	},
	(cmd_function[]) {
		(cmd_function)use_table,
		(cmd_function)db_init,
		(cmd_function)db_close,
		(cmd_function)db_query,
		(cmd_function)db_free_query,
		(cmd_function)db_insert,
		(cmd_function)db_delete,
		(cmd_function)db_update
	},
	(int[]) {
                2, 1, 2, 2, 2, 2, 2, 2
	},
	(fixup_function[]) {
		0, 0, 0, 0, 0, 0, 0, 0
	},
	8, /* number of functions*/

	0,   /* Module parameter names */
	0,   /* Module parameter types */
	0,   /* Module parameter variable pointers */
	0,   /* Number of module paramers */

	mod_init, /* module initialization function */
	0,        /* response function*/
	0,        /* destroy function */
	0,        /* oncancel function */
	0         /* per-child init function */
};


static int mod_init(void)
{
	fprintf(stderr, "mysql - initializing\n");
	return 0;
}
