/*
 *
 * eXtended JABber module
 *
 *
 * Copyright (C) 2001-2003 Fhg Fokus
 *
 * This file is part of ser, a free SIP server.
 *
 * ser is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * For a license to use the ser software under conditions
 * other than those described here, or to purchase support for this
 * software, please contact iptel.org by e-mail at the following addresses:
 *    info@iptel.org
 *
 * ser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _XJAB_WORKER_H_
#define _XJAB_WORKER_H_

#include "../../str.h"
#include "../../db/db.h"
#include "../tm/tm_load.h"

#include "xjab_jcon.h"
#include "tree234.h"
#include "lock.h"

/**********             ***/
typedef struct _xj_jalias
{
	int size;
	str *jdm;
	str *a;
} t_xj_jalias, *xj_jalias;

typedef struct _xj_worker
{
	int pid;			// process id
	int wpipe;			// communication pipe - write
	int rpipe;			// communication pipe - read
	int nr;				// number of jobs
	tree234 *sip_ids;   // sip ids allocated for the worker
} t_xj_worker, *xj_worker;

typedef struct _xj_wlist
{
	int len;   			// length of the list
	int maxj;			// maximum jobs / worker
	int cachet;
	int delayt;
	int sleept;
	str *contact_h;		// contact header
    smart_lock	*sems;	 // semaphores
	xj_jalias	aliases; // addess aliases
	xj_worker	workers; // the list of workers
} t_xj_wlist, *xj_wlist;

/**********   LOOK AT IMPLEMENTATION OF FUNCTIONS FOR DESCRIPTION    ***/

xj_wlist xj_wlist_init(int **, int, int, int, int, int);
int  xj_wlist_init_contact(xj_wlist, char *);
int  xj_wlist_set_pid(xj_wlist, int, int);
int  xj_wlist_get(xj_wlist, xj_jkey, xj_jkey*);
int  xj_wlist_check(xj_wlist, xj_jkey, xj_jkey*);
void xj_wlist_del(xj_wlist, xj_jkey, int);
void xj_wlist_free(xj_wlist);
int  xj_wlist_set_aliases(xj_wlist, char *, char *);
int  xj_wlist_send_info(xj_wlist, int); 

int xj_worker_process(xj_wlist, char*, int, int, db_con_t*);

int xj_address_translation(str *src, str *dst, xj_jalias als, int flag);
int xj_manage_jab(char *buf, int len, int *pos, str *sct, 
			xj_jalias als, xj_jcon jbc);

void xj_sig_handler(int s);

/**********             ***/

int xj_send_sip_msg(str *, str *, str *, str *, int *);
int xj_send_sip_msgz(str *, str *, str *, char *, int *);
void xj_tuac_callback(struct cell *, struct sip_msg *,
			int, void *);

#endif

