#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <strings.h>
#include <pthread.h>
#include <libnet.h>
#include <pcap.h>
#include <sys/utsname.h>

#define VERSION		"v1.0"

#define DNS		(1)
#define ARP		(1 << 1)
#define LATENCY		(1 << 2)
#define ETHERPING	(1 << 3)

struct host_info {
  char *ip;
  unsigned long ip_addr;
  int results, methods;
  struct host_info *next;
};

struct sentinel {
  int size, positive, method;
  struct host_info *tail;
  struct host_info *head;
};

struct netinit {
  char *iface;
  int datalink, offset, num;
  unsigned long src_ipaddr;
  struct ether_addr src_hwaddr;
};

extern struct netinit netinit;

void arp_send(void *);
void arp_sniff(void *);

void icmp_send(void *);
void icmp_sniff(void *);

void dns_sniff(void *);
void dns_flood(void);

void net_init();
pcap_t *pcap_init(char *, int);
void sentinel_init(struct sentinel *, int);
void init_classc(struct sentinel *, char *, int);
int init_host(struct sentinel *, char *, int);
void init_ipfile(struct sentinel *, char *, int);

void report(struct sentinel *);
void detect_promisc(struct sentinel *);
void sentinel_list_insert(struct sentinel *, char *);
