#include <sentinel.h>

pcap_t *pcap_init(char *filter, int promisc)
{
  pcap_t *pd;
  char errbuf[1024];
  struct bpf_program bpf_program;
  unsigned int network, netmask;

  pcap_lookupnet(netinit.iface, &network, &netmask, errbuf);

  pd = pcap_open_live(netinit.iface, 1024, promisc, 1024, errbuf);
  if(!pd) {
    puts("Error: Cannot initialize pcap descriptor");
    puts(errbuf);
    exit(-1);
  }

  if(pcap_compile(pd, &bpf_program, filter, 0, netmask) < 0) {
    puts("Error: Cannot compile bpf filter");
    exit(-1);
  }

  if(pcap_setfilter(pd, &bpf_program) < 0) {
    puts("Error: Cannot set bpf filter");
    exit(-1);
  }

  return(pd);
}

void net_init()
{
  int i;
  pcap_t *pd;
  char errbuf[1024], *tmp;
  struct libnet_link_int link_int;

  if(netinit.iface == NULL)
    netinit.iface = strdup(pcap_lookupdev(errbuf));
  if(netinit.iface == NULL) {
    puts("Error: Unable to initialize network device");
    exit(-1);
  }

  pd = pcap_open_live(netinit.iface, 0, 0, 0, errbuf);
  if(!pd) {
    printf("Error: Unable to open device '%s'\n", netinit.iface);
    exit(-1);
  }

  netinit.datalink = pcap_datalink(pd);

  pcap_close(pd);

  switch(netinit.datalink) {
    case DLT_EN10MB:
      netinit.offset = 14; 
      break;
    default: 
      printf("Device '%s' uses unsupported datalink\n", netinit.iface);
      exit(-1);
  }

  i = libnet_get_ipaddr(&link_int, netinit.iface, errbuf);
  if(!i) {
    printf("Error: Cannot get IP address from '%s'\n", netinit.iface);
    exit(-1);
  } 

  tmp = libnet_host_lookup(ntohl(i), 0);
  netinit.src_ipaddr = libnet_name_resolve(tmp, 0);
  memcpy(&netinit.src_hwaddr, 
    libnet_get_hwaddr(&link_int, netinit.iface, errbuf), 
      sizeof(struct ether_addr));

}

void init_classc(struct sentinel *sentinel, char *class_c, int method)
{
  int i;
  char ip_addr[16];
  struct sockaddr_in sin;

  sentinel_init(sentinel, method);

  for(i = 1; i < 256; i++) {
    snprintf(ip_addr, 16, "%s.%i", class_c, i);
    if(!inet_aton(ip_addr, &sin.sin_addr))
      break;
    sentinel_list_insert(sentinel, ip_addr);
  }
}

int init_host(struct sentinel *sentinel, char *host, int method)
{
  struct sockaddr_in sin;
  struct in_addr addr;
  char *ip_addr;

  addr.s_addr = libnet_name_resolve(host, 1);
  ip_addr =  inet_ntoa(addr);

  if(!inet_aton(ip_addr, &sin.sin_addr))
    return(-1);

  if(strstr(ip_addr, "255.255.255.255")) {
    puts("Error: Unable to resolve hostname");
    return(-1);
  }

  sentinel_init(sentinel, method);
  sentinel_list_insert(sentinel, ip_addr);
  return(0);
}

void init_ipfile(struct sentinel *sentinel, char *filename, int method)
{
  FILE *file;
  char buf[80], *ip;
  struct sockaddr_in sin;

  file = fopen(filename, "r");
  if(!file) {
    printf("Error: Cannot open '%s'\n", filename);
    exit(-1);
  }

  sentinel_init(sentinel, method);

  for(;;) {
    memset(buf, 0, sizeof(buf));

    if(feof(file))
      break;

    fgets(buf, sizeof(buf), file);

    if(*buf == NULL)
      continue;

    ip = strtok(buf, "\n");
 
    if(!ip)
      continue; 
 
    if(!inet_aton(ip, &sin.sin_addr))
      continue;

    sentinel_list_insert(sentinel, ip);
  }
  fclose(file);
}
