#include <sentinel.h>

extern pthread_mutex_t th_mutex;
extern pthread_mutex_t local_mutex;
extern int tag;       

void icmp_sniff(void *data)
{
  pcap_t *pd;
  unsigned char *pkt, filter[1024];
  struct in_addr addr;
  struct pcap_pkthdr pcap_h;
  struct libnet_ip_hdr *ip;
  struct libnet_icmp_hdr *icmp;
  struct host_info *host_info;

  host_info = (struct host_info *)data;
  addr.s_addr = host_info->ip_addr;

  memset(filter, 0, sizeof(filter));
  snprintf(filter, sizeof(filter), "icmp and src host %s", host_info->ip);

  pd = pcap_init(filter, 0);

  for(;;) {
    usleep(100);

    pthread_mutex_lock(&local_mutex);
    if(tag)
      break;
    pthread_mutex_unlock(&local_mutex);

    pkt = (unsigned char *)pcap_next(pd, &pcap_h);
    if(!pkt)
      continue;

    ip = (struct libnet_ip_hdr *)(pkt + netinit.offset);
    icmp = (struct libnet_icmp_hdr *)(pkt + netinit.offset + LIBNET_IP_H);

    if(icmp->icmp_type == 0) {
      if(ntohs(icmp->icmp_id) == 0x7a69) {
        host_info->results = 1;
        pthread_mutex_lock(&local_mutex);
        tag++;
        pthread_mutex_unlock(&local_mutex);
        break;
      }
    }
  }
  pcap_close(pd);
  pthread_exit(0);
}
                    
void icmp_send(void *data)
{
  int i;
  unsigned char *pkt, errbuf[1024];
  unsigned char fke_hwaddr[6] = { 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 };
  struct host_info *host_info;
  struct libnet_link_int *link_int;

  host_info = (struct host_info *)data;

  link_int = libnet_open_link_interface(netinit.iface, errbuf);
  if(!link_int) {
    puts("Error: Could not open link interface");
    exit(-1);
  }

  if(libnet_init_packet(LIBNET_ICMP_ECHO_H + LIBNET_ETH_H +
                          LIBNET_IP_H, &pkt) < 0) {
    puts("Error: Could not allocate memory for packet");
    exit(-1);
  }       


  libnet_build_ethernet(fke_hwaddr, fke_hwaddr, ETHERTYPE_IP, NULL, 0, pkt);

  libnet_build_ip(LIBNET_ICMP_ECHO_H, 0, 100, 0, 64, IPPROTO_ICMP,
    netinit.src_ipaddr, host_info->ip_addr, NULL, 0, pkt + LIBNET_ETH_H);

  libnet_build_icmp_echo(ICMP_ECHO, 0, 0x7a69, 1, NULL, 0, pkt +
    LIBNET_IP_H + LIBNET_ETH_H);

  libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H);
  libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_ICMP,LIBNET_ICMP_ECHO_H);

  for(i = 0; i < netinit.num; i++) {
    putchar('.');
    usleep(100);

    pthread_mutex_lock(&local_mutex);
    if(tag)
      break;
    pthread_mutex_unlock(&local_mutex);

    libnet_write_link_layer(link_int, netinit.iface, pkt, 
      LIBNET_ICMP_H + LIBNET_IP_H + LIBNET_ETH_H + 4);
  }

  tag++;
  libnet_destroy_packet(&pkt);
  libnet_close_link_interface(link_int);
  pthread_exit(0);
}         
                             
