/* $Id: dns.c,v 1.2 2000/04/22 07:12:52 bind Exp $ */

#include "sentinel.h"

char dnsname[255];

int process_dns(char *);
void nameformat(char *, char *);

void *dns_sniff(void)
{
  pcap_t *socket;
  char *pkt;
  struct bpf_program prog;
  struct pcap_pkthdr pcap_h;
  unsigned int network, netmask, temp;

  bzero(&pthread_mutex,sizeof(pthread_mutex));

  pcap_lookupnet(device, &network, &netmask, errbuf);

  socket = pcap_open_live(device, 128, 1, 1024, errbuf);
  if(socket == NULL) {
    perror("pcap_open_live");
    exit(1);
  }
 
  pcap_compile(socket, &prog, "udp dst port 53", 0, netmask);
  
  pcap_setfilter(socket, &prog);

  while(1) {
    usleep(1000);
 
    pkt = (u_char *)pcap_next(socket, &pcap_h);

    if(pkt != NULL)
      if(process_dns(pkt) == 1) {
        pcap_close(socket);
        pthread_mutex_lock(&pthread_mutex);
        tag = 1;
        pthread_mutex_unlock(&pthread_mutex); 
        result("dns",1);
	pthread_exit(0);
      }
  pthread_mutex_lock(&pthread_mutex);
  temp = tag;
  pthread_mutex_unlock(&pthread_mutex);
  if(temp == 2)
    break;
  }
 
  pcap_close(socket);
  result("dns",0);
  pthread_exit(0);  
}

int process_dns(char *pkt)
{
  struct ip_header *ip;
  struct udp_header *udp;
  struct dns_header *dns;
  char *data, *host;
  char names[100];
  int count;

  ip = (struct ip_header *) (pkt + offset);
  udp = (struct udp_header *) (pkt + offset + IPHDRSIZE);
  dns = (struct dns_header *) (pkt + offset + IPHDRSIZE + UDPHDRSIZE);
  data = (char *) (pkt + offset + IPHDRSIZE + UDPHDRSIZE + DNSHDRSIZE);

  memset(names,'\0',sizeof(names));
   
  if(ip->ip_p == 17) {
    if(ntohs(udp->uh_dport) == 53) {
      host = inet_ntoa(ip->ip_src);
      if(strstr(host,dst) == NULL) return 0;
#ifdef DEBUG
      printf("\n\ndns id: %d\n", ntohs(dns->id));
      printf("response flag: %d\n", dns->qr);
      printf("response code: %d\n",dns->rcode);
      printf("opcode: %d\n", dns->opcode);
      printf("recursion: %d\n", dns->rd);
      printf("truncated message: %d\n", dns->tc);
      printf("authoritive answer: %d\n", dns->aa);
      printf("count: %d\n", htons(dns->que_num));
#endif

  if(!dns->que_num) return 0;

      count = (char)*data;

      while(count) { 
        (char *)data++;
        strncat(names, (char *)data, count);
        data += count;
        count = (char)*data;
        strncat(names,".",sizeof(names) - strlen(names));
      }

      names[strlen(names)-1] = '\0';

      if(strstr(names,dnsname) != NULL) { 
#ifdef DEBUG
      printf("\nResolve: %s Size = %d\n",names,strlen(names));
      printf("Match: %s Size = %d",dnsname, strlen(dnsname));
#endif
     return 1;
     }
    }
  }
  return 0;
}

void dns_generate(char *host)
{
  struct sockaddr_in test;
  char *ip;
  int A1, A2, A3, A4;

  if(!inet_aton(host,&test.sin_addr)) {
    printf("You must specify a valid ip for the fake host\n");
    exit(1);
  }

  ip = strtok(host,".");
  A1 = atoi(ip);
  ip = strtok(NULL,".");
  A2 = atoi(ip);
  ip = strtok(NULL,".");
  A3 = atoi(ip);
  ip = strtok(NULL,".");
  A4 = atoi(ip);

  sprintf(dnsname,"%d.%d.%d.%d.in-addr.arpa",A4,A3,A2,A1);
  return;
}

