%{
/*	$Id: parse.y,v 1.4 2007/01/26 11:16:10 mbalmer Exp $	*/

/*
 * Copyright (c) 2006 Marc Balmer <marc@msys.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>

#include <ctype.h>
#include <err.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

char *_cfgfile;

extern char *vnd_dev;
extern char *vnd_part;
extern char *vnd_type;
extern char *vnd_file;
extern char *mp1, *mp2;

extern FILE	*yyin;
extern int	 yylineno;
extern char	*yytext;

int	yyerror(const char *, ...);
int	yyparse(void);
int	yylex(void);

static int 	 yyerrcnt;

%}

%union {
	long	 number;
	char	*string;
}

%token	VND_DEV VND_PART VND_TYPE VND_FILE
%token	PRIMARY_MOUNTPOINT SECONDARY_MOUNTPOINT
%token	<string>	NUMBER
%token	<string>	TEXT

%%
statement	: /* empty */
		| statement '\n'
		| statement vnd_dev '\n'
		| statement vnd_part '\n'
		| statement vnd_type '\n'
		| statement vnd_file '\n'
		| statement primary_mountpoint '\n'
		| statement secondary_mountpoint '\n'
		;

vnd_dev		: VND_DEV '=' TEXT			{
			vnd_dev = $3;
		}
		;

vnd_part	: VND_PART '=' TEXT			{
			vnd_part = $3;
		}
		;

vnd_type	: VND_TYPE '=' TEXT			{
			vnd_type = $3;
		}
		;

vnd_file	: VND_FILE '=' TEXT			{
			vnd_file = $3;
		}
		;

primary_mountpoint	: PRIMARY_MOUNTPOINT '=' TEXT	{
				mp1 = $3;
			}
			;

secondary_mountpoint	: SECONDARY_MOUNTPOINT '=' TEXT	{
				mp2 = $3;
			}
			;

%%

void
seal_init(char *cfgfile)
{
	yylineno = 1;
	yyerrcnt = 0;
	_cfgfile = cfgfile;

	if ((yyin = fopen(cfgfile, "r")) != NULL) {
		while (!feof(yyin))
			yyparse();

		fclose(yyin);
	}
	if (yyerrcnt)
		errx(1, "configuration file contains errors, terminating");
}

int
yyerror(const char *fmt, ...)
{
	va_list		 ap;
	char		*nfmt;

	++yyerrcnt;
	va_start(ap, fmt);
	if (asprintf(&nfmt, "%s, line %d: %s near '%s'",
	    _cfgfile, yylineno, fmt, yytext) == -1)
		errx(1, "asprintf failed");
	fprintf(stderr, "%s\n", nfmt);
	va_end(ap);
	free(nfmt);
	return 0;
}
