/* @(#)sdd.c	1.22 97/05/15 Copyright 1984 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)sdd.c	1.22 97/05/15 Copyright 1984 J. Schilling";
#endif
/*	sdd	Disk and Tape copy		*/

/*
 *	Copyright (c) 1984 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <mconfig.h>
#include <stdio.h>
#include <standard.h>
#include <stdxlib.h>
#include <unixstd.h>
#include <signal.h>

#ifdef	BSD4_2
#	ifdef	SIGRELSE
#		define	signal	sigset	/* reliable signal */
#	else
#		define	HAVE_GETPAGESIZE
#	endif
#endif

#ifdef	JOS
#	include <error.h>
#	define	BAD		1
#else
#	include <errno.h>
#	include	<sys/time.h>
#	define	BAD		(-1)
#	define	ENDOFFILE	EFBIG
#endif

#ifdef	NO_LONGLONG
#undef	HAVE_LONGLONG
#endif
#ifdef	HAVE_LONGLONG
typedef	long long	Llong;
#else
typedef	unsigned long	Llong;	/* give maximum precision */
#endif

EXPORT	int	main		__PR((int ac, char** av));
LOCAL	void	intr		__PR((int sig));
LOCAL	FILE*	openfile	__PR((char* name, char* mode));
LOCAL	char*	memalloc	__PR((long size));
LOCAL	void	simple_copy	__PR((void));
LOCAL	void	copy_reblocked	__PR((void));
LOCAL	long	readvol		__PR((char* buf, long len));
LOCAL	long	writevol	__PR((char* buf, long len));
LOCAL	BOOL	next_in		__PR((void));
LOCAL	BOOL	next_out	__PR((void));
LOCAL	BOOL	next		__PR((char* fname, char* inout, FILE * f, long pos, int volnum));
LOCAL	BOOL	cont		__PR((char* inout, int num));
LOCAL	void	makelower	__PR((char* s));
LOCAL	long	readbuf		__PR((char* buf, long len));
LOCAL	long	writebuf	__PR((char* buf, long len));
LOCAL	long	readblocks	__PR((char* buf, long len));
LOCAL	long	writeblocks	__PR((char* buf, long len));
LOCAL	void	fill		__PR((char* bp, long start, long end));
LOCAL	void	swabb		__PR((char* bp, int cnt));
LOCAL	void	lcase		__PR((char* bp, long cnt));
LOCAL	void	ucase		__PR((char* bp, long cnt));
LOCAL	long	block		__PR((char* bp, long cnt));
LOCAL	long	unblock		__PR((char* bp, long cnt));
LOCAL	void	conv		__PR((char* bp, long cnt, unsigned char* tab));
LOCAL	void	term		__PR((int ret));
LOCAL	void	getstarttime	__PR((void));
LOCAL	void	prstats		__PR((void));
LOCAL	void	getopts		__PR((int ac, char** av));
LOCAL	long	number		__PR((char* arg, int* retp));
LOCAL	int	getnum		__PR((char* arg, long* valp));
LOCAL	void	usage		__PR((int ex));

#define min(a,b)	(a < b ? a : b)

#define	BSIZE		512L

#define	FILL		000001
#define	SWAB		000002
#define	LCASE		000004
#define	UCASE		000010
#define	BLOCK		000020
#define	UNBLOCK		000040
#define	ASCII		000100
#define	EBCDIC		000200
#define	IBM		000400
#define	NULLIN		010000
#define	NULLOUT		020000

char	*infile;
char	*outfile;

FILE	*fin;
FILE	*fout;
FILE	*tty;

long	ibs;
long	obs;
long	bs;
long	cbs;
long	count;
long	iseek;
long	oseek;
long	seek;
long	iskip;
long	oskip;
long	skip;
long	ivseek;
long	ovseek;
long	ivsize;
long	ovsize;
int	try	= 2;

long	irec;
long	orec;
long	iparts;
long	oparts;
long	ivpos;
long	ovpos;
int	ivolnum = 1;
int	ovolnum = 1;
long	readerrs;
long	writeerrs;
long	lastreaderrs;
#ifdef	BSD4_2
struct	timeval	starttime;
struct	timeval	stoptime;
#endif

int	flags;
BOOL	notrunc;
BOOL	progress;
BOOL	noerror;
BOOL	noerrwrite;
BOOL	noseek;
BOOL	debug;
BOOL	showtime;

/* ebcdic to ascii */
unsigned char	asctab[] = {
/*  0 */	0x00,	0x01,	0x02,	0x03,	0x9C,	0x09,	0x86,	0x7F,
/*  8 */	0x97,	0x8D,	0x8E,	0x0B,	0x0C,	0x0D,	0x0E,	0x0F,
/* 10 */	0x10,	0x11,	0x12,	0x13,	0x9D,	0x85,	0x08,	0x87,
/* 18 */	0x18,	0x19,	0x92,	0x8F,	0x1C,	0x1D,	0x1E,	0x1F,
/* 20 */	0x80,	0x81,	0x82,	0x83,	0x84,	0x0A,	0x17,	0x1B,
/* 28 */	0x88,	0x89,	0x8A,	0x8B,	0x8C,	0x05,	0x06,	0x07,
/* 30 */	0x90,	0x91,	0x16,	0x93,	0x94,	0x95,	0x96,	0x04,
/* 38 */	0x98,	0x99,	0x9A,	0x9B,	0x14,	0x15,	0x9E,	0x1A,
/* 40 */	0x20,	0xA0,	0xA1,	0xA2,	0xA3,	0xA4,	0xA5,	0xA6,
/* 48 */	0xA7,	0xA8,	0xD5,	0x2E,	0x3C,	0x28,	0x2B,	0x7C,
/* 50 */	0x26,	0xA9,	0xAA,	0xAB,	0xAC,	0xAD,	0xAE,	0xAF,
/* 58 */	0xB0,	0xB1,	0x21,	0x24,	0x2A,	0x29,	0x3B,	0x7E,
/* 60 */	0x2D,	0x2F,	0xB2,	0xB3,	0xB4,	0xB5,	0xB6,	0xB7,
/* 68 */	0xB8,	0xB9,	0xCB,	0x2C,	0x25,	0x5F,	0x3E,	0x3F,
/* 70 */	0xBA,	0xBB,	0xBC,	0xBD,	0xBE,	0xBF,	0xC0,	0xC1,
/* 78 */	0xC2,	0x60,	0x3A,	0x23,	0x40,	0x27,	0x3D,	0x22,
/* 80 */	0xC3,	0x61,	0x62,	0x63,	0x64,	0x65,	0x66,	0x67,
/* 88 */	0x68,	0x69,	0xC4,	0xC5,	0xC6,	0xC7,	0xC8,	0xC9,
/* 90 */	0xCA,	0x6A,	0x6B,	0x6C,	0x6D,	0x6E,	0x6F,	0x70,
/* 98 */	0x71,	0x72,	0x5E,	0xCC,	0xCD,	0xCE,	0xCF,	0xD0,
/* A0 */	0xD1,	0xE5,	0x73,	0x74,	0x75,	0x76,	0x77,	0x78,
/* A8 */	0x79,	0x7A,	0xD2,	0xD3,	0xD4,	0x5B,	0xD6,	0xD7,
/* B0 */	0xD8,	0xD9,	0xDA,	0xDB,	0xDC,	0xDD,	0xDE,	0xDF,
/* B8 */	0xE0,	0xE1,	0xE2,	0xE3,	0xE4,	0x5D,	0xE6,	0xE7,
/* C0 */	0x7B,	0x41,	0x42,	0x43,	0x44,	0x45,	0x46,	0x47,
/* C8 */	0x48,	0x49,	0xE8,	0xE9,	0xEA,	0xEB,	0xEC,	0xED,
/* D0 */	0x7D,	0x4A,	0x4B,	0x4C,	0x4D,	0x4E,	0x4F,	0x50,
/* D8 */	0x51,	0x52,	0xEE,	0xEF,	0xF0,	0xF1,	0xF2,	0xF3,
/* E0 */	0x5C,	0x9F,	0x53,	0x54,	0x55,	0x56,	0x57,	0x58,
/* E8 */	0x59,	0x5A,	0xF4,	0xF5,	0xF6,	0xF7,	0xF8,	0xF9,
/* F0 */	0x30,	0x31,	0x32,	0x33,	0x34,	0x35,	0x36,	0x37,
/* F8 */	0x38,	0x39,	0xFA,	0xFB,	0xFC,	0xFD,	0xFE,	0xFF,
};

/* ascii to ebcdic */

unsigned char	ebctab[] = {

/*	0	1	2	3	4	5	6	7	*/
/*  0	NUL(@)	SOH(A)	STX(B)	ETX(C)	EOT(D)	ENQ(E)	ACK(F)	BEL(G)	*/
	0x00,	0x01,	0x02,	0x03,	0x37,	0x2D,	0x2E,	0x2F,

/*  8	BS(H)	HT(I)	LF(J)	VT(K)	FF(L)	CR(M)	SO(N)	SI(O)	*/
	0x16,	0x05,	0x25,	0x0B,	0x0C,	0x0D,	0x0E,	0x0F,

/* 10	DLE(P)	DC1(Q)	DC2(R)	DC3(S)	DC4(T)	NAK(U)	SYN(V)	ETB(W)	*/
	0x10,	0x11,	0x12,	0x13,	0x3C,	0x3D,	0x32,	0x26,

/* 18	CAN(X)	EM(Y)	SUB(Z)	ESC([)	FS(\)	GS(])	RS(^)	US(_)	*/
	0x18,	0x19,	0x3F,	0x27,	0x1C,	0x1D,	0x1E,	0x1F,

/* 20	SP	!	"	#	$	%	&	'	*/
	0x40,	0x5A,	0x7F,	0x7B,	0x5B,	0x6C,	0x50,	0x7D,

/* 28	(	)	*	+	,	-	.	/	*/
	0x4D,	0x5D,	0x5C,	0x4E,	0x6B,	0x60,	0x4B,	0x61,

/* 30	0	1	2	3	4	5	6	7	*/
	0xF0,	0xF1,	0xF2,	0xF3,	0xF4,	0xF5,	0xF6,	0xF7,

/* 38	8	9	:	;	<	=	>	?	*/
	0xF8,	0xF9,	0x7A,	0x5E,	0x4C,	0x7E,	0x6E,	0x6F,

/* 40	@	A	B	C	D	E	F	G	*/
	0x7C,	0xC1,	0xC2,	0xC3,	0xC4,	0xC5,	0xC6,	0xC7,

/* 48	H	I	J	K	L	M	N	O	*/
	0xC8,	0xC9,	0xD1,	0xD2,	0xD3,	0xD4,	0xD5,	0xD6,

/* 50	P	Q	R	S	T	U	V	W	*/
	0xD7,	0xD8,	0xD9,	0xE2,	0xE3,	0xE4,	0xE5,	0xE6,

/* 58	X	Y	Z	[	\	]	^ ??	_	*/
	0xE7,	0xE8,	0xE9,	0xAD,	0xE0,	0xBD,	0x9A,	0x6D,

/* 60	`	a	b	c	d	e	f	g	*/
	0x79,	0x81,	0x82,	0x83,	0x84,	0x85,	0x86,	0x87,

/* 68	h	i	j	k	l	m	n	o	*/
	0x88,	0x89,	0x91,	0x92,	0x93,	0x94,	0x95,	0x96,

/* 70	p	q	r	s	t	u	v	w	*/
	0x97,	0x98,	0x99,	0xA2,	0xA3,	0xA4,	0xA5,	0xA6,

/* 78	x	y	z	{	|	}	~ ??	DEL	*/
	0xA7,	0xA8,	0xA9,	0xC0,	0x4F,	0xD0,	0x5F,	0x07,

/* 80	NUL(@)	SOH(A)	STX(B)	ETX(C)	EOT(D)	ENQ(E)	ACK(F)	BEL(G)	*/
	0xC3,	0x61,	0x62,	0x63,	0x64,	0x65,	0x66,	0x67,

/* 88	BS(H)	HT(I)	LF(J)	VT(K)	FF(L)	CR(M)	SO(N)	SI(O)	*/
	0x68,	0x69,	0xC4,	0xC5,	0xC6,	0xC7,	0xC8,	0xC9,

/* 90	DLE(P)	DC1(Q)	DC2(R)	DC3(S)	DC4(T)	NAK(U)	SYN(V)	ETB(W)	*/
	0xCA,	0x6A,	0x6B,	0x6C,	0x6D,	0x6E,	0x6F,	0x70,

/* 98	CAN(X)	EM(Y)	SUB(Z)	ESC([)	FS(\)	GS(])	RS(^)	US(_)	*/
	0x71,	0x72,	0x5E,	0xCC,	0xCD,	0xCE,	0xCF,	0xD0,

/* A0	SP	!	"	#	$	%	&	'	*/
	0xD1,	0xE5,	0x73,	0x74,	0x75,	0x76,	0x77,	0x78,

/* A8	(	)	*	+	,	-	.	/	*/
	0x79,	0x7A,	0xD2,	0xD3,	0xD4,	0x5B,	0xD6,	0xD7,

/* B0	0	1	2	3	4	5	6	7	*/
	0xD8,	0xD9,	0xDA,	0xDB,	0xDC,	0xDD,	0xDE,	0xDF,

/* B8	8	9	:	;	<	=	>	?	*/
	0xE0,	0xE1,	0xE2,	0xE3,	0xE4,	0x5D,	0xE6,	0xE7,

/* C0	@	A	B	C	D	E	F	G	*/
	0x7B,	0x41,	0x42,	0x43,	0x44,	0x45,	0x46,	0x47,

/* C8	H	I	J	K	L	M	N	O	*/
	0x48,	0x49,	0xE8,	0xE9,	0xEA,	0xEB,	0xEC,	0xED,

/* D0	P	Q	R	S	T	U	V	W	*/
	0x7D,	0x4A,	0x4B,	0x4C,	0x4D,	0x4E,	0x4F,	0x50,

/* D8	X	Y	Z	[	\	]	^	_	*/
	0x51,	0x52,	0xEE,	0xEF,	0xF0,	0xF1,	0xF2,	0xF3,

/* E0	`	a	b	c	d	e	f	g	*/
	0x5C,	0x9F,	0x53,	0x54,	0x55,	0x56,	0x57,	0x58,

/* E8	h	i	j	k	l	m	n	o	*/
	0x59,	0x5A,	0xF4,	0xF5,	0xF6,	0xF7,	0xF8,	0xF9,

/* F0	p	q	r	s	t	u	v	w	*/
	0x30,	0x31,	0x32,	0x33,	0x34,	0x35,	0x36,	0x37,

/* F8	x	y	z	{	|	}	~	DEL	*/
	0x38,	0x39,	0xFA,	0xFB,	0xFC,	0xFD,	0xFE,	0xFF,
};

/* ascii to ibm */
unsigned char	ibmtab[] = {

/*	0	1	2	3	4	5	6	7	*/
/*  0	NUL(@)	SOH(A)	STX(B)	ETX(C)	EOT(D)	ENQ(E)	ACK(F)	BEL(G)	*/
	0x00,	0x01,	0x02,	0x03,	0x37,	0x2D,	0x2E,	0x2F,

/*  8	BS(H)	HT(I)	LF(J)	VT(K)	FF(L)	CR(M)	SO(N)	SI(O)	*/
	0x16,	0x05,	0x25,	0x0B,	0x0C,	0x0D,	0x0E,	0x0F,

/* 10	DLE(P)	DC1(Q)	DC2(R)	DC3(S)	DC4(T)	NAK(U)	SYN(V)	ETB(W)	*/
	0x10,	0x11,	0x12,	0x13,	0x3C,	0x3D,	0x32,	0x26,

/* 18	CAN(X)	EM(Y)	SUB(Z)	ESC([)	FS(\)	GS(])	RS(^)	US(_)	*/
	0x18,	0x19,	0x3F,	0x27,	0x1C,	0x1D,	0x1E,	0x1F,

/* 20	SP	!	"	#	$	%	&	'	*/
	0x40,	0x5A,	0x7F,	0x7B,	0x5B,	0x6C,	0x50,	0x7D,

/* 28	(	)	*	+	,	-	.	/	*/
	0x4D,	0x5D,	0x5C,	0x4E,	0x6B,	0x60,	0x4B,	0x61,

/* 30	0	1	2	3	4	5	6	7	*/
	0xF0,	0xF1,	0xF2,	0xF3,	0xF4,	0xF5,	0xF6,	0xF7,

/* 38	8	9	:	;	<	=	>	?	*/
	0xF8,	0xF9,	0x7A,	0x5E,	0x4C,	0x7E,	0x6E,	0x6F,

/* 40	@	A	B	C	D	E	F	G	*/
	0x7C,	0xC1,	0xC2,	0xC3,	0xC4,	0xC5,	0xC6,	0xC7,

/* 48	H	I	J	K	L	M	N	O	*/
	0xC8,	0xC9,	0xD1,	0xD2,	0xD3,	0xD4,	0xD5,	0xD6,

/* 50	P	Q	R	S	T	U	V	W	*/
	0xD7,	0xD8,	0xD9,	0xE2,	0xE3,	0xE4,	0xE5,	0xE6,

/* 58	X	Y	Z	[	\	]	^	_	*/
	0xE7,	0xE8,	0xE9,	0xAD,	0xE0,	0xBD,	0x5F,	0x6D,

/* 60	`	a	b	c	d	e	f	g	*/
	0x79,	0x81,	0x82,	0x83,	0x84,	0x85,	0x86,	0x87,

/* 68	h	i	j	k	l	m	n	o	*/
	0x88,	0x89,	0x91,	0x92,	0x93,	0x94,	0x95,	0x96,

/* 70	p	q	r	s	t	u	v	w	*/
	0x97,	0x98,	0x99,	0xA2,	0xA3,	0xA4,	0xA5,	0xA6,

/* 78	x	y	z	{	|	}	~	DEL	*/
	0xA7,	0xA8,	0xA9,	0xC0,	0x4F,	0xD0,	0xA1,	0x07,

/* 80	NUL(@)	SOH(A)	STX(B)	ETX(C)	EOT(D)	ENQ(E)	ACK(F)	BEL(G)	*/
	0x20,	0x21,	0x22,	0x23,	0x24,	0x15,	0x06,	0x17,

/* 88	BS(H)	HT(I)	LF(J)	VT(K)	FF(L)	CR(M)	SO(N)	SI(O)	*/
	0x28,	0x29,	0x2A,	0x2B,	0x2C,	0x09,	0x0A,	0x1B,

/* 90	DLE(P)	DC1(Q)	DC2(R)	DC3(S)	DC4(T)	NAK(U)	SYN(V)	ETB(W)	*/
	0x30,	0x31,	0x1A,	0x33,	0x34,	0x35,	0x36,	0x0B,

/* 98	CAN(X)	EM(Y)	SUB(Z)	ESC([)	FS(\)	GS(])	RS(^)	US(_)	*/
	0x38,	0x39,	0x3A,	0x3B,	0x04,	0x14,	0x3E,	0xE1,

/* A0	SP	!	"	#	$	%	&	'	*/
	0x41,	0x42,	0x43,	0x44,	0x45,	0x46,	0x47,	0x48,

/* A8	(	)	*	+	,	-	.	/	*/
	0x49,	0x51,	0x52,	0x53,	0x54,	0x55,	0x56,	0x57,

/* B0	0	1	2	3	4	5	6	7	*/
	0x58,	0x59,	0x62,	0x63,	0x64,	0x65,	0x66,	0x67,

/* B8	8	9	:	;	<	=	>	?	*/
	0x68,	0x69,	0x70,	0x71,	0x72,	0x73,	0x74,	0x75,

/* C0	@	A	B	C	D	E	F	G	*/
	0x76,	0x77,	0x78,	0x80,	0x8A,	0x8B,	0x8C,	0x8D,

/* C8	H	I	J	K	L	M	N	O	*/
	0x8E,	0x8F,	0x90,	0x6A,	0x9B,	0x9C,	0x9D,	0x9E,

/* D0	P	Q	R	S	T	U	V	W	*/
	0x9F,	0xA0,	0xAA,	0xAB,	0xAC,	0x4A,	0xAE,	0xAF,

/* D8	X	Y	Z	[	\	]	^	_	*/
	0xB0,	0xB1,	0xB2,	0xB3,	0xB4,	0xB5,	0xB6,	0xB7,

/* E0	`	a	b	c	d	e	f	g	*/
	0xB8,	0xB9,	0xBA,	0xBB,	0xBC,	0xA1,	0xBE,	0xBF,

/* E8	h	i	j	k	l	m	n	o	*/
	0xCA,	0xCB,	0xCC,	0xCD,	0xCE,	0xCF,	0xDA,	0xDB,

/* F0	p	q	r	s	t	u	v	w	*/
	0xDC,	0xDD,	0xDE,	0xDF,	0xEA,	0xEB,	0xEC,	0xED,

/* F8	x	y	z	{	|	}	~	DEL	*/
	0xEE,	0xEF,	0xFA,	0xFB,	0xFC,	0xFD,	0xFE,	0xFF,
};


EXPORT int
main(ac, av)
	int	ac;
	char	*av[];
{
	save_args(ac, av);
	getopts(ac, av);
	tty = stdin;

	getstarttime();
	if (signal(SIGINT, intr) == SIG_IGN)
		signal(SIGINT, SIG_IGN);
	if (signal(SIGQUIT, intr) == SIG_IGN)
		signal(SIGQUIT, SIG_IGN);

	if (infile)
		fin = openfile(infile, "ru");
	else {
		fin = stdin;
		setbuf(fin, NULL);
		file_raise(fin, FALSE);
		infile = "stdin";
		if (ivsize || ovsize)
			tty = openfile("/dev/tty", "r");
	}
	if (outfile)
		fout = openfile(outfile, notrunc ? "wcu" : "wctu");
	else {
		fout = stdout;
		setbuf(fout, NULL);
		file_raise(fout, FALSE);
		outfile = "stdout";
	}

	ivpos = iseek + ivseek;
	ovpos = oseek + ovseek;
	(void) fileseek(fin, ivpos);
	(void) fileseek(fout, ovpos);

	getstarttime();

	if (obs != ibs
	    || (flags & (BLOCK|UNBLOCK))	/* Reblock forced uncond.    */
	    || (ivsize && !(flags & NULLOUT))	/* Reblock at end of vol     */
	    || (ovsize &&
	        ((ovsize - ovpos) % obs		/* Reblock at end of 1st vol */
		  || (ovsize - ovseek) % obs)))	/* Reblock at end of 2nd vol */
		copy_reblocked();
	else
		simple_copy();
	term(0);
	return (0);	/* Keep lint happy */
}

LOCAL void
intr(sig)
	int	sig;
{
	signal(sig, intr);
	prstats();
	if (sig == SIGINT) {
		errmsgno(BAD, "KILLED by SIGINT.\n");
		exit(SIGINT);
	}
}

LOCAL FILE *
openfile(name, mode)
	char	*name;
	char	*mode;
{
	FILE	*f;

	if ((f = fileopen(name, mode)) == (FILE*) NULL)
		comerr("Can't open '%s'.\n", name);
	file_raise(f, FALSE);
	return (f);
}

#define	roundup(x, y)	((((x)+((y)-1))/(y))*(y))

LOCAL char *
memalloc(size)
	long	size;
{
	char	*ret;
	unsigned int pagesize = 512;
	unsigned long l;

#ifdef	_SC_PAGESIZE
	pagesize = sysconf(_SC_PAGESIZE);
#else
#ifdef	HAVE_GETPAGESIZE
	pagesize = getpagesize();
#endif
#endif
	if ((ret = malloc((unsigned int)size+pagesize)) == NULL)
		comerr("No memory.\n");

	l = (unsigned long)ret;
	l = roundup(l, pagesize);
	ret = (char *)l;

	return (ret);
}

LOCAL void
simple_copy()
{
	register long	obcnt;
	register long	cnt;
	register char	*obp;
	register int	rflags;

	if (debug)
		error("Simple copy ...\n");

	obp = memalloc(bs);	/* obs == ibs == bs */
	rflags = flags;

	if (rflags & NULLIN)
		fill(obp, 0L, bs);

	while((cnt = readvol(obp, bs)) > 0) {
		if (rflags & NULLOUT) {
			if (progress && !debug) {
				putc('.', stderr);
				fflush (stderr);
			}
			continue;
		}
		if(cnt < bs && (rflags & FILL)) {
			fill(obp, cnt, bs);
			cnt = bs;
		}
		for (obcnt = 0; obcnt < cnt ;)
			obcnt += writevol(obp + obcnt, (long) (cnt - obcnt));
	}
}

LOCAL void
copy_reblocked()
{
	register long	obcnt = 0;
	register long	cnt;
	register char	*obp;

	if (debug)
		error ("Copy reblocked ...\n");

	obp = memalloc((long) (obs + ibs));

	while ((cnt = readvol(obp + obcnt, ibs)) > 0) {
		obcnt += cnt;
		cnt = 0;
		for (cnt = 0; obcnt - cnt >= obs ;)
			cnt += writevol(obp + cnt, obs);
		if (cnt != 0) {
			if (obcnt > cnt) {
				if (debug)
					error("Moving down %d bytes.\n",
								obcnt - cnt);
				(void) movebytes(obp + cnt, obp, obcnt - cnt);
			}
			obcnt -= cnt;
		}
	}
	if (obcnt > 0) {
		if (debug)
			error("Writing tail of %d bytes\n", obcnt);
		if(flags & FILL) {
			fill(obp, obcnt, obs);
			obcnt = obs;
		}
		cnt = 0;
		while (obcnt - cnt > 0)
			cnt += writevol(obp + cnt, (long) (obcnt - cnt));
	}
}

LOCAL long
readvol(buf, len)
	char	*buf;
	long	len;
{
	long	left;
	long	cnt;
	register int	rflags;

	rflags = flags;

	if (count != 0 && irec >= count)
		return (0);

	if (rflags & NULLIN) {
		irec++;
		return (len);
	}

	if (ivsize == 0)
		cnt = readbuf(buf, len);
	else for(;;) {
		if ((left = ivsize - ivpos) > 0) {
			if ((cnt = readbuf(buf, (long) min(len, left))) > 0)
				break;
		}
		if (!next_in())
			return (0);
	}
	ivpos += cnt;
	if (cnt == ibs)
		irec++;
	else
		iparts += cnt;
	if (rflags & NULLOUT)
		return (cnt);
	if (rflags & SWAB)
		swabb(buf, cnt);
	if (rflags & ASCII)
		conv(buf, cnt, asctab);
	if (rflags & LCASE)
		lcase(buf, cnt);
	if (rflags & UCASE)
		ucase(buf, cnt);
	if (rflags & BLOCK)
		cnt = block(buf, cnt);
	if (rflags & UNBLOCK)
		cnt = unblock(buf, cnt);
	if (rflags & EBCDIC)
		conv(buf, cnt, ebctab);
	if (rflags & IBM)
		conv(buf, cnt, ibmtab);
	return (cnt);
}

LOCAL long
writevol(buf, len)
	char	*buf;
	long	len;
{
	int cnt;

	if (ovsize != 0) {
		if (ovpos >= ovsize)
			if (!next_out())
				term(BAD);
		len = min(len, ovsize - ovpos);
	}
	cnt = writebuf(buf, len);
	ovpos += cnt;
	if (cnt == obs)
		orec++;
	else
		oparts += cnt;
	return (cnt);
}

LOCAL BOOL
next_in()
{
	return (next(infile, "input", fin, ivpos = ivseek, ivolnum++));
}

LOCAL BOOL
next_out()
{
	return (next(outfile, "output", fout, ovpos = ovseek, ovolnum++));
}

LOCAL BOOL
next(fname, inout, f, pos, volnum)
	char	*fname;
	char	*inout;
	FILE	*f;
	long	pos;
	int	volnum;
{
	if (progress || debug) {
		putc('\n', stderr);
		fflush (stderr);
	}
	errmsgno (BAD, "Done with %s volume # %d.\n", inout, volnum);
	if (!cont(inout, ++volnum))
		return (FALSE);
	error("Insert %s volume # %d in '%s' and then hit <cr>: ",
						inout, volnum, fname);
	fflush (stderr);
	while (getc(tty) != '\n')
		 if (feof(tty))
			return (FALSE);
	error("Working on %s volume # %d of '%s'.\n", inout, volnum, fname);
	(void) fileseek(f, pos);
	return (TRUE);
}

LOCAL BOOL
cont(inout, num)
	char	*inout;
	int	num;
{
		char	answer [16];
	register char	*ap;

	for(;;) {
		error("Do you want to continue with %s volume # %d (y/n): ",
						inout, num);
		fflush(stderr);
		ap = answer;
		if (fgetline(tty, ap, 16) == EOF)
			return (FALSE);
		while (*ap == ' ' || *ap == '\t')
			ap++;
		makelower(ap);
		if (streql(ap, "y") || streql(ap, "yes"))
			return (TRUE);
		if (streql(ap, "n") || streql(ap, "no"))
			return (FALSE);
	}
}

LOCAL void
makelower(s)
	register char	*s;
{
	while (*s) {
		if (*s >= 'A' && *s <= 'Z')
			*s += 'a' - 'A';
		else if (*s == ' ' || *s == '\t') {
			*s = '\0';
			return;
		}
		s++;
	}
}

LOCAL long 
readbuf(buf, len)
	char	*buf;
	long	len;
{
	long	cnt;
	int	err = 0;

	lastreaderrs = 0;
	if (debug) {
		error("readbuf  (%d, 0x%x, %d) ", fdown(fin), buf, len);
		fflush(stderr);
	}
	if (noerror && noseek)
		fill(buf, 0L, len);
	cnt = ffileread(fin, buf, (int)len);
	if (debug) {
		if (cnt < 0)
			err = geterrno();
		error("= %l\n", cnt);
	}
	if(cnt < 0) {
		if (!debug)
			err = geterrno();
		if (progress && !debug)
			putc('\n', stderr);
		errmsgno(err, "Error reading '%s'.\n", infile);
		if(noerror)
			cnt = readblocks(buf, len);
		else
			term(err);
  	}
	if (cnt == 0)
		if(count != 0 && ivsize == 0) {
			if (progress || debug)
				putc('\n', stderr);
			errmsgno(BAD, "END OF FILE\n");
		}
	return (cnt);
}

LOCAL long
writebuf(buf, len)
	char	*buf;
	long	len;
{
	long cnt;

	if (debug)
		error("writebuf (%d, 0x%x, %d)\n", fdown(fout), buf, len);
	if ((lastreaderrs > 0) && noerrwrite) {
		if (debug)
			error("seek(%d, %d)\n", fdown(fout), ovpos + len);
		if (fileseek(fout, ovpos + len) < 0) {
			cnt = geterrno();
			if (progress && !debug)
				putc('\n', stderr);
			errmsgno((int) cnt, "Error seeking '%s'.\n", outfile);
		}
		cnt = len;
	} else if((cnt = ffilewrite(fout, buf, (int)len)) <= 0) {
		if (cnt == 0)		/* EOF */
			cnt = ENDOFFILE;
		else if (cnt < 0)
			cnt = geterrno();
		if (progress && !debug)
			putc('\n', stderr);
		errmsgno((int) cnt, "Error writing '%s'.\n", outfile);
		if (noerror && cnt != ENDOFFILE)
			cnt = writeblocks(buf, len);
		else
			term((int) cnt);
	}
	if (progress && !debug) {
		putc('.', stderr);
		fflush (stderr);
	}
	return (cnt);
}

LOCAL long
readblocks(buf, len)
	register char	*buf;
	register long	len;
{
	register long	cnt;
	register long	aktlen;
	register int	trys;
	register long	pos = ivpos;
	register long	total = 0;

	if (noseek) {
		errmsgno(BAD, "Can't read %l Bytes at %l\n", len, pos);
		readerrs++;
		return (len);
	}
	while(len > 0) {
		aktlen = min(BSIZE, len);
		trys = 0;
		do {
			if (trys && !(trys & 15)){
				if (debug) {
					putc('+', stderr);
					fflush(stderr);
				}
				(void) fileseek(fin, (long) (filesize(fin)- BSIZE));
				(void) ffileread(fin, buf, (int) aktlen);
			}
			else if (trys > 0 && (trys == 2 || ! (trys & 7))) {
				if (debug) {
					putc('-', stderr);
					fflush(stderr);
				}
				(void) fileseek(fin, 0L);
				(void) ffileread(fin, buf, (int) aktlen);
			}
			if (debug) {
				putc(',', stderr);
				fflush(stderr);
			}
			fill(buf, 0L, aktlen);
			(void) fileseek(fin, pos);
			cnt = ffileread(fin, buf, (int) aktlen);
		} while (cnt < 0 && trys++ < try);

		if(cnt < 0) {
			if (progress || debug) {
				putc('\n', stderr);
				fflush(stderr);
			}
			errmsgno(BAD, "Block %d not read correctly.\n",
								pos/BSIZE);
			cnt = aktlen;
			readerrs++;
			lastreaderrs++;
		}
		else if (cnt == 0)	/* EOF */
			break;
		buf += cnt;
		len -= cnt;
		pos += cnt;
		total += cnt;
	}
	(void) fileseek(fin, pos);
	return (total);
}

LOCAL long
writeblocks(buf, len)
	register char	*buf;
	register long	len;
{
	register long	cnt;
	register long	aktlen;
	register int	trys;
	register long	pos = ovpos;
	register long	total = 0;
		char	rdbuf[BSIZE];

	if (noseek) {
		errmsgno(BAD, "Can't write %l Bytes at %l\n", len, pos);
		writeerrs++;
		return (len);
	}
	while(len > 0) {
		aktlen = min(BSIZE, len);
		trys = 0;
		do {
			if (trys && !(trys & 15)){
				if (debug) {
					putc('>', stderr);
					fflush(stderr);
				}
				(void) fileseek(fin, (long) (filesize(fin) - BSIZE));
				(void) ffileread(fin, rdbuf, (int) aktlen);
			}
			else if (trys > 0 && (trys == 2 || ! (trys & 7))) {
				if (debug) {
					putc('<', stderr);
					fflush(stderr);
				}
				(void) fileseek(fin, 0L);
				(void) ffileread(fin, rdbuf, (int) aktlen);
			}
			if (debug) {
				putc(';', stderr);
				fflush(stderr);
			}
			(void) fileseek(fout, pos);
			cnt = ffilewrite(fout, buf, (int) aktlen);
		} while (cnt < 0 && trys++ < try);
		if(cnt < 0) {
			if (progress || debug) {
				putc('\n', stderr);
				fflush(stderr);
			}
			errmsgno(BAD, "Block %d not written correctly.\n",
								pos/BSIZE);
			cnt = aktlen;
			writeerrs++;
		}
		else if (cnt == 0)	/* EOF */
			break;
		buf += cnt;
		len -= cnt;
		pos += cnt;
		total += cnt;
	}
	(void) fileseek(fout, pos);
	return (total);
}

LOCAL void
fill(bp, start, end)
	char	*bp;
	long	start;
	long	end;
{
#ifdef	OLD
	register char *p = &bp[start];
	register char *ep = &bp[end];

	while(p < ep)
		*p++ = '\0';
#else
	fillbytes(&bp[start], end-start, '\0');
#endif
}

#define	DO8(a)  a;a;a;a;a;a;a;a;

LOCAL void
swabb(bp, cnt)
	register char	*bp;
	register int	cnt;
{
	register char	c;

	cnt /= 2;	/* even count only */
	while ((cnt -= 8) >= 0) {
		DO8(
			c = *bp++;
			bp[-1] = *bp;
			*bp++ = c;
		);
	}
	cnt += 8;
	while (--cnt >= 0) {
		c = *bp++;
		bp[-1] = *bp;
		*bp++ = c;
	}
}

LOCAL void
lcase(bp, cnt)
	register char	*bp;
	register long	cnt;
{
	while(--cnt >= 0) {
		if (*bp >= 'A' && *bp <= 'Z')
			*bp += 'a' - 'A';
		bp++;
	}
}

LOCAL void
ucase(bp, cnt)
	register char	*bp;
	register long	cnt;
{
	while(--cnt >= 0) {
		if (*bp >= 'a' && *bp <= 'z')
			*bp -= 'a' - 'A';
		bp++;
	}
}

LOCAL long
block(bp, cnt)
	register char	*bp;
	register long	cnt;
{
	register long	ocnt;

	ocnt = cnt;
	while(--cnt >= 0) {
		bp++;
	}
	return (ocnt);
}

LOCAL long
unblock(bp, cnt)
	register char	*bp;
	register long	cnt;
{
	register long	ocnt;

	ocnt = cnt;
	while(--cnt >= 0) {
		bp++;
	}
	return (ocnt);
}

LOCAL void
conv(bp, cnt, tab)
	register char	*bp;
	register long	cnt;
	register unsigned char	*tab;
{
	register char	c;

	while ((cnt -= 8) >= 0) {
		DO8(
			c = (char)tab[(unsigned char) *bp];
			*bp++ = c;
		);
	}
	cnt += 8;
	while (--cnt >= 0) {
		c = (char)tab[(unsigned char) *bp];
		*bp++ = c;
	}

	/* Reihenfolge der Auswertung ist nicht sichergestellt !!! bei: */
	/* XXX		*bp++ = tab[(unsigned char) *bp];*/
}

LOCAL void
term(ret)
	int	ret;
{
	prstats();
	exit(ret);
}

LOCAL void
getstarttime()
{
#ifdef	BSD4_2
	if (showtime && gettimeofday(&starttime, 0L) < 0)
		comerr("Cannot get starttime\n");
#endif
}

LOCAL void
prstats()
{
	long	savirec = 0L;
	Llong	ibytes;
	Llong	obytes;
	long	hibytes;
	long	lobytes;
	char	cbytes[32];
	long	ikbytes;
	long	okbytes;
	int	iper;
	int	oper;
#ifdef	BSD4_2
	int	sec;
	int	usec;
	int	tmsec;
#endif

#ifdef	BSD4_2
	if (showtime && gettimeofday(&stoptime, 0L) < 0)
			comerr("Cannot get stoptime\n");
#endif
	if (flags & NULLIN) {
		savirec = irec;
		irec = 0L;
	}
	ibytes = (Llong)irec * (Llong)ibs + iparts;
	obytes = (Llong)orec * (Llong)obs + oparts;
	ikbytes = ibytes >> 10;
	okbytes = obytes >> 10;
	iper = ((ibytes&1023)<<10)/10485;
	oper = ((obytes&1023)<<10)/10485;

	if (progress || debug) putc('\n', stderr);
	if (readerrs)
		errmsgno(BAD, "%d %s(s) not read correctly.\n",
					 readerrs, noseek?"Record":"Block");
	if (writeerrs)
		errmsgno(BAD, "%d %s(s) not written correctly.\n",
					writeerrs, noseek?"Record":"Block");

	cbytes[0] = '\0';
	hibytes = ibytes / 1000000000;
	lobytes = ibytes % 1000000000;
	if (hibytes)
		sprintf(cbytes, "%ld%09ld", hibytes, lobytes);
	else
		sprintf(cbytes, "%ld", lobytes);

	errmsgno(BAD,
		"Read  %l records + %l bytes (total of %s bytes = %l.%02dk).\n",
		irec, iparts, cbytes, ikbytes, iper);

	cbytes[0] = '\0';
	hibytes = obytes / 1000000000;
	lobytes = obytes % 1000000000;
	if (hibytes)
		sprintf(cbytes, "%ld%09ld", hibytes, lobytes);
	else
		sprintf(cbytes, "%ld", lobytes);
	errmsgno(BAD,
		"Wrote %l records + %l bytes (total of %s bytes = %l.%02dk).\n",
		orec, oparts, cbytes, okbytes, oper);

	if (flags & NULLIN) {
		irec = savirec;
		ibytes = obytes;
		ikbytes = okbytes;
	}
#ifdef	BSD4_2
	if (showtime) {
		Llong	kbs;

		sec = stoptime.tv_sec - starttime.tv_sec;
		usec = stoptime.tv_usec - starttime.tv_usec;
		tmsec = sec*1000 + usec/1000;
		if (usec < 0) {
			sec--;
			usec += 1000000;
		}
		if (tmsec == 0)
			tmsec++;

		kbs = (Llong)ikbytes*(Llong)1000/tmsec;
		lobytes = kbs;
		errmsgno(BAD, "Total time %d.%03dsec (%d kBytes/sec)\n",
				sec, usec/1000, lobytes);
	}
#endif
}

char	opts[]	= "\
if*,of*,ibs&,obs&,bs&,cbs&,ivsize&,ovsize&,count&,iseek&,oseek&,seek&,\
iskip&,oskip&,skip&,ivseek&,ovseek&,\
notrunc,pg,noerror,noerrwrite,noseek,try#,\
fill,swab,block,unblock,lcase,ucase,ascii,ebcdic,ibm,\
inull,onull,help,debug,time,t";

LOCAL void
getopts(ac, av)
	int	ac;
	char	*av[];
{
	int	cac;
	char	* const *cav;
	BOOL	help	= FALSE;
	BOOL	fillflg	= FALSE;
	BOOL	swabflg	= FALSE;
	BOOL	blkflg	= FALSE;
	BOOL	ublkflg	= FALSE;
	BOOL	lcflg	= FALSE;
	BOOL	ucflg	= FALSE;
	BOOL	ascflg	= FALSE;
	BOOL	ebcflg	= FALSE;
	BOOL	ibmflg	= FALSE;
	BOOL	nullin	= FALSE;
	BOOL	nullout	= FALSE;
	int	trys	= -1;

	cac = ac - 1;
	cav = av + 1;
	if (getallargs(&cac, &cav, opts,
				&infile, &outfile,
				getnum, &ibs, getnum, &obs, getnum, &bs,
				getnum,	&cbs,
				getnum, &ivsize, getnum, &ovsize,
				getnum, &count,
				getnum, &iseek, getnum, &oseek, getnum, &seek,
				getnum, &iskip, getnum, &oskip, getnum, &skip,
				getnum, &ivseek, getnum, &ovseek,
#ifndef	lint			/* lint kann leider nur 52 args !!! */
				&notrunc,
				&progress,
				&noerror,
				&noerrwrite,
				&noseek,
				&trys,
				&fillflg,
				&swabflg,
				&blkflg, &ublkflg,
				&lcflg, &ucflg,
				&ascflg, &ebcflg, &ibmflg,
				&nullin,
				&nullout,
#endif
				&help, &debug, &showtime, &showtime) < 0) {
		error("Bad Option: '%s'\n", cav[0]);
		usage(BAD);
	}
	if (help)
		usage(0);
	cac = ac - 1;
	cav = av + 1;
	if (getfiles(&cac, &cav, opts) != 0) {
		error("Bad Argument: '%s'\n",cav[0]);
		usage(BAD);
	}

	if (trys >= 0) {
		if (!noerror) {
			error ("'try' only with '-noerror'.\n");
			usage(BAD);
		}
		if (noseek) {
			error ("Can't try with -noseek.\n");
			usage(BAD);
		}
		try = trys;
	}
	if ((iseek || oseek || seek) && (iskip || oskip || skip)) {
		error("Can't seek and skip.\n");
		usage(BAD);
	}
	if ((iseek || oseek || seek) && noseek) {
		error("Can't seek and noseek.\n");
		usage(BAD);
	}
	if (noseek && noerrwrite) {
		error("Can't noseek and noerrwrite.\n");
		usage(BAD);
	}
	if (bs == 0)
		bs = BSIZE;
	if (ibs == 0)
		ibs = bs;
	if (obs == 0)
		obs = bs;
	if (iskip == 0)
		iskip = skip;
	if (oskip == 0)
		oskip = skip;
	if (iseek == 0)
		iseek = seek;
	if (oseek == 0)
		oseek = seek;
	if (iskip || oskip) {
		error ("skip not implemented.\n");
		usage (BAD);
	}
	if (fillflg)
		flags |= FILL;
	if (swabflg)
		flags |= SWAB;
	if (blkflg)
		flags |= BLOCK;
	if (ublkflg)
		flags |= UNBLOCK;
	if ((flags & (BLOCK|UNBLOCK)) && cbs == 0) {
		error("Must specify cbs if block or unblock.\n");
		usage(BAD);
	}
	if (blkflg || ublkflg) {
		error ("block/unblock not implemented.\n");
		usage (BAD);
	}
	if (lcflg && ucflg) {
		error("Can't lcase and ucase.\n");
		usage(BAD);
	}
	if (lcflg)
		flags |= LCASE;
	if (ucflg)
		flags |= UCASE;
	if (ascflg)
		flags |= ASCII;
	if (ebcflg && ibmflg) {
		error("Can't ebcdic and ibm.\n");
		usage(BAD);
	}
	if (ebcflg)
		flags |= EBCDIC;
	if (ibmflg)
		flags |= IBM;
	if (nullin && nullout) {
		error("Can't inull and onull.\n");
		usage(BAD);
	}
	if (nullin) {
		flags &= ~(BLOCK|UNBLOCK);
		flags |= NULLIN;
		ibs = bs = obs;
	}
	if (nullout) {
		flags &= ~(BLOCK|UNBLOCK);
		flags |= NULLOUT;
		obs = bs = ibs;
	}
}

LOCAL long
number(arg, retp)
	register char	*arg;
		int	*retp;
{
	long	val	= 0;

	if (*retp != 1)
		return (val);
	if (*arg == '\0')
		*retp = -1;
	else if (*(arg = astol(arg, &val))) {
		if (*arg == 'm' || *arg == 'M') {
			val *= (1024*1024);
			arg++;
		}
		else if (*arg == 'k' || *arg == 'K') {
			val *= 1024;
			arg++;
		}
		else if (*arg == 'b' || *arg == 'B') {
			val *= BSIZE;
			arg++;
		}
		else if (*arg == 'w' || *arg == 'W') {
			val *= 2;
			arg++;
		}
		if (*arg == '*' || *arg == 'x')
			val *= number(++arg, retp);
		else if (*arg != '\0')
			*retp = -1;
	}
	return (val);
}

LOCAL int
getnum(arg, valp)
	char	*arg;
	long	*valp;
{
	int	ret = 1;

	*valp = number(arg, &ret);
	return (ret);
}

LOCAL void
usage(ex)
	int ex;
{
	error("\
Usage:	sdd [option=value] [-flag]\n\
Options:\n\
");
	error ("\
	if=name		  Read  input from name instead of stdin\n\
	of=name		  Write output to name instead of stdout\n\
	-inull		  Do not read input from file (use null char's)\n\
	-onull		  Do not write output to any file\n\
	ibs=#,obs=#,bs=#  Set input/outbut buffersize or both to #\n\
	cbs=#		  Set conversion buffersize to #\n\
	ivsize=#,ovsize=# Set input/output volume size to #\n\
	count=#		  Transfer at most # input records\n\
	iseek=#,iskip=#	  Seek/skip # bytes on input before starting\n\
	oseek=#,oskip=#	  Seek/skip # bytes on output before starting\n\
	seek=#,skip=#	  Seek/skip # bytes on input/output before starting\n\
	ivseek=#,ovseek=# Seek # bytes on input/output volumes before starting\n\
");
	error("\
	-notrunc	  Do not trunctate existing output file\n\
	-pg		  Print a dot on each write to indicate progress\n\
	-noerror	  Do not stop on error\n\
	-noerrwrite	  Do not write blocks not read correctly\n\
	-noseek		  Don't seek\n\
	try=#		  Set error retrycount to # if -noerror (default 2)\n\
	-debug		  Print debugging messages\n\
	-fill		  Fill each record with zeros up to obs\n\
	-swab,-block,-unblock,-lcase,-ucase,-ascii,-ebcdic,-ibm\n\
");
	exit(ex);
}
