#include <PalmOS.h>
#include "globals.h"

DmOpenRef dbP[3] = {NULL,NULL,NULL};
///////////////////////////////////////////////////////////////////

void writeRecord(MemPtr ptr, UInt32 size, UInt16 index, UInt16 dbID) {
	Err e;
	
	MemHandle recordH = DmNewRecord(dbP[dbID], &index, size);
	MemPtr save = MemHandleLock(recordH);
	e = DmWrite(save, 0, ptr, size);
	MemHandleUnlock(recordH);
	DmReleaseRecord (dbP[dbID], index, 0);
}
///////////////////////////////////////////////////////////////////
void buildAll() {
	Err err;
	LocalID olddb;
	
	olddb = DmFindDatabase(0, "ScummVM-Globals");
	if (olddb) {
		DmDeleteDatabase(0,olddb);
		FrmCustomAlert(1000,"delete old DB",0,0);
	}
	olddb = DmFindDatabase(0, "Scumm-Globals");
	if (olddb) {
		DmDeleteDatabase(0,olddb);
		FrmCustomAlert(1000,"delete old DB",0,0);
	}
/*	olddb = DmFindDatabase(0, "Simon-Globals");
	if (olddb) {
		DmDeleteDatabase(0,olddb);
		FrmCustomAlert(1000,"delete old DB",0,0);
	}
	olddb = DmFindDatabase(0, "Sky-Globals");
	if (olddb) {
		DmDeleteDatabase(0,olddb);
		FrmCustomAlert(1000,"delete old DB",0,0);
	}
*/
	err = DmCreateDatabase (0, "Scumm-Globals", 'ScVM', 'GLBS', false);
//	err = DmCreateDatabase (0, "Simon-Globals", 'ScVM', 'GLBS', false);
//	err = DmCreateDatabase (0, "Sky-Globals", 'ScVM', 'GLBS', false);
//	if (err)
//		FrmCustomAlert(testAlert,"error creating DB",0,0);
	olddb = DmFindDatabase(0, "Scumm-Globals");
	dbP[GBVARS_SCUMM] = DmOpenDatabase(0, olddb, dmModeReadWrite);
//	olddb = DmFindDatabase(0, "Simon-Globals");
//	dbP[GBVARS_SIMON] = DmOpenDatabase(0, olddb, dmModeReadWrite);
//	olddb = DmFindDatabase(0, "Sky-Globals");
//	dbP[GBVARS_SKY] = DmOpenDatabase(0, olddb, dmModeReadWrite);
	
	addImuseDigi();
	addNewGui();
	// temp removed
	// TODO ::scummvm use sizeof(OLD256_MIDI_HACK) so i need to fix it
	// directly in the code or call MemHandleSize but it may slow down
	// code execution
//	addResource();
	addAkos();
	addCodec47();
	addGfx();
	addDialogs();
	addCharset();
//	addFmpol();

	//addSimon();
	
	DmCloseDatabase(dbP[GBVARS_SCUMM]);
	//DmCloseDatabase(dbP[GBVARS_SIMON]);
	//DmCloseDatabase(dbP[GBVARS_SKY]);
}
