/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $URL: https://scummvm.svn.sourceforge.net/svnroot/scummvm/scummvm/tags/release-0-12-0/engines/cine/msg.cpp $
 * $Id: msg.cpp 31651 2008-04-21 20:51:17Z sev $
 *
 */


#include "common/endian.h"

#include "cine/msg.h"
#include "cine/various.h"

namespace Cine {

Common::StringList messageTable;

void loadMsg(char *pMsgName) {
	int i, count, len;
	byte *ptr, *dataPtr;
	const char *messagePtr;

	checkDataDisk(-1);

	messageTable.clear();

	ptr = dataPtr = readBundleFile(findFileInBundle(pMsgName));

	setMouseCursor(MOUSE_CURSOR_DISK);

	count = READ_BE_UINT16(ptr);
	ptr += 2;

	messagePtr = (const char*)(ptr + 2 * count);

	for (i = 0; i < count; i++) {
		len = READ_BE_UINT16(ptr);
		ptr += 2;
		
		messageTable.push_back(messagePtr);
		messagePtr += len;
	}

	free(dataPtr);
}

} // End of namespace Cine
