/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $URL: https://scummvm.svn.sourceforge.net/svnroot/scummvm/scummvm/tags/release-0-11-0/backends/fs/ds/ds-fs-factory.cpp $
 * $Id: ds-fs-factory.cpp 30459 2008-01-12 23:07:51Z sev $
 */

#include "backends/fs/ds/ds-fs-factory.h"
#include "backends/fs/ds/ds-fs.h"
#include "dsmain.h" //for the isGBAMPAvailable() function

DECLARE_SINGLETON(DSFilesystemFactory);

AbstractFilesystemNode *DSFilesystemFactory::makeRootFileNode() const {
	if (DS::isGBAMPAvailable()) {
		return new DS::GBAMPFileSystemNode();
	} else {
		return new DS::DSFileSystemNode();
	}
}

AbstractFilesystemNode *DSFilesystemFactory::makeCurrentDirectoryFileNode() const {
	if (DS::isGBAMPAvailable()) {
		return new DS::GBAMPFileSystemNode();
	} else {
		return new DS::DSFileSystemNode();
	}
}

AbstractFilesystemNode *DSFilesystemFactory::makeFileNodePath(const String &path) const {
	if (DS::isGBAMPAvailable()) {
		return new DS::GBAMPFileSystemNode(path);
	} else {
		return new DS::DSFileSystemNode(path);
	}
}
