/* Convert between a lo24/hi integer-pair bitset and a sigset_t value.
** These macros are OS-dependent, and must be defined per-OS.
*/

#define make_sigset(maskp, hi, lo) \
    ((maskp)->__val[0] = (unsigned long int) ((hi) << 24) | (lo))
 
#define split_sigset(mask, hip, lop)\
    ((*(hip) = ((mask).__val[0] >> 24) & 0xff),\
    (*(lop) = ((mask).__val[0] & 0xffffff)))
