/* Scheme48/scsh Unix system interface.
** Routines that require custom C support.
** Copyright (c) 1995 by David Albertz.
*/

/*  File locking routines  */

#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>

/* Make sure our exports match up w/the implementation: */
#include "flock1.h"

int set_lock(int fd, int cmd, int type, int whence, int start, int len)
{
    struct flock lock;
    lock.l_type   = type;
    lock.l_whence = whence;
    lock.l_start  = start;
    lock.l_len    = len;
    return(fcntl(fd, cmd, &lock));
    }

int get_lock(int fd, int cmd, int type, int whence, int start, int len,
	     int *rtype, int *rwhence, int *rstart, int *rlen, int *rpid)
{
    struct flock lock;
    int ret;
    lock.l_type   = type;
    lock.l_whence = whence;
    lock.l_start  = start;
    lock.l_len    = len;
    ret = fcntl(fd, F_GETLK, &lock);
    *rtype = lock.l_type;
    *rwhence = lock.l_whence;
    *rstart = lock.l_start;
    *rlen = lock.l_len;
    *rpid = lock.l_pid;
    return(ret);
    }
