/***************************************************************************
 *   copyright           : (C) 2004 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMSUDH_H
#define SMSUDH_H

//own headers
#include <smspdu.h>

struct sms_pdu_ud_header* sms_udh_multipart16_get (uint16_t seqnum,
						   uint8_t index,
						   uint8_t total);


/** print all headers as text to fp
 *  sms_udh_fill() and sms_multipart_merge() should be
 *  called before this one
 *  This is called e.g. by sms_pdu_print_deliver()
 *
 *  @param fp file/pipe/etc. to print to
 *  @param plist user data from the (concatenated) short message
 *  @param parts message parts (1-255)
 */
void sms_udh_print (FILE* fp, struct sms_pdu_ud* plist, uint8_t parts);
void sms_udh_print_header (FILE* fp, struct sms_pdu_ud_header* header);

/** to parse the user data header from a pdu
 */
void sms_udh_fill (struct sms_pdu_data* sms, char* data);

/** called by sms_udh_fill(), no need to call anywhere else
 */
void sms_udh_multipart_mark (struct sms_pdu_data* data);

//mainly used by sms_udh_fill()
struct sms_pdu_ud_header_def {
  int16_t type; //negative entries are invalid
  uint8_t minlen; //in octets
  uint8_t maxlen; //in octets (obviously not more than 137(=140-1-2)))
  void (*print_func) (FILE* fp, uint8_t* data); //function pointer to header type printer
};
extern struct sms_pdu_ud_header_def sms_pdu_ud_header_defs[]; //known header types

#endif
