/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPTIONS_H
#define OPTIONS_H

#define SCMXX_ACTION_REMOVE 0x1
#define SCMXX_ACTION_SEND   0x2
#define SCMXX_ACTION_GET    0x4

#define SCMXX_FTYPE_BINARY 0x1
#define SCMXX_FTYPE_PBOOK  0x2
#define SCMXX_FTYPE_SMS    0x4

#define SCMXX_SLOT_LAST       -7
#define SCMXX_SLOT_SMS_SENT   -6
#define SCMXX_SLOT_SMS_UNSENT -5
#define SCMXX_SLOT_SMS_READ   -4
#define SCMXX_SLOT_SMS_UNREAD -3
#define SCMXX_SLOT_ALL        -2
#define SCMXX_SLOT_UNDEFINED  -1

#define SCMXX_SLOT_BINARY_MIN 0
#define SCMXX_SLOT_PBOOK_MIN  1
#define SCMXX_SLOT_SMS_MIN    1

#define VCARD_PHONEBOOK_NAME "VCF"

#include "smspdu.h"
#include "ttyaccess.h"
#include "intincl.h"

struct parameters {
  char* text;
  char* number;
  int slot;
  char* mem;
};

struct args_t {
  struct port_args_t port;

  struct parameters myparams;
  struct smsopts mysmsopts;

  char scmxx_action;
  char scmxx_ftype;

  char* myFILE;
  char* myPIPE;

  unsigned int info :1;
  unsigned int meminfo :1;
  unsigned int lockinfo :1;
  unsigned int time :1;
  char* lock;
  int state_change;
  unsigned int smsc :1;
  unsigned int dial :1;
  unsigned int hangup :1;
  unsigned int reset :1;
  unsigned int help :1;
  unsigned int version :1;

  int verbose;
  char* pin;
  char* system_charset;
};

enum args_param_type {
  ARGS_PARAM_NONE = 0, //no parameter allowed
  ARGS_PARAM_OPT, //parameter is optional, does not work with libpopt
  ARGS_PARAM_REQ //parameter is required
};
struct args_def {
  char* long_name; //long option name
  char short_name; //short option name, 0 for none
  enum args_param_type ptype; //parameter type
};
#define ARGS_DEF_LAST { NULL, 0, ARGS_PARAM_NONE }
extern struct args_def args_list[];

/* return full path of filename with
 * the configuration directory as base
 * return value needs to be freed
 */
char* configfile_get_path (char* filename);

/* reads a config file located at filename
 * the config file must contain long-options only
 * seperator of option and arguments is '='
 * comments have a '#' at beginning of line
 */
char** configfile_read (char* filename);

/* a function to init the variables in the struct
 */
void args_init (struct args_t* args);

/* functions to fill the struct by parsing the command line
 * currently only GNU getopt_long() is implemented (options_getopt.c)
 * returns a NULL terminated list of files
 */
char** args_parse (int argc, char** argv,
		   struct args_t* args);

/* used by the different implementations of args_parse()
 */
void arg_fill (int short_opt, const char* long_opt,
	       char* argument, struct args_t* args);

/* include environment variables and/or
 * use values from config.h
 */
void use_envvars (struct args_t* args);

/* prints program syntax to stdout
 *  me is the program name (path is ignored)
 */
void help(char *me);

/* prints the program version to stdout
 */
void version();

#endif
