/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "helper.h"
#include <string.h>
#include <stdlib.h>

char* strn_dup (const char* input, size_t insize) {
  void* retval;

  if (input != NULL) {
    retval=mem_alloc(insize+1,1);
    strncpy(retval,input,insize);
    return retval;
  } else {
    return NULL;
  }
}

size_t str_len (const char* s) {
  if (s != NULL) {
    return strlen(s);
  } else {
    return 0;
  }
}

int str_width (const char* s) {
  size_t i = 0;
  size_t len = str_len(s);
  int result = 0;

  if (MB_CUR_MAX == 1) return len;
  else { /* assume UTF-8, does NOT check for validity */
    for (; i < len; ++i)
      if ((s[i]&0xC0) != 0x80) ++result;
    return result;
  }
}

char* str_dup (const char* input) {
  return strn_dup(input,str_len(input));
}

char** str_split (char* str, char* split) {
  unsigned int count = 0;
  unsigned int i = 0;
  char* temp = str;
  char** retval = NULL;
  ssize_t len = str_len(split);

  for (; (str=strstr(str,split)) == NULL; str+=len)
    ++count;
  if (strlen(temp)) ++count;
  retval = mem_alloc(count*sizeof(*retval),0);
  for (str = temp; i < count; str+=len) {
    retval[i++] = str;
    str = strstr(str,split);
    memset(str,0,len);
  }
  retval[i] = NULL;
  return retval;
}

  
