/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef HELPERS_H
#define HELPERS_H

#include "intincl.h"
#include <stdlib.h>

/* returns the number of digits in num */
unsigned int numlen (long num);

/* returns the GSM type of address (TOA) value */
uint8_t numtype (const char* number);

/* returns 1 if every character in s is a digit else 0*/
int is_number(const char* s);

/* returns 1 if s is a telephone number else 0 */
int is_telephone_number (const char* s);

/* converts a hexadezimal string with a given length to an int */
unsigned int hexstr2int(char *hexstring, unsigned int length);


/* (re)allocate memory */
void* mem_alloc (size_t size, short zero_it);
void* mem_realloc (void* oldpointer, size_t size);

/* duplicate a c string */
char* str_dup (const char* input);
char* strn_dup (const char* input, size_t insize);

/* strlen() does not seem to check for strlen(NULL) and crashes */
size_t str_len(const char *s);

/** calculate the printed string width
 * @param s string in ISO-8859-? or UTF-8
 * @return amount of printed characters
 */
int str_width (const char* s);

/** split a string
 * @param str string to split up (it gets modified!)
 * @param split at what points in str to split
 * 
 * @return return the dynamically allocated array ([0] = str)
 */
char** str_split (char* str, char* split);

#endif
