/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <charsets.h>
#include <helper.h>
#include <gtincl.h>

#include <string.h>
#include <stdio.h>

/* Converting to GSM and back does _NOT_ always result in the same string!
 *
 * You should only use the last 7 bits of the encoded characters!
 * (e.g. using the mask "& 0x7f")
 */

#include "gsm.h"
gsmchar_t* convert_to_gsm (ucs4char_t* input) {
  gsmchar_t* retval;
  unsigned int i;
  unsigned int k = 0;
  unsigned int g;
  unsigned int l;
  
  retval = mem_alloc((ucs4len(input)*2)+1,0);
  for (i = 0; i < ucs4len(input); ++i) {
    for (g = 0; gsm_chars[g].gsize != 0; ++g) {
      if (input[i] == gsm_chars[g].uval) break;
    }
    if (gsm_chars[g].gsize == 0) {
      fprintf(stderr,_("Unicode value 0x%04lx is not a GSM character\n"),
	      (unsigned long)input[i]);
      continue;
    }
    for (l = 0; l < gsm_chars[g].gsize; ++l) {
      retval[k++] = gsm_chars[g].gval[l];
    }
  }
  retval[k]=0;

  return mem_realloc(retval,(k+1)*sizeof(gsmchar_t));
}
