/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "charsets.h"
#include "helpers.h"
#include "common.h"
#include <stdio.h>
#include <string.h>

unsigned char* convert_to_ucs2 (wchar_t* input) {
  unsigned char* retval;
  unsigned char* temp;
  int i;

  temp=convert_from_internal("UCS-2BE",input,0);
  retval=mem_alloc((wcslen(input)*4)+1,1);
  for (i=0;i<wcslen(input);i++) {
    sprintf(&retval[4*i],"%02X%02X",temp[2*i],temp[(2*i)+1]);
  }
  mem_realloc(temp,0);
  return retval;
}

wchar_t* convert_from_ucs2 (unsigned char* input) {
  wchar_t* retval;
  char* temp;
  int i;
    
  temp=mem_alloc((strlen(input)/2)+1,1);
  for (i=0;i<strlen(input);i+=2) {
    temp[i/2]=(char)(hexstr2int(input+i,2)&255);
  }

  retval=convert_to_internal("UCS-2BE",temp,strlen(input)/2);
  mem_realloc(temp,0);
  return retval;
}
