/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMSCODING_H
#define SMSCODING_H

#include "depincludes.h"

//This value is static - DO NOT CHANGE
#define MAXSMSSIZE 160
#define MAXSMSSIZEUCS 70

/*
 * This calls all functions that are needed to encode the 7bit userdata
 * returns NULL on parameter errors else a char* that must be freed and
 *   which contains the data already as HEXSTRING!
 * outsize contains the returned string size after execution
 */
unsigned char* sms_data_7bit_encode (wchar_t* input, int* enc_outsize);

/*
 * This calls all function that are needed to encode the 7bit userdata
 * returns NULL on parameter errors else a wchar_t* that must be freed
 * encoded_insize must contain the size of the encoded string and
 *      NOT the string length of input which certainly differs
 */
wchar_t* sms_data_7bit_decode (unsigned char* input, int encoded_size);

#endif
