/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "smscoding.h"
#include "common.h"
#include "helpers.h"
#include "charsets.h"
#include <string.h>

unsigned char* sms_data_7bit_encode (wchar_t* input, int* enc_outsize){
  unsigned char* temp;
  int i, first, end, outsize;
  unsigned char* retval;

  if (input==NULL || enc_outsize==NULL) {
    return NULL;
  }
  temp=convert_to_gsm(input);
  /* 
   * make it easy to see if user data does not exceed the 140 octets limit
   * when there are characters from the extension table
   */
  if (strlen(temp) > MAXSMSSIZE) {
    errexit ("SMS text is too long (max. %d characters).\nPlease be aware that some characters are encoded as 14bit (instead of 7bit), e.g. the euro character.\n",
	     MAXSMSSIZE);
  }
    
  retval=mem_alloc(281,1);
  *enc_outsize=strlen(temp);
  outsize=0;
  //7bit-GSM octet encoding
  for (i = 0; i < strlen(temp); i++) {
    end = temp[i] & 127; //the character are 7bit
    end >>= (i % 8);
    first = temp[i+1] & 127;
    first <<= 7 - (i % 8);
    first &= 255; //we only need the last eight bits (AND mask)
    sprintf (&retval[2*outsize], "%02X", (first | end));
    ++outsize;
    if ((i % 8) == 6) { //every 8th char is already coded in (it really must be 6)
      i++;
    }
  }
  mem_realloc(temp,0);
  //*enc_outsize=outsize;
  return retval;
}

wchar_t* sms_data_7bit_decode (unsigned char* input, int encoded_size) {
  char temp[3];
  unsigned char userdata[281];
  unsigned char decoded[MAXSMSSIZE+1];
  int i, first, end, offset, counter;

  if (!encoded_size || input==NULL) {
    return NULL;
  }

  memset(temp,0,sizeof(temp));
  memset(userdata,0,sizeof(userdata));
  memset(decoded,0,sizeof(decoded));
  counter=0;
  for (i=0; i<strlen(input); i+=2) {
    userdata[counter++]=hexstr2int(input+i,2);
  }
  offset=-1;
  counter=0;
  for (i=0; i<encoded_size; i++) {
    if (i%8) {
      first = userdata[i-1-offset];
      first >>= 8-(i%8);
      end = userdata[i-offset];
      end <<= (i%8);
      *(decoded+counter) = (first|end)&127;
    } else {
      ++offset;
      *(decoded+counter) = userdata[i-offset]&127;
    }
    if (*(decoded+counter) == 0) { //special char @
      *(decoded+counter) = 128;
    }
    ++counter;
  }
  return convert_from_gsm(decoded);
}
