/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "common.h"
#include <string.h>
#include <stdlib.h>

void handle_s35(char* file,  char* pipe,
		int settings, struct parameters myparams, struct smsopts mysmsopts){
  char* temp;
  static int minimum=-1;
  static int maximum;
  char type[4];
  char buffer;
  int i=0;

  if (settings&1) {
    switch ((settings>>1)&7){
    default:
      errexit("Unknown %stype %d in program. Report as bug\n","file ",(settings>>1)&1);
      break;
    case 0: //Bitmap
      strcpy(type,"bmp");
      break;
    case 1: //Midi
      strcpy(type,"mid");
      break;
    case 2: //vCalendar (vcs)
      strcpy(type,"vcs");
      break;
    case 3: //vCards aka address book (vcf)
      strcpy(type,"vcf");
      break;
    }
    if (minimum==-1) { //get the real minimum and maximum slot number and ...
      if (((settings>>5)&7)==4) {
	temp=get_filetypes(1);
      } else {
	temp=get_filetypes(0);
      }
      if (temp!=NULL && (temp=strstr(temp,type))!=NULL) {
	temp+=3+strlen(type);
	minimum=atoi(temp);
	do {
	  buffer=temp[i++];
	} while (buffer!=')' && buffer!='-');
	if (buffer!=')') {
	  maximum=atoi(temp+i);
	} else {
	  maximum=minimum;
	}
      } else {
	errexit("%s slot numbers could not be retrieved.\n",type);
      }
      if (myparams.slot>=0 && (minimum>myparams.slot || myparams.slot>maximum)) { // ... test if slot is correctly set
	if (minimum!=maximum) {
	  errexit("%s values can only be %d to %d.\n",type,minimum,maximum);
	} else {
	  errexit("%s value can only be %d.\n",type,minimum);
	}
      }
    }
    transfer_s35((settings>>4)&15,file,type,myparams.slot,minimum,maximum,pipe);
  } else {
    switch ((settings>>1)&3){
    case 0: //no file type selected
      errexit("You must choose a valid file type.\n");
    case 1: //Phonebook
      pbook_s35((settings>>4)&15,file,myparams.mem);
      break;
    case 2: //SMS
      sms_s35((settings>>4)&15,file,pipe,myparams,mysmsopts);
      break;
    default:
      errexit("Unknown %stype %d in program. Report as bug\n","",(settings>>1)&1);
      break;
    }
  }			
}
