/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "common.h"
#include <ctype.h>
#include <string.h>

unsigned int hexstr2int(char *hexstring, int length){
  unsigned int i,digitvalue=0,intvalue=0,shift;
  char hexdigit;
	
  // simply believe me that atoi DID NOT WORK RELIABLE
  for (i=0;i<length;i++){
    switch(hexdigit=hexstring[i]){
    case '1':
      digitvalue=1;
      break;
    case '2':
      digitvalue=2;
      break;
    case '3':
      digitvalue=3;
      break;
    case '4':
      digitvalue=4;
      break;
    case '5':
      digitvalue=5;
      break;
    case '6':
      digitvalue=6;
      break;
    case '7':
      digitvalue=7;
      break;
    case '8':
      digitvalue=8;
      break;
    case '9':
      digitvalue=9;
      break;
    case 'A':
    case 'a':
      digitvalue=10;
      break;
    case 'B':
    case 'b':
      digitvalue=11;
      break;
    case 'C':
    case 'c':
      digitvalue=12;
      break;
    case 'D':
    case 'd':
      digitvalue=13;
      break;
    case 'E':
    case 'e':
      digitvalue=14;
      break;
    case 'F':
    case 'f':
      digitvalue=15;
      break;
    case '0':
    default:
      digitvalue=0;
      break;
    }
    shift=4*(length-i-1); //multiplicator: <<4*  = *16^
    intvalue+=digitvalue<<shift;
  }
  return(intvalue);
}

int is_number(char *string) {
  return is_pnumber(string,0);
}

int is_pnumber (char* string, unsigned short positive_only) {
  char buffer;
  int i;
    
  buffer=string[0];
  if (!positive_only) {
    if (buffer!='-' && buffer!='+' && !isdigit(buffer)) {
      return 0;
    }
  } else {
    if (buffer!='+' && !isdigit(buffer)) {
      return 0;
    }
  }
  for (i=1;i<strlen(string);i++) {
    buffer=string[i];
    if (!isdigit(buffer)) {
      return 0;
    }
  }
  return 1;
}

int is_numfield (char* string) {
  char buffer;
  int i;
  int infield=0;
    
  for (i=0;i<strlen(string);i++) {
    buffer=string[i];
    if (!isdigit(buffer) && buffer!='-' && buffer!=',') {
      return 0;
    }
    if (isdigit(buffer) && infield==0) {
      infield=1;
    }
    if (buffer=='-'){
      if (infield==1) {
	infield=2;
      } else {
	return 0;
      }
    }
    if (buffer==',') {
      if (infield==0) {
	return 0;
      } else {
	infield=0;
      }
    }
  }    
  return 1;
}
