/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef HELPERS_H
#define HELPERS_H

#include <stdarg.h>
#include <stdio.h>

void* mem_alloc (size_t size, short zero_it);
void* mem_realloc (void* oldpointer, size_t size);

char* str_dup (const char* input);
char* strn_dup (const char* input, size_t insize);

/*
 * These functions either read the length from the variable length or,
 * if <=0, will determine the needed size. The returns char* has to be
 * freed.
 */
char* strn_printf(int length, char* input,...);
char* strn_vprintf(int length, char* input, va_list* ap);
#endif
