/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//this file shall be an include for all subfiles of this project.

#include "../config.h"
/* needed for strptime, see NOTES in "man strptime" */
#define _GNU_SOURCE
#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

//#include "depincludes.h"
#include "smspdu.h"
#include <termios.h>
#include <unistd.h>

//global variables
int mytty;
int VERBOSE_LEVEL;
char PIN[13];

//some own types
struct parameters {
  char* text;
  char* number;
  int slot;
  char* mem;
};

/*
 * A bitfield for the settings
 * bits 3,2,1,0 -> file type
 *	x x x 1    file transfer
 *			0 0 0 1   bitmap
 *			0 0 1 1   midi
 *			0 1 0 1   vcs (vCalendar)
 *			0 1 1 1   vcf (vCard)
 *			1 x x 1   reserved
 *	x x x 0    other types
 *			0 0 0 0   unused value (no file type selected)
 *			0 0 1 0   phone book
 *			0 1 0 0   SMS (Short Message Service)
 *			0 1 1 0   reserved
 *			1 x x 0   reserved
 * bits 7,6,5,4 -> action type
 *	0 0 0 x   no action selected
 *	x x x 1   direct mode
 *	x x 1 x   delete/remove
 *	x 1 x x   send
 *	1 x x x   get
 */

//functon declaration
//from scmxx.c (no direct text output anywhere else!!!)
void help(char *me);
void version();
void errexit(char *errmessage, ...);
void myprintf(int verbose_level, char *output, ...);
//from common.c
void set_ttyport(char* ttyport, char *newttyport);
speed_t tty_speed(char *newttyspeed);
void new_at_command(char *at_command_p, char *addon_p);
void add_at_command(char *at_command_p, char *addon_p,...);
char* tty_write_read (char *at_command_p);
void tty_write_command(const char *at_command_p);
int  tty_write_data (const char* data, size_t count);
int  tty_write (const char* data, size_t count, const char* finish);
char* tty_readline(void);
char* tty_read(char *at_command_p);
void tty_open (char* ttyport, speed_t baudrate,unsigned int timeout,
               unsigned int ignore_serial_bits);
void tty_close();
int open_myFile_ro(char* file);
int open_myFile_rw(char* file);
void close_myFile(int filedes);
//from numhandle.c
unsigned int hexstr2int(char *hexstring, int length);
int is_number (char* string);
int is_pnumber (char* string, unsigned short positive_only);
int is_numfield (char* string);
//from action.c
void set_smsc (char* smsnr);
void set_time ();
char* get_value (char* at);
char* get_vendor ();
char* get_model ();
char* get_revision ();
char* get_phoneserial ();
char* get_simserial ();
char* get_simid ();
char* get_operator ();
char* get_smsc ();
char* get_charset ();
char* get_battery ();
char* get_signal_ber ();
struct tm* get_time ();
char* get_netstatus (unsigned int* areacode_p, unsigned int* cellid_p);
char* get_filetypes (short readable);
char* get_pbtypes ();
char* get_smsmemtypes ();
void info(char* file);
//from s35.c
void handle_s35(char* file, char* pipe,
		int settings, struct parameters myparams, struct smsopts mysmsopts);
//from s35_files.c
void transfer_s35(int action, char* file, char *ftype,
		  int slot, int minimum, int maximum,
		  char* myPIPE);
void delete_file_s35(char *ftype, int slot);
int detect_free_s35(char *ftype, int minimum, int maximum);
void send_file_s35(char* file, char *ftype, int slot);
void get_file_s35(char* file, char *ftype, int slot, char* pipe);
//from s35_pbook.c
void pbook_s35(int action, char* file, char* phonebook);
void delete_pb_s35(char* phonebook);
void send_pb_s35(char* file, char* phonebook);
void get_pb_s35(char* file, char* phonebook);
//from s35_sms.c
void sms_s35(int action, char* file, char* pipe,
	     struct parameters myparams, struct smsopts mysmsopts);
void delete_sms_s35(int smsslot);
void send_smsslot_s35(int smsslot, char* smsnumber);
char* create_smspdu(char* file, char* smstext, char* smsnumber, struct smsopts mysmsopts);
void send_smspdu(char* pdu, int direct);
void get_sms_s35(char* file, char* pipe, struct parameters myparams, int action);
void get_direct_sms_s35(char* file, char* pipe);
