/* This file is part of s10sh
 *
 * Copyright (C) 2000 by Salvatore Sanfilippo <antirez@invece.org>
 *
 * S10sh IS FREE SOFTWARE, UNDER THE TERMS OF THE GPL VERSION 2
 * don't forget what free software means, even if today is so diffused.
 *
 * ALL THIRD PARTY BRAND, PRODUCT AND SERVICE NAMES MENTIONED ARE
 * THE TRADEMARK OR REGISTERED TRADEMARK OF THEIR RESPECTIVE OWNERS
 */

#ifndef S10SH_COMMON_H
#define S10SH_COMMON_H

unsigned long get_usec(void);
int camera_last_ls(void);
int camera_get_last_ls(int which);
int camera_get_list(char *pathname);
void dump_filename(struct canonfile *f);
int offset_from_GMT(void);
int camera_get_image(char *pathname, char *destfile);
int camera_get_thumb(char *pathname, char *destfile);
int view_thumb(char *pathname);
int view_all(void);
int camera_get_file_attr(char *name);
int camera_file_chmod(char *name, int action, int bits);
int camera_file_chmod_all(int action, int bits);
int camera_delete_all(int which);
int camera_close(void);
char *camera_get_id(void);
char *camera_get_disk(void);
void camera_startup_initialization(void);
void camera_ping(void);
int camera_get_disk_info(char *disk, int *size, int *free);
int camera_get_power_status(int *good, int *ac);
void dump_hex(const char *msg, const unsigned char *buf, int len);

#endif
