/* -*- c-file-style: "ruby" -*- */
/************************************************

  rbgtktogglebutton.c -

  $Author: klamath $
  $Date: 2001/10/04 02:13:44 $

  Copyright (C) 1998-2000 Yukihiro Matsumoto,
                          Daisuke Kanda,
                          Hiroshi Igarashi
************************************************/

#include "global.h"

static VALUE
tbtn_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
{
    VALUE label;
    GtkWidget *widget;

    if (rb_scan_args(argc, argv, "01", &label) == 1) {
	widget = gtk_toggle_button_new_with_label(STR2CSTR(label));
    }
    else {
	widget = gtk_toggle_button_new();
    }

    set_widget(self, widget);
    return Qnil;
}

static VALUE
tbtn_set_mode(self, mode)
    VALUE self, mode;
{
    gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(get_widget(self)),
			       RGTEST(mode));
    return self;
}

static VALUE
tbtn_set_state(self, state)
    VALUE self, state;
{
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(get_widget(self)),
				RGTEST(state));
    return self;
}

static VALUE
tbtn_toggled(self)
    VALUE self;
{
    gtk_toggle_button_toggled(GTK_TOGGLE_BUTTON(get_widget(self)));
    return self;
}

static VALUE
tbtn_is_active(self)
    VALUE self;
{
    if (GTK_TOGGLE_BUTTON(get_widget(self))->active)
	return Qtrue;
    return Qfalse;
}
static VALUE
tbtn_set_active(self,n)
    VALUE self, n;
{
    (void)gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(get_widget(self)),
				       RGTEST(n));
    return self;
}

void Init_gtk_toggle_button()
{
    gTButton = rb_define_class_under(mGtk, "ToggleButton", gButton);

    rb_define_const(gTButton, "SIGNAL_TOGGLED", rb_str_new2("toggled"));

    rb_define_method(gTButton, "initialize", tbtn_initialize, -1);
    rb_define_method(gTButton, "set_mode", tbtn_set_mode, 1);
    rb_define_method(gTButton, "set_state", tbtn_set_state, 1); /* back-compat. */
    rb_define_method(gTButton, "toggled", tbtn_toggled, 0);
    rb_define_method(gTButton, "active", tbtn_is_active, 0);
    rb_define_method(gTButton, "active?", tbtn_is_active, 0);
    rb_define_method(gTButton, "set_active", tbtn_set_active, 1);
    rb_define_method(gTButton, "active=", tbtn_set_active, 1);

    /* child initialization */
    Init_gtk_check_button();
}
