/* $Id: proto.h,v 1.39 2006/02/08 13:15:53 hacki Exp $ */

/*
 * Copyright (c) 2006 Marcus Glocker <marcus@nazgul.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/* cipher.c */

int			cipher_base64_encode(unsigned char *,
			    const unsigned char *, const int, const int);
int			cipher_base64_decode(unsigned char *,
			    const unsigned char *, const int, const int);
int			cipher_base64_rp(char *, const int);
int			cipher_aes_sendsample(unsigned char *, const int);
unsigned char *		cipher_rsa_encrypt_aeskey(unsigned char *);
unsigned char *		cipher_aes_generate_key(void);

/* mp4.c */

int			mp4_check(const int);
int			mp4_revert(unsigned char *);
int			mp4_seek_box(const int, const char *);
struct stco *		mp4_parse_stco(const int);
struct stsz *		mp4_parse_stsz(const int);
struct stsc *		mp4_parse_stsc(const int);
struct stsd *		mp4_parse_stsd(const int);

/* rtsp.c */

int			rtsp_generate_sid(char *, const int);
int			rtsp_connect(void);
int			rtsp_disconnect(void);
int			rtsp_Announce(void);
int			rtsp_Setup(void);
int			rtsp_Record(void);
int			rtsp_Setparameter(void);
int			rtsp_Teardown(void);
int			rtsp_parse_token(char *, const char *, const char *,
			    const int len);
char *			rtsp_execreq(const char *);
struct rtsp_response *	rtsp_parse_response(void);

/* sys.c */

int			sys_connect(const char *, const int);
int			sys_getlocalip(char *, const int);
int			sys_read(const int, char *, const int);
int			sys_write(const int, const char *, const int);
int			sys_strcutl(char *, const char *, const int, const int);
int			sys_strcutw(char *, const char *, const int, const int);
int			sys_strcuts(char *, const char *, const char,
			    const char, const int);
