// rTorrent - BitTorrent client
// Copyright (C) 2005-2007, Jari Sundell
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// In addition, as a special exception, the copyright holders give
// permission to link the code of portions of this program with the
// OpenSSL library under certain conditions as described in each
// individual source file, and distribute linked combinations
// including the two.
//
// You must obey the GNU General Public License in all respects for
// all of the code used other than OpenSSL.  If you modify file(s)
// with this exception, you may extend this exception to your version
// of the file(s), but you are not obligated to do so.  If you do not
// wish to do so, delete this exception statement from your version.
// If you delete this exception statement from all source files in the
// program, then also delete it here.
//
// Contact:  Jari Sundell <jaris@ifi.uio.no>
//
//           Skomakerveien 33
//           3185 Skoppum, NORWAY

#include "config.h"

#include <torrent/exceptions.h>

#include "rpc/command_slot.h"
#include "rpc/command_variable.h"
#include "rpc/command_download_slot.h"
#include "rpc/command_file_slot.h"
#include "rpc/command_peer_slot.h"
#include "rpc/command_tracker_slot.h"

#include "globals.h"
#include "control.h"
#include "command_helpers.h"

rpc::CommandSlot          commandSlots[COMMAND_SLOTS_SIZE];
rpc::CommandSlot*         commandSlotsItr = commandSlots;
rpc::CommandVariable      commandVariables[COMMAND_VARIABLES_SIZE];
rpc::CommandVariable*     commandVariablesItr = commandVariables;
rpc::CommandDownloadSlot  commandDownloadSlots[COMMAND_DOWNLOAD_SLOTS_SIZE];
rpc::CommandDownloadSlot* commandDownloadSlotsItr = commandDownloadSlots;
rpc::CommandFileSlot      commandFileSlots[COMMAND_FILE_SLOTS_SIZE];
rpc::CommandFileSlot*     commandFileSlotsItr = commandFileSlots;
rpc::CommandPeerSlot      commandPeerSlots[COMMAND_PEER_SLOTS_SIZE];
rpc::CommandPeerSlot*     commandPeerSlotsItr = commandPeerSlots;
rpc::CommandTrackerSlot   commandTrackerSlots[COMMAND_TRACKER_SLOTS_SIZE];
rpc::CommandTrackerSlot*  commandTrackerSlotsItr = commandTrackerSlots;

void initialize_command_download();
void initialize_command_events();
void initialize_command_file();
void initialize_command_peer();
void initialize_command_local();
void initialize_command_network();
void initialize_command_tracker();
void initialize_command_ui();

void
initialize_commands() {
  initialize_command_events();
  initialize_command_network();
  initialize_command_local();
  initialize_command_ui();
  initialize_command_download();
  initialize_command_file();
  initialize_command_peer();
  initialize_command_tracker();

#ifdef ADDING_COMMANDS 
  if (commandSlotsItr > commandSlots + COMMAND_SLOTS_SIZE ||
      commandVariablesItr > commandVariables + COMMAND_VARIABLES_SIZE ||
      commandDownloadSlotsItr > commandDownloadSlots + COMMAND_DOWNLOAD_SLOTS_SIZE ||
      commandFileSlotsItr > commandFileSlots + COMMAND_FILE_SLOTS_SIZE ||
      commandPeerSlotsItr > commandPeerSlots + COMMAND_PEER_SLOTS_SIZE ||
      commandTrackerSlotsItr > commandTrackerSlots + COMMAND_TRACKER_SLOTS_SIZE)
#else
  if (commandSlotsItr != commandSlots + COMMAND_SLOTS_SIZE ||
      commandVariablesItr != commandVariables + COMMAND_VARIABLES_SIZE ||
      commandDownloadSlotsItr != commandDownloadSlots + COMMAND_DOWNLOAD_SLOTS_SIZE ||
      commandFileSlotsItr != commandFileSlots + COMMAND_FILE_SLOTS_SIZE ||
      commandPeerSlotsItr != commandPeerSlots + COMMAND_PEER_SLOTS_SIZE ||
      commandTrackerSlotsItr != commandTrackerSlots + COMMAND_TRACKER_SLOTS_SIZE)
#endif
    throw torrent::internal_error("initialize_commands() static command array size mismatch.");
}

void
add_variable(const char* getKey, const char* setKey, const char* defaultSetKey,
             rpc::CommandMap::generic_slot getSlot, rpc::CommandMap::generic_slot setSlot,
             const torrent::Object& defaultObject) {
  rpc::CommandVariable* variable = commandVariablesItr++;
  variable->set_variable(defaultObject);

  rpc::commands.insert_generic(getKey, variable, getSlot, rpc::CommandMap::flag_dont_delete | rpc::CommandMap::flag_public_xmlrpc, "i:", "");

  if (setKey)
    rpc::commands.insert_generic(setKey, variable, setSlot, rpc::CommandMap::flag_dont_delete | rpc::CommandMap::flag_public_xmlrpc, "i:", "");

  if (defaultSetKey)
    rpc::commands.insert_generic(defaultSetKey, variable, setSlot, rpc::CommandMap::flag_dont_delete, "i:", "");
}
