#!/usr/bin/perl
# Create clickable rrd graphs by. james@diku.dk (Claus Norrbohm)

# Basic idea: click high -> zoom out, click low -> zoom in,
# click left -> back history, click right -> forward history

use CGI;
use POSIX;

# modify as needed
$hight=300; # Image size
$width=600;
$title="notes01"; # Name of graph

$expiredate = strftime "%a, %e %b %Y %H:%M:%S GMT", gmtime(time); # Format date(now)

print "Content-type: text/html\n"; # Use html
print "Cache-Control: no-cache\n"; # Ensure no cashing of page
print "Expires: $expiredate\n\n"; # Expire now

my $query = new CGI;

print $query->start_html("Clickable rrd-graph"); # Title of html page

if ($query->param()) { # the form has already been filled out

  $start = $query->param("start"); # Start time
  $end = $query->param("end"); # End time
  $x = $query->param("img.x"); # x/y cordinates of click
  $y = $query->param("img.y");

  $intv=($end-$start); # Last used interval
  $zoom=($hight+100-$y)/$hight; # Find zoom factor + 100 because hight is not exact
  $center=$start+$intv*$x/$width;  # Find time corresponding to click

  $start=int($center-$intv*$zoom); # Calc new start
  $end=int($center+$intv*$zoom); # Calc new end

} else { # first time through, so present clean form
  
  $end=time(); # use now for end
  $start=$end-86400; # and go back 24 hours
}

print "\n\n";
print "<FORM ACTION=\"map.cgi\">\n"; # Create a form with image see page xxx in: Wallace, Shawn P.
print "<INPUT TYPE=\"image\" NAME=\"img\" SRC=\"png.cgi?start=$start&end=$end&title=$title&hight=$hight&width=$width\">\n";
print "<INPUT TYPE=\"hidden\" NAME=\"start\" VALUE=\"$start\">\n"; # Programming Web Graphics with Perl
print "<INPUT TYPE=\"hidden\" NAME=\"end\" VALUE=\"$end\">\n"; # and GNU Software
print "</FORM>\n\n"; # O'Reilly UK,1999, UK, Paperback

print $query->end_html(); # lmth ....
