/* rle.h - header file for Utah Raster Toolkit files */

#define RLE_MAGIC   0xcc52

typedef struct {
    unsigned short  magic;
    unsigned short  xpos, ypos;
    unsigned short  xsize, ysize;
    unsigned char   flags;
    unsigned char   ncolors;        /* no of color channels - 0 = only color map, 1 = B&W, 3 = RGB */
    unsigned char   pixelbits;      /* bits per pixel, per color channel (max 8) */
    unsigned char   ncmap;          /* no of color map channels */
    unsigned char   cmaplen;        /* no of entries in color map for each channel (log base 2, i.e. 8 = 256 entries) */
} Header;

/* flags */
#define H_CLEARFIRST        0x01    /* clear frame buffer -- ignored (we always clear) */
#define H_NO_BACKGROUND     0x02    /* no background color provided */
#define H_ALPHA             0x04    /* has alpha channel (color channel -1, not counted in Header.ncolors) */
#define H_COMMENT           0x08    /* comments after header */

/* image encoding opcodes */
#define OP_SKIPLINES        0x01
#define OP_SETCOLOR         0x02
#define OP_SKIPPIXELS       0x03
#define OP_BYTEDATA         0x05
#define OP_RUNDATA          0x06
#define OP_EOF              0x07

#define OP_LONG_DATUM       0x40

/* SetColor datum values */
#define CHANNEL_RED           0x00
#define CHANNEL_GREEN         0x01
#define CHANNEL_BLUE          0x02
#define CHANNEL_ALPHA         0xff  /* -1 */

