/*
 *      Resolv
 *      Copyright (c) 2001 - s23a <s23a@mail.ru> 
 * 
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
#include <stdio.h>

#include "resolv.h"

void
usage(void)
{       
	(void)printf("\n%s\n", TITLE);
        (void)printf("usage: resolv [options] <ip>\n\n"
"[options]\n"
"   -f <file>           Output to a logfile\n"
"   -l <ipsfile>        Resolve several ips from file\n"
"   -m                  Like -f option, for -l option\n"
"   -s <pattern>        Search pattern and output to a logfile\n"
"   -x <patfile>        Extract patterns from file and output to a logfile\n"
"   -d                  Exec in background mode\n"
"   -a                  Show hostname aliasses\n"
"   -t <timeout>        Set timeout\n"
"   -i <wait>           Wait \"wait\" seconds between each resolv\n"
"   -e \"format\"         Execute <format> string when a match is found\n"
"   -v                  Verbose.\n"
"   -h                  Display this help\n"
"\n"
"\"format\" - valid variables:\n"
"  %%s  insert space         %%c  insert double quotes\n"
"  %%n  insert newline       %%T  insert total ip addresses\n"
"  %%t  insert tab           %%d  exec program in background mode\n"
"  %%i  insert ip address\n"
"  %%h  insert hostname\n"
"\n"
"<ip>	aaa.bbb.ccc.ddd\n\n");
        exit(0);
}       
