/*
 *      Resolv
 *      Copyright (c) 2001 - s23a <s23a@mail.ru> 
 * 
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "resolv.h"

extern int dflag;
extern int fflag;
extern int mflag;


/*
 * Format and make vars.string string 
 */
char*
get_vars()
{
        register int i, j;
        
       	(void)bzero((char*)&vars.make, sizeof(vars.make));

        for (i = 0, j = 0; i < strlen(vars.format); i++, j++) {
                if (vars.format[i] == '%') {
                        ++i;
                        switch (vars.format[i]) {
                        case 'i':
                        	snprintf(vars.make, MAKE_SIZE, "%s%s", vars.make, vars.ip); 
                                j = (strlen(vars.make) - 1);
                                break;
                        case 'h':
                                snprintf(vars.make, MAKE_SIZE, "%s%s", vars.make, vars.hostname);
                                j = (strlen(vars.make) - 1);
				break;       
			case 'T':
				snprintf(vars.make, MAKE_SIZE, "%s%1.0f", vars.make,  resolv_count);
				j = (strlen(vars.make) - 1);
				break;
                        case 'n':
                                vars.make[j] = '\n';
                                break;
                        case 't':
                                vars.make[j] = '\t';
                                break;
                        case 's':
                                vars.make[j] = ' ';
                                break;
                        case '%':
                                vars.make[j] = '%';
                                break;
			case 'c':
				vars.make[j] = '"';
				break;
			case 'd':
				vars.flags |= FMT_DAEMON;
				break;
                        default:
                                printf("[%%%c] not valid variable\n", vars.format[i]);
                                usage();
                                break;
                        }       
                }       
                else
                        vars.make[j] = vars.format[i];
        }               
        return (vars.make);
}


/*
 * executing vars.string progname when match is found
 */
int
executing(hostname, fildes, f)
	char *hostname;
	FILE *fildes;
	int *f;
{	
	/* load vars.ip */
	(void)snprintf(vars.ip, 15, "%d.%d.%d.%d", *(f+0), *(f+2), *(f+4), *(f+6));
	/* load vars.hostname */
	(void)strncpy(vars.hostname, hostname, strlen(hostname));               

	(void)fprintf(SFLAGS, "\nFound pattern in [%s]\n", hostname);
	(void)snprintf(vars.string, STRING_SIZE, "%s", get_vars());
	
	/* run each procces into background */
	if (vars.flags & FMT_DAEMON) {
		switch (fork()) {
			case 0:
				if (dflag) {
					close(STDIN_FILENO);
                                        close(STDOUT_FILENO);
					close(STDERR_FILENO);
				}       
			
				(void)fprintf(SFLAGS, "%s \"%s\"\n", "Executing:", vars.string);
				(void)system(vars.string);
                                break;
                        case -1:
				perror("fork()");
				exit(-1);
				break;
			default:
				exit(-1);
				break;
		}
	}
	else {
		(void)fprintf(SFLAGS, "%s \"%s\"\n", "Executing:", vars.string);
		(void)system(vars.string);
	}

	return (0);
}
