/*
 *      Resolv
 *      Copyright (c) 2001 - s23a <s23a@mail.ru> 
 * 
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
#include <stdio.h>
#include <stdlib.h>

#include "resolv.h"

#define MAX_ERR_CODES	8

struct err_code {
	char string[40];	/* message */
	int code;		/* error level & exit code */
} err_code_list[MAX_ERR_CODES] =
		{
/* 1 */	{ "logfile too long", 1},
/* 2 */	{ "pattern too long", 1},
/* 3 */	{ "listfile too long", 1},
/* 4 */	{ "patterns list file too long", 1},
/* 5 */	{ "exec string too long", 1},
/* 6 */	{ "Ip range too long", 1},
/* 7 */	{ "pattern > name", 1},
/* 8 */	{ "address format incorrect", 1}
		};

/*
 * Show error messages
 */
int
error(type)
        int type;
{
        fprintf(stderr, "%s: %s\n", (err_code_list[type-1].code == 1)? 
		"error": "warning", err_code_list[type-1].string);

        if (err_code_list[type-1].code != 0)
                exit(err_code_list[type-1].code);
        else
                return (0);
}
