#include "util.h"
#include "config.h"
#include <time.h>
#include "tcl.h"

extern HANDLE 		TclpGetProcess(unsigned long pid);

int gettimeofday(struct timeval *p, struct timezone *z)
{
    TIME_ZONE_INFORMATION tz;
    GetTimeZoneInformation(&tz);

    if (p) {
        p->tv_sec = time(NULL);
	p->tv_usec = 0;
    }
    if (z) {
	z->tz_minuteswest = tz.Bias ;
	z->tz_dsttime = tz.StandardBias != tz.Bias;
    }
    return 0;
}

/*  TCL Terminate Process Command - always returns TCL_OK even if there is an error
 *   UsesTclPGetProcess in TclWinPipe.c, which returns a process handle given its id.
 *   The process id is passed as an argument and originally comes from "exec &"   
 */
int termProc(dummy, interp, argc, argv) 
	ClientData dummy;		/* Not used. */
	Tcl_Interp *interp;		/* Current interpreter. */
	int argc;			/* Number of arguments. */
	char **argv;		/* Argument strings. */
{
	unsigned long status;
	HANDLE hProc;
	unsigned long temp=atol ((char*)argv[1]);   
	(HANDLE) hProc=TclpGetProcess(temp);			/* get the handle for our process id*/
	if (GetExitCodeProcess(hProc, &status) == FALSE) {return TCL_OK;}	/*now get the exit code*/
	if (status != STILL_ACTIVE) {return TCL_OK;}			/*if the process is not active anymore then return*/
	TerminateProcess (hProc, status);				/*if we get this far we can kill the process*/
	return (TCL_OK);
}
