/*
 *	FILE: util.h
 *	PROGRAM: BAT
 *	AUTHOR: Isidor Kouvelas
 *
 * 	$Revision: 1.2 $
 *	$Date: 1998/10/14 14:32:22 $
 *
 * Copyright (c) 1995,1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, is permitted, for non-commercial use only, provided
 * that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 * Use of this software for commercial purposes is explicitly forbidden
 * unless prior written permission is obtained from the authors.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _UTIL_H_
#define _UTIL_H_

#define UNUSED(x)	(x=x)
#define IN_CLASSD(i)	(((long)(i) & 0xf0000000) == 0xe0000000)
#define IN_MULTICAST(i)	IN_CLASSD(i)

#define xmalloc(x)	_xmalloc(x,__FILE__,__LINE__)
#define block_alloc(x)	_block_alloc(x,__FILE__,__LINE__)
#define block_free(x,y) _block_free(x,y,__LINE__)
#define xstrdup(x)	_xstrdup(x,__FILE__,__LINE__)
#define debug_msg	_dprintf("%s:%d ", __FILE__, __LINE__), _dprintf

void 	 xdoneinit(void);
void	 xmemchk(void);
void     xmemdmp(void);
void	 xfree(void *x);
void	*_xmalloc(unsigned size,const char *filen,int line);
char	*_xstrdup(const char *s1, const char *filen, int line);
void	*_block_alloc(unsigned size, const char *filen, int line);
void	 _block_free(void *p, int size, int line);
void	 block_release_all(void);
void     block_trash_chk(void);
void	 _dprintf(const char *format, ...);

#endif /* _UTIL_H_ */

#ifdef WIN32
struct timezone {
	int tz_minuteswest;
	int tz_dsttime;
};
#endif

typedef struct _socket_udp socket_udp;