/* 
 * winMain.c --
 *
 * Main entry point for wish and other Tk-based applications.
 *
 * Copyright (c) 1995 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * SCCS: @(#) winMain.c 1.33 96/12/17 12:56:14
 */

#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#undef WIN32_LEAN_AND_MEAN
#include <winsock.h>
#endif

#include <tcl.h>
#include <tk.h>
#include <malloc.h>
#include <locale.h>
#include <assert.h>
#include <time.h>
#include "util.h"
#include "config.h"

#ifdef RELATE_INT
#include "xbm/merci.xbm"
#include "xbm/relate.xbm"
#include "xbm/ucl.xbm"
#include "xbm/exeter.xbm"
#else
#include "xbm/ucl.xbm"
#include "xbm/shrimp.xbm"
#endif

#include "xbm/cd.xbm"
#include "xbm/mic.xbm"
#include "xbm/speaker.xbm"
#include "xbm/head.xbm"
#include "xbm/line_in.xbm"
#include "xbm/line_out.xbm"
#include "xbm/disk.xbm"
#include "xbm/stop.xbm"
#include "xbm/play.xbm"
#include "xbm/pause.xbm"
#include "xbm/rec.xbm"

static Tk_Window mainWindow;	/* The main window for the application.  If
				 * NULL then the application no longer
				 * exists. */

extern char code[];

#ifdef WIN32
extern void		setargv _ANSI_ARGS_((int *argcPtr, char ***argvPtr));
extern void		WishPanic _ANSI_ARGS_(TCL_VARARGS(char *,format));
extern void 		Dll_Init (HINSTANCE hInstance);
extern int 		gettimeofday(struct timeval *p, struct timezone *z);
extern int		termProc(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
#endif

extern void		lbl_cb_send_quit();
extern void		lbl_cb_init();
extern int 		initconfbus (ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
extern int		startconfbus(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

double	nteVersion=1.5;
int	ratVersion=0;

#ifdef WIN32
int check_exists(char* filename) {
	PROCESS_INFORMATION piProcInfo;	
	STARTUPINFO siStartInfo; 

	ZeroMemory( &siStartInfo, sizeof(STARTUPINFO) );
	siStartInfo.cb = sizeof(STARTUPINFO); 
	return CreateProcess(NULL, filename, NULL,NULL,FALSE,0,NULL,NULL, &siStartInfo, &piProcInfo);
}

void check_versions () 
{
	HKEY hKeyResult;
	DWORD dwDisp;
	int buffersz = 20, v1, v2, v3;
	char buffer[20];
	int rat30, rat32;
	/* Check which rat binaries are vailable */
	rat30=check_exists("rat -version");
	rat32=check_exists("rat32 -version");

	/* check to see if rat 3.2 has been installed in registry*/
	RegCreateKeyEx(HKEY_CURRENT_USER, "Software\\Mbone Applications\\rat\\", 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKeyResult, &dwDisp);
	if (ERROR_SUCCESS == RegQueryValueEx(hKeyResult, "*audioTool", 0, &dwDisp, buffer, &buffersz)) {
		sscanf(buffer, "%*s %d.%d.%d",&v1, &v2, &v3);
		ratVersion=10000*v1+100*v2+v3;
		if (ratVersion<30205) ratVersion=0;
	}
	RegCloseKey(hKeyResult);
	/* if we got 3.0 and 3.2 then indicate that we have both */
	if (ratVersion!=0 && rat32==1 && rat30==1) ratVersion=2;

	/* if we didn't find 3.2 but got 3.0 then assume it's 3.0.29 */
	if (ratVersion==0 && rat30==1) ratVersion=30029;

	/* if ratVersion is still=0 then just disable it */
	if (ratVersion==0) ratVersion=-1;

	/* we'll assume that we're using the newer version of NTE */
	/*(CreateKeyEx(HKEY_CURRENT_USER, "Software\\Mbone Applications\\nte\\", 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKeyResult, &dwDisp);
	if (ERROR_SUCCESS == RegQueryValueEx(hKeyResult, "version", 0, &dwDisp, buffer, &buffersz)) nteVersion=atof(buffer);
	RegCloseKey(hKeyResult);*/
}
#else
void check_versions () 
{
	/* we'll just check rat for the moment*/
	char buffer[128];  
	FILE *file; 
	int v1, v2, v3;
	if ( ( file=popen( "rat -version", "rt") )!=NULL ) {
		fgets(buffer, sizeof(buffer), file);
		pclose(file);
		/* get version */
		if (strncmp(buffer,"RAT",3)==0) {
			sscanf(buffer, "%*s v%d.%d.%d",&v1, &v2, &v3);
			ratVersion=10000*v1+100*v2+v3;
		}
	}

	/* try a different filename if we didn't get 3.2 first time round*/
	if (ratVersion<30200) {
		memset (buffer,0, sizeof(buffer));
		if ( ( file=popen( "rat32 -version", "rt") )!=NULL ) {
			fgets(buffer, sizeof(buffer), file);
			pclose(file);
			if (strncmp(buffer,"RAT",3)==0) {
				sscanf(buffer, "%*s v%d.%d.%d",&v1, &v2, &v3);
				/* if we got 3.0 earlier and this is 3.2 then indicate that we have both */
				if (ratVersion>0 && ratVersion<30200 && ((10000*v1+100*v2+v3)>30204)) ratVersion=2;
				/* ...otherwise if this is something else then ignore it */
			}
		}
	}
	/* if ratVersion is still=0 then just disable it */
	if (ratVersion==0) ratVersion=-1;
}
#endif

int quitvic (dummy, interp, argc, argv) 
	ClientData dummy;		/* Not used. */
	Tcl_Interp *interp;		/* Current interpreter. */
	int argc;			/* Number of arguments. */
	char **argv;		/* Argument strings. */
{
	lbl_cb_send_quit();
	return (TCL_OK);
}

#ifndef WIN32
int
main(argc, argv)
	int argc;			/* Number of command-line arguments. */
	char **argv;		/* Values of command-line arguments. */
{
	lbl_cb_init();
	check_versions();
	 _Tk_Main(argc, argv, Tcl_AppInit);
	return 0;			/* Needed only to prevent compiler warning. */
}
#else

int APIENTRY
WinMain(hInstance, hPrevInstance, lpszCmdLine, nCmdShow)
	HINSTANCE hInstance;
	HINSTANCE hPrevInstance;
	LPSTR lpszCmdLine;
	int nCmdShow;
{
	char **argv, *p;
	int argc;
	char buffer[MAX_PATH];
	WSADATA WSAdata;

	if (WSAStartup(MAKEWORD (1, 1), &WSAdata)) {
		perror("Windows Sockets init failed");
		abort();
	}

	Tcl_SetPanicProc(WishPanic);
	setlocale(LC_ALL, "C");
	SetMessageQueue(64);
	setargv(&argc, &argv);
	GetModuleFileName(NULL, buffer, sizeof(buffer));
	argv[0] = buffer;
	for (p = buffer; *p != '\0'; p++) {
		if (*p == '\\') {
			*p = '/';
		}
	}
	lbl_cb_init();
	Dll_Init(hInstance);
	check_versions();

	_Tk_Main(argc, argv, Tcl_AppInit);
	return 1;
}
#endif

/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

int
Tcl_AppInit(interp)
    Tcl_Interp *interp;		/* Interpreter for application. */
{
	Tcl_Init(interp);
	Tk_Init(interp);

#ifdef WIN32
	Tcl_CreateCommand(interp,"terminate_process", termProc, (ClientData)mainWindow, NULL);
	Tcl_SetVar(interp, "win32", "1", TCL_GLOBAL_ONLY);
	Registry_Init(interp);
#endif

	Tcl_CreateCommand(interp,"init_confbus", initconfbus, (ClientData)mainWindow, NULL);
	Tcl_CreateCommand(interp,"quit_vic", quitvic, (ClientData)mainWindow, NULL);

#ifdef RELATE_INT
	Tk_DefineBitmap(interp, Tk_GetUid("merci"), merci_bits, merci_width, merci_height);
	Tk_DefineBitmap(interp, Tk_GetUid("ucl"), ucl_bits, ucl_width, ucl_height);
	Tk_DefineBitmap(interp, Tk_GetUid("relate"), r140_bits, r140_width, r140_height);
	Tk_DefineBitmap(interp, Tk_GetUid("exeter"), exeter_bits, exeter_width, exeter_height);

#else
	Tk_DefineBitmap(interp, Tk_GetUid("ucl"), ucl_bits, ucl_width, ucl_height);
	Tk_DefineBitmap(interp, Tk_GetUid("shrimp"), shrimp_bits, shrimp_width, shrimp_height);
#endif
    
	if (ratVersion>30204 || ratVersion==2) {
		init_mbus(interp);
		Tcl_SetVar(interp, "rat32", "1", TCL_GLOBAL_ONLY);
		Tk_DefineBitmap(interp, Tk_GetUid("headphone"), head_bits, head_width, head_height);
		Tk_DefineBitmap(interp, Tk_GetUid("line_out"), line_out_bits, line_out_width, line_out_height);
		Tk_DefineBitmap(interp, Tk_GetUid("line_in"), line_in_bits, line_in_width, line_in_height);
		Tk_DefineBitmap(interp, Tk_GetUid("speaker"), speaker_bits, speaker_width, speaker_height);
		Tk_DefineBitmap(interp, Tk_GetUid("microphone"), mic_bits, mic_width, mic_height);
		Tk_DefineBitmap(interp, Tk_GetUid("cd"), cd_bits, cd_width, cd_height);
		Tk_DefineBitmap(interp, Tk_GetUid("disk"), disk_bits, disk_width, disk_height);
		Tk_DefineBitmap(interp, Tk_GetUid("stop"), stop_bits, stop_width, stop_height);
		Tk_DefineBitmap(interp, Tk_GetUid("play"), play_bits, play_width, play_height);
		Tk_DefineBitmap(interp, Tk_GetUid("pause"), pause_bits, pause_width, pause_height);
		Tk_DefineBitmap(interp, Tk_GetUid("rec"), rec_bits, rec_width, rec_height);

		Tcl_CreateCommand(interp,"start_confbus", startconfbus, (ClientData)mainWindow, NULL);
	}
	Tcl_SetVar(interp, "my_cname", (char *)get_cname(), TCL_GLOBAL_ONLY);
	if (ratVersion<30200) Tcl_SetVar(interp, "rat32", "0", TCL_GLOBAL_ONLY);
	if (ratVersion==2) Tcl_SetVar(interp, "rat32", "2", TCL_GLOBAL_ONLY);
	if (ratVersion==-1) Tcl_SetVar(interp, "rat32", "-1", TCL_GLOBAL_ONLY);

	if (nteVersion>1.4) Tcl_SetVar(interp, "nte15", "1", TCL_GLOBAL_ONLY); else Tcl_SetVar(interp, "nte15", "0", TCL_GLOBAL_ONLY);

#ifdef EXT_SCRIPT
	if (Tcl_VarEval(interp, "source ", "relate.tcl", (char *) NULL) != TCL_OK) {
		goto error;
		exit (-1);
	}
#else
	if (Tcl_Eval(interp, code)!=TCL_OK) {
		goto error;
	}
#endif
	return TCL_OK;

error:
#ifdef WIN32
	WishPanic(interp->result);
#else
	fprintf(stderr, "error: %s\n", interp->result);
#endif
	return TCL_ERROR;
}
