/*
 * FILE:    lbl_confbus.c
 * PROGRAM: RAT
 * AUTHORS: Colin Perkins
 *
 * $Revision: 1.2 $
 * $Date: 1998/12/04 15:08:05 $
 * 
 * Copyright (c) 1997 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, is permitted, for non-commercial use only, provided
 * that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 * Use of this software for commercial purposes is explicitly forbidden
 * unless prior written permission is obtained from the authors.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


#include "util.h"
#include "config.h"
#include "tcl.h"

#define LBL_CB_ADDR 	0xe0ffdeef
#define LBL_CB_PORT 	0xdeaf
#define LBL_CB_MAGIC	0x0ef5ee0a
#define CB_BUF_SIZE    	1024

typedef struct {
        int     magic;
        short   type;
        short   pid;
        char    buf[1];
} lbl_cb_msg;

int lbl_cb_base_socket;
int lbl_cb_channel;
int lbl_cb_channel_socket;

void lbl_cb_init()
{
  char loop = 1;
  char addr = 1;
  lbl_cb_base_socket = sock_init(LBL_CB_ADDR, LBL_CB_PORT, 0);
}

void lbl_cb_init_channel(int channel)
{
  char loop = 1;
  char addr = 1;
  lbl_cb_channel_socket = sock_init(LBL_CB_ADDR, LBL_CB_PORT+channel, 0);
  lbl_cb_channel = channel;
}

void lbl_cb_send_quit()
{
  char		 	 buffer[CB_BUF_SIZE];
  lbl_cb_msg		*msg = (lbl_cb_msg *) buffer;
  struct sockaddr_in	 dest;
  u_long		 addr = htonl(LBL_CB_ADDR);
  int			 ret;

  if (lbl_cb_channel_socket == -1) {
    /* Conference bus is not being used! */
    return;
  }

  memcpy((char *) &dest.sin_addr.s_addr, (char *) &addr, sizeof(addr));
  dest.sin_family = AF_INET;
  dest.sin_port   = htons(LBL_CB_PORT + lbl_cb_channel);
  msg->magic = htonl(LBL_CB_MAGIC);
  msg->type  = htons(0);
  msg->pid   = htons(getpid());
  sprintf(msg->buf, "relate_quit nomsg");
  if ((ret = sendto(lbl_cb_channel_socket, buffer, strlen(msg->buf) + 9, 0, (struct sockaddr *) &dest, sizeof(dest))) < 0) {
    perror("lbl_cb_send_quit");
  }
}

int
sock_init(u_long inaddr, int port, int t_flag)
{
	struct sockaddr_in sinme;
#ifndef WIN32
	char            ttl = (char)t_flag;
#else
	int		ttl = t_flag;
#endif
	int             tmp_fd;
	int             reuse = 1;
	char          loop = 1;
	struct ip_mreq  imr;

	memset((char *) &sinme, 0, sizeof(sinme));

	if ((tmp_fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
		perror("Relate: socket error");
		exit(-1);
	}

	if (setsockopt(tmp_fd, SOL_SOCKET, SO_REUSEADDR, (char *) &reuse, sizeof(reuse)) < 0) {
		perror("Relate: setsockopt SO_REUSEADDR");
	}

#ifdef SO_REUSEPORT
	if (setsockopt(tmp_fd, SOL_SOCKET, SO_REUSEPORT, (char *) &reuse, sizeof(reuse)) != 0) {
		perror("setsockopt SO_REUSEPORT");
		abort();
	}
#endif
	sinme.sin_family = AF_INET;
	sinme.sin_addr.s_addr = htonl(INADDR_ANY);
	sinme.sin_port = htons(port);
	if (bind(tmp_fd, (struct sockaddr *) & sinme, sizeof(sinme)) < 0) {
		perror("Relate: LBL bind error");
		exit(1);
	}

	imr.imr_multiaddr.s_addr = inaddr;
	imr.imr_interface.s_addr = htonl(INADDR_ANY);

	if (setsockopt(tmp_fd, IPPROTO_IP, IP_ADD_MEMBERSHIP, (char *) &imr, sizeof(struct ip_mreq)) == -1)
			perror("Relate: IP multicast join failed!\n");

	setsockopt(tmp_fd, IPPROTO_IP, IP_MULTICAST_LOOP, &loop, sizeof(loop));

	if (setsockopt(tmp_fd, IPPROTO_IP, IP_MULTICAST_TTL, &ttl, sizeof(ttl)) < 0)
			perror("Relate: setsockopt IP_MULTICAST_TTL");

	return tmp_fd;
}

int initconfbus (dummy, interp, argc, argv) 
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
	int channel=atoi ((char*)argv[1]);
	lbl_cb_init_channel(channel);
	return (TCL_OK);
}