#!/usr/bin/perl -s
## 
## Razor::Config
## 
## Copyright (c) 1998, Vipul Ved Prakash.  All rights reserved.
## This code is free software; you can redistribute it and/or modify
## it under the same terms as Perl itself.
##
## $Id: Config.pm,v 1.7 2001/12/25 09:44:33 vipul Exp $

package Razor::Config; 
use strict;
use Data::Dumper;
use vars qw( $VERSION ); 

sub new { 
    my ($class, $sc, $conf, %params) = @_; 
    my $self = bless {}, $class;
    if ($sc eq "server") { 
        $self->server ($conf, %params); 
    } else { 
        $self->client ($conf, %params);
    }
    return $self;
} 


sub conf {
    my ($self, $conf, %params) = @_;
    unless (-e $conf) { 
        if (%params) { 
            %$self = (%$self, %params);
            return $self;
        } else {
            return;
        }
    }
    open CONF, "<$conf" || return; 
    for (<CONF>) { 
        chomp; 
        next if /^\s*#/;
        next unless /=/;
        my ($attribute, $value) = split /\=/, $_, 2; 
        $attribute =~ s/^\s+//; $attribute =~ s/\s+$//;
        $value =~ s/^\s+//; $value =~ s/\s+$//;
        if ($value =~ m:,:) { 
            my @values = split /,\s*/, $value;
            $self->{$attribute} = [@values];
        } else { 
            $self->{$attribute} = $value;
        }
    }
    print "debug: Read configuration from $conf\n" if $self->{debug};
    %$self = (%$self, %params);
    return $self;
} 


sub server { 
    my ($self, $conf, %params) = @_; 
    $self->conf($conf, %params); 
    %$self = (( 
        razorzone => "razor.vipul.net", 
        dope      => "/tmp/razor",
        pidfile   => "/var/run/razord.pid",
        port      => 2702, 
        children  => 5, 
        rlimit    => 20, 
        debug     => 1, 
        smode     => "fork",
        user      => "nobody",
        defaultm  => "SHA",
    ), %$self);
    return $self;
}        


sub client { 
    my ($self, $conf, %params) = @_;
    $self->conf($conf, %params); 
    my $zt = $params{zonetype} || "";
    %$self = (( 
        razorzone  => "razor.vipul.net",
        serverlist => undef,
        listfile   => "$ENV{HOME}/.razor.lst",
        rlimit     => 20,
        turn_off_discovery => 0,
        rediscovery_wait => (2 * 24 * 3600),
    ), %$self);
    if ($zt) { 
        $self->switchzone($zt);
        $self->switchlistfile($zt);
    }
    return $self;
}

sub findconf { 
    my ($name) = @_;
    my $conf;
    my  (@CPATHS) = ("$ENV{HOME}/etc/$name", "$ENV{HOME}/$name", "/etc/$name");
    for (@CPATHS) { if (-e $_) { $conf = $_; last } }
    return $conf if $conf;
    return;
}


sub findbin {
    my ($name) = @_;
    my $path;
    my  (@PATHS) = ("$ENV{HOME}/bin/$name", "/usr/bin/$name", "/usr/sbin/$name", "bin/$name");
    for (@PATHS) { if (-e $_) { $path = $_; last } }
    return $path if $path;
    return;
}


sub switchzone { 
    my ($self, $type) = @_;
    my $gzone = $$self{razorzone};
    my ($sub, $dom) = split /\./, $gzone, 2; 
    $$self{razorzone} = "$sub-$type.$dom";
    return $self;
}


sub switchlistfile { 
    my ($self, $type) = @_;
    my $olistfile = $$self{listfile};
    $olistfile =~ s/razor/razor-$type/g;
    $$self{listfile} = $olistfile;
    return $self;
}


1;

