#!/usr/bin/perl -sw
##
## Makefile for Vipul's Razor. 
##
## Copyright (c) 1999, Vipul Ved Prakash.  All rights reserved.
## This code is free software; you can redistribute it and/or modify
## it under the same terms as Perl itself.
##
## $Id: Makefile.PL,v 1.1.1.1 2001/10/18 04:00:30 vipul Exp $

use ExtUtils::MakeMaker;

WriteMakefile(

    NAME          => 'razor-agents',
    AUTHOR        => 'Vipul Ved Prakash <mail@vipul.net>',
    ABSTRACT      => 'Collaborative, content-based spam filtering network.',
    DISTNAME      => 'razor-agents', 
    NOECHO        => '',
    VERSION_FROM  => 'lib/Razor/Client.pm', 
    EXE_FILES     => [ qw( bin/razor-check bin/razor-report bin/razor-discover ) ], 
    PREREQ_PM     => { 
                       'Net::Ping'      => 0, 
                       'Net::DNS'       => 0, 
                       'Time::HiRes'    => 0,
                       'Digest::SHA1'   => 0,  
                       'Mail::Internet' => 0, 
                     },
    MAN3PODS      => { 
        "man/razor.conf.pod"      => 'razor.conf',
        "man/razor-whitelist.pod" => 'razor-whitelist.pod', 
    },

);
