Name: rats
Summary: Rough Auditing Tool for Security
Version: 1.5
Release: 1
Copyright: GPL
Group: Development/Tools
Source0: http://www.securesw.com/rats/rats-%{version}.tar.gz
Packager: Scott Shinn <scott@securesw.com> Darryl Luff <darryl@snakegully.nu>
Vendor: Secure Software Solutions
Buildroot: /var/tmp/%{name}-root
BuildPrereq: expat-devel
Requires: expat


%description
RATS scans through code,
finding potentially dangerous function calls.  The goal of this tool
is not to definitively find bugs (yet).  The current goal is to provide a reasonable starting point for performing manual security audits.

The initial vulnerability database is taken directly from things that
could be easily found when starting with the forthcoming book, 
"Building Secure Software" by Viega and McGraw.  

RATS is released under version 2 of the GNU Public License (GPL).


%prep
%setup 

%build
CFLAGS="$RPM_OPT_FLAGS"; export CFLAGS
./configure --prefix=/usr
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/{usr/lib/,/usr/bin}
install -c rats $RPM_BUILD_ROOT/usr/bin/
install -c -m644 rats-c.xml $RPM_BUILD_ROOT/usr/lib/
install -c -m644 rats-perl.xml $RPM_BUILD_ROOT/usr/lib/
install -c -m644 rats-php.xml $RPM_BUILD_ROOT/usr/lib/
install -c -m644 rats-python.xml $RPM_BUILD_ROOT/usr/lib/


%post

%preun

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/usr/lib/rats-c.xml
/usr/lib/rats-perl.xml
/usr/lib/rats-php.xml
/usr/lib/rats-python.xml
/usr/bin/rats

%changelog
* Mon May 15 2002 Robert M. Zigweid <rzigweid@securesw.com>
- Fixed spec file for 1.5 based changes from Darryl Luff <darryl@snakegully.nu>

* Sat Jun 2 2001 Scott Shinn <scott@securesw.com>
- 1.0 release 

* Mon May 21 2001 Scott Shinn <scott@securesw.com>
- initial release
