/* 
 * Copyright (c) 2001 Secure Software Solutions
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef ENGINE_H
#define ENGINE_H

#include "vuln_db.h"

#define DEPTH_PARENTHESIS       0
#define DEPTH_BRACKET           1
#define DEPTH_BRACE             2
#define DEPTH_COUNT             3

#define INCLUDE_ALL_REFERENCES  0x1
#define INPUT_MODE              0x2

#define LANG_PYTHON		1	
#define LANG_C		 	2	
#define LANG_PERL		3


typedef struct _lexer_t lexer_t;

struct _lexer_t
{
    char **	    yytext;
    FILE *	    yyin;
    int 	    (*yylex)();
    char **	    yycomment;
    int *	    lex_lineno;
    Hash	    langhash;
    int		    lang;
};

    
typedef struct _argument_t argument_t;
struct _argument_t
{
    int             is_constant;    /* is the argument a constant string?    */
    int             contains_ps;    /* does the string contain dangerous %s? */
    char *          yytext;         /* token text making up the argument     */
    argument_t *    next;
};

typedef struct _stack_t stack_t;
struct _stack_t
{
    char *          identifier;
    Vuln_t *        data;
    int             lineno;
    int             argc;
    argument_t *    argv;
    stack_t *       next;
};

typedef struct _argscan_t argscan_t;
struct _argscan_t
{
    argument_t *    tail;
    argument_t *    current;
    int             depths[DEPTH_COUNT];
};

typedef struct _charscan_t charscan_t;
struct _charscan_t
{
    int lineno;
    int last_token;
    int depth;
    int skip;
};

typedef struct _accumulator_t accumulator_t;
struct _accumulator_t
{
    char **         text;
    int             length;
    accumulator_t * next;
};

typedef struct _toctou_t toctou_t;
struct _toctou_t
{
    int         lineno;
    Vuln_t *    data;
    char *      key;
    int         use;
    toctou_t *  next;
};

typedef int (* processorfn_t)(int, void *);

extern int          flags;
extern Hash         database;
extern Hash	    defaultdb;
extern char *       current_file;
extern stack_t *    current_frame;

extern void process_file(char *, FILE *, int);

#endif  /* ENGINE_H */
