/*
 * FILE:    repair.c
 * PROGRAM: RAT
 * AUTHOR:  Orion Hodson + Isidor Kouvelas
 *
 * $Revision: 1.1.1.1 $
 * $Date: 1998/08/15 19:16:46 $
 *
 * Copyright (c) 1995,1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, is permitted, for non-commercial use only, provided
 * that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 * Use of this software for commercial purposes is explicitly forbidden
 * unless prior written permission is obtained from the authors.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/types.h>
#ifndef WIN32
#include <netdb.h>
#endif
#include "bat_include.h"

/*
 * When we arrive here we know that participant has an audio sample from
 * previous interval and a dummy for this interval.
 */

char *
get_repair_name(int id)
{
        switch(id) {
        case REPAIR_NONE:
                return "NONE";
        case REPAIR_REPEAT:
                return "REPEAT";
        case REPAIR_WAVEFORM_PM:
                return "PM";
        default:
                return "UNKNOWN";
        }
}

/* consecutive dummies behind */
int
count_dummies_back(rx_interval_struct      *ip,
                   rx_queue_element_struct *up)
{
        int n = 0; 
        rx_queue_element_struct *prev;
        
        prev = get_participant_unit(ip->prev_ptr, *up->dbe_source);
        
        while (prev && ip) {
                if ((prev->comp_format[0].scheme != DUMMY) ||
                    (ip->prev_ptr == NULL))  
                        break;
                prev = get_participant_unit(ip->prev_ptr, *up->dbe_source);
                ip   = ip->prev_ptr;
                n++;
        }
        return (n);
}
/* consecutive dummies ahead */
int
count_dummies_ahead(rx_interval_struct      *ip,
                    rx_queue_element_struct *up)
{
        int n = 0; 
        rx_queue_element_struct *next;
        
        next = get_participant_unit(ip->next_ptr, *up->dbe_source);
        
        while (next && ip) {
                if ((next->comp_format[0].scheme != DUMMY) ||
                    (ip->next_ptr == NULL))  
                        break;
                next = get_participant_unit(ip->next_ptr, *up->dbe_source);
                ip   = ip->next_ptr;
                n++;
        }
        return (n);
}

static void
repeat(rx_interval_struct      *ip,
       rx_queue_element_struct *srcp,
       rx_queue_element_struct *up,
       int type)
{
        register int   i;
        register float sf;
        if (up->decomp_data == NULL) {
                up->decomp_data = (sample*)block_alloc(BYTES_PER_SAMPLE * SAMPLES_PER_UNIT);
        }
        up->decomp_format.scheme = L16;
   
        switch(type) {
        case FADE_TO_RIGHT:
                sf = 1.0 - FADE_SIZE * count_dummies_back(ip, up);
                for(i=0;i<SAMPLES_PER_UNIT;i++) {
                        up->decomp_data[i] = (short)((float)srcp->decomp_data[i] * sf);
                        sf = sf - FADE_STEP;
                }
                break;
        case FADE_TO_LEFT:
                sf = FADE_SIZE * count_dummies_back(ip, up);
                assert(sf<=1.0);
                for(i=SAMPLES_PER_UNIT-1;i>=0;i--) {
                        up->decomp_data[i] = (short)((float)srcp->decomp_data[i] * sf);
                        sf = sf - FADE_STEP;
                }
                break;
        }
        return;
}

static void
repeat_lpc(rx_queue_element_struct *pp,
           rx_queue_element_struct *up)
{
        lpcparams_t *lp;
        assert(pp->comp_data          != NULL);
        assert(pp->comp_format[0].scheme == LPC);
        
        if (up->comp_data[0] == NULL) {
                up->comp_data[0] = (sample*)xmalloc(LPCRECSIZE);
        }
        memcpy(up->comp_data[0],
               pp->comp_data[0],
               LPCRECSIZE);
        up->comp_format[0].scheme = LPC;
        lp = (lpcparams_t*)up->comp_data[0];
        lp->gain = (short)((float)lp->gain*0.8);
        decode_unit(up);
}

void
patch_dummy(int repair,
            rx_interval_struct      *ip,
            rx_queue_element_struct *up)
{
        rx_queue_element_struct *pp;

        pp = get_participant_unit(ip->prev_ptr, *up->dbe_source);
        if (pp == NULL) {
                return;
        }
        if (repair != REPAIR_NONE) {
                if ((pp->decomp_data == NULL) &&
                    (pp->comp_data[0] != NULL)) {
                        decode_unit(pp);
                }
                if (pp->comp_format[0].scheme == LPC) {
                        repeat_lpc(pp,up);
                } else  if (pp->decomp_data!=NULL) {
                        switch(repair) {
                        case REPAIR_REPEAT:
                                repeat(ip, pp ,up , FADE_TO_RIGHT);
                                break;
                        case REPAIR_WAVEFORM_PM:
                                break;
                        default:
                                break;
                        }
                }

        } 
        return;
}
