#ifdef DMALLOC
#include <dmalloc.h>
#endif

#include "window.h"

int twindow::windowtype(char *pathname) {
  if(!strncmp(pathname,".status",7)) return TYPE_STATUS;
  if(!strncmp(pathname,".channel",8)) return TYPE_CHANNEL;
  if(!strncmp(pathname,".query",6)) return TYPE_QUERY;
  if(!strcmp(pathname,".main")) return TYPE_MAIN;
  if(!strncmp(pathname,".files",6)) return TYPE_FILE;
  if(!strncmp(pathname,".chat",4)) return TYPE_CHAT;
  return TYPE_OTHER;
}

int twindow::operator==(twindow &t) {
  if(pathname&&t.pathname) {
    if(!strcmp(pathname,t.pathname)) return 1;
  }
  if(index==t.index) return 1;
  return 0;
}

int twindow::operator>=(twindow &t) {
  //printf("If %s is bigger than %s then insert it the smaller before the larger now by returning 1.  If it's smaller, return 0.\n",pathname,t.pathname);
  //printf("%s (%s - %p - %d) >= %s (%s - %p - %d)\n",pathname,name,server,windowtype(pathname),t.pathname,t.name,t.server,windowtype(t.pathname));
  
  // The main window is always the smallest in the list, so always go to the
  // next one.
  if(!strcmp(pathname,".main")) return 0;
  
  // If we delete the main window, this will be being inserted.  It must be
  // inserted first.
  if(!strcmp(t.pathname,".main")) return 1;
  
  if(atoi(t.server->pathname+7)>atoi(server->pathname+7)) {
    return 0;
  } else {
    if((windowtype(pathname)==TYPE_STATUS)&&(atoi(t.server->pathname+7)!=atoi(server->pathname+7))) return 1;
  }

  // Bit of reverse psychology.  T is the one being inserted.  This basically
  // says to insert if the next window is a channel, query, or chat.
  if((windowtype(pathname)==TYPE_CHANNEL)&&(windowtype(t.pathname)==TYPE_FILE)) return 1;
  if((windowtype(pathname)==TYPE_QUERY)&&(windowtype(t.pathname)==TYPE_FILE)) return 1;
  if((windowtype(pathname)==TYPE_CHAT)&&(windowtype(t.pathname)==TYPE_FILE)) return 1;

  // If what we're inserting is a status window, then insert it before the
  // other 4 window types.
  if((windowtype(pathname)==TYPE_CHANNEL)&&(windowtype(t.pathname)==TYPE_STATUS)) return 1;
  if((windowtype(pathname)==TYPE_QUERY)&&(windowtype(t.pathname)==TYPE_STATUS)) return 1;
  if((windowtype(pathname)==TYPE_CHAT)&&(windowtype(t.pathname)==TYPE_STATUS)) return 1;
  if((windowtype(pathname)==TYPE_FILE)&&(windowtype(t.pathname)==TYPE_STATUS)) return 1;
  
  // This is needed because not everything uses the "reverse" strategy.
  if((windowtype(t.pathname)==TYPE_FILE)&&(windowtype(pathname)==TYPE_STATUS)) return 0;
  
  if((windowtype(t.pathname)==TYPE_CHANNEL)&&(windowtype(pathname)==TYPE_STATUS)) return 0;
  if((windowtype(t.pathname)==TYPE_CHANNEL)&&(windowtype(pathname)==TYPE_FILE)) return 0;
  
  if((windowtype(t.pathname)==TYPE_QUERY)&&(windowtype(pathname)==TYPE_STATUS)) return 0;
  if((windowtype(t.pathname)==TYPE_QUERY)&&(windowtype(pathname)==TYPE_FILE)) return 0;
  if((windowtype(t.pathname)==TYPE_QUERY)&&(windowtype(pathname)==TYPE_CHANNEL)) return 0;
  
  if((windowtype(t.pathname)==TYPE_CHAT)&&(windowtype(pathname)==TYPE_STATUS)) return 0;
  if((windowtype(t.pathname)==TYPE_CHAT)&&(windowtype(pathname)==TYPE_FILE)) return 0;
  if((windowtype(t.pathname)==TYPE_CHAT)&&(windowtype(pathname)==TYPE_CHANNEL)) return 0;
  if((windowtype(t.pathname)==TYPE_CHAT)&&(windowtype(pathname)==TYPE_QUERY)) return 0;
  
  if(strcasecmp(name,t.name)<0) return 0;
  return 1;
}

twindow::twindow() {
  index=-1;
  name[0]=0;
  pathname[0]=0;
  server=0;
  dcc=0;
}
