set doc_section WinPopUp
set doc_type Server

doc add "Scripts ($doc_type)/$doc_section" "~/.quirc/winpopup.tcl

WinPopUp support for QuIRC

This system is designed to keep track of your WinPopUp messages even when QuIRC isn't running, it will display them the next time you start QuIRC.  To use this, you must have smbclient installed and you must add the following line to your /etc/smb.conf file (replace HOME with the absolute path to your home directory):

    message command = sh -c 'mv %s HOME/.quirc/winpopup; cd HOME/.quirc/winpopup; echo \"%f\" > `basename %s`.quirc_winpopup; echo \"%m\" >> `basename %s`.quirc_winpopup; cat `basename %s` >> `basename %s`.quirc_winpopup; rm `basename %s`'

It would be best to load this script in QuIRC sometime before you set the message command line in the smb.conf file as it sets up a dir if needed.  Beware that the dir ~/.quirc/winpopup will be world-writeable.  If anyone has any better ideas on how to implement this other than creating a world-writeable dir, let me know (patearl@pobox.com)."

doc add "Variables (Config)/WinPopUp/winpopup_checktime" "How often in milliseconds to check for new WinPopUp messages."
config default winpopup_checktime 15
if { [info vars ::dynamic::winpopup_checktime]=="" } { set ::dynamic::winpopup_checktime 15 }


proc event_unload {} {
    doc remove Variables/winpopup_checktime
}

# ALIASES

# /winpopup
doc add "Aliases ($doc_type)/$doc_section/winpopup" "/winpopup <host> <message>

This command uses smbclient to send a WinPopUp message to the specified host."

# This could handle IPs too... like smbclient -I 207.229.35.247 -M k9
alias winpopup {
    if { [llength [split $arg " "]]<2 } {
	error "Usage: /winpopup <host> <message>"
    }
    set host [lindex [split $arg " "] 0]
    set message [join [lrange [split $arg " "] 1 end]]
    echo " \0030,2 WINPOPUP \003 smbclient says:\n[exec echo -n $message | smbclient -M $host]\n \0030,2 WINPOPUP \003 END" [pathname status]
}

proc checknow {} {
    set filenames [glob -nocomplain "$::env(HOME)/.quirc/winpopup/*.quirc_winpopup"]
    foreach file $filenames {
	while { [file exists [string range $file 0 [expr [string first ".quirc_winpopup" $file]-1]]] } {}
	set thefile [open $file "r"]
        gets $thefile name
        gets $thefile host
        set data ""
        while {![eof $thefile]} {
            append data "[gets $thefile]\n"
        }
        set data [string range $data 0 [expr [string length $data]-2]]
	close $thefile
	if { [string match "*\n*" $data] } {
	    echo " \0030,2 WINPOPUP \003 Message from $name@\00302$host\003:\n$data\n \0030,2 WINPOPUP \003 END"
	} else {
	    echo " \0030,2 WINPOPUP \003 Message from $name@\00302$host\003: $data"
	}
	file delete $file
    }
    after [set ::[index]::winpopup::checktime] ::[index]::winpopup::checknow
}

if { ![file exists "$env(HOME)/.quirc/winpopup"] } {
    file mkdir "$env(HOME)/.quirc/winpopup"
    exec chmod 777 "$env(HOME)/.quirc/winpopup"
}

set checktime $::dynamic::winpopup_checktime
after $::dynamic::winpopup_checktime ::[index]::winpopup::checknow
