# This is a QuIRC theme file.  It contains most of the code relating to what
# QuIRC looks like.  If you notice something that isn't in this file but should
# be, let me know.  The first part of the file is the global style config.  The
# second part is the event handling code that displays what comes from the
# server and such.  To load a different theme file, change the theme setting
# in config.tcl and restart QuIRC.  To get more information about the colors
# and options you can use, see the Tk man pages.  As a note, activeXXXXXXX is
# usually for when the mouse is over the item.  Things in this file should
# not be removed without care, as doing so may cause errors in the execution of
# the program.


# Server Lag Checker Colours
set ::dynamic::theme_lag_foreground green
set ::dynamic::theme_lag_background black


# Default settings to use for setting other variables throughout this file.
# These are not used directly by anything else.
# These should be defined as numbers between 0 and 15.
set ::default_foreground 1
set ::default_background 0
# These should be defined as normal Tk settings.
set ::default_font_normal "-misc-fixed-medium-r-semicondensed-*-*-100-*-*-c-*-iso8859-1"
set ::default_font_bold "-misc-fixed-bold-r-semicondensed-*-*-100-*-*-c-*-iso8859-1"
#set ::default_font_normal "-adobe-courier-medium-r-normal-*-*-100-*-*-m-*-iso8859-1"
#set ::default_font_bold "-adobe-courier-bold-r-normal-*-*-100-*-*-m-*-iso8859-1"
set ::default_selectbackground grey
set ::default_selectforeground grey
set ::default_selectborderwidth 3
set ::default_entry_foreground black
set ::default_entry_background white
set ::default_entry_font $default_font_normal
set ::default_entry_insertbackground $default_entry_foreground


# These are used within this particular theme file to display a number of
# things.  They should be defined as numbers between 0 and 15.  The
# definitions of what these do is subject to change as more of the C based code
# is moved here.
# This one is used in a lot of places.
set ::dynamic::theme_default_foreground2 2
# This is used in CTCP messages and replies to display the type of CTCP.
set ::dynamic::theme_default_foreground3 5
# This is used to display op messages.
set ::dynamic::theme_default_foreground4 6
# This is used to display part of the who response.
set ::dynamic::theme_default_foreground5 12


# Window List Configuration
set ::dynamic::theme_windowlist_indent " "
set ::dynamic::theme_windowlist_background white
set ::dynamic::theme_windowlist_foreground blue
set ::dynamic::theme_windowlist_activeforeground red
set ::dynamic::theme_windowlist_activebackground white
set ::dynamic::theme_windowlist_selectforeground black
set ::dynamic::theme_windowlist_selectbackground cyan
set ::dynamic::theme_windowlist_font $::default_font_normal
set ::dynamic::theme_windowlist_width 120


# The following colour definitions are used to define what the "mIRC colours"
# 0 through 15 map to in terms of real colour.  They would not normally be
# modified.  For example, if QuIRC or somebody on IRC sends a <color-code>4,
# it will use #ff0000 which is red.
set ::dynamic::theme_color(0) "#FFFFFF"
set ::dynamic::theme_color(1) "#000000"
set ::dynamic::theme_color(2) "#00007F"
set ::dynamic::theme_color(3) "#007F00"
set ::dynamic::theme_color(4) "#FF0000"
set ::dynamic::theme_color(5) "#7F0000"
set ::dynamic::theme_color(6) "#7F007F"
set ::dynamic::theme_color(7) "#FF7F00"
set ::dynamic::theme_color(8) "#FFFF00"
set ::dynamic::theme_color(9) "#00FF00"
set ::dynamic::theme_color(10) "#007F7F"
set ::dynamic::theme_color(11) "#00FFFF"
set ::dynamic::theme_color(12) "#0000FF"
set ::dynamic::theme_color(13) "#FF00FF"
set ::dynamic::theme_color(14) "#7F7F7F"
set ::dynamic::theme_color(15) "#CFCFCF"


# Button Bar Config

# The background to the menubar
set ::dynamic::theme_buttonbar_background black

# Forground and background of Connect/Disconnect button
set ::dynamic::theme_button_condis_foreground white
set ::dynamic::theme_button_condis_background #00008b
set ::dynamic::theme_button_condis_activeforeground white
set ::dynamic::theme_button_condis_activebackground blue

# Forground and background of close button
set ::dynamic::theme_button_close_foreground white
set ::dynamic::theme_button_close_background #00008b
set ::dynamic::theme_button_close_activeforeground white
set ::dynamic::theme_button_close_activebackground blue

# Forground and background of menu button
set ::dynamic::theme_button_menu_foreground white
set ::dynamic::theme_button_menu_background #00008b
set ::dynamic::theme_button_menu_activeforeground white
set ::dynamic::theme_button_menu_activebackground blue


# These are the nicklist settings
set ::dynamic::theme_nicklist_foreground white
set ::dynamic::theme_nicklist_background black
set ::dynamic::theme_nicklist_font $default_font_normal
set ::dynamic::theme_nicklist_width 15


# These are the banlist settings
set ::dynamic::theme_banlist_font $default_font_normal
set ::dynamic::theme_banlist_foreground lightblue
set ::dynamic::theme_banlist_background black
set ::dynamic::theme_banlist_title_foreground yellow
set ::dynamic::theme_banlist_title_background $::dynamic::theme_banlist_background
set ::dynamic::theme_banlist_entry_foreground white
set ::dynamic::theme_banlist_entry_background $::dynamic::theme_banlist_background
set ::dynamic::theme_banlist_entry_insertbackground $::dynamic::theme_banlist_entry_foreground


# DCC Files Listbox settings
set ::dynamic::theme_filelist_foreground white
set ::dynamic::theme_filelist_background black
set ::dynamic::theme_filelist_font $default_font_normal


# Status window text color and font settings
set ::dynamic::theme_status_foreground $default_foreground
set ::dynamic::theme_status_background $default_background
set ::dynamic::theme_status_selectbackground $default_selectbackground
set ::dynamic::theme_status_selectforeground $default_selectforeground
set ::dynamic::theme_status_selectborderwidth $default_selectborderwidth
set ::dynamic::theme_status_font_normal $default_font_normal
set ::dynamic::theme_status_font_bold $default_font_bold

# Status entrybox settings
set ::dynamic::theme_status_entry_foreground $default_entry_foreground
set ::dynamic::theme_status_entry_background $default_entry_background
set ::dynamic::theme_status_entry_font $default_entry_font
set ::dynamic::theme_status_entry_insertbackground $default_entry_insertbackground

# Chat window text color and font settings
set ::dynamic::theme_chat_foreground $default_foreground
set ::dynamic::theme_chat_background $default_background
set ::dynamic::theme_chat_selectbackground $default_selectbackground
set ::dynamic::theme_chat_selectforeground $default_selectforeground
set ::dynamic::theme_chat_selectborderwidth $default_selectborderwidth
set ::dynamic::theme_chat_font_normal $default_font_normal
set ::dynamic::theme_chat_font_bold $default_font_bold

# Chat entrybox settings
set ::dynamic::theme_chat_entry_foreground $default_entry_foreground
set ::dynamic::theme_chat_entry_background $default_entry_background
set ::dynamic::theme_chat_entry_font $default_entry_font
set ::dynamic::theme_chat_entry_insertbackground $default_entry_insertbackground

# File window text color and font settings
set ::dynamic::theme_files_foreground $default_foreground
set ::dynamic::theme_files_background $default_background
set ::dynamic::theme_files_selectbackground $default_selectbackground
set ::dynamic::theme_files_selectforeground $default_selectforeground
set ::dynamic::theme_files_selectborderwidth $default_selectborderwidth
set ::dynamic::theme_files_font_normal $default_font_normal
set ::dynamic::theme_files_font_bold $default_font_bold

# File entrybox settings
set ::dynamic::theme_files_entry_foreground $default_entry_foreground
set ::dynamic::theme_files_entry_background $default_entry_background
set ::dynamic::theme_files_entry_font $default_entry_font
set ::dynamic::theme_files_entry_insertbackground $default_entry_insertbackground

# Main window text color and font settings
set ::dynamic::theme_main_foreground $default_foreground
set ::dynamic::theme_main_background $default_background
set ::dynamic::theme_main_selectbackground $default_selectbackground
set ::dynamic::theme_main_selectforeground $default_selectforeground
set ::dynamic::theme_main_selectborderwidth $default_selectborderwidth
set ::dynamic::theme_main_font_normal $default_font_normal
set ::dynamic::theme_main_font_bold $default_font_bold

# Main entrybox settings
set ::dynamic::theme_main_entry_foreground $default_entry_foreground
set ::dynamic::theme_main_entry_background $default_entry_background
set ::dynamic::theme_main_entry_font $default_entry_font
set ::dynamic::theme_main_entry_insertbackground $default_entry_insertbackground

# Channel window text color and font settings
set ::dynamic::theme_channel_foreground $default_foreground
set ::dynamic::theme_channel_background $default_background
set ::dynamic::theme_channel_selectbackground $default_selectbackground
set ::dynamic::theme_channel_selectforeground $default_selectforeground
set ::dynamic::theme_channel_selectborderwidth $default_selectborderwidth
set ::dynamic::theme_channel_font_normal $default_font_normal
set ::dynamic::theme_channel_font_bold $default_font_bold

# Channel entrybox settings
set ::dynamic::theme_channel_entry_foreground $default_entry_foreground
set ::dynamic::theme_channel_entry_background $default_entry_background
set ::dynamic::theme_channel_entry_font $default_entry_font
set ::dynamic::theme_channel_entry_insertbackground $default_entry_insertbackground

# Query window text color and font settings
set ::dynamic::theme_query_foreground $default_foreground
set ::dynamic::theme_query_background $default_background
set ::dynamic::theme_query_selectbackground $default_selectbackground
set ::dynamic::theme_query_selectforeground $default_selectforeground
set ::dynamic::theme_query_selectborderwidth $default_selectborderwidth
set ::dynamic::theme_query_font_normal $default_font_normal
set ::dynamic::theme_query_font_bold $default_font_bold

# Query entrybox settings
set ::dynamic::theme_query_entry_foreground $default_entry_foreground
set ::dynamic::theme_query_entry_background $default_entry_background
set ::dynamic::theme_query_entry_font $default_entry_font
set ::dynamic::theme_query_entry_insertbackground $default_entry_insertbackground


# Global Formats

fset DNS_ERROR " \0030,6 ERROR \003 %0"
fset DNS_FOR " \0030,14 DNS \003 Info for %0:" [flocation current]
fset DNS_HOSTNAME " \0030,14 DNS \003 Host name: %0" [flocation current]
fset DNS_IP " \0030,14 DNS \003 IP Address: %0" [flocation current]
fset ERROR_INFO " \0030,4 ERROR \003 Info:\003$::dynamic::theme_default_foreground3\n%0"
fset ERROR_CODE " \0030,4 ERROR \003 Code: %0"
fset ERROR_ADDITIONAL " \0030,4 ERROR \003 Additional Info: %0"
fset SET_APPENDED " \0030,6 SET \003\003$::dynamic::theme_default_foreground2 %0 \003appended to be\003$::dynamic::theme_default_foreground2 %1" [flocation current]
fset SET_CHANGED " \0030,6 SET \003\003$::dynamic::theme_default_foreground2 %0 \003set to\003$::dynamic::theme_default_foreground2 %1" [flocation current]
fset SET_CLEARED " \0030,6 SET \003\003$::dynamic::theme_default_foreground2 %0 \003cleared." [flocation current]
fset SET_DISPLAY " \0030,6 SET \003\003$::dynamic::theme_default_foreground2 %0 \003is set to\003$::dynamic::theme_default_foreground2 %1" [flocation current]
fset THEME_CHANGED " \0030,12 THEME \003 Theme variable set.  All variables and aliases stored.  Please restart QuIRC to activate your new theme." [flocation current]
fset THEME_SAVED " \0030,12 THEME \003 Current theme variable settings stored to custom.tcl." [flocation current]

# Server Specific Formats

# For IRC_*, prefix is %0, args are %1-
# %1 is the same as [mynick] (except for in a few buggy situations)
# IRC_* events are generated whenever the server sends a message.  The *
# corresponds to the uppercase command name from the server.

# Where the whois replies go.
# set whoislocation [flocation currentorstatus]
set whoislocation [flocation status]

fset IRC_TOPIC " \0030,7 TOPIC \003 \\\"%2\\\" by %0" [flocation onchannel 1]
fset IRC_WALLOPS " \0030,3 WALLOPS \003\003$::dynamic::theme_default_foreground2 %0\003: %1" [flocation status]

# Away response
fset IRC_301 " \0030,10 AWAY \003 %2 (%3-)" [flocation status]
# ISON list
fset IRC_303 " \0030,10 ISON-LIST \003 %2 " [flocation status]
# "You are no longer marked as being away"
fset IRC_305 " \0030,10 BACK \003 %2" [flocation status]
# "You have been marked as being away"
fset IRC_306 " \0030,10 AWAY \003 %2" [flocation status]
# WHOIS Idenfitied to NickServ (Dalnet)
fset IRC_307 " \0030,10 WHOIS \003 nickserv  : %2-" $whoislocation
# WHOIS help-op reply
fset IRC_310 " \0030,10 WHOIS \003 help      : %2-" $whoislocation
# WHOIS server reply
fset IRC_312 " \0030,10 WHOIS \003 server    : %3 (%4-)" $whoislocation
# WHOIS operator reply
fset IRC_313 " \0030,10 WHOIS \003 operator  : %2-" $whoislocation
# End of WHO reply
fset IRC_315 " \0030,10 WHO-LIST \003\003$::dynamic::theme_default_foreground2 End of WHO list for %2" [flocation status]
# End of WHOIS response
fset IRC_318 "" [flocation none]
# WHOIS channels response
fset IRC_319 " \0030,10 WHOIS \003 channels  : %3-" $whoislocation
# Current MODE of channel
fset IRC_324 " \0030,12 MODE \003 \\\"%3-\\\"" [flocation channelorstatus 2]
# Channel creation date
fset IRC_329 " \0030,10 CREATED \003 \[clock format %3]" [flocation channelorstatus 2]
# Reply to TOPIC query
fset IRC_332 " \0030,7 TOPIC \003 \\\"%3\\\"" [flocation onchannel 2]
# Date and nick reply to TOPIC query
fset IRC_333 " \0030,7 TOPIC \003 Set by %3 on \[clock format %4]" [flocation onchannel 2]
# Succesful reply to INVITE
fset IRC_341 " \0030,7 INVITE \003 %2 to %3" [flocation status]
# WHO reply.
fset IRC_352 " \0030,10 WHO-LIST \003\003$::dynamic::theme_default_foreground2 %2 \0031,08%7\003\003$::dynamic::theme_default_foreground5 %6\003!\003[ic $::dynamic::theme_default_foreground5 status]%3@%4 \003(\003[ic $::dynamic::theme_default_foreground2 status]\[join \[lrange \[split %8 \" \"] 1 end]]\003) %5\\\[\[lindex \[split %8 \" \"] 0]]" [flocation status]
# MOTD Body
fset IRC_372 " \0030,7 MOTD \003 %2" [flocation status]
# MOTD Start
fset IRC_375 " \0030,7 MOTD \003 %2" [flocation status]
# MOTD End
fset IRC_376 " \0030,7 MOTD \003 %2" [flocation status]
# No such nick error
fset IRC_401 " \0030,6 OOPS \003 %3: %2" [flocation status]
# No such channel error (/mode #nonexistant to test.)
fset IRC_403 " \0030,6 OOPS \003 %3: %2" [flocation status]
# Invalid command error
fset IRC_421 " \0030,6 OOPS \003 %3: %2" [flocation status]
# User is not on channel (/mode #existant +o not_in_channel_existant to test.)
fset IRC_441 " \0030,6 OOPS \003 %2 %3 %4" [flocation status]

# Error or Quit occured.  Usually diconnects after sending error message.
fset IRC_ERROR " \0030,13 ERROR \003 %1-" [flocation serverall] 0
# Invite
fset IRC_INVITE " \0030,7 INVITE \003 %2 from %0" [flocation status]
# Displayed when somebody joins a channel.
fset IRC_JOIN " \0030,3 JOIN \003 %0" [flocation onchannel 1]
# Pong
fset IRC_PONG " \0030,6 PONG \003 %1-" [flocation status]
# Kill
fset IRC_KILL " \0030,4 KILL \003\003$::dynamic::theme_default_foreground2 %1\003 by\003$::dynamic::theme_default_foreground2 %0\003 (\003[ic $::dynamic::theme_default_foreground2 status]%2-\003)" [flocation status]

# For UNPARSED*, %0 is prefix, %1 is command, %2- is args.

# Numerics not parsed by any script commands or within QuIRC's internals
fset UNPARSED_NUMERIC " \0030,1 %1 \003 %3-" [flocation status]
# Anything not parsed by previous script, or within QuIRC's internals
fset UNPARSED " \0034,1 %1 \003 (%0) %2-" [flocation status]


# QuIRC Main Title for the various window types.
# 0 is channel, 1 is topic.
fset TITLE_CHANNEL "QuIRC - %0 (%1)"
# 0 is channel
fset TITLE_CHANNEL_NOTOPIC "QuIRC - %0"

# Channel URL (328)
# 0 is channel, 1 is url.
fset URL_CHANNEL " \0030,10 URL \003 %1" [flocation channelorstatus 0]
# Not Tested
fset URL " \0030,10 URL \003 %0: %1" [flocation status]

# WHOIS NickHost/Name (311)
# 0 is nick, 1 is user, 2 is host, 3 is country description.
fset WHOIS_NICKHOST " \0030,10 WHOIS \003 nick,host : \002%0\002 \00314\002(\003\002%1@%2\00314\002)\002\003 (%3)" $whoislocation
# 0 is the user's IRC name.
fset WHOIS_NAME " \0030,10 WHOIS \003 ircname   : %0" $whoislocation
# WHOIS Idle (317)
# 0 is a text description of idle time, 1 is a text description of signon time.
fset WHOIS_IDLE " \0030,10 WHOIS \003 idle      : %0. Signon: %1" $whoislocation
fset WHOIS_IDLE_NOSIGNON " \0030,10 WHOIS \003 idle      : %0" $whoislocation

# QUIT (0 is prefix, 1 is reason)
fset QUIT " \0030,5 QUIT \003 %0 (%1)"

# These are used by notify.tcl to display notification messages when nicks join
# or leave IRC.
fset NOTIFY_OFF " \0030,7 NOTIFY \003 %0 signed off." [flocation status]
fset NOTIFY_ON " \0030,7 NOTIFY \003 %0 signed on." [flocation status]

# This is displayed when starting a connection.
# 0 is the numeric ip of the server being connected to.
fset CONNECT_ATTEMPT " \0030,14 STATUS \003 Attempting connection to %0" [flocation serverall] 0

# This is called when an error occurs in a DCC Chat session.
# 0 is the pathname to the DCC window, 1 is what the error occured in, 2 is
# information about the error.
fset DCC_ERROR " \0030,5 ERROR \003 %1: %2" [flocation pathname 0]
# This is called when an error occurs in a DCC File transfer.
# 0 is the file index number, 1 is what the error occured in, and 2 is
# information about the error.
fset DCC_FILE_ERROR " \\\[%0] \0030,5 ERROR \003 %1: %2 " [flocation files]

# This is displayed when a script is loaded.  0 is the script's filename, 1 is
# the name of the namespace it is being loaded into.
fset SCRIPT_LOAD " \0030,4 SCRIPT \003 Loading\003$::dynamic::theme_default_foreground2 %0\003 into namespace\003$::dynamic::theme_default_foreground2 %1" [flocation status]

# This is displayed if a mode is missing a required parameter.
# 0 is a - or + and 1 is the mode letter.
fset NO_MODE_PARAMETER " \0030,5 ERROR \003 No parameter given for mode change %0%1.  This is likely due to a bug in the IRCd.  If you don't believe it to be the IRCd's fault, please contact patearl@pobox.com with an explaination.  Sending a channel mode request to ensure correct modes." [flocation status]

# This is displayed if a 324 mode numeric is missing a required parameter when
# we are on the channel.
# 0 is a - or + and 1 is the mode letter.
fset NO_324_MODE_PARAMETER " \0030,5 ERROR \003 No parameter given for mode change %0%1 resulting from a 324 numeric.  This is likely due to a bug in the IRCd.  If you don't believe it to be the IRCd's fault, please contact patearl@pobox.com with an explaination.  The channel modes as stored by QuIRC may not be correct any longer." [flocation status]

# This is used by /me to display outgoing actions.
# 0 is the pathname of the action, 1 is the message.
fset OUTGOING_ACTION "\003$::dynamic::theme_default_foreground2* \[mynick] %1" [flocation pathname 0]

# Used when there is a /msg sent to somebody that does not have an open query.
# 0 is the nick, 1 is the message.
fset OUTGOING_MSG "\003$::dynamic::theme_default_foreground2*%0*>\003 %1" [flocation currentorstatus]

# Used to display outgoing /notice messages.
# 0 is the nick, 1 is the message.
fset OUTGOING_NOTICE "\003$::dynamic::theme_default_foreground2-%0\\->\003 %1" [flocation current]

# Used to display /ops messages.
# 0 is the channel, 1 is the message.
fset OUTGOING_OPS "\003$::dynamic::theme_default_foreground4-@%0\\->\003 %1" [flocation channelorstatus 0]

# This is used to display text as eminated from yourself.
# 0 is the destination pathname, 1 is the message.
fset OUTGOING_TEXT "\003$::dynamic::theme_default_foreground2<\[mynick]>\003 %1" [flocation pathname 0]

# This is displayed when the connection to the server succeeds.
fset CONNECTED " \0030,14 STATUS \003 Connected." [flocation serverall] 0

# DCC Chat connection success.
# 0 is the pathname of the chat window.
fset DCC_CONNECTED " \0030,14 DCC \003 Connected." [flocation pathname 0]

# DCC File connection success.
# 0 is the dcc index of the file connection being established.
fset DCC_FILE_CONNECTED " \\\[%0] \0030,14 DCC \003 Connected." [flocation files]

# This is displayed in the DCC Files listbox before receiving an ack.
# 0 is the dcc index of the file connection being established.
fset DCC_FILE_WAITING " \\\[%0] Connected... Waiting for transfer."

# This is displayed in the text box when starting a DCC send.
# 0 is the file index, 1 is the full path of the file being sent, 2 is the
# filename it is being sent as, 3 is the size of the file in bytes.
fset DCC_FILE_TRANSFERING " \\\[%0] Transfering\003$::dynamic::theme_default_foreground2 %1\003 as\003$::dynamic::theme_default_foreground2 %2\003 (\003[ic $::dynamic::theme_default_foreground2 files]%3\003 bytes)" [flocation files]

# This is displayed in the text box when starting a DCC receive.
# 0 is the file index, 1 is the filename of the file being received, 2 is the
# full path of where the file is being placed, 3 is the size of the file in
# bytes.
fset DCC_FILE_RECEIVING " \\\[%0] Receiving\003$::dynamic::theme_default_foreground2 %1\003 to\003$::dynamic::theme_default_foreground2 %2\003 (\003[ic $::dynamic::theme_default_foreground2 files]%3\003 bytes)" [flocation files]

# This is displayed in the DCC file list during the reception of a file.
# 0 is the file index, 1 is the filename, 2 is the nick, 3 is the number of
# bytes written, 4 is the size of the file.
fset DCC_FILE_GETSTATUS " \\\[%0] Getting \\\"%1\\\" from %2.  \[expr int(%3/(%4+0.0)*100)]% (%3)"

# This is displayed in the DCC file list during the reception of a file where
# no size has been specified.
# 0 is the file index, 1 is the filename, 2 is the nick, 3 is the number of
# bytes written.
fset DCC_FILE_GETSTATUS_NOSIZE " \\\[%0] Getting \\\"%1\\\" from %2.  ???% (%3)"

# This is displayed in the DCC file list during the transmission of a file.
# 0 is the file index, 1 is the filename, 2 is the nick, 3 is the number of
# bytes acknowledged, 4 is the size of the file.
fset DCC_FILE_SENDSTATUS " \\\[%0] Sending \\\"%1\\\" to %2.  \[expr int(%3/(%4+0.0)*100)]% (%3)"

# These are used to display DCC chat messages or actions.
# 0 is the nick, 1 is the message.
fset DCC_CHAT_ACTION "\003$::dynamic::theme_default_foreground2* %0 %1" [flocation chat 0]
fset DCC_CHAT_TEXT "\003$::dynamic::theme_default_foreground2<%0>\003 %1" [flocation chat 0]

# This is displayed when disconnected from a server.
fset DISCONNECTED " \0030,14 STATUS \003 Disconnected." [flocation serverall] 0

# Displayed when somebody is kicked from a channel.
# 0 is the kickee, 1 is the kicker, and 2 is the reason.
fset KICK " \0030,13 KICK \003 %0 by %1 (%2)"

# Channel and personal mode change display.
# 0 is the mode change, 1 is the prefix.
fset MODE_CHANNEL " \0030,12 MODE \003 \\\"%0\\\" by %1"
# 0 is the mode change.
fset MODE " \0030,12 MODE \003 \\\"%0\\\""

# Nick change.
# 0 is source nick, 1 is destination nick.
fset NICK " \0030,10 NICK \003 %0 is now known as %1"

# Part, 0 is prefix, 1 is channel 2 is reason.
fset PART_REASON " \0030,4 PART \003 %0 (%2)"
fset PART " \0030,4 PART \003 %0"

# The server lag meter display.  0 is the lag time in seconds.
fset SERVER_LAG "Server Lag: \[format %%5.2f %0]"

# Displayed when there's channel or query text.
# 0 is nick, 1 is message.
fset TEXT "\003$::dynamic::theme_default_foreground2<%0>\003 %1"
# Displayed when there's channel or query op messages.
# 0 is nick, 1 is message.
fset OP_TEXT "\003$::dynamic::theme_default_foreground4<%0>\003 %1"

# Displayed when there's an action.
# 0 is nick, 1 is message.
fset ACTION "\003$::dynamic::theme_default_foreground2* %0 %1"
# Displayed when there's an op action.
# 0 is nick, 1 is message.
fset OP_ACTION "\003$::dynamic::theme_default_foreground4* %0 %1"


# CTCP's
# 0 is type, 1 is nick.
fset CTCP " \0030,10 CTCP \003\003$::dynamic::theme_default_foreground3 %0\003 from\003$::dynamic::theme_default_foreground2 %1"
# CTCP to @#channel.
fset OP_CTCP " \0030,6 CTCP \003\003$::dynamic::theme_default_foreground3 %0\003 from\003$::dynamic::theme_default_foreground2 %1"

# CTCP's with a data argument.
# 0 is type, 1 is nick, 2 is argument.
fset CTCP_DATA " \0030,10 CTCP \003\003$::dynamic::theme_default_foreground3 %0\003 from\003$::dynamic::theme_default_foreground2 %1\003: %2"
# CTCP to @#channel.
fset OP_CTCP_DATA " \0030,6 CTCP \003\003$::dynamic::theme_default_foreground3 %0\003 from\003$::dynamic::theme_default_foreground2 %1\003: %2"

# CTCP PING Reply.  0 is nick, 1 is time.
fset CTCP_REPLY_PING " \0030,10 CTCP-REPLY \003\003$::dynamic::theme_default_foreground3 PING\003 from\003$::dynamic::theme_default_foreground2 %0\003: \[format \"%.3f\" %1]\003 seconds" [flocation status]

# CTCP Reply with data.
# 0 is type, 1 is nick, 2 is argument.
fset CTCP_REPLY_DATA " \0030,10 CTCP-REPLY \003\003$::dynamic::theme_default_foreground3 %0\003 from\003$::dynamic::theme_default_foreground2 %1\003: %2" [flocation status]
# CTCP Reply without data.
# 0 is the type, 1 is the nick.
fset CTCP_REPLY " \0030,10 CTCP-REPLY \003\003$::dynamic::theme_default_foreground3 %0\003 from\003$::dynamic::theme_default_foreground2 %1" [flocation status]

# Server notice
# 0 is prefix, 1 is text.
fset SERVER_NOTICE "\003$::dynamic::theme_default_foreground2-%0\\-\003 %1" [flocation status]

# Regular notice
# 0 is nick, 1 is text.
fset NOTICE "\003$::dynamic::theme_default_foreground2-%0\\-\003 %1" [flocation currentorstatus]

# Op notice
# 0 is channel, 1 is nick, 2 is text.
fset OP_NOTICE "\003$::dynamic::theme_default_foreground4-%1\\-\003 %2" [flocation onchannel 0]

# Channel targetted notice
# 0 is channel, 1 is nick, 2 is text.
fset CHANNEL_NOTICE "\003$::dynamic::theme_default_foreground2-(%0)-%1\\-\003 %2" [flocation onchannel 0]

# ChanServ/MemoServ/NickServ notice
# 0 is service, 1 is text.
fset SERVICES_NOTICE "\003$::dynamic::theme_default_foreground2-%0\\-\003 %1" [flocation currentorstatus]

# Temporary DCC completion echo text.
fset DCC_COMPLETE_FILE "%0"
fset DCC_COMPLETE_DIR "%0%1"
