set doc_section Internal

doc add "How To/Use Help" "For various information about performing certain tasks, consult the How To section.

If you would like to expand your knowledge of QuIRC or find tidbits of useful information, check out the Tips section.

The other sections are divided into two types, server and global.  The global sections are applicable anywhere, even if a server window isn't open.  The server sections apply to a single server only, the one that's currently active, or the one that an event is received from.
"

doc add "How To/Add a Popup Menu Item" "FIXME"

doc add "How To/Create an Alias" "FIXME"

doc add "How To/Deal with Themes" "FIXME"

doc add "Tips/Calculator" "For quick calculation or evaluation of scripts, try:

    /calc 4*8+10
    /calc \[info patchlevel]
"

doc add "Events (Global)/event_client_start" "event_client_start

This event is called after all of the normal initialization has occured.  It will not be called if the first_time variable is set."

doc add "Events (Global)/event_echo" "event_echo <message> <pathname> <new>

This event is called everytime text is to be echoed.  You must return the text that you actually want to be echoed.  If you return nothing, it will not echo anything.  You can use echotags from within this proc for very customized echoing.  The pathname parameter indicates which window the message is being echoed to.  The new parameter indicates whether or not the window list should light up indicating there is new text."

doc add "Events (Global)/event_first_time" "event_first_time

This event is called when the client is started if the first_time variable is set."

doc add "Events (Global)/event_windowchanged" "event_windowchanged <old_pathname> <old_name> <old_server> <old_index> <pathname> <name> <server> <index>

This Is called whenever the user switches windows.  The pathname parameters are the internal window reference names.  The names are the names displayed in the window list.  The server parameters are the indexes of the servers.  The index parameters are the indexes of the window list items in the window list itself.  The old parameters are those before the change, the others are those after the change."

doc add "Procedures (Global)/$doc_section/activebutton" "activebutton <windowindex>

Makes the window list item windowindex colored indicating there is new text in that window."

doc add "Procedures (Global)/$doc_section/fgetformat" "fgetformat <type>

type
    The fset format type.

This procedure returns the format string for the given fset format type.  See fset for more details."

doc add "Procedures (Global)/$doc_section/fgetpathnames" "fgetpathnames <type> \[<argument> \[<argument> ...]]

type
    The fset format type.

This procedure is invoked in the same manner as fparse.  It returns a list of pathnames when given a type and the associated arguments.  If no location was set, the main status window pathname (.main) is returned.  There is a server version of this procedure as well."

doc add "Procedures (Server)/$doc_section/fgetpathnames" "fgetpathnames <type> \[<argument> \[<argument> ...]]

type
    The fset format type.

This procedure is invoked in the same manner as fparse.  It returns a list of pathnames when given a type and the associated arguments.  If no location was set, the main status window pathname (.main) is returned.  There is a global version of this procedure as well."

doc add "Procedures (Server)/$doc_section/userlist" "userlist set <type info> \[<list of flag/data> \[<index>]]

type info
    Any of the following:
        {alias name}
        {simple <Mask containing ?, *, or \[chars]>}
        {regexp <Regular expression>}
    For example:
        {alias friends}
        {simple *!*@*}
        {regexp .*!.*@.*}

list of flag/data
    A list consisting of flag/data pairs or just flags.
    If the first flag does not have an explcit -/+ on it, the list will be cleared before adding or removing the given flags.
    Flags with no sign are assumed to have a + sign.
    Flags with - on them are removed from the flag list.
    If you specify a flag with no data, any previous data will be removed.

    For example:
        only_flag
        +one_more_flag
        {{+one_more_flag with_data}}
        {+another_flag -bad_flag {+yet_another_flag {with data}}}

index
    A number used to to indicate the position of an item in the list.
    0 is the first position.
    end is the last position.
    If you try inserting before the first position, or after the last one, it will adjust it to be within the possible insert range.

Sets a given type/info pair with the given flag set in the following manner:

If you specify a type/info pair that does not already exist in the list, it will by default be inserted at the beginning of the list.  If you specify an index, it will be inserted or moved to that position.

The resulting index of the inserted or changed item is returned.

If the flag list argument is omitted, the current list of flags for the item will be returned.

Examples:

To ignore everybody (inserted at end so it can be preempted by other masks, such as masks of friends):
    userlist set {simple *!*@*} +ignore end"
