/* Copyright (C) 2006 P.L. Lucas
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA. 
 */

#ifndef __TERMINAL_H__
#define __TERMINAL_H__

#include <QTextEdit>
#include <QPushButton>
#include <QWorkspace>
#include "basewidget.h"
#include "octave_connection.h"
#include "dynamic_help.h"
#include "autocomplete.h"

/** Builds windows with QtextEdit and QLineEdit. QTextEdit shows OctaveConnection output.
 * QLineEdit is used to write commands.
 * 
 */

class Terminal:public BaseWidget
{
	Q_OBJECT
	public:
	Terminal( QWidget * parent = 0 );
	QTextEdit *getTextEdit();
	void setOctaveConnection(OctaveConnection *octave_connection);
	OctaveConnection *getOctaveConnection();
	void command_enter(const QString &text);
	QWorkspace *work_space;
	private:
	QTextEdit *text;
	Autocomplete *combo_box;
	//QPushButton *completion_matches_button, *dynamic_help_button, *stop_process_button, *clear_button;
	OctaveConnection *octave_connection;
	Dynamic_help *dynamic_help;
	int lines_in_terminal;
	int cols_in_terminal;
	void remove_lines(QTextCursor &cursor);
	public slots:
	void return_pressed();
	void write_output(QString output);
	void write_error(QString error);
	void write_command(QString command);
	void completion_matches_callback();
	void dynamic_help_callback();
	void stop_process_callback();
	void clear_callback();
};


#endif
