/* Copyright (C) 2006 P.L. Lucas
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA. 
 */

#ifndef __TABLE_H__
#define __TABLE_H__

#include <QTableWidget>
#include <QContextMenuEvent>
#include "octave_connection.h"
#include "ui_table_ui.h"
#include "basewidget.h"
#include "operations/table_plot.h"

using namespace Ui;

/** Shows QTable with spreadsheet. Spreadsheet's data are from given matrix.
When spreadsheet is modificated, matrix is modificated.
*/

class Table:public BaseWidget
{
	Q_OBJECT
	public:
	Table( QWidget * parent = 0 );
	void setOctaveConnection(OctaveConnection *octave_connection);
	void setMatrix(QString matrix);
	QString getMatrix();
	private:
	TableForm *table_form;
	OctaveConnection *octave_connection;
	QString matrix;
	void change_rows();
	void change_cols();
	void build_menu();
	QMenu *menu;
	protected:
	void contextMenuEvent ( QContextMenuEvent * event );
	public slots:
	void windowActivated ( QWidget * w );
	void windowActivated();
	//Plot callbacks
	void plot(TablePlot::Type);
	void plotPlot();
	void plotPolar();
	void plotLogXandY();
	void plotLogY();
	void plotLogX();
	void plotBar();
	/** Callback to line_ready signal from OctaveConnection.
	 * @param line line from Octave.
	*/
	void line_ready(QString line);
	void cellChanged ( int row, int col );
	void rows_changed();
	void cols_changed();
	void order_changed();
	void copy_cb();
	void copy_matrix_cb();
	void paste_cb();
	void delete_rows_cb();
	void delete_columns_cb();
	void insert_column_right_cb();
	void insert_column_left_cb();
	void insert_row_down_cb();
	void insert_row_up_cb();
};


#endif
