/****************************************************************************
**
** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.0, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** In addition, as a special exception, Trolltech, as the sole copyright
** holder for Qt Designer, grants users of the Qt/Eclipse Integration
** plug-in the right for the Qt/Eclipse Integration to link to
** functionality provided by Qt Designer and its related libraries.
**
** Trolltech reserves all rights not expressly granted herein.
** 
** Trolltech ASA (c) 2007
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QLOCALE_DATA_P_H
#define QLOCALE_DATA_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of qapplication_*.cpp, qwidget*.cpp and qfiledialog.cpp.  This header
// file may change from version to version without notice, or even be removed.
//
// We mean it.
//

/*
    This file was generated on 2006-09-06 from the Common Locale Data Repository v1.4

    http://www.unicode.org/cldr/

    Do not change it, instead edit $QTDIR/util/locale_database/locale.xml and run
    qlocalexml2cpp.py.
*/


static const uint locale_index[] = {
     0, // unused
     0, // C
     0, // Abkhazian
     1, // Afan
     3, // Afar
     6, // Afrikaans
     8, // Albanian
     9, // Amharic
    10, // Arabic
    27, // Armenian
    28, // Assamese
     0, // Aymara
    29, // Azerbaijani
     0, // Bashkir
    30, // Basque
    31, // Bengali
    33, // Bhutani
     0, // Bihari
     0, // Bislama
     0, // Breton
    34, // Bulgarian
     0, // Burmese
    35, // Byelorussian
    36, // Cambodian
    37, // Catalan
    38, // Chinese
     0, // Corsican
    43, // Croatian
    44, // Czech
    45, // Danish
    46, // Dutch
    48, // English
     0, // Esperanto
    74, // Estonian
    75, // Faroese
     0, // Fiji
    76, // Finnish
    77, // French
     0, // Frisian
     0, // Gaelic
    83, // Galician
    84, // Georgian
    85, // German
    91, // Greek
    93, // Greenlandic
     0, // Guarani
    94, // Gujarati
    95, // Hausa
    98, // Hebrew
    99, // Hindi
   100, // Hungarian
   101, // Icelandic
   102, // Indonesian
     0, // Interlingua
     0, // Interlingue
     0, // Inuktitut
     0, // Inupiak
   103, // Irish
   104, // Italian
   106, // Japanese
     0, // Javanese
   107, // Kannada
     0, // Kashmiri
   108, // Kazakh
   109, // Kinyarwanda
   110, // Kirghiz
   111, // Korean
   112, // Kurdish
     0, // Kurundi
   116, // Laothian
     0, // Latin
   117, // Latvian
   118, // Lingala
   120, // Lithuanian
   121, // Macedonian
     0, // Malagasy
   122, // Malay
   124, // Malayalam
   125, // Maltese
     0, // Maori
   126, // Marathi
     0, // Moldavian
   127, // Mongolian
     0, // Nauru
   128, // Nepali
   129, // Norwegian
     0, // Occitan
   130, // Oriya
   131, // Pashto
   132, // Persian
   134, // Polish
   135, // Portuguese
   137, // Punjabi
     0, // Quechua
     0, // RhaetoRomance
   139, // Romanian
   140, // Russian
     0, // Samoan
     0, // Sangho
   142, // Sanskrit
   143, // Serbian
   146, // SerboCroatian
   149, // Sesotho
   150, // Setswana
     0, // Shona
     0, // Sindhi
     0, // Singhalese
   151, // Siswati
   152, // Slovak
   153, // Slovenian
   154, // Somali
   158, // Spanish
     0, // Sundanese
   178, // Swahili
   180, // Swedish
     0, // Tagalog
   182, // Tajik
   183, // Tamil
   184, // Tatar
   185, // Telugu
   186, // Thai
     0, // Tibetan
   187, // Tigrinya
     0, // Tonga
   189, // Tsonga
   190, // Turkish
     0, // Turkmen
     0, // Twi
     0, // Uigur
   191, // Ukrainian
   192, // Urdu
   194, // Uzbek
   196, // Vietnamese
     0, // Volapuk
   197, // Welsh
     0, // Wolof
   198, // Xhosa
     0, // Yiddish
   199, // Yoruba
     0, // Zhuang
   200, // Zulu
   201, // Nynorsk
   202, // Bosnian
   203, // Divehi
   204, // Manx
   205, // Cornish
   206, // Akan
   207, // Konkani
   208, // Ga
   209, // Igbo
   210, // Kamba
   211, // Syriac
   212, // Blin
   213, // Geez
   215, // Koro
   216, // Sidamo
   217, // Atsam
   218, // Tigre
   219, // Jju
   220, // Friulian
   221, // Venda
   222, // Ewe
     0, // Walamo
   224, // Hawaiian
   225, // Tyap
   226, // Chewa
     0 // trailing 0
};

static const QLocalePrivate locale_data[] = {
//      lang   terr    dec  group   list  prcnt   zero  minus    exp sDtFmt lDtFmt sTmFmt lTmFmt sMonth lMonth  sDays  lDays
    {      1,     0,    46,    44,    59,    37,    48,    45,   101,     0,    11,     0,     9,     0,    49,     0,    29 }, // C/AnyCountry
    {      3,    69,    46,    44,    59,    37,    48,    45,   101,    29,    38,    20,    28,   136,   185,    87,   116 }, // Afan/Ethiopia
    {      3,   111,    46,    44,    59,    37,    48,    45,   101,    29,    38,    20,    28,   136,   185,    87,   116 }, // Afan/Kenya
    {      4,    59,    46,    44,    59,    37,    48,    45,   101,    29,    57,    20,    28,   297,   346,   172,   201 }, // Afar/Djibouti
    {      4,    67,    46,    44,    59,    37,    48,    45,   101,    29,    57,    20,    28,   297,   476,   172,   201 }, // Afar/Eritrea
    {      4,    69,    46,    44,    59,    37,    48,    45,   101,    29,    57,    20,    28,   297,   476,   172,   201 }, // Afar/Ethiopia
    {      5,   195,    44,   160,    59,    37,    48,    45,   101,    77,    88,    20,    28,   595,   644,   254,   276 }, // Afrikaans/SouthAfrica
    {      5,   148,    44,   160,    59,    37,    48,    45,   101,   106,   117,    39,     9,   595,   644,   254,   276 }, // Afrikaans/Namibia
    {      6,     2,    44,    46,    59,    37,    48,    45,   101,   134,   143,    45,    53,   737,   787,   335,   366 }, // Albanian/Albania
    {      7,    69,    46,    44,    59,    37,    48,    45,   101,    29,   162,    20,    66,   867,   982,   431,   499 }, // Amharic/Ethiopia
    {      8,   186,  1643,  1644,    59,  1642,  1632,    45,   101,   192,   201,    20,    78,  1145,  1145,   570,   570 }, // Arabic/SaudiArabia
    {      8,     3,  1643,  1644,    59,  1642,    48,    45,   101,   192,   201,    20,    78,  1145,  1145,   668,   570 }, // Arabic/Algeria
    {      8,    17,  1643,  1644,    59,  1642,  1632,    45,   101,   192,   201,    20,    78,  1145,  1145,   668,   570 }, // Arabic/Bahrain
    {      8,    64,  1643,  1644,    59,  1642,  1632,    45,   101,   192,   201,    20,    78,  1145,  1145,   668,   570 }, // Arabic/Egypt
    {      8,   103,  1643,  1644,    59,  1642,  1632,    45,   101,   192,   201,    20,    78,  1145,  1145,   668,   570 }, // Arabic/Iraq
    {      8,   109,  1643,  1644,    59,  1642,  1632,    45,   101,   192,   201,    20,    78,  1284,  1284,   570,   570 }, // Arabic/Jordan
    {      8,   115,  1643,  1644,    59,  1642,  1632,    45,   101,   192,   201,    20,    78,  1145,  1145,   668,   570 }, // Arabic/Kuwait
    {      8,   119,  1643,  1644,    59,  1642,  1632,    45,   101,   192,   201,    20,    78,  1453,  1453,   570,   570 }, // Arabic/Lebanon
    {      8,   122,  1643,  1644,    59,  1642,  1632,    45,   101,   192,   201,    20,    78,  1145,  1145,   668,   570 }, // Arabic/LibyanArabJamahiriya
    {      8,   145,  1643,  1644,    59,  1642,    48,    45,   101,   192,   201,    20,    78,  1145,  1145,   668,   570 }, // Arabic/Morocco
    {      8,   162,  1643,  1644,    59,  1642,  1632,    45,   101,   192,   201,    20,    78,  1145,  1145,   668,   570 }, // Arabic/Oman
    {      8,   175,  1643,  1644,    59,  1642,  1632,    45,   101,   192,   201,    20,    78,  1145,  1145,   570,   570 }, // Arabic/Qatar
    {      8,   201,  1643,  1644,    59,  1642,  1632,    45,   101,   192,   201,    20,    78,  1145,  1145,   668,   570 }, // Arabic/Sudan
    {      8,   207,  1643,  1644,    59,  1642,  1632,    45,   101,   192,   201,    20,    78,  1453,  1453,   570,   570 }, // Arabic/SyrianArabRepublic
    {      8,   216,  1643,  1644,    59,  1642,    48,    45,   101,   192,   201,    20,    78,  1145,  1145,   570,   570 }, // Arabic/Tunisia
    {      8,   223,  1643,  1644,    59,  1642,  1632,    45,   101,   192,   201,    20,    78,  1145,  1145,   668,   570 }, // Arabic/UnitedArabEmirates
    {      8,   237,  1643,  1644,    59,  1642,  1632,    45,   101,   192,   201,    20,    78,  1145,  1145,   570,   570 }, // Arabic/Yemen
    {      9,    11,    44,    46,    59,    37,    48,    45,   101,   220,    38,    39,     9,  1622,  1707,   690,   740 }, // Armenian/Armenia
    {     10,   100,    46,    44,    59,    37,    48,    45,   101,   229,   201,    91,   100,  1888,  2051,   858,   956 }, // Assamese/India
    {     12,    15,    44,   160,    59,    37,    48,    45,   101,   238,   247,    39,     9,  2298,  2347,  1117,  1148 }, // Azerbaijani/Azerbaijan
    {     14,   197,    44,    46,    59,    37,    48,    45,   101,   266,   279,    39,     9,  2427,  2476,  1245,  1267 }, // Basque/Spain
    {     15,    18,    46,    44,    59,    37,    48,    45,   101,   311,   117,    20,   113,  2570,  2570,  1336,  1434 }, // Bengali/Bangladesh
    {     15,   100,    46,    44,    59,    37,    48,    45,   101,   311,   117,    20,   113,  2570,  2570,  1336,  1434 }, // Bengali/India
    {     16,    25,    46,    44,    59,    37,  3872,    45,   101,   318,   378,   126,   175,  2817,  2995,  1595,  1684 }, // Bhutani/Bhutan
    {     20,    33,    44,   160,    59,    37,    48,    45,   101,   438,   447,    39,     9,  3587,  3686,  1908,  1944 }, // Bulgarian/Bulgaria
    {     22,    20,    44,   160,    59,    37,    48,    45,   101,   466,    11,   254,   260,  3839,  3924,  2048,  2084 }, // Byelorussian/Belarus
    {     23,    36,    44,    46,    59,    37,    48,    45,   101,   192,   473,   271,   276,  4103,  4161,  2190,  2234 }, // Cambodian/Cambodia
    {     24,   197,    44,    46,    59,    37,    48,    45,   101,    29,   533,   271,   339,  4351,  4413,  2449,  2478 }, // Catalan/Spain
    {     25,    44,    46,    44,    59,    37,    48,    45,   101,   560,   567,   349,   356,  4497,  4497,  2539,  2589 }, // Chinese/China
    {     25,    97,    46,    44,    59,    37,    48,    45,   101,   593,   613,   349,     9,  4588,  4497,  2539,  2589 }, // Chinese/HongKong
    {     25,   126,    46,    44,    59,    37,    48,    45,   101,   593,   640,   349,     9,  4588,  4497,  2539,  2589 }, // Chinese/Macau
    {     25,   190,    46,    44,    59,    37,    48,    45,   101,    29,   669,   382,   391,  4497,  4497,  2539,  2589 }, // Chinese/Singapore
    {     25,   208,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9,  4497,  4497,  2660,  2589 }, // Chinese/Taiwan
    {     27,    54,    44,    46,    59,    37,    48,    45,   101,   682,   693,    39,     9,  4652,  4702,  2710,  2740 }, // Croatian/Croatia
    {     28,    57,    44,   160,    59,    37,    48,    45,   101,   466,   707,   271,   339,  4804,  4862,  2800,  2825 }, // Czech/CzechRepublic
    {     29,    58,    44,    46,    59,    37,    48,  8722,   101,    29,   726,   254,   260,  4957,  5006,  2883,  2914 }, // Danish/Denmark
    {     30,   151,    44,    46,    59,    37,    48,    45,   101,   750,   117,    39,   403,  5091,  5140,  2968,  2990 }, // Dutch/Netherlands
    {     30,    21,    44,    46,    59,    37,    48,    45,   101,   759,   117,    39,   403,  5091,  5140,  2968,  2990 }, // Dutch/Belgium
    {     31,   225,    46,    44,    59,    37,    48,    45,   101,   767,    38,    20,   413,     0,    49,     0,    29 }, // English/UnitedStates
    {     31,     4,    46,    44,    59,    37,    48,    45,   101,   767,    38,    20,   413,     0,    49,     0,    29 }, // English/AmericanSamoa
    {     31,    13,    46,    44,    59,    37,    48,    45,   101,   759,    11,    20,   413,     0,    49,     0,    29 }, // English/Australia
    {     31,    21,    44,    46,    59,    37,    48,    45,   101,    29,   117,    39,   425,     0,    49,     0,    29 }, // English/Belgium
    {     31,    22,    46,    44,    59,    37,    48,    45,   101,    29,   669,    39,     9,     0,    49,     0,    29 }, // English/Belize
    {     31,    28,    46,    44,    59,    37,    48,    45,   101,    29,    88,    20,    28,     0,    49,     0,    29 }, // English/Botswana
    {     31,    38,    46,    44,    59,    37,    48,    45,   101,    29,    38,    20,   413,     0,    49,     0,    29 }, // English/Canada
    {     31,    89,    46,    44,    59,    37,    48,    45,   101,   767,    38,    20,   413,     0,    49,     0,    29 }, // English/Guam
    {     31,    97,    46,    44,    59,    37,    48,    45,   101,   774,    11,    20,   413,     0,    49,     0,    29 }, // English/HongKong
    {     31,   100,    46,    44,    59,    37,    48,    45,   101,    29,   117,    20,   413,     0,    49,     0,    29 }, // English/India
    {     31,   104,    46,    44,    59,    37,    48,    45,   101,   774,   117,    39,     9,     0,    49,     0,    29 }, // English/Ireland
    {     31,   107,    46,    44,    59,    37,    48,    45,   101,   767,    38,    20,   413,     0,    49,     0,    29 }, // English/Jamaica
    {     31,   133,    46,    44,    59,    37,    48,    45,   101,   774,    11,    39,     9,     0,    49,     0,    29 }, // English/Malta
    {     31,   134,    46,    44,    59,    37,    48,    45,   101,   767,    38,    20,   413,     0,    49,     0,    29 }, // English/MarshallIslands
    {     31,   148,    46,    44,    59,    37,    48,    45,   101,   767,    38,    20,   413,     0,    49,     0,    29 }, // English/Namibia
    {     31,   154,    46,    44,    59,    37,    48,    45,   101,   759,    11,    20,   413,     0,    49,     0,    29 }, // English/NewZealand
    {     31,   160,    46,    44,    59,    37,    48,    45,   101,   767,    38,    20,   413,     0,    49,     0,    29 }, // English/NorthernMarianaIslands
    {     31,   163,    46,    44,    59,    37,    48,    45,   101,    29,   117,    20,   413,     0,    49,     0,    29 }, // English/Pakistan
    {     31,   170,    46,    44,    59,    37,    48,    45,   101,   767,    38,    20,   413,     0,    49,     0,    29 }, // English/Philippines
    {     31,   190,    46,    44,    59,    37,    48,    45,   101,    29,   669,   382,   391,     0,    49,     0,    29 }, // English/Singapore
    {     31,   195,    46,    44,    59,    37,    48,    45,   101,    77,    88,    20,    28,     0,    49,     0,    29 }, // English/SouthAfrica
    {     31,   215,    46,    44,    59,    37,    48,    45,   101,   767,    38,    20,   413,     0,    49,     0,    29 }, // English/TrinidadAndTobago
    {     31,   224,    46,    44,    59,    37,    48,    45,   101,   774,    11,    39,     9,     0,    49,     0,    29 }, // English/UnitedKingdom
    {     31,   226,    46,    44,    59,    37,    48,    45,   101,   767,    38,    20,   413,     0,    49,     0,    29 }, // English/UnitedStatesMinorOutlyingIslands
    {     31,   234,    46,    44,    59,    37,    48,    45,   101,   767,    38,    20,   413,     0,    49,     0,    29 }, // English/USVirginIslands
    {     31,   240,    46,    44,    59,    37,    48,    45,   101,   192,    88,    20,    28,     0,    49,     0,    29 }, // English/Zimbabwe
    {     33,    68,    44,   160,    59,    37,    48,    45,   101,   438,   785,   271,   339,  5229,  5290,  3050,  3065 }, // Estonian/Estonia
    {     34,    71,    44,    46,    59,    37,    48,    45,   101,   750,    88,    39,     9,  5383,  5432,  3136,  3169 }, // Faroese/FaroeIslands
    {     36,    73,    44,   160,    59,    37,    48,    45,   101,   804,   813,   450,   455,  5517,  5589,  3248,  3270 }, // Finnish/Finland
    {     37,    74,    44,   160,    59,    37,    48,    45,   101,    29,   117,    39,   464,  5697,  5764,  3338,  3374 }, // French/France
    {     37,    21,    44,    46,    59,    37,    48,    45,   101,   759,   117,    39,   476,  5697,  5764,  3338,  3374 }, // French/Belgium
    {     37,    38,    44,   160,    59,    37,    48,    45,   101,   134,   117,    39,   425,  5697,  5764,  3338,  3374 }, // French/Canada
    {     37,   125,    44,    46,    59,    37,    48,    45,   101,    29,   117,    39,   464,  5697,  5764,  3338,  3374 }, // French/Luxembourg
    {     37,   142,    44,   160,    59,    37,    48,    45,   101,    29,   117,    39,   464,  5697,  5764,  3338,  3374 }, // French/Monaco
    {     37,   206,    46,    39,    59,    37,    48,    45,   101,   438,    11,    39,   500,  5697,  5764,  3338,  3374 }, // French/Switzerland
    {     40,   197,    44,    46,    59,    37,    48,    45,   101,    29,    88,    39,     9,  5853,  5903,  3427,  3458 }, // Galician/Spain
    {     41,    81,    44,   160,    59,    37,    48,    45,   101,   238,   247,   515,   529,  5992,  6113,  3510,  3581 }, // Georgian/Georgia
    {     42,    82,    44,    46,    59,    37,    48,    45,   101,   438,   707,    39,   550,  6387,  6436,  3754,  3776 }, // German/Germany
    {     42,    14,    44,    46,    59,    37,    48,    45,   101,   438,   839,    39,   563,  6521,  6572,  3754,  3776 }, // German/Austria
    {     42,    21,    44,    46,    59,    37,    48,    45,   101,   759,   117,    39,   577,  6658,  6436,  3837,  3776 }, // German/Belgium
    {     42,   123,    46,    39,    59,    37,    48,    45,   101,   438,   707,    39,   550,  6387,  6436,  3754,  3776 }, // German/Liechtenstein
    {     42,   125,    44,    46,    59,    37,    48,    45,   101,   438,   707,    39,   550,  6387,  6436,  3754,  3776 }, // German/Luxembourg
    {     42,   206,    46,    39,    59,    37,    48,    45,   101,   438,   707,    39,   550,  6387,  6436,  3754,  3776 }, // German/Switzerland
    {     43,    85,    44,    46,    59,    37,    48,    45,   101,   774,   143,    20,   113,  6708,  6797,  3866,  3916 }, // Greek/Greece
    {     43,    56,    44,    46,    59,    37,    48,    45,   101,   774,   143,    20,   113,  6708,  6797,  3866,  3916 }, // Greek/Cyprus
    {     44,    86,    44,    46,    59,    37,    48,    45,   101,    29,    88,    20,    28,  4957,  7016,  4020,  4049 }, // Greenlandic/Greenland
    {     46,   100,    46,    44,    59,    37,  2790,    45,   101,   859,   117,   602,   611,  7113,  7291,  4148,  4231 }, // Gujarati/India
    {     47,    83,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9,  7529,  7578,  4377,  4406 }, // Hausa/Ghana
    {     47,   156,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9,  7529,  7578,  4377,  4406 }, // Hausa/Niger
    {     47,   157,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9,  7529,  7578,  4377,  4406 }, // Hausa/Nigeria
    {     48,   105,    46,    44,    59,    37,    48,    45,   101,    29,   117,    39,     9,  7662,  7747,  4460,  4482 }, // Hebrew/Israel
    {     49,   100,    46,    44,    59,    37,  2406,    45,   101,   311,   117,    20,   113,  7880,  7880,  4592,  4675 }, // Hindi/India
    {     50,    98,    44,   160,    59,    37,    48,    45,   101,   867,   879,   271,   339,  8082,  8152,  4821,  4841 }, // Hungarian/Hungary
    {     51,    99,    44,    46,    59,    37,    48,    45,   101,   804,   707,    39,     9,  8259,  8314,  4901,  4934 }, // Icelandic/Iceland
    {     52,   101,    44,    46,    59,    37,    48,    45,   101,    29,    88,   271,   625,  8409,  8458,  5021,  5050 }, // Indonesian/Indonesia
    {     57,   104,    46,    44,    59,    37,    48,    45,   101,   774,   117,    39,     9,  8546,  8614,  5094,  5135 }, // Irish/Ireland
    {     58,   106,    44,    46,    59,    37,    48,    45,   101,    29,   117,    39,     9,  8730,  8779,  5220,  5249 }, // Italian/Italy
    {     58,   206,    46,    39,    59,    37,    48,    45,   101,   438,    11,    39,   500,  8730,  8779,  5220,  5249 }, // Italian/Switzerland
    {     59,   108,    46,    44,    59,    37,    48,    45,   101,   238,   567,   271,   633,  8874,  8874,  5312,  5341 }, // Japanese/Japan
    {     61,   100,    46,    44,    59,    37,    48,    45,   101,   311,   117,   602,   611,  8950,  8950,  5412,  5469 }, // Kannada/India
    {     63,   110,    44,   160,    59,    37,    48,    45,   101,   438,   893,    39,     9,  9185,  9284,  5615,  5658 }, // Kazakh/Kazakhstan
    {     64,   179,    44,    46,    59,    37,    48,    45,   101,   238,   247,    39,     9,  9439,  9500,  5760,  5796 }, // Kinyarwanda/Rwanda
    {     65,   116,    44,   160,    59,    37,    48,    45,   101,   238,   247,    39,     9,  9602,  9615,  5881,  5881 }, // Kirghiz/Kyrgyzstan
    {     66,   114,    46,    44,    59,    37,    48,    45,   101,   917,   928,   655,   663,  9643,  9643,  5896,  5925 }, // Korean/RepublicOfKorea
    {     67,   102,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9,  9707,  9744,  5996,  6025 }, // Kurdish/Iran
    {     67,   103,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9,  9707,  9744,  5996,  6025 }, // Kurdish/Iraq
    {     67,   207,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9,  9707,  9744,  5996,  6025 }, // Kurdish/SyrianArabRepublic
    {     67,   217,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9,  9707,  9744,  5996,  6025 }, // Kurdish/Turkey
    {     69,   117,    46,    44,    59,    37,    48,    45,   101,   192,   957,   271,   692,  9799,  9915,  6076,  6121 }, // Laothian/Lao
    {     71,   118,    44,   160,    59,    37,    48,    45,   101,   985,   992,    39,     9, 10117, 10168,  6279,  6296 }, // Latvian/Latvia
    {     72,    49,    44,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 10275, 10315,  6371,  6395 }, // Lingala/DemocraticRepublicOfCongo
    {     72,    50,    44,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 10275, 10315,  6371,  6395 }, // Lingala/PeoplesRepublicOfCongo
    {     73,   124,    44,    46,    59,    37,    48,    45,   101,   106,  1019,    39,     9, 10565, 10614,  6516,  6539 }, // Lithuanian/Lithuania
    {     74,   127,    44,    46,    59,    37,    48,    45,   101,  1046,   143,    39,     9, 10722, 10827,  6632,  6687 }, // Macedonian/Macedonia
    {     76,   130,    46,    44,    59,    37,    48,    45,   101,   774,  1054,   744,   113, 10986, 11036,  6789,  6818 }, // Malay/Malaysia
    {     76,    32,    44,    46,    59,    37,    48,    45,   101,   774,   669,   625,   749, 10986, 11036,  6789,  6818 }, // Malay/BruneiDarussalam
    {     77,   100,    46,    44,    59,    37,  3430,    45,   101,   750,   117,    20,   113, 11119, 11288,  6862,  6912 }, // Malayalam/India
    {     78,   133,    46,    44,    59,    37,    48,    45,   101,   774,  1071,    39,     9, 11559, 11610,  7040,  7072 }, // Maltese/Malta
    {     80,   100,    46,    44,    59,    37,    48,    45,   101,   311,   117,    20,   113, 11698, 11698,  7141,  7224 }, // Marathi/India
    {     82,   143,    44,   160,    59,    37,    48,    45,   101,   238,   247,    39,     9, 11930, 12015,  7370,  7406 }, // Mongolian/Mongolia
    {     84,   150,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 12136, 12281,  7486,  7572 }, // Nepali/Nepal
    {     85,   161,    44,   160,    59,    37,    48,    45,   101,   438,  1097,   254,   762, 12513, 12574,  7721,  2914 }, // Norwegian/Norway
    {     87,   100,    46,    44,    59,    37,  2918,    45,   101,   750,   117,    20,   113,  9602, 12658,  7752,  7838 }, // Oriya/India
    {     88,     1,  1643,  1644,    59,  1642,  1776,  8722,   101,  1115,  1124,   271,   779, 12902, 12927,  5881,  7987 }, // Pashto/Afghanistan
    {     89,   102,  1643,  1644,  1563,  1642,  1776,  8722,   101,  1147,  1156,   271,   791,  9602, 13052,  7987,  7987 }, // Persian/Iran
    {     89,     1,  1643,  1644,  1563,  1642,  1776,  8722,   101,  1147,  1156,   271,   791, 13189, 13232,  7987,  7987 }, // Persian/Afghanistan
    {     90,   172,    44,   160,    59,    37,    48,    45,   101,   134,    11,    39,     9, 13357, 13407,  8080,  8116 }, // Polish/Poland
    {     91,   173,    44,    46,    59,    37,    48,    45,   101,   238,  1178,    39,   802, 13509, 13558,  8179,  8209 }, // Portuguese/Portugal
    {     91,    30,    44,    46,    59,    37,    48,    45,   101,    29,  1178,    39,   820, 13509, 13558,  8179,  8209 }, // Portuguese/Brazil
    {     92,   100,    46,    44,    59,    37,  2662,    45,   101,   311,   117,   602,   611, 13649, 13649,  8291,  8378 }, // Punjabi/India
    {     92,   163,    46,    44,    59,    37,  2662,    45,   101,   238,   247,    39,     9, 13649, 13649,  8291,  8378 }, // Punjabi/Pakistan
    {     95,   177,    44,    46,    59,    37,    48,    45,   101,  1206,  1217,    39,     9, 13830, 13879,  8530,  8547 }, // Romanian/Romania
    {     96,   178,    44,   160,    59,    37,    48,    45,   101,   438,  1229,   271,   339, 13978, 14085,  8601,  8637 }, // Russian/RussianFederation
    {     96,   222,    44,   160,    59,    37,    48,    45,   101,   438,  1246,    39,     9, 13978, 14085,  8601,  8637 }, // Russian/Ukraine
    {     99,   100,    46,    44,    59,    37,  2406,    45,   101,   859,   117,   602,   611,  9602,  9615,  5881,  5881 }, // Sanskrit/India
    {    100,   241,    44,    46,    59,    37,    48,    45,   101,  1270,  1278,   254,   260, 14238, 14323,  8755,  8805 }, // Serbian/SerbiaAndMontenegro
    {    100,    27,    44,    46,    59,    37,    48,    45,   101,   134,  1298,    39,   840, 14238, 14474,  8903,  8953 }, // Serbian/BosniaAndHerzegowina
    {    100,   238,    44,    46,    59,    37,    48,    45,   101,  1270,  1278,   254,   260, 14238, 14323,  8755,  8805 }, // Serbian/Yugoslavia
    {    101,   241,    46,    44,    59,    37,    48,    45,   101,   238,  1298,    39,     9, 14629, 14678,  9055,  9085 }, // SerboCroatian/SerbiaAndMontenegro
    {    101,    27,    46,    44,    59,    37,    48,    45,   101,   134,  1298,    39,   898, 14629, 14760,  2710,  9141 }, // SerboCroatian/BosniaAndHerzegowina
    {    101,   238,    46,    44,    59,    37,    48,    45,   101,   238,  1298,    39,     9, 14629, 14678,  9055,  9085 }, // SerboCroatian/Yugoslavia
    {    102,   195,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 14844, 14893,  9199,  9227 }, // Sesotho/SouthAfrica
    {    103,   195,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 14999, 15048,  9289,  9317 }, // Setswana/SouthAfrica
    {    107,   195,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 15166, 15215,  9382,  9410 }, // Siswati/SouthAfrica
    {    108,   191,    44,   160,    59,    37,    48,    45,   101,   804,   707,   271,   339, 15330, 15382,  9479,  9502 }, // Slovak/Slovakia
    {    109,   192,    44,    46,    59,    37,    48,    45,   101,   466,   839,   271,   339, 14629, 15472,  9557,  9587 }, // Slovenian/Slovenia
    {    110,   194,    46,    44,    59,    37,    48,    45,   101,    29,    57,    20,    28, 15559, 15608,  9641,  9670 }, // Somali/Somalia
    {    110,    59,    46,    44,    59,    37,    48,    45,   101,    29,    57,    20,    28, 15559, 15608,  9641,  9670 }, // Somali/Djibouti
    {    110,    69,    46,    44,    59,    37,    48,    45,   101,    29,    57,    20,    28, 15559, 15608,  9641,  9670 }, // Somali/Ethiopia
    {    110,   111,    46,    44,    59,    37,    48,    45,   101,    29,    57,    20,    28, 15559, 15608,  9641,  9670 }, // Somali/Kenya
    {    111,   197,    44,    46,    59,    37,    48,    45,   101,    29,  1319,   271,   938, 15798, 15847,  9718,  9749 }, // Spanish/Spain
    {    111,    10,    44,    46,    59,    37,    48,    45,   101,    29,  1319,    39,   953, 15798, 15847,  9718,  9749 }, // Spanish/Argentina
    {    111,    26,    44,    46,    59,    37,    48,    45,   101,    29,  1319,   602,   611, 15798, 15847,  9718,  9749 }, // Spanish/Bolivia
    {    111,    43,    44,    46,    59,    37,    48,    45,   101,   750,  1319,   271,     9, 15798, 15847,  9718,  9749 }, // Spanish/Chile
    {    111,    47,    44,    46,    59,    37,    48,    45,   101,   759,  1319,   271,     9, 15798, 15847,  9718,  9749 }, // Spanish/Colombia
    {    111,    52,    44,    46,    59,    37,    48,    45,   101,    29,  1319,   602,   611, 15798, 15847,  9718,  9749 }, // Spanish/CostaRica
    {    111,    61,    46,    44,    59,    37,    48,    45,   101,    29,  1319,   602,   611, 15798, 15847,  9718,  9749 }, // Spanish/DominicanRepublic
    {    111,    63,    44,    46,    59,    37,    48,    45,   101,    29,  1319,   271,     9, 15798, 15847,  9718,  9749 }, // Spanish/Ecuador
    {    111,    65,    46,    44,    59,    37,    48,    45,   101,    29,  1319,   602,   611, 15798, 15847,  9718,  9749 }, // Spanish/ElSalvador
    {    111,    90,    46,    44,    59,    37,    48,    45,   101,   759,  1319,   602,   611, 15798, 15847,  9718,  9749 }, // Spanish/Guatemala
    {    111,    96,    46,    44,    59,    37,    48,    45,   101,    29,  1346,   602,   611, 15798, 15847,  9718,  9749 }, // Spanish/Honduras
    {    111,   139,    46,    44,    59,    37,    48,    45,   101,    29,  1319,   602,   611, 15798, 15847,  9718,  9749 }, // Spanish/Mexico
    {    111,   155,    46,    44,    59,    37,    48,    45,   101,    29,  1319,   602,   611, 15798, 15847,  9718,  9749 }, // Spanish/Nicaragua
    {    111,   166,    46,    44,    59,    37,    48,    45,   101,   220,  1319,   602,   611, 15798, 15847,  9718,  9749 }, // Spanish/Panama
    {    111,   168,    44,    46,    59,    37,    48,    45,   101,    29,  1319,   602,   611, 15798, 15847,  9718,  9749 }, // Spanish/Paraguay
    {    111,   169,    44,    46,    59,    37,    48,    45,   101,   759,  1319,    39,   938, 15798, 15847,  9718,  9749 }, // Spanish/Peru
    {    111,   174,    46,    44,    59,    37,    48,    45,   101,   220,  1319,   602,   611, 15798, 15847,  9718,  9749 }, // Spanish/PuertoRico
    {    111,   225,    46,    44,    59,    37,    48,    45,   101,   767,  1319,    20,   113, 15798, 15847,  9718,  9749 }, // Spanish/UnitedStates
    {    111,   227,    44,    46,    59,    37,    48,    45,   101,    29,  1319,   602,   611, 15798, 15847,  9718,  9749 }, // Spanish/Uruguay
    {    111,   231,    44,    46,    59,    37,    48,    45,   101,    29,  1319,   602,   611, 15798, 15847,  9718,  9749 }, // Spanish/Venezuela
    {    113,   111,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 15937, 15986,  9805,  9834 }, // Swahili/Kenya
    {    113,   210,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 15937, 15986,  9805,  9834 }, // Swahili/Tanzania
    {    114,   205,    44,   160,    59,    37,    48,  8722,   101,   106,  1374,   254,   762,  4957, 16071,  9895,  9920 }, // Swedish/Sweden
    {    114,    73,    44,   160,    59,    37,    48,  8722,   101,   106,  1374,   254,   762,  4957, 16071,  9895,  9920 }, // Swedish/Finland
    {    116,   209,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 16158, 16243,  9974, 10024 }, // Tajik/Tajikistan
    {    117,   100,    46,    44,    59,    37,    48,    45,   101,   311,   117,    20,   113, 16374, 16507, 10128, 10175 }, // Tamil/India
    {    118,   178,    44,   160,    59,    37,    48,    45,   101,  1206,  1217,   625,    28,  9602,  9615,  5881,  5881 }, // Tatar/RussianFederation
    {    119,   100,    46,    44,    59,    37,  3174,    45,   101,   750,   117,    20,   113, 16742, 16742, 10309, 10392 }, // Telugu/India
    {    120,   211,    46,    44,    59,    37,    48,    45,   101,   192,  1399,   271,   965, 16977, 17095, 10559, 10601 }, // Thai/Thailand
    {    122,    67,    46,    44,    59,    37,    48,    45,   101,    29,  1429,    20,    28, 17366, 17481, 10792, 10863 }, // Tigrinya/Eritrea
    {    122,    69,    46,    44,    59,    37,    48,    45,   101,    29,  1465,    20,    28,   867,   982, 10937, 11008 }, // Tigrinya/Ethiopia
    {    124,   195,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 17620, 17669, 11082, 11110 }, // Tsonga/SouthAfrica
    {    125,   217,    44,    46,    59,    37,    48,    45,   101,  1206,  1501,    39,     9, 17792, 17843, 11183, 11213 }, // Turkish/Turkey
    {    129,   222,    44,   160,    59,    37,    48,    45,   101,   438,  1519,    39,     9, 17925, 18010, 11272, 11308 }, // Ukrainian/Ukraine
    {    130,   100,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9,  9602,  9615,  5881,  5881 }, // Urdu/India
    {    130,   163,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9,  9602,  9615,  5881,  5881 }, // Urdu/Pakistan
    {    131,   228,    44,   160,    59,    37,    48,    45,   101,   238,   247,    39,     9, 16158, 18173, 11414, 11464 }, // Uzbek/Uzbekistan
    {    131,     1,    44,   160,    59,    37,    48,    45,   101,   238,   247,    39,     9, 16158, 18173, 11414, 11464 }, // Uzbek/Afghanistan
    {    132,   232,    44,    46,    59,    37,    48,    45,   101,   774,  1543,    39,     9, 18386, 18462, 11564, 11598 }, // Vietnamese/VietNam
    {    134,   224,    46,    44,    59,    37,    48,    45,   101,   774,   143,    39,     9, 18625, 18688, 11675, 11706 }, // Welsh/UnitedKingdom
    {    136,   195,    44,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 18775, 18824, 11784, 11813 }, // Xhosa/SouthAfrica
    {    138,   157,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 18916, 18983, 11875, 11916 }, // Yoruba/Nigeria
    {    140,   195,    44,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 19088, 19137, 11972, 12001 }, // Zulu/SouthAfrica
    {    141,   161,    44,   160,    59,    37,    48,    45,   101,   438,  1097,   254,   762,  5383, 12574, 12069, 12092 }, // Nynorsk/Norway
    {    142,    27,    44,    46,    59,    37,    48,    45,   101,   238,   247,    39,     9, 19227, 19276, 12145, 12175 }, // Bosnian/BosniaAndHerzegowina
    {    143,   131,    46,    44,  1548,    37,  1632,    45,   101,   311,   117,   602,   611,  9602,  9615,  5881,  5881 }, // Divehi/Maldives
    {    144,   224,    46,    44,    59,    37,    48,    45,   101,    29,    88,    39,     9, 19360, 19463, 12235, 12266 }, // Manx/UnitedKingdom
    {    145,   224,    46,    44,    59,    37,    48,    45,   101,   774,   117,    39,     9, 19604, 19651, 12324, 12353 }, // Cornish/UnitedKingdom
    {    146,    83,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 19776, 19833, 12414, 12443 }, // Akan/Ghana
    {    147,   100,    46,    44,    59,    37,    48,    45,   101,   311,   117,    20,   113, 11698, 20048,  7141, 12493 }, // Konkani/India
    {    148,    83,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 20286, 20335, 12645, 12672 }, // Ga/Ghana
    {    149,   157,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 20430, 20485, 12707, 12747 }, // Igbo/Nigeria
    {    150,   111,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 20592, 20592, 12821, 12850 }, // Kamba/Kenya
    {    151,   207,    46,    44,    59,    37,    48,    45,   101,   774,  1577,   744,    28, 20782,  9615,  5881,  5881 }, // Syriac/SyrianArabRepublic
    {    152,    67,    46,    44,    59,    37,    48,    45,   101,    29,  1591,    20,    28, 20901, 21015, 12910, 12971 }, // Blin/Eritrea
    {    153,    67,    46,  4808,    59,    37,    48,    45,   101,    29,  1624,    20,    28, 21217, 21338, 13079, 13150 }, // Geez/Eritrea
    {    153,    69,    46,  4808,    59,    37,    48,    45,   101,    29,  1624,    20,    28, 21217, 21338, 13079, 13150 }, // Geez/Ethiopia
    {    154,   157,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 21462, 21511, 13224, 13253 }, // Koro/Nigeria
    {    155,    69,    46,    44,    59,    37,    48,    45,   101,    29,    57,    20,    28,     0,    49, 13308, 13337 }, // Sidamo/Ethiopia
    {    156,   157,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 21636, 21696, 13389, 13425 }, // Atsam/Nigeria
    {    157,    67,    46,    44,    59,    37,    48,    45,   101,    29,  1660,    20,    28,   867,   982, 13513, 13577 }, // Tigre/Eritrea
    {    158,   157,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 21826, 21893, 13683, 13712 }, // Jju/Nigeria
    {    159,   106,    44,    46,    59,    37,    48,    45,   101,   759,  1690,    39,     9, 22083, 22132, 13757, 13786 }, // Friulian/Italy
    {    160,   195,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 22214, 22269, 13837, 13869 }, // Venda/SouthAfrica
    {    161,    83,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 22387, 22437, 13952, 13988 }, // Ewe/Ghana
    {    161,   212,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 22387, 22437, 13952, 13988 }, // Ewe/Togo
    {    163,   225,    46,    44,    59,    37,    48,    45,   101,  1707,    11,    20,   113, 22532, 22595, 14041, 14063 }, // Hawaiian/UnitedStates
    {    164,   157,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 22694, 22743, 14129, 14158 }, // Tyap/Nigeria
    {    165,   129,    46,    44,    59,    37,    48,    45,   101,   238,   247,    39,     9, 22897, 22946, 14201, 14230 }, // Chewa/Malawi
    {      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0 }  // trailing 0s
};

static const char date_format_data[] =
"d MMM yyyy\0"
"dddd, d MMMM yyyy\0"
"dd/MM/yy\0"
"dddd, MMMM d, yyyy\0"
"dddd, MMMM dd, yyyy\0"
"yyyy/MM/dd\0"
"dddd dd MMMM yyyy\0"
"yyyy-MM-dd\0"
"dddd d MMMM yyyy\0"
"yy-MM-dd\0"
"dddd, dd MMMM yyyy\0"
"dddd\xe1\x8d\xa3 dd MMMM \xe1\x89\x80\xe1\x8a\x95 yyyy G\0"
"d/M/yyyy\0"
"dddd, d MMMM, yyyy\0"
"MM/dd/yy\0"
"d-M-yyyy\0"
"yy/MM/dd\0"
"dddd, yyyy MMMM dd\0"
"yy'-'MM'-'dd\0"
"dddd, yyyy'eko' MMMM'ren' dd'a'\0"
"d-M-yy\0"
"\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\xa3\xe0\xbd\xbc"
"\xe0\xbc\x8b yyyy \xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b MMM \xe0\xbd\x9a\xe0\xbd\xba"
"\xe0\xbd\xa6\xe0\xbc\x8b dd\0"
"\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\xa3\xe0\xbd\xbc"
"\xe0\xbc\x8byyyy \xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b MMMM \xe0\xbd\x9a\xe0\xbd\xba"
"\xe0\xbd\xa6\xe0\xbc\x8b dd\0"
"dd.MM.yy\0"
"dd MMMM yyyy, dddd\0"
"d.M.yy\0"
"dddd' \xe1\x9e\x90\xe1\x9f\x92\xe1\x9e\x84\xe1\x9f\x83 'd' \xe1\x9e\x81\xe1\x9f\x82"
" 'MMMM' \xe1\x9e\x86\xe1\x9f\x92\xe1\x9e\x93\xe1\x9e\xb6\xe1\x9f\x86 ' yyyy\0"
"dddd d 'de' MMMM 'de' yyyy\0"
"yy-M-d\0"
"yyyy'\xe5\xb9\xb4'M'\xe6\x9c\x88'd'\xe6\x97\xa5'dddd\0"
"yy'\xe5\xb9\xb4'M'\xe6\x9c\x88'd'\xe6\x97\xa5'\0"
"yyyy'\xe5\xb9\xb4'M'\xe6\x9c\x88'd'\xe6\x97\xa5' dddd\0"
"yyyy'\xe5\xb9\xb4'MM'\xe6\x9c\x88'dd'\xe6\x97\xa5' dddd\0"
"dd MMMM yyyy\0"
"yyyy.MM.dd\0"
"yyyy. MMMM dd\0"
"dddd, d. MMMM yyyy\0"
"dddd 'den' d. MMMM yyyy\0"
"dd-MM-yy\0"
"d/MM/yy\0"
"M/d/yy\0"
"dd/MM/yyyy\0"
"dddd, d, MMMM yyyy\0"
"d.M.yyyy\0"
"dddd'na 'd. MMMM'ta 'yyyy\0"
"dddd, dd. MMMM yyyy\0"
"d-MM-yy\0"
"yyyy.MM.dd.\0"
"yyyy. MMMM d.\0"
"dddd, d MMMM yyyy '\xd0\xb6.'\0"
"yy. MM. dd\0"
"yyyy'\xeb\x85\x84' M'\xec\x9b\x94' d'\xec\x9d\xbc' dddd\0"
"dddd'\xe0\xba\x97\xe0\xba\xb5  'd MMMM G yyyy\0"
"yy.d.M\0"
"dddd, yyyy'. gada 'd. MMMM\0"
"yyyy 'm.' MMMM d 'd.',dddd\0"
"dd.M.yy\0"
"dddd dd MMM yyyy\0"
"dddd, d 'ta\xe2\x80\x99' MMMM yyyy\0"
"dddd d. MMMM yyyy\0"
"yyyy/M/d\0"
"dddd \xd8\xaf yyyy \xd8\xaf MMMM d\0"
"yy/M/d G\0"
"dddd d MMMM yyyy GGGG\0"
"dddd, d' de 'MMMM' de 'yyyy\0"
"dd.MM.yyyy\0"
"d MMMM yyyy\0"
"d MMMM yyyy'\xd0\xb3.'\0"
"dddd, d MMMM yyyy '\xd0\xb3.'\0"
"d.M.yy.\0"
"dddd, dd.MMMM.yyyy.\0"
"dddd, dd. MMMM yyyy.\0"
"dddd d' de 'MMMM' de 'yyyy\0"
"dddd dd' de 'MMMM' de 'yyyy\0"
"dddd'en den' d MMMM yyyy\0"
"dddd'\xe0\xb8\x97\xe0\xb8\xb5\xe0\xb9\x88 'd MMMM G yyyy\0"
"dddd\xe1\x8d\xa1 dd MMMM \xe1\x88\x98\xe1\x8b\x93\xe1\x88\x8d\xe1\x89\xb2 yyyy G\0"
"dddd\xe1\x8d\xa3 dd MMMM \xe1\x88\x98\xe1\x8b\x93\xe1\x88\x8d\xe1\x89\xb2 yyyy G\0"
"dd MMMM yyyy dddd\0"
"dddd, d MMMM yyyy '\xd1\x80.'\0"
"dddd, 'ng\xc3\xa0y' dd MMMM 'n\xc4\x83m' yyyy\0"
"dd MMMM, yyyy\0"
"dddd\xe1\x8d\xa1 dd MMMM \xe1\x8c\x8d\xe1\x88\xad\xe1\x8c\x8b yyyy G\0"
"dddd\xe1\x8d\xa5 dd MMMM \xe1\x88\x98\xe1\x8b\x93\xe1\x88\x8d\xe1\x89\xb5 yyyy G\0"
"dddd\xe1\x8d\xa1 dd MMMM \xe1\x8b\xae\xe1\x88\x9d yyyy G\0"
"d MMMM yyyy dddd\0"
"d/M/yy\0"
;

static const char time_format_data[] =
"HH:mm:ss\0"
"HH:mm:ss t\0"
"h:mm AP\0"
"h:mm:ss AP\0"
"HH:mm\0"
"h.mm.AP\0"
"h.mm.ss.AP t\0"
"hh:mm:ss AP\0"
"t h:mm:ss AP\0"
"h.mm. AP\0"
"h.mm.ss AP t\0"
"h:mm:ss AP t\0"
"\xe0\xbd\x86\xe0\xbd\xb4\xe0\xbc\x8b\xe0\xbd\x9a\xe0\xbd\xbc\xe0\xbd\x91\xe0\xbc\x8b"
" h \xe0\xbd\xa6\xe0\xbe\x90\xe0\xbd\xa2\xe0\xbc\x8b\xe0\xbd\x98\xe0\xbc\x8b mm AP"
"\0"
"\xe0\xbd\x86\xe0\xbd\xb4\xe0\xbc\x8b\xe0\xbd\x9a\xe0\xbd\xbc\xe0\xbd\x91\xe0\xbc\x8b"
" h \xe0\xbd\xa6\xe0\xbe\x90\xe0\xbd\xa2\xe0\xbc\x8b\xe0\xbd\x98\xe0\xbc\x8b mm \xe0"
"\xbd\xa6\xe0\xbe\x90\xe0\xbd\xa2\xe0\xbc\x8b\xe0\xbd\x86\xe0\xbd\xb1\xe0\xbc\x8b "
"ss AP tttt\0"
"HH.mm\0"
"HH.mm.ss t\0"
"H:mm\0"
"H' \xe1\x9e\x98\xe1\x9f\x89\xe1\x9f\x84\xe1\x9e\x84 'm' \xe1\x9e\x93\xe1\x9e\xb6\xe1"
"\x9e\x91\xe1\x9e\xb8 'ss' \xe1\x9e\x9c\xe1\x9e\xb7\xe1\x9e\x93\xe1\x9e\xb6\xe1\x9e"
"\x91\xe1\x9e\xb8\xe2\x80\x8b' t\0"
"H:mm:ss t\0"
"APh:mm\0"
"APhh'\xe6\x97\xb6'mm'\xe5\x88\x86'ss'\xe7\xa7\x92' t\0"
"AP hh:mm\0"
"AP hh:mm:ss\0"
"HH:mm:ss \0"
"h:mm:ss AP \0"
"HH' h 'mm' min 'ss' s 't\0"
"H.mm\0"
"H.mm.ss \0"
"HH' h 'mm t\0"
"H' h 'mm' min 'ss' s 't\0"
"HH.mm:ss' h' t\0"
"\xe1\x83\xa1\xe1\x83\x97:\xe1\x83\xac\xe1\x83\x97\0"
"\xe1\x83\xa1\xe1\x83\x97:\xe1\x83\xac\xe1\x83\x97:\xe1\x83\xac\xe1\x83\x9b\0"
"H:mm' Uhr 't\0"
"HH:mm' Uhr 't\0"
"HH 'h' mm 'min' ss 's' t\0"
"hh:mm AP\0"
"hh:mm:ss AP t\0"
"H:mm:ss\0"
"H'\xe6\x99\x82'mm'\xe5\x88\x86'ss'\xe7\xa7\x92't\0"
"AP h:mm\0"
"AP hh'\xec\x8b\x9c' mm'\xeb\xb6\x84' ss'\xec\xb4\x88' t\0"
"H'\xe0\xbb\x82\xe0\xba\xa1\xe0\xba\x87 'm'\xe0\xba\x99\xe0\xba\xb2\xe0\xba\x97\xe0"
"\xba\xb5 'ss' \xe0\xba\xa7\xe0\xba\xb4\xe0\xba\x99\xe0\xba\xb2\xe0\xba\x97\xe0\xba"
"\xb5\0"
"h:mm\0"
"h:mm:ss APAP\0"
"'kl. 'HH.mm.ss t\0"
"H:mm:ss (t)\0"
"H:mm:ss ()\0"
"HH'H'mm'm'ss's' t\0"
"HH'h'mm'min'ss's' t\0"
"HH '\xd1\x87\xd0\xb0\xd1\x81\xd0\xbe\xd0\xb2\xd0\xb0', mm '\xd0\xbc\xd0\xb8\xd0\xbd"
"\xd1\x83\xd1\x82\xd0\xb0', ss' \xd1\x81\xd0\xb5\xd0\xba\xd1\x83\xd0\xbd\xd0\xb4\xd0"
"\xb8'\0"
"HH '\xc4\x8d\x61sova', mm 'minuta', ss 'sekundi'\0"
"HH'H'mm''ss\" t\0"
"HH'h'''mm t\0"
"H' \xe0\xb8\x99\xe0\xb8\xb2\xe0\xb8\xac\xe0\xb8\xb4\xe0\xb8\x81\xe0\xb8\xb2 'm' \xe0"
"\xb8\x99\xe0\xb8\xb2\xe0\xb8\x97\xe0\xb8\xb5 'ss' \xe0\xb8\xa7\xe0\xb8\xb4\xe0\xb8"
"\x99\xe0\xb8\xb2\xe0\xb8\x97\xe0\xb8\xb5'\0"
;

static const char months_data[] =
"Jan;Feb;Mar;Apr;May;Jun;Jul;Aug;Sep;Oct;Nov;Dec;\0"
"January;February;March;April;May;June;July;August;September;October;November;Dece"
"mber;\0"
"Ama;Gur;Bit;Elb;Cam;Wax;Ado;Hag;Ful;Onk;Sad;Mud;\0"
"Amajjii;Guraandhala;Bitooteessa;Elba;Caamsa;Waxabajjii;Adooleessa;Hagayya;Fuulban"
"a;Onkololeessa;Sadaasa;Muddee;\0"
"Qun;Nah;Cig;Agd;Cax;Qas;Qad;Leq;Way;Dit;Xim;Kax;\0"
"Qunxa Garablu;Naharsi Kudo;Ciggilta Kudo;Agda Baxisso;Caxah Alsa;Qasa Dirri;Qado "
"Dirri;Leqeeni;Waysu;Diteli;Ximoli;Kaxxa Garablu;\0"
"Qunxa Garablu;Kudo;Ciggilta Kudo;Agda Baxis;Caxah Alsa;Qasa Dirri;Qado Dirri;Liiq"
"en;Waysu;Diteli;Ximoli;Kaxxa Garablu;\0"
"Jan;Feb;Mar;Apr;Mei;Jun;Jul;Aug;Sep;Okt;Nov;Des;\0"
"Januarie;Februarie;Maart;April;Mei;Junie;Julie;Augustus;September;Oktober;Novembe"
"r;Desember;\0"
"Jan;Shk;Mar;Pri;Maj;Qer;Kor;Gsh;Sht;Tet;N\xc3\xabn;Dhj;\0"
"janar;shkurt;mars;prill;maj;qershor;korrik;gusht;shtator;tetor;n\xc3\xabntor;dhje"
"tor;\0"
"\xe1\x8c\x83\xe1\x8a\x95\xe1\x8b\xa9;\xe1\x8d\x8c\xe1\x89\xa5\xe1\x88\xa9;\xe1\x88"
"\x9b\xe1\x88\xad\xe1\x89\xbd;\xe1\x8a\xa4\xe1\x8d\x95\xe1\x88\xa8;\xe1\x88\x9c\xe1"
"\x8b\xad;\xe1\x8c\x81\xe1\x8a\x95;\xe1\x8c\x81\xe1\x88\x8b\xe1\x8b\xad;\xe1\x8a\xa6"
"\xe1\x8c\x88\xe1\x88\xb5;\xe1\x88\xb4\xe1\x8d\x95\xe1\x89\xb4;\xe1\x8a\xa6\xe1\x8a"
"\xad\xe1\x89\xb0;\xe1\x8a\x96\xe1\x89\xac\xe1\x88\x9d;\xe1\x8b\xb2\xe1\x88\xb4\xe1"
"\x88\x9d;\0"
"\xe1\x8c\x83\xe1\x8a\x95\xe1\x8b\xa9\xe1\x8b\x88\xe1\x88\xaa;\xe1\x8d\x8c\xe1\x89"
"\xa5\xe1\x88\xa9\xe1\x8b\x88\xe1\x88\xaa;\xe1\x88\x9b\xe1\x88\xad\xe1\x89\xbd;\xe1"
"\x8a\xa4\xe1\x8d\x95\xe1\x88\xa8\xe1\x88\x8d;\xe1\x88\x9c\xe1\x8b\xad;\xe1\x8c\x81"
"\xe1\x8a\x95;\xe1\x8c\x81\xe1\x88\x8b\xe1\x8b\xad;\xe1\x8a\xa6\xe1\x8c\x88\xe1\x88"
"\xb5\xe1\x89\xb5;\xe1\x88\xb4\xe1\x8d\x95\xe1\x89\xb4\xe1\x88\x9d\xe1\x89\xa0\xe1"
"\x88\xad;\xe1\x8a\xa6\xe1\x8a\xad\xe1\x89\xb0\xe1\x8b\x8d\xe1\x89\xa0\xe1\x88\xad"
";\xe1\x8a\x96\xe1\x89\xac\xe1\x88\x9d\xe1\x89\xa0\xe1\x88\xad;\xe1\x8b\xb2\xe1\x88"
"\xb4\xe1\x88\x9d\xe1\x89\xa0\xe1\x88\xad;\0"
"\xd9\x8a\xd9\x86\xd8\xa7\xd9\x8a\xd8\xb1;\xd9\x81\xd8\xa8\xd8\xb1\xd8\xa7\xd9\x8a"
"\xd8\xb1;\xd9\x85\xd8\xa7\xd8\xb1\xd8\xb3;\xd8\xa3\xd8\xa8\xd8\xb1\xd9\x8a\xd9\x84"
";\xd9\x85\xd8\xa7\xd9\x8a\xd9\x88;\xd9\x8a\xd9\x88\xd9\x86\xd9\x8a\xd9\x88;\xd9\x8a"
"\xd9\x88\xd9\x84\xd9\x8a\xd9\x88;\xd8\xa3\xd8\xba\xd8\xb3\xd8\xb7\xd8\xb3;\xd8\xb3"
"\xd8\xa8\xd8\xaa\xd9\x85\xd8\xa8\xd8\xb1;\xd8\xa3\xd9\x83\xd8\xaa\xd9\x88\xd8\xa8"
"\xd8\xb1;\xd9\x86\xd9\x88\xd9\x81\xd9\x85\xd8\xa8\xd8\xb1;\xd8\xaf\xd9\x8a\xd8\xb3"
"\xd9\x85\xd8\xa8\xd8\xb1;\0"
"\xd9\x83\xd8\xa7\xd9\x86\xd9\x88\xd9\x86 \xd8\xa7\xd9\x84\xd8\xab\xd8\xa7\xd9\x86"
"\xd9\x8a;\xd8\xb4\xd8\xa8\xd8\xa7\xd8\xb7;\xd8\xa2\xd8\xb0\xd8\xa7\xd8\xb1;\xd9\x86"
"\xd9\x8a\xd8\xb3\xd8\xa7\xd9\x86;\xd8\xa3\xd9\x8a\xd8\xa7\xd8\xb1;\xd8\xad\xd8\xb2"
"\xd9\x8a\xd8\xb1\xd8\xa7\xd9\x86;\xd8\xaa\xd9\x85\xd9\x88\xd8\xb2;\xd8\xa2\xd8\xa8"
";\xd8\xa3\xd9\x8a\xd9\x84\xd9\x88\xd9\x84;\xd8\xaa\xd8\xb4\xd8\xb1\xd9\x8a\xd9\x86"
" \xd8\xa7\xd9\x84\xd8\xa3\xd9\x88\xd9\x84;\xd8\xaa\xd8\xb4\xd8\xb1\xd9\x8a\xd9\x86"
" \xd8\xa7\xd9\x84\xd8\xab\xd8\xa7\xd9\x86\xd9\x8a;\xd9\x83\xd8\xa7\xd9\x86\xd9\x88"
"\xd9\x86 \xd8\xa7\xd9\x84\xd8\xa3\xd9\x88\xd9\x84;\0"
"\xd9\x83\xd8\xa7\xd9\x86\xd9\x88\xd9\x86 \xd8\xa7\xd9\x84\xd8\xab\xd8\xa7\xd9\x86"
"\xd9\x8a;\xd8\xb4\xd8\xa8\xd8\xa7\xd8\xb7;\xd8\xa2\xd8\xb0\xd8\xa7\xd8\xb1;\xd9\x86"
"\xd9\x8a\xd8\xb3\xd8\xa7\xd9\x86;\xd9\x86\xd9\x88\xd8\xa7\xd8\xb1;\xd8\xad\xd8\xb2"
"\xd9\x8a\xd8\xb1\xd8\xa7\xd9\x86;\xd8\xaa\xd9\x85\xd9\x88\xd8\xb2;\xd8\xa2\xd8\xa8"
";\xd8\xa3\xd9\x8a\xd9\x84\xd9\x88\xd9\x84;\xd8\xaa\xd8\xb4\xd8\xb1\xd9\x8a\xd9\x86"
" \xd8\xa7\xd9\x84\xd8\xa3\xd9\x88\xd9\x84;\xd8\xaa\xd8\xb4\xd8\xb1\xd9\x8a\xd9\x86"
" \xd8\xa7\xd9\x84\xd8\xab\xd8\xa7\xd9\x86\xd9\x8a;\xd9\x83\xd8\xa7\xd9\x86\xd9\x88"
"\xd9\x86 \xd8\xa7\xd9\x84\xd8\xa3\xd9\x88\xd9\x84;\0"
"\xd5\x85\xd5\xb6\xd6\x80;\xd5\x93\xd5\xbf\xd6\x80;\xd5\x84\xd6\x80\xd5\xbf;\xd4\xb1"
"\xd5\xba\xd6\x80;\xd5\x84\xd5\xb5\xd5\xbd;\xd5\x85\xd5\xb6\xd5\xbd;\xd5\x85\xd5\xac"
"\xd5\xbd;\xd5\x95\xd5\xa3\xd5\xbd;\xd5\x8d\xd5\xa5\xd5\xba;\xd5\x80\xd5\xb8\xd5\xaf"
";\xd5\x86\xd5\xb8\xd5\xb5;\xd4\xb4\xd5\xa5\xd5\xaf;\0"
"\xd5\x85\xd5\xb8\xd6\x82\xd5\xb6\xd5\xb8\xd6\x82\xd5\xa1\xd6\x80;\xd5\x93\xd5\xa5"
"\xd5\xbf\xd6\x80\xd5\xb8\xd6\x82\xd5\xa1\xd6\x80;\xd5\x84\xd5\xa1\xd6\x80\xd5\xbf"
";\xd4\xb1\xd5\xba\xd6\x80\xd5\xab\xd5\xac;\xd5\x84\xd5\xa1\xd5\xb5\xd5\xab\xd5\xbd"
";\xd5\x85\xd5\xb8\xd6\x82\xd5\xb6\xd5\xab\xd5\xbd;\xd5\x85\xd5\xb8\xd6\x82\xd5\xac"
"\xd5\xab\xd5\xbd;\xd5\x95\xd5\xa3\xd5\xb8\xd5\xbd\xd5\xbf\xd5\xb8\xd5\xbd;\xd5\x8d"
"\xd5\xa5\xd5\xba\xd5\xbf\xd5\xa5\xd5\xb4\xd5\xa2\xd5\xa5\xd6\x80;\xd5\x80\xd5\xb8"
"\xd5\xaf\xd5\xbf\xd5\xa5\xd5\xb4\xd5\xa2\xd5\xa5\xd6\x80;\xd5\x86\xd5\xb8\xd5\xb5"
"\xd5\xa5\xd5\xb4\xd5\xa2\xd5\xa5\xd6\x80;\xd4\xb4\xd5\xa5\xd5\xaf\xd5\xbf\xd5\xa5"
"\xd5\xb4\xd5\xa2\xd5\xa5\xd6\x80;\0"
"\xe0\xa6\x9c\xe0\xa6\xbe\xe0\xa6\xa8\xe0\xa7\x81;\xe0\xa6\xab\xe0\xa7\x87\xe0\xa6"
"\xac\xe0\xa7\x8d\xe0\xa7\xb0\xe0\xa7\x81;\xe0\xa6\xae\xe0\xa6\xbe\xe0\xa7\xb0\xe0"
"\xa7\x8d\xe0\xa6\x9a;\xe0\xa6\x8f\xe0\xa6\xaa\xe0\xa7\x8d\xe0\xa7\xb0\xe0\xa6\xbf"
"\xe0\xa6\xb2;\xe0\xa6\xae\xe0\xa7\x87;\xe0\xa6\x9c\xe0\xa7\x81\xe0\xa6\xa8;\xe0\xa6"
"\x9c\xe0\xa7\x81\xe0\xa6\xb2\xe0\xa6\xbe\xe0\xa6\x87;\xe0\xa6\x86\xe0\xa6\x97;\xe0"
"\xa6\xb8\xe0\xa7\x87\xe0\xa6\xaa\xe0\xa7\x8d\xe0\xa6\x9f;\xe0\xa6\x85\xe0\xa6\x95"
"\xe0\xa7\x8d\xe0\xa6\x9f\xe0\xa7\x8b;\xe0\xa6\xa8\xe0\xa6\xad\xe0\xa7\x87;\xe0\xa6"
"\xa1\xe0\xa6\xbf\xe0\xa6\xb8\xe0\xa7\x87;\0"
"\xe0\xa6\x9c\xe0\xa6\xbe\xe0\xa6\xa8\xe0\xa7\x81\xe0\xa6\xaf\xe0\xa6\xbc\xe0\xa6\xbe"
"\xe0\xa7\xb0\xe0\xa7\x80;\xe0\xa6\xab\xe0\xa7\x87\xe0\xa6\xac\xe0\xa7\x8d\xe0\xa7"
"\xb0\xe0\xa7\x81\xe0\xa6\xaf\xe0\xa6\xbc\xe0\xa6\xbe\xe0\xa7\xb0\xe0\xa7\x80;\xe0"
"\xa6\xae\xe0\xa6\xbe\xe0\xa7\xb0\xe0\xa7\x8d\xe0\xa6\x9a;\xe0\xa6\x8f\xe0\xa6\xaa"
"\xe0\xa7\x8d\xe0\xa7\xb0\xe0\xa6\xbf\xe0\xa6\xb2;\xe0\xa6\xae\xe0\xa7\x87;\xe0\xa6"
"\x9c\xe0\xa7\x81\xe0\xa6\xa8;\xe0\xa6\x9c\xe0\xa7\x81\xe0\xa6\xb2\xe0\xa6\xbe\xe0"
"\xa6\x87;\xe0\xa6\x86\xe0\xa6\x97\xe0\xa6\xb7\xe0\xa7\x8d\xe0\xa6\x9f;\xe0\xa6\xb8"
"\xe0\xa7\x87\xe0\xa6\xaa\xe0\xa7\x8d\xe0\xa6\x9f\xe0\xa7\x87\xe0\xa6\xae\xe0\xa7\x8d"
"\xe0\xa6\xac\xe0\xa7\xb0;\xe0\xa6\x85\xe0\xa6\x95\xe0\xa7\x8d\xe0\xa6\x9f\xe0\xa7"
"\x8b\xe0\xa6\xac\xe0\xa7\xb0;\xe0\xa6\xa8\xe0\xa6\xad\xe0\xa7\x87\xe0\xa6\xae\xe0"
"\xa7\x8d\xe0\xa6\xac\xe0\xa7\xb0;\xe0\xa6\xa1\xe0\xa6\xbf\xe0\xa6\xb8\xe0\xa7\x87"
"\xe0\xa6\xae\xe0\xa7\x8d\xe0\xa6\xac\xe0\xa7\xb0;\0"
"yan;fev;mar;apr;may;iyn;iyl;avq;sen;okt;noy;dek;\0"
"Yanvar;Fevral;Mart;Aprel;May;\xc4\xb0yun;\xc4\xb0yul;Avqust;Sentyabr;Oktyabr;Noya"
"br;Dekabr;\0"
"urt;ots;mar;api;mai;eka;uzt;abu;ira;urr;aza;abe;\0"
"urtarrila;otsaila;martxoa;apirila;maiatza;ekaina;uztaila;abuztua;iraila;urria;aza"
"roa;abendua;\0"
"\xe0\xa6\x9c\xe0\xa6\xbe\xe0\xa6\xa8\xe0\xa7\x81\xe0\xa6\xaf\xe0\xa6\xbc\xe0\xa6\xbe"
"\xe0\xa6\xb0\xe0\xa7\x80;\xe0\xa6\xab\xe0\xa7\x87\xe0\xa6\xac\xe0\xa7\x8d\xe0\xa6"
"\xb0\xe0\xa7\x81\xe0\xa6\xaf\xe0\xa6\xbc\xe0\xa6\xbe\xe0\xa6\xb0\xe0\xa7\x80;\xe0"
"\xa6\xae\xe0\xa6\xbe\xe0\xa6\xb0\xe0\xa7\x8d\xe0\xa6\x9a;\xe0\xa6\x8f\xe0\xa6\xaa"
"\xe0\xa7\x8d\xe0\xa6\xb0\xe0\xa6\xbf\xe0\xa6\xb2;\xe0\xa6\xae\xe0\xa7\x87;\xe0\xa6"
"\x9c\xe0\xa7\x81\xe0\xa6\xa8;\xe0\xa6\x9c\xe0\xa7\x81\xe0\xa6\xb2\xe0\xa6\xbe\xe0"
"\xa6\x87;\xe0\xa6\x86\xe0\xa6\x97\xe0\xa6\xb8\xe0\xa7\x8d\xe0\xa6\x9f;\xe0\xa6\xb8"
"\xe0\xa7\x87\xe0\xa6\xaa\xe0\xa7\x8d\xe0\xa6\x9f\xe0\xa7\x87\xe0\xa6\xae\xe0\xa7\x8d"
"\xe0\xa6\xac\xe0\xa6\xb0;\xe0\xa6\x85\xe0\xa6\x95\xe0\xa7\x8d\xe0\xa6\x9f\xe0\xa7"
"\x8b\xe0\xa6\xac\xe0\xa6\xb0;\xe0\xa6\xa8\xe0\xa6\xad\xe0\xa7\x87\xe0\xa6\xae\xe0"
"\xa7\x8d\xe0\xa6\xac\xe0\xa6\xb0;\xe0\xa6\xa1\xe0\xa6\xbf\xe0\xa6\xb8\xe0\xa7\x87"
"\xe0\xa6\xae\xe0\xa7\x8d\xe0\xa6\xac\xe0\xa6\xb0;\0"
"\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa1;\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc"
"\x8b \xe0\xbc\xa2;\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa3;\xe0\xbd\x9f\xe0"
"\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa4;\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa5"
";\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa6;\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc"
"\x8b \xe0\xbc\xa7;\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa8;\xe0\xbd\x9f\xe0"
"\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa9;\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa1"
"\xe0\xbc\xa0;\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa1\xe0\xbc\xa1;\xe0\xbd"
"\x9f\xe0\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa1\xe0\xbc\xa2;\0"
"\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x9f\xe0\xbe\xb3"
"\xe0\xbd\x9d\xe0\xbc\x8b\xe0\xbd\x91\xe0\xbd\x84\xe0\xbd\x94\xe0\xbc\x8b;\xe0\xbd"
"\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbd"
"\x9d\xe0\xbc\x8b\xe0\xbd\x82\xe0\xbd\x89\xe0\xbd\xb2\xe0\xbd\xa6\xe0\xbc\x8b\xe0\xbd"
"\x94\xe0\xbc\x8b;\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0"
"\xbd\x9f\xe0\xbe\xb3\xe0\xbd\x9d\xe0\xbc\x8b\xe0\xbd\x82\xe0\xbd\xa6\xe0\xbd\xb4\xe0"
"\xbd\x98\xe0\xbc\x8b\xe0\xbd\x94\xe0\xbc\x8b;\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1"
"\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbd\x9d\xe0\xbc\x8b\xe0\xbd\x96"
"\xe0\xbd\x9e\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x94\xe0\xbc\x8b;\xe0\xbd\xa6\xe0\xbe"
"\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbd\x9d\xe0\xbc"
"\x8b\xe0\xbd\xa3\xe0\xbe\x94\xe0\xbc\x8b\xe0\xbd\x94\xe0\xbc\x8b;\xe0\xbd\xa6\xe0"
"\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbd\x9d\xe0"
"\xbc\x8b\xe0\xbd\x91\xe0\xbe\xb2\xe0\xbd\xb4\xe0\xbd\x82\xe0\xbc\x8b\xe0\xbd\x94\xe0"
"\xbc\x8b;\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x9f"
"\xe0\xbe\xb3\xe0\xbd\x9d\xe0\xbc\x8b\xe0\xbd\x96\xe0\xbd\x91\xe0\xbd\xb4\xe0\xbd\x93"
"\xe0\xbc\x8b\xe0\xbd\x94\xe0\xbc\x8b;\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd"
"\xb2\xe0\xbc\x8b\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbd\x9d\xe0\xbc\x8b\xe0\xbd\x96\xe0\xbd"
"\xa2\xe0\xbe\x92\xe0\xbe\xb1\xe0\xbd\x91\xe0\xbc\x8b\xe0\xbd\x94\xe0\xbc\x8b;\xe0"
"\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x9f\xe0\xbe\xb3\xe0"
"\xbd\x9d\xe0\xbc\x8b\xe0\xbd\x91\xe0\xbd\x82\xe0\xbd\xb4\xe0\xbc\x8b\xe0\xbd\x94\xe0"
"\xbc\x8b;\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x9f"
"\xe0\xbe\xb3\xe0\xbd\x9d\xe0\xbc\x8b\xe0\xbd\x96\xe0\xbd\x85\xe0\xbd\xb4\xe0\xbc\x8b"
"\xe0\xbd\x94\xe0\xbc\x8b;\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc"
"\x8b\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbd\x9d\xe0\xbc\x8b\xe0\xbd\x96\xe0\xbd\x85\xe0\xbd"
"\xb4\xe0\xbc\x8b\xe0\xbd\x82\xe0\xbd\x85\xe0\xbd\xb2\xe0\xbd\x82\xe0\xbc\x8b\xe0\xbd"
"\x94\xe0\xbc\x8b;\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0"
"\xbd\x9f\xe0\xbe\xb3\xe0\xbd\x9d\xe0\xbc\x8b\xe0\xbd\x96\xe0\xbd\x85\xe0\xbd\xb4\xe0"
"\xbc\x8b\xe0\xbd\x82\xe0\xbd\x89\xe0\xbd\xb2\xe0\xbd\xa6\xe0\xbc\x8b\xe0\xbd\x94\xe0"
"\xbc\x8b;\0"
"\xd1\x8f\xd0\xbd.;\xd1\x84\xd0\xb5\xd0\xb2\xd1\x80.;\xd0\xbc\xd0\xb0\xd1\x80\xd1\x82"
";\xd0\xb0\xd0\xbf\xd1\x80.;\xd0\xbc\xd0\xb0\xd0\xb9;\xd1\x8e\xd0\xbd\xd0\xb8;\xd1"
"\x8e\xd0\xbb\xd0\xb8;\xd0\xb0\xd0\xb2\xd0\xb3.;\xd1\x81\xd0\xb5\xd0\xbf\xd1\x82.;"
"\xd0\xbe\xd0\xba\xd1\x82.;\xd0\xbd\xd0\xbe\xd0\xb5\xd0\xbc.;\xd0\xb4\xd0\xb5\xd0\xba"
".;\0"
"\xd1\x8f\xd0\xbd\xd1\x83\xd0\xb0\xd1\x80\xd0\xb8;\xd1\x84\xd0\xb5\xd0\xb2\xd1\x80"
"\xd1\x83\xd0\xb0\xd1\x80\xd0\xb8;\xd0\xbc\xd0\xb0\xd1\x80\xd1\x82;\xd0\xb0\xd0\xbf"
"\xd1\x80\xd0\xb8\xd0\xbb;\xd0\xbc\xd0\xb0\xd0\xb9;\xd1\x8e\xd0\xbd\xd0\xb8;\xd1\x8e"
"\xd0\xbb\xd0\xb8;\xd0\xb0\xd0\xb2\xd0\xb3\xd1\x83\xd1\x81\xd1\x82;\xd1\x81\xd0\xb5"
"\xd0\xbf\xd1\x82\xd0\xb5\xd0\xbc\xd0\xb2\xd1\x80\xd0\xb8;\xd0\xbe\xd0\xba\xd1\x82"
"\xd0\xbe\xd0\xbc\xd0\xb2\xd1\x80\xd0\xb8;\xd0\xbd\xd0\xbe\xd0\xb5\xd0\xbc\xd0\xb2"
"\xd1\x80\xd0\xb8;\xd0\xb4\xd0\xb5\xd0\xba\xd0\xb5\xd0\xbc\xd0\xb2\xd1\x80\xd0\xb8"
";\0"
"\xd1\x81\xd1\x82\xd1\x83;\xd0\xbb\xd1\x8e\xd1\x82;\xd1\x81\xd0\xb0\xd0\xba;\xd0\xba"
"\xd1\x80\xd0\xb0;\xd0\xbc\xd0\xb0\xd0\xb9;\xd1\x87\xd1\x8d\xd1\x80;\xd0\xbb\xd1\x96"
"\xd0\xbf;\xd0\xb6\xd0\xbd\xd1\x96;\xd0\xb2\xd0\xb5\xd1\x80;\xd0\xba\xd0\xb0\xd1\x81"
";\xd0\xbb\xd1\x96\xd1\x81;\xd1\x81\xd0\xbd\xd0\xb5;\0"
"\xd1\x81\xd1\x82\xd1\x83\xd0\xb4\xd0\xb7\xd0\xb5\xd0\xbd\xd1\x8c;\xd0\xbb\xd1\x8e"
"\xd1\x82\xd1\x8b;\xd1\x81\xd0\xb0\xd0\xba\xd0\xb0\xd0\xb2\xd1\x96\xd0\xba;\xd0\xba"
"\xd1\x80\xd0\xb0\xd1\x81\xd0\xb0\xd0\xb2\xd1\x96\xd0\xba;\xd0\xbc\xd0\xb0\xd0\xb9"
";\xd1\x87\xd1\x8d\xd1\x80\xd0\xb2\xd0\xb5\xd0\xbd\xd1\x8c;\xd0\xbb\xd1\x96\xd0\xbf"
"\xd0\xb5\xd0\xbd\xd1\x8c;\xd0\xb6\xd0\xbd\xd1\x96\xd0\xb2\xd0\xb5\xd0\xbd\xd1\x8c"
";\xd0\xb2\xd0\xb5\xd1\x80\xd0\xb0\xd1\x81\xd0\xb5\xd0\xbd\xd1\x8c;\xd0\xba\xd0\xb0"
"\xd1\x81\xd1\x82\xd1\x80\xd1\x8b\xd1\x87\xd0\xbd\xd1\x96\xd0\xba;\xd0\xbb\xd1\x96"
"\xd1\x81\xd1\x82\xd0\xb0\xd0\xbf\xd0\xb0\xd0\xb4;\xd1\x81\xd0\xbd\xd0\xb5\xd0\xb6"
"\xd0\xb0\xd0\xbd\xd1\x8c;\0"
"\xe1\x9f\xa1;\xe1\x9f\xa2;\xe1\x9f\xa3;\xe1\x9f\xa4;\xe1\x9f\xa5;\xe1\x9f\xa6;\xe1"
"\x9f\xa7;\xe1\x9f\xa8;\xe1\x9f\xa9;\xe1\x9f\xa1\xe1\x9f\xa0;\xe1\x9f\xa1\xe1\x9f\xa1"
";\xe1\x9f\xa1\xe1\x9f\xa2;\0"
"\xe1\x9e\x98\xe1\x9e\x80\xe1\x9e\x9a\xe1\x9e\xb6;\xe1\x9e\x80\xe1\x9e\xbb\xe1\x9e"
"\x98\xe1\x9f\x92\xe1\x9e\x97\xe1\x9f\x88;\xe1\x9e\x98\xe1\x9e\xb7\xe1\x9e\x93\xe1"
"\x9e\xb6;\xe1\x9e\x98\xe1\x9f\x81\xe1\x9e\x9f\xe1\x9e\xb6;\xe1\x9e\xa7\xe1\x9e\x9f"
"\xe1\x9e\x97\xe1\x9e\xb6;\xe1\x9e\x98\xe1\x9e\xb7\xe1\x9e\x90\xe1\x9e\xbb\xe1\x9e"
"\x93\xe1\x9e\xb6;\xe1\x9e\x80\xe1\x9e\x80\xe1\x9f\x92\xe1\x9e\x80\xe1\x9e\x8a\xe1"
"\x9e\xb6;\xe1\x9e\x9f\xe1\x9e\xb8\xe1\x9e\xa0\xe1\x9e\xb6;\xe1\x9e\x80\xe1\x9e\x89"
"\xe1\x9f\x92\xe1\x9e\x89\xe1\x9e\xb6;\xe1\x9e\x8f\xe1\x9e\xbb\xe1\x9e\x9b\xe1\x9e"
"\xb6;\xe1\x9e\x9c\xe1\x9e\xb7\xe1\x9e\x85\xe1\x9f\x92\xe1\x9e\x86\xe1\x9e\xb7\xe1"
"\x9e\x80\xe1\x9e\xb6;\xe1\x9e\x92\xe1\x9f\x92\xe1\x9e\x93\xe1\x9e\xbc;\0"
"gen.;febr.;mar\xc3\xa7;abr.;maig;juny;jul.;ag.;set.;oct.;nov.;des.;\0"
"gener;febrer;mar\xc3\xa7;abril;maig;juny;juliol;agost;setembre;octubre;novembre;d"
"esembre;\0"
"\xe4\xb8\x80\xe6\x9c\x88;\xe4\xba\x8c\xe6\x9c\x88;\xe4\xb8\x89\xe6\x9c\x88;\xe5\x9b"
"\x9b\xe6\x9c\x88;\xe4\xba\x94\xe6\x9c\x88;\xe5\x85\xad\xe6\x9c\x88;\xe4\xb8\x83\xe6"
"\x9c\x88;\xe5\x85\xab\xe6\x9c\x88;\xe4\xb9\x9d\xe6\x9c\x88;\xe5\x8d\x81\xe6\x9c\x88"
";\xe5\x8d\x81\xe4\xb8\x80\xe6\x9c\x88;\xe5\x8d\x81\xe4\xba\x8c\xe6\x9c\x88;\0"
"1\xe6\x9c\x88;2\xe6\x9c\x88;3\xe6\x9c\x88;4\xe6\x9c\x88;5\xe6\x9c\x88;6\xe6\x9c\x88"
";7\xe6\x9c\x88;8\xe6\x9c\x88;9\xe6\x9c\x88;10\xe6\x9c\x88;11\xe6\x9c\x88;12\xe6\x9c"
"\x88;\0"
"sij;vel;o\xc5\xbeu;tra;svi;lip;srp;kol;ruj;lis;stu;pro;\0"
"sije\xc4\x8dnja;velja\xc4\x8d\x65;o\xc5\xbeujka;travnja;svibnja;lipnja;srpnja;kol"
"ovoza;rujna;listopada;studenoga;prosinca;\0"
"led;\xc3\xbano;b\xc5\x99\x65;dub;kv\xc4\x9b;\xc4\x8drn;\xc4\x8drc;srp;z\xc3\xa1\xc5"
"\x99;\xc5\x99\xc3\xadj;lis;pro;\0"
"ledna;\xc3\xbanora;b\xc5\x99\x65zna;dubna;kv\xc4\x9btna;\xc4\x8d\x65rvna;\xc4\x8d"
"\x65rvenec;srpna;z\xc3\xa1\xc5\x99\xc3\xad;\xc5\x99\xc3\xadjna;listopadu;prosince"
";\0"
"jan;feb;mar;apr;maj;jun;jul;aug;sep;okt;nov;dec;\0"
"januar;februar;marts;april;maj;juni;juli;august;september;oktober;november;decemb"
"er;\0"
"jan;feb;mrt;apr;mei;jun;jul;aug;sep;okt;nov;dec;\0"
"januari;februari;maart;april;mei;juni;juli;augustus;september;oktober;november;de"
"cember;\0"
"jaan;veebr;m\xc3\xa4rts;apr;mai;juuni;juuli;aug;sept;okt;nov;dets;\0"
"jaanuar;veebruar;m\xc3\xa4rts;aprill;mai;juuni;juuli;august;september;oktoober;no"
"vember;detsember;\0"
"jan;feb;mar;apr;mai;jun;jul;aug;sep;okt;nov;des;\0"
"januar;februar;mars;apr\xc3\xadl;mai;juni;juli;august;september;oktober;november;"
"desember;\0"
"tammi;helmi;maalis;huhti;touko;kes\xc3\xa4;hein\xc3\xa4;elo;syys;loka;marras;joul"
"u;\0"
"tammikuu;helmikuu;maaliskuu;huhtikuu;toukokuu;kes\xc3\xa4kuu;hein\xc3\xa4kuu;elok"
"uu;syyskuu;lokakuu;marraskuu;joulukuu;\0"
"janv.;f\xc3\xa9vr.;mars;avr.;mai;juin;juil.;ao\xc3\xbbt;sept.;oct.;nov.;d\xc3\xa9"
"\x63.;\0"
"janvier;f\xc3\xa9vrier;mars;avril;mai;juin;juillet;ao\xc3\xbbt;septembre;octobre;"
"novembre;d\xc3\xa9\x63\x65mbre;\0"
"Xan;Feb;Mar;Abr;Mai;Xu\xc3\xb1;Xul;Ago;Set;Out;Nov;Dec;\0"
"Xaneiro;Febreiro;Marzo;Abril;Maio;Xu\xc3\xb1o;Xullo;Agosto;Setembro;Outubro;Novem"
"bro;Decembro;\0"
"\xe1\x83\x98\xe1\x83\x90\xe1\x83\x9c;\xe1\x83\x97\xe1\x83\x94\xe1\x83\x91;\xe1\x83"
"\x9b\xe1\x83\x90\xe1\x83\xa0;\xe1\x83\x90\xe1\x83\x9e\xe1\x83\xa0;\xe1\x83\x9b\xe1"
"\x83\x90\xe1\x83\x98;\xe1\x83\x98\xe1\x83\x95\xe1\x83\x9c;\xe1\x83\x98\xe1\x83\x95"
"\xe1\x83\x9a;\xe1\x83\x90\xe1\x83\x92\xe1\x83\x95;\xe1\x83\xa1\xe1\x83\x94\xe1\x83"
"\xa5;\xe1\x83\x9d\xe1\x83\xa5\xe1\x83\xa2;\xe1\x83\x9c\xe1\x83\x9d\xe1\x83\x94;\xe1"
"\x83\x93\xe1\x83\x94\xe1\x83\x99;\0"
"\xe1\x83\x98\xe1\x83\x90\xe1\x83\x9c\xe1\x83\x95\xe1\x83\x90\xe1\x83\xa0\xe1\x83\x98"
";\xe1\x83\x97\xe1\x83\x94\xe1\x83\x91\xe1\x83\x94\xe1\x83\xa0\xe1\x83\x95\xe1\x83"
"\x90\xe1\x83\x9a\xe1\x83\x98;\xe1\x83\x9b\xe1\x83\x90\xe1\x83\xa0\xe1\x83\xa2\xe1"
"\x83\x98;\xe1\x83\x90\xe1\x83\x9e\xe1\x83\xa0\xe1\x83\x98\xe1\x83\x9a\xe1\x83\x98"
";\xe1\x83\x9b\xe1\x83\x90\xe1\x83\x98\xe1\x83\xa1\xe1\x83\x98;\xe1\x83\x98\xe1\x83"
"\x95\xe1\x83\x9c\xe1\x83\x98\xe1\x83\xa1\xe1\x83\x98;\xe1\x83\x98\xe1\x83\x95\xe1"
"\x83\x9a\xe1\x83\x98\xe1\x83\xa1\xe1\x83\x98;\xe1\x83\x90\xe1\x83\x92\xe1\x83\x95"
"\xe1\x83\x98\xe1\x83\xa1\xe1\x83\xa2\xe1\x83\x9d;\xe1\x83\xa1\xe1\x83\x94\xe1\x83"
"\xa5\xe1\x83\xa2\xe1\x83\x94\xe1\x83\x9b\xe1\x83\x91\xe1\x83\x94\xe1\x83\xa0\xe1\x83"
"\x98;\xe1\x83\x9d\xe1\x83\xa5\xe1\x83\xa2\xe1\x83\x9d\xe1\x83\x9b\xe1\x83\x91\xe1"
"\x83\x94\xe1\x83\xa0\xe1\x83\x98;\xe1\x83\x9c\xe1\x83\x9d\xe1\x83\x94\xe1\x83\x9b"
"\xe1\x83\x91\xe1\x83\x94\xe1\x83\xa0\xe1\x83\x98;\xe1\x83\x93\xe1\x83\x94\xe1\x83"
"\x99\xe1\x83\x94\xe1\x83\x9b\xe1\x83\x91\xe1\x83\x94\xe1\x83\xa0\xe1\x83\x98;\0"
"Jan;Feb;Mrz;Apr;Mai;Jun;Jul;Aug;Sep;Okt;Nov;Dez;\0"
"Januar;Februar;M\xc3\xa4rz;April;Mai;Juni;Juli;August;September;Oktober;November;"
"Dezember;\0"
"J\xc3\xa4n;Feb;M\xc3\xa4r;Apr;Mai;Jun;Jul;Aug;Sep;Okt;Nov;Dez;\0"
"J\xc3\xa4nner;Februar;M\xc3\xa4rz;April;Mai;Juni;Juli;August;September;Oktober;No"
"vember;Dezember;\0"
"Jan;Feb;M\xc3\xa4r;Apr;Mai;Jun;Jul;Aug;Sep;Okt;Nov;Dez;\0"
"\xce\x99\xce\xb1\xce\xbd;\xce\xa6\xce\xb5\xce\xb2;\xce\x9c\xce\xb1\xcf\x81;\xce\x91"
"\xcf\x80\xcf\x81;\xce\x9c\xce\xb1\xcf\x8a;\xce\x99\xce\xbf\xcf\x85\xce\xbd;\xce\x99"
"\xce\xbf\xcf\x85\xce\xbb;\xce\x91\xcf\x85\xce\xb3;\xce\xa3\xce\xb5\xcf\x80;\xce\x9f"
"\xce\xba\xcf\x84;\xce\x9d\xce\xbf\xce\xb5;\xce\x94\xce\xb5\xce\xba;\0"
"\xce\x99\xce\xb1\xce\xbd\xce\xbf\xcf\x85\xce\xb1\xcf\x81\xce\xaf\xce\xbf\xcf\x85;"
"\xce\xa6\xce\xb5\xce\xb2\xcf\x81\xce\xbf\xcf\x85\xce\xb1\xcf\x81\xce\xaf\xce\xbf\xcf"
"\x85;\xce\x9c\xce\xb1\xcf\x81\xcf\x84\xce\xaf\xce\xbf\xcf\x85;\xce\x91\xcf\x80\xcf"
"\x81\xce\xb9\xce\xbb\xce\xaf\xce\xbf\xcf\x85;\xce\x9c\xce\xb1\xce\x90\xce\xbf\xcf"
"\x85;\xce\x99\xce\xbf\xcf\x85\xce\xbd\xce\xaf\xce\xbf\xcf\x85;\xce\x99\xce\xbf\xcf"
"\x85\xce\xbb\xce\xaf\xce\xbf\xcf\x85;\xce\x91\xcf\x85\xce\xb3\xce\xbf\xcf\x8d\xcf"
"\x83\xcf\x84\xce\xbf\xcf\x85;\xce\xa3\xce\xb5\xcf\x80\xcf\x84\xce\xb5\xce\xbc\xce"
"\xb2\xcf\x81\xce\xaf\xce\xbf\xcf\x85;\xce\x9f\xce\xba\xcf\x84\xcf\x89\xce\xb2\xcf"
"\x81\xce\xaf\xce\xbf\xcf\x85;\xce\x9d\xce\xbf\xce\xb5\xce\xbc\xce\xb2\xcf\x81\xce"
"\xaf\xce\xbf\xcf\x85;\xce\x94\xce\xb5\xce\xba\xce\xb5\xce\xbc\xce\xb2\xcf\x81\xce"
"\xaf\xce\xbf\xcf\x85;\0"
"januari;februari;martsi;aprili;maji;juni;juli;augustusi;septemberi;oktoberi;novem"
"beri;decemberi;\0"
"\xe0\xaa\x9c\xe0\xaa\xbe\xe0\xaa\xa8\xe0\xab\x8d\xe0\xaa\xaf\xe0\xab\x81;\xe0\xaa"
"\xab\xe0\xab\x87\xe0\xaa\xac\xe0\xab\x8d\xe0\xaa\xb0\xe0\xab\x81;\xe0\xaa\xae\xe0"
"\xaa\xbe\xe0\xaa\xb0\xe0\xab\x8d\xe0\xaa\x9a;\xe0\xaa\x8f\xe0\xaa\xaa\xe0\xab\x8d"
"\xe0\xaa\xb0\xe0\xaa\xbf\xe0\xaa\xb2;\xe0\xaa\xae\xe0\xab\x87;\xe0\xaa\x9c\xe0\xab"
"\x82\xe0\xaa\xa8;\xe0\xaa\x9c\xe0\xab\x81\xe0\xaa\xb2\xe0\xaa\xbe\xe0\xaa\x88;\xe0"
"\xaa\x91\xe0\xaa\x97\xe0\xaa\xb8\xe0\xab\x8d\xe0\xaa\x9f;\xe0\xaa\xb8\xe0\xaa\xaa"
"\xe0\xab\x8d\xe0\xaa\x9f\xe0\xab\x87;\xe0\xaa\x91\xe0\xaa\x95\xe0\xab\x8d\xe0\xaa"
"\x9f\xe0\xab\x8b;\xe0\xaa\xa8\xe0\xaa\xb5\xe0\xab\x87;\xe0\xaa\xa1\xe0\xaa\xbf\xe0"
"\xaa\xb8\xe0\xab\x87;\0"
"\xe0\xaa\x9c\xe0\xaa\xbe\xe0\xaa\xa8\xe0\xab\x8d\xe0\xaa\xaf\xe0\xab\x81\xe0\xaa\x86"
"\xe0\xaa\xb0\xe0\xab\x80;\xe0\xaa\xab\xe0\xab\x87\xe0\xaa\xac\xe0\xab\x8d\xe0\xaa"
"\xb0\xe0\xab\x81\xe0\xaa\x86\xe0\xaa\xb0\xe0\xab\x80;\xe0\xaa\xae\xe0\xaa\xbe\xe0"
"\xaa\xb0\xe0\xab\x8d\xe0\xaa\x9a;\xe0\xaa\x8f\xe0\xaa\xaa\xe0\xab\x8d\xe0\xaa\xb0"
"\xe0\xaa\xbf\xe0\xaa\xb2;\xe0\xaa\xae\xe0\xab\x87;\xe0\xaa\x9c\xe0\xab\x82\xe0\xaa"
"\xa8;\xe0\xaa\x9c\xe0\xab\x81\xe0\xaa\xb2\xe0\xaa\xbe\xe0\xaa\x88;\xe0\xaa\x91\xe0"
"\xaa\x97\xe0\xaa\xb8\xe0\xab\x8d\xe0\xaa\x9f;\xe0\xaa\xb8\xe0\xaa\xaa\xe0\xab\x8d"
"\xe0\xaa\x9f\xe0\xab\x87\xe0\xaa\xae\xe0\xab\x8d\xe0\xaa\xac\xe0\xaa\xb0;\xe0\xaa"
"\x91\xe0\xaa\x95\xe0\xab\x8d\xe0\xaa\x9f\xe0\xab\x8d\xe0\xaa\xac\xe0\xaa\xb0;\xe0"
"\xaa\xa8\xe0\xaa\xb5\xe0\xab\x87\xe0\xaa\xae\xe0\xab\x8d\xe0\xaa\xac\xe0\xaa\xb0;"
"\xe0\xaa\xa1\xe0\xaa\xbf\xe0\xaa\xb8\xe0\xab\x87\xe0\xaa\xae\xe0\xab\x8d\xe0\xaa\xac"
"\xe0\xaa\xb0;\0"
"Jan;Fab;Mar;Afr;May;Yun;Yul;Agu;Sat;Okt;Nuw;Dis;\0"
"Janairu;Fabrairu;Maris;Afrilu;Mayu;Yuni;Yuli;Agusta;Satumba;Oktoba;Nuwamba;Disamb"
"a;\0"
"\xd7\x99\xd7\xa0\xd7\x95;\xd7\xa4\xd7\x91\xd7\xa8;\xd7\x9e\xd7\xa8\xd7\xa5;\xd7\x90"
"\xd7\xa4\xd7\xa8;\xd7\x9e\xd7\x90\xd7\x99;\xd7\x99\xd7\x95\xd7\xa0;\xd7\x99\xd7\x95"
"\xd7\x9c;\xd7\x90\xd7\x95\xd7\x92;\xd7\xa1\xd7\xa4\xd7\x98;\xd7\x90\xd7\x95\xd7\xa7"
";\xd7\xa0\xd7\x95\xd7\x91;\xd7\x93\xd7\xa6\xd7\x9e;\0"
"\xd7\x99\xd7\xa0\xd7\x95\xd7\x90\xd7\xa8;\xd7\xa4\xd7\x91\xd7\xa8\xd7\x95\xd7\x90"
"\xd7\xa8;\xd7\x9e\xd7\xa8\xd7\xa5;\xd7\x90\xd7\xa4\xd7\xa8\xd7\x99\xd7\x9c;\xd7\x9e"
"\xd7\x90\xd7\x99;\xd7\x99\xd7\x95\xd7\xa0\xd7\x99;\xd7\x99\xd7\x95\xd7\x9c\xd7\x99"
";\xd7\x90\xd7\x95\xd7\x92\xd7\x95\xd7\xa1\xd7\x98;\xd7\xa1\xd7\xa4\xd7\x98\xd7\x9e"
"\xd7\x91\xd7\xa8;\xd7\x90\xd7\x95\xd7\xa7\xd7\x98\xd7\x95\xd7\x91\xd7\xa8;\xd7\xa0"
"\xd7\x95\xd7\x91\xd7\x9e\xd7\x91\xd7\xa8;\xd7\x93\xd7\xa6\xd7\x9e\xd7\x91\xd7\xa8"
";\0"
"\xe0\xa4\x9c\xe0\xa4\xa8\xe0\xa4\xb5\xe0\xa4\xb0\xe0\xa5\x80;\xe0\xa4\xab\xe0\xa4"
"\xb0\xe0\xa4\xb5\xe0\xa4\xb0\xe0\xa5\x80;\xe0\xa4\xae\xe0\xa4\xbe\xe0\xa4\xb0\xe0"
"\xa5\x8d\xe0\xa4\x9a;\xe0\xa4\x85\xe0\xa4\xaa\xe0\xa5\x8d\xe0\xa4\xb0\xe0\xa5\x88"
"\xe0\xa4\xb2;\xe0\xa4\xae\xe0\xa4\x88;\xe0\xa4\x9c\xe0\xa5\x82\xe0\xa4\xa8;\xe0\xa4"
"\x9c\xe0\xa5\x81\xe0\xa4\xb2\xe0\xa4\xbe\xe0\xa4\x88;\xe0\xa4\x85\xe0\xa4\x97\xe0"
"\xa4\xb8\xe0\xa5\x8d\xe0\xa4\xa4;\xe0\xa4\xb8\xe0\xa4\xbf\xe0\xa4\xa4\xe0\xa4\xae"
"\xe0\xa5\x8d\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\x85\xe0\xa4\x95\xe0\xa5\x8d\xe0\xa4"
"\xa4\xe0\xa5\x82\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\xa8\xe0\xa4\xb5\xe0\xa4\xae\xe0"
"\xa5\x8d\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\xa6\xe0\xa4\xbf\xe0\xa4\xb8\xe0\xa4\xae"
"\xe0\xa5\x8d\xe0\xa4\xac\xe0\xa4\xb0;\0"
"jan.;febr.;m\xc3\xa1rc.;\xc3\xa1pr.;m\xc3\xa1j.;j\xc3\xban.;j\xc3\xbal.;aug.;szep"
"t.;okt.;nov.;dec.;\0"
"janu\xc3\xa1r;febru\xc3\xa1r;m\xc3\xa1rcius;\xc3\xa1prilis;m\xc3\xa1jus;j\xc3\xba"
"nius;j\xc3\xbalius;augusztus;szeptember;okt\xc3\xb3\x62\x65r;november;december;\0"
"jan;feb;mar;apr;ma\xc3\xad;j\xc3\xban;j\xc3\xbal;\xc3\xa1g\xc3\xba;sep;okt;n\xc3\xb3"
"v;des;\0"
"jan\xc3\xba\x61r;febr\xc3\xba\x61r;mars;apr\xc3\xadl;ma\xc3\xad;j\xc3\xban\xc3\xad"
";j\xc3\xbal\xc3\xad;\xc3\xa1g\xc3\xbast;september;okt\xc3\xb3\x62\x65r;n\xc3\xb3v"
"ember;desember;\0"
"Jan;Feb;Mar;Apr;Mei;Jun;Jul;Agu;Sep;Okt;Nov;Des;\0"
"Januari;Februari;Maret;April;Mei;Juni;Juli;Agustus;September;Oktober;November;Des"
"ember;\0"
"Ean;Feabh;M\xc3\xa1rta;Aib;Beal;Meith;I\xc3\xbail;L\xc3\xban;MF\xc3\xb3mh;DF\xc3\xb3"
"mh;Samh;Noll;\0"
"Ean\xc3\xa1ir;Feabhra;M\xc3\xa1rta;Aibre\xc3\xa1n;Bealtaine;Meitheamh;I\xc3\xbail"
";L\xc3\xbanasa;Me\xc3\xa1n F\xc3\xb3mhair;Deireadh F\xc3\xb3mhair;Samhain;Nollaig"
";\0"
"gen;feb;mar;apr;mag;giu;lug;ago;set;ott;nov;dic;\0"
"gennaio;febbraio;marzo;aprile;maggio;giugno;luglio;agosto;settembre;ottobre;novem"
"bre;dicembre;\0"
"1 \xe6\x9c\x88;2 \xe6\x9c\x88;3 \xe6\x9c\x88;4 \xe6\x9c\x88;5 \xe6\x9c\x88;6 \xe6"
"\x9c\x88;7 \xe6\x9c\x88;8 \xe6\x9c\x88;9 \xe6\x9c\x88;10 \xe6\x9c\x88;11 \xe6\x9c"
"\x88;12 \xe6\x9c\x88;\0"
"\xe0\xb2\x9c\xe0\xb2\xa8\xe0\xb2\xb5\xe0\xb2\xb0\xe0\xb3\x80;\xe0\xb2\xab\xe0\xb3"
"\x86\xe0\xb2\xac\xe0\xb3\x8d\xe0\xb2\xb0\xe0\xb2\xb5\xe0\xb2\xb0\xe0\xb3\x80;\xe0"
"\xb2\xae\xe0\xb2\xbe\xe0\xb2\xb0\xe0\xb3\x8d\xe0\xb2\x9a\xe0\xb3\x8d;\xe0\xb2\x8e"
"\xe0\xb2\xaa\xe0\xb3\x8d\xe0\xb2\xb0\xe0\xb2\xbf\xe0\xb2\xb2\xe0\xb3\x8d;\xe0\xb2"
"\xae\xe0\xb3\x86;\xe0\xb2\x9c\xe0\xb3\x82\xe0\xb2\xa8\xe0\xb3\x8d;\xe0\xb2\x9c\xe0"
"\xb3\x81\xe0\xb2\xb2\xe0\xb3\x88;\xe0\xb2\x86\xe0\xb2\x97\xe0\xb2\xb8\xe0\xb3\x8d"
"\xe0\xb2\x9f\xe0\xb3\x8d;\xe0\xb2\xb8\xe0\xb2\xaa\xe0\xb3\x8d\xe0\xb2\x9f\xe0\xb3"
"\x86\xe0\xb2\x82\xe0\xb2\xac\xe0\xb2\xb0\xe0\xb3\x8d;\xe0\xb2\x85\xe0\xb2\x95\xe0"
"\xb3\x8d\xe0\xb2\x9f\xe0\xb3\x8b\xe0\xb2\xac\xe0\xb2\xb0\xe0\xb3\x8d;\xe0\xb2\xa8"
"\xe0\xb2\xb5\xe0\xb3\x86\xe0\xb2\x82\xe0\xb2\xac\xe0\xb2\xb0\xe0\xb3\x8d;\xe0\xb2"
"\xa1\xe0\xb2\xbf\xe0\xb2\xb8\xe0\xb3\x86\xe0\xb2\x82\xe0\xb2\xac\xe0\xb2\xb0\xe0\xb3"
"\x8d;\0"
"\xd2\x9b\xd0\xb0\xd2\xa3.;\xd0\xb0\xd2\x9b\xd0\xbf.;\xd0\xbd\xd0\xb0\xd1\x83.;\xd1"
"\x81\xd3\x99\xd1\x83.;\xd0\xbc\xd0\xb0\xd0\xbc.;\xd0\xbc\xd0\xb0\xd1\x83.;\xd1\x88"
"\xd1\x96\xd0\xbb.;\xd1\x82\xd0\xb0\xd0\xbc.;\xd2\x9b\xd1\x8b\xd1\x80.;\xd2\x9b\xd0"
"\xb0\xd0\xb7.;\xd2\x9b\xd0\xb0\xd1\x80.;\xd0\xb6\xd0\xb5\xd0\xbb\xd1\x82.;\0"
"\xd2\x9b\xd0\xb0\xd2\xa3\xd1\x82\xd0\xb0\xd1\x80;\xd0\xb0\xd2\x9b\xd0\xbf\xd0\xb0"
"\xd0\xbd;\xd0\xbd\xd0\xb0\xd1\x83\xd1\x80\xd1\x8b\xd0\xb7;\xd1\x81\xd3\x99\xd1\x83"
"\xd1\x96\xd1\x80;\xd0\xbc\xd0\xb0\xd0\xbc\xd1\x8b\xd1\x80;\xd0\xbc\xd0\xb0\xd1\x83"
"\xd1\x81\xd1\x8b\xd0\xbc;\xd1\x88\xd1\x96\xd0\xbb\xd0\xb4\xd0\xb5;\xd1\x82\xd0\xb0"
"\xd0\xbc\xd1\x8b\xd0\xb7;\xd2\x9b\xd1\x8b\xd1\x80\xd0\xba\xd2\xaf\xd0\xb9\xd0\xb5"
"\xd0\xba;\xd2\x9b\xd0\xb0\xd0\xb7\xd0\xb0\xd0\xbd;\xd2\x9b\xd0\xb0\xd1\x80\xd0\xb0"
"\xd1\x88\xd0\xb0;\xd0\xb6\xd0\xb5\xd0\xbb\xd1\x82\xd0\xbe\xd2\x9b\xd1\x81\xd0\xb0"
"\xd0\xbd;\0"
"mut.;gas.;wer.;mat.;gic.;kam.;nya.;kan.;nze.;ukw.;ugu.;uku.;\0"
"Mutarama;Gashyantare;Werurwe;Mata;Gicuransi;Kamena;Nyakanga;Kanama;Nzeli;Ukwakira"
";Ugushyingo;Ukuboza;\0"
";;;;;;;;;;;;\0"
"1;2;3;4;5;6;7;8;9;10;11;12;\0"
"1\xec\x9b\x94;2\xec\x9b\x94;3\xec\x9b\x94;4\xec\x9b\x94;5\xec\x9b\x94;6\xec\x9b\x94"
";7\xec\x9b\x94;8\xec\x9b\x94;9\xec\x9b\x94;10\xec\x9b\x94;11\xec\x9b\x94;12\xec\x9b"
"\x94;\0"
"\xc3\xa7il;sib;adr;n\xc3\xaes;gul;hez;t\xc3\xaer;;;;;;\0"
"\xc3\xa7ile;sibat;adar;n\xc3\xaesan;gulan;hez\xc3\xaeran;7;8;9;10;11;12;\0"
"\xe0\xba\xa1.\xe0\xba\x81.;\xe0\xba\x81.\xe0\xba\x9e.;\xe0\xba\xa1\xe0\xba\xb5.\xe0"
"\xba\x99.;\xe0\xba\xa1.\xe0\xba\xaa..;\xe0\xba\x9e.\xe0\xba\x9e.;\xe0\xba\xa1\xe0"
"\xba\xb4.\xe0\xba\x96.;\xe0\xba\x81.\xe0\xba\xa5.;\xe0\xba\xaa.\xe0\xba\xab.;\xe0"
"\xba\x81.\xe0\xba\x8d.;\xe0\xba\x95.\xe0\xba\xa5.;\xe0\xba\x9e.\xe0\xba\x88.;\xe0"
"\xba\x97.\xe0\xba\xa7.;\0"
"\xe0\xba\xa1\xe0\xba\xb1\xe0\xba\x87\xe0\xba\x81\xe0\xba\xad\xe0\xba\x99;\xe0\xba"
"\x81\xe0\xba\xb8\xe0\xba\xa1\xe0\xba\x9e\xe0\xba\xb2;\xe0\xba\xa1\xe0\xba\xb5\xe0"
"\xba\x99\xe0\xba\xb2;\xe0\xbb\x80\xe0\xba\xa1\xe0\xba\xaa\xe0\xba\xb2;\xe0\xba\x9e"
"\xe0\xba\xb6\xe0\xba\x94\xe0\xba\xaa\xe0\xba\xb0\xe0\xba\x9e\xe0\xba\xb2;\xe0\xba"
"\xa1\xe0\xba\xb4\xe0\xba\x96\xe0\xba\xb8\xe0\xba\x99\xe0\xba\xb2;\xe0\xba\x81\xe0"
"\xbb\x8d\xe0\xba\xa5\xe0\xba\xb0\xe0\xba\x81\xe0\xba\xbb\xe0\xba\x94;\xe0\xba\xaa"
"\xe0\xba\xb4\xe0\xba\x87\xe0\xba\xab\xe0\xba\xb2;\xe0\xba\x81\xe0\xba\xb1\xe0\xba"
"\x99\xe0\xba\x8d\xe0\xba\xb2;\xe0\xba\x95\xe0\xba\xb8\xe0\xba\xa5\xe0\xba\xb2;\xe0"
"\xba\x9e\xe0\xba\xb0\xe0\xba\x88\xe0\xba\xb4\xe0\xba\x81;\xe0\xba\x97\xe0\xba\xb1"
"\xe0\xba\x99\xe0\xba\xa7\xe0\xba\xb2;\0"
"Jan;Feb;Mar;Apr;Mai;J\xc5\xabn;J\xc5\xabl;Aug;Sep;Okt;Nov;Dec;\0"
"janv\xc4\x81ris;febru\xc4\x81ris;marts;apr\xc4\xablis;maijs;j\xc5\xabnijs;j\xc5\xab"
"lijs;augusts;septembris;oktobris;novembris;decembris;\0"
"s1;s2;s3;s4;s5;s6;s7;s8;s9;s10;s11;s12;\0"
"s\xc3\xa1nz\xc3\xa1 ya yambo;s\xc3\xa1nz\xc3\xa1 ya m\xc3\xad\x62\x61l\xc3\xa9;s\xc3"
"\xa1nz\xc3\xa1 ya m\xc3\xads\xc3\xa1to;s\xc3\xa1nz\xc3\xa1 ya m\xc3\xadn\xc3\xa9i"
";s\xc3\xa1nz\xc3\xa1 ya m\xc3\xadt\xc3\xa1no;s\xc3\xa1nz\xc3\xa1 ya mot\xc3\xb3\x62"
"\xc3\xa1;s\xc3\xa1nz\xc3\xa1 ya nsambo;s\xc3\xa1nz\xc3\xa1 ya mwambe;s\xc3\xa1nz\xc3"
"\xa1 ya libwa;s\xc3\xa1nz\xc3\xa1 ya z\xc3\xb3m\xc3\xad;s\xc3\xa1nz\xc3\xa1 ya z\xc3"
"\xb3m\xc3\xad na m\xc9\x94\xcc\x8ck\xc9\x94\xcc\x81;s\xc3\xa1nz\xc3\xa1 ya z\xc3\xb3"
"m\xc3\xad na m\xc3\xad\x62\x61l\xc3\xa9;\0"
"Sau;Vas;Kov;Bal;Geg;Bir;Lie;Rgp;Rgs;Spl;Lap;Grd;\0"
"sausio;vasario;kovo;baland\xc5\xbeio;gegu\xc5\xbe\xc4\x97s;bir\xc5\xbe\x65lio;lie"
"pos;rugpj\xc5\xab\xc4\x8dio;rugs\xc4\x97jo;spalio;lapkri\xc4\x8dio;gruod\xc5\xbei"
"o;\0"
"\xd1\x98\xd0\xb0\xd0\xbd.;\xd1\x84\xd0\xb5\xd0\xb2.;\xd0\xbc\xd0\xb0\xd1\x80.;\xd0"
"\xb0\xd0\xbf\xd1\x80.;\xd0\xbc\xd0\xb0\xd1\x98.;\xd1\x98\xd1\x83\xd0\xbd.;\xd1\x98"
"\xd1\x83\xd0\xbb.;\xd0\xb0\xd0\xb2\xd0\xb3.;\xd1\x81\xd0\xb5\xd0\xbf\xd1\x82.;\xd0"
"\xbe\xd0\xba\xd1\x82.;\xd0\xbd\xd0\xbe\xd0\xb5\xd0\xbc.;\xd0\xb4\xd0\xb5\xd0\xba\xd0"
"\xb5\xd0\xbc.;\0"
"\xd1\x98\xd0\xb0\xd0\xbd\xd1\x83\xd0\xb0\xd1\x80\xd0\xb8;\xd1\x84\xd0\xb5\xd0\xb2"
"\xd1\x80\xd1\x83\xd0\xb0\xd1\x80\xd0\xb8;\xd0\xbc\xd0\xb0\xd1\x80\xd1\x82;\xd0\xb0"
"\xd0\xbf\xd1\x80\xd0\xb8\xd0\xbb;\xd0\xbc\xd0\xb0\xd1\x98;\xd1\x98\xd1\x83\xd0\xbd"
"\xd0\xb8;\xd1\x98\xd1\x83\xd0\xbb\xd0\xb8;\xd0\xb0\xd0\xb2\xd0\xb3\xd1\x83\xd1\x81"
"\xd1\x82;\xd1\x81\xd0\xb5\xd0\xbf\xd1\x82\xd0\xb5\xd0\xbc\xd0\xb2\xd1\x80\xd0\xb8"
";\xd0\xbe\xd0\xba\xd1\x82\xd0\xbe\xd0\xbc\xd0\xb2\xd1\x80\xd0\xb8;\xd0\xbd\xd0\xbe"
"\xd0\xb5\xd0\xbc\xd0\xb2\xd1\x80\xd0\xb8;\xd0\xb4\xd0\xb5\xd0\xba\xd0\xb5\xd0\xbc"
"\xd0\xb2\xd1\x80\xd0\xb8;\0"
"Jan;Feb;Mac;Apr;Mei;Jun;Jul;Ogos;Sep;Okt;Nov;Dis;\0"
"Januari;Februari;Mac;April;Mei;Jun;Julai;Ogos;September;Oktober;November;Disember"
";\0"
"\xe0\xb4\x9c\xe0\xb4\xa8\xe0\xb5\x81;\xe0\xb4\xab\xe0\xb4\xbf\xe0\xb4\xac\xe0\xb5"
"\x8d;\xe0\xb4\xae\xe0\xb4\xbe\xe0\xb4\xb1\xe0\xb5\x8d\xe0\xb4\x85;\xe0\xb4\x8f\xe0"
"\xb4\xaa\xe0\xb5\x8d\xe0\xb4\xb1\xe0\xb4\xbf\xe0\xb4\xb2\xe0\xb5\x8d\xe0\xb4\x85;"
"\xe0\xb4\xae\xe0\xb5\x86\xe0\xb4\xaf\xe0\xb5\x8d;\xe0\xb4\x9c\xe0\xb5\x82\xe0\xb4"
"\xa3\xe0\xb5\x8d\xe0\xb4\x85;\xe0\xb4\x9c\xe0\xb5\x82\xe0\xb5\x88\xe0\xb4\xb2;\xe0"
"\xb4\x86\xe0\xb4\x97;\xe0\xb4\xb8\xe0\xb5\x86\xe0\xb4\xaa\xe0\xb5\x8d\xe0\xb4\xa4"
"\xe0\xb4\x82;\xe0\xb4\x92\xe0\xb4\x95\xe0\xb5\x8d\xe0\xb4\x9f;\xe0\xb4\xa8\xe0\xb4"
"\xb5\xe0\xb4\x82;\xe0\xb4\xa1\xe0\xb4\xbf\xe0\xb4\xb8\xe0\xb4\x82;\0"
"\xe0\xb4\x9c\xe0\xb4\xa8\xe0\xb5\x81\xe0\xb4\xb5\xe0\xb4\xb0\xe0\xb4\xbf;\xe0\xb4"
"\xab\xe0\xb4\xbf\xe0\xb4\xac\xe0\xb5\x8d\xe0\xb4\xb1\xe0\xb4\xb5\xe0\xb4\xb0\xe0\xb4"
"\xbf;\xe0\xb4\xae\xe0\xb4\xbe\xe0\xb4\xb1\xe0\xb5\x8d\xe0\xb4\x85\xe0\xb4\x9a\xe0"
"\xb5\x8d\xe0\xb4\x85\xe0\xb4\x9a\xe0\xb5\x8d;\xe0\xb4\x8f\xe0\xb4\xaa\xe0\xb5\x8d"
"\xe0\xb4\xb1\xe0\xb4\xbf\xe0\xb4\xb2\xe0\xb5\x8d\xe0\xb4\x85;\xe0\xb4\xae\xe0\xb5"
"\x86\xe0\xb4\xaf\xe0\xb5\x8d;\xe0\xb4\x9c\xe0\xb5\x82\xe0\xb4\xa3\xe0\xb5\x8d\xe0"
"\xb4\x85;\xe0\xb4\x9c\xe0\xb5\x82\xe0\xb5\x88\xe0\xb4\xb2;\xe0\xb4\x86\xe0\xb4\x97"
"\xe0\xb4\xb8\xe0\xb5\x8d\xe0\xb4\xa4\xe0\xb5\x8d\xe0\xb4\x85;\xe0\xb4\xb8\xe0\xb5"
"\x86\xe0\xb4\xaa\xe0\xb5\x8d\xe0\xb4\xa4\xe0\xb4\x82\xe0\xb4\xac\xe0\xb4\xb1\xe0\xb5"
"\x8d\xe0\xb4\x85;\xe0\xb4\x92\xe0\xb4\x95\xe0\xb5\x8d\xe0\xb4\x9f\xe0\xb5\x88\xe0"
"\xb4\xac\xe0\xb4\xb1\xe0\xb5\x8d\xe0\xb4\x85;\xe0\xb4\xa8\xe0\xb4\xb5\xe0\xb4\x82"
"\xe0\xb4\xac\xe0\xb4\xb1\xe0\xb5\x8d\xe0\xb4\x85;\xe0\xb4\xa1\xe0\xb4\xbf\xe0\xb4"
"\xb8\xe0\xb4\x82\xe0\xb4\xac\xe0\xb4\xb1\xe0\xb5\x8d\xe0\xb4\x85;\0"
"Jan;Fra;Mar;Apr;Mej;\xc4\xa0un;Lul;Awi;Set;Ott;Nov;Di\xc4\x8b;\0"
"Jannar;Frar;Marzu;April;Mejju;\xc4\xa0unju;Lulju;Awissu;Settembru;Ottubru;Novembr"
"u;Di\xc4\x8b\x65mbru;\0"
"\xe0\xa4\x9c\xe0\xa4\xbe\xe0\xa4\xa8\xe0\xa5\x87\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0"
"\xe0\xa5\x80;\xe0\xa4\xab\xe0\xa5\x87\xe0\xa4\xac\xe0\xa5\x83\xe0\xa4\xb5\xe0\xa4"
"\xbe\xe0\xa4\xb0\xe0\xa5\x80;\xe0\xa4\xae\xe0\xa4\xbe\xe0\xa4\xb0\xe0\xa5\x8d\xe0"
"\xa4\x9a;\xe0\xa4\x8f\xe0\xa4\xaa\xe0\xa5\x8d\xe0\xa4\xb0\xe0\xa4\xbf\xe0\xa4\xb2"
";\xe0\xa4\xae\xe0\xa5\x87;\xe0\xa4\x9c\xe0\xa5\x82\xe0\xa4\xa8;\xe0\xa4\x9c\xe0\xa5"
"\x81\xe0\xa4\xb2\xe0\xa5\x88;\xe0\xa4\x93\xe0\xa4\x97\xe0\xa4\xb8\xe0\xa5\x8d\xe0"
"\xa4\x9f;\xe0\xa4\xb8\xe0\xa5\x87\xe0\xa4\xaa\xe0\xa5\x8d\xe0\xa4\x9f\xe0\xa5\x87"
"\xe0\xa4\x82\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\x93\xe0\xa4\x95\xe0\xa5\x8d\xe0\xa4"
"\x9f\xe0\xa5\x8b\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\xa8\xe0\xa5\x8b\xe0\xa4\xb5\xe0"
"\xa5\x8d\xe0\xa4\xb9\xe0\xa5\x87\xe0\xa4\x82\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\xa1"
"\xe0\xa4\xbf\xe0\xa4\xb8\xe0\xa5\x87\xe0\xa4\x82\xe0\xa4\xac\xe0\xa4\xb0;\0"
"\xd1\x85\xd1\x83\xd0\xbb;\xd2\xaf\xd1\x85\xd1\x8d;\xd0\xb1\xd0\xb0\xd1\x80;\xd1\x82"
"\xd1\x83\xd1\x83;\xd0\xbb\xd1\x83\xd1\x83;\xd0\xbc\xd0\xbe\xd0\xb3;\xd0\xbc\xd0\xbe"
"\xd1\x80;\xd1\x85\xd0\xbe\xd0\xbd;\xd0\xb1\xd0\xb8\xd1\x87;\xd1\x82\xd0\xb0\xd1\x85"
";\xd0\xbd\xd0\xbe\xd1\x85;\xd0\xb3\xd0\xb0\xd1\x85;\0"
"\xd0\xa5\xd1\x83\xd0\xbb\xd0\xb3\xd0\xb0\xd0\xbd\xd0\xb0;\xd2\xae\xd1\x85\xd1\x8d"
"\xd1\x80;\xd0\x91\xd0\xb0\xd1\x80;\xd0\xa2\xd1\x83\xd1\x83\xd0\xbb\xd0\xb0\xd0\xb9"
";\xd0\x9b\xd1\x83\xd1\x83;\xd0\x9c\xd0\xbe\xd0\xb3\xd0\xbe\xd0\xb9;\xd0\x9c\xd0\xbe"
"\xd1\x80\xd1\x8c;\xd0\xa5\xd0\xbe\xd0\xbd\xd1\x8c;\xd0\x91\xd0\xb8\xd1\x87;\xd0\xa2"
"\xd0\xb0\xd1\x85\xd0\xb8\xd0\xb0;\xd0\x9d\xd0\xbe\xd1\x85\xd0\xbe\xd0\xb9;\xd0\x93"
"\xd0\xb0\xd1\x85\xd0\xb0\xd0\xb9;\0"
"\xe0\xa4\x9c\xe0\xa4\xa8;\xe0\xa4\xab\xe0\xa5\x87\xe0\xa4\xac;\xe0\xa4\xae\xe0\xa4"
"\xbe\xe0\xa4\xb0\xe0\xa5\x8d\xe0\xa4\x9a;\xe0\xa4\x85\xe0\xa4\xaa\xe0\xa5\x8d\xe0"
"\xa4\xb0\xe0\xa4\xbf;\xe0\xa4\xae\xe0\xa5\x87;\xe0\xa4\x9c\xe0\xa5\x81\xe0\xa4\xa8"
";\xe0\xa4\x9c\xe0\xa5\x81\xe0\xa4\xb2\xe0\xa4\xbe;\xe0\xa4\x85\xe0\xa4\x97;\xe0\xa4"
"\xb8\xe0\xa5\x87\xe0\xa4\xaa\xe0\xa5\x8d\xe0\xa4\x9f;\xe0\xa4\x85\xe0\xa4\x95\xe0"
"\xa5\x8d\xe0\xa4\x9f\xe0\xa5\x8b;\xe0\xa4\xa8\xe0\xa5\x8b\xe0\xa4\xad\xe0\xa5\x87"
";\xe0\xa4\xa1\xe0\xa4\xbf\xe0\xa4\xb8\xe0\xa5\x87;\0"
"\xe0\xa4\x9c\xe0\xa4\xa8\xe0\xa4\xb5\xe0\xa4\xb0\xe0\xa5\x80;\xe0\xa4\xab\xe0\xa5"
"\x87\xe0\xa4\xac\xe0\xa5\x8d\xe0\xa4\xb0\xe0\xa5\x81\xe0\xa4\x85\xe0\xa4\xb0\xe0\xa5"
"\x80;\xe0\xa4\xae\xe0\xa4\xbe\xe0\xa4\xb0\xe0\xa5\x8d\xe0\xa4\x9a;\xe0\xa4\x85\xe0"
"\xa4\xaa\xe0\xa5\x8d\xe0\xa4\xb0\xe0\xa4\xbf\xe0\xa4\xb2;\xe0\xa4\xae\xe0\xa5\x87"
";\xe0\xa4\x9c\xe0\xa5\x81\xe0\xa4\xa8;\xe0\xa4\x9c\xe0\xa5\x81\xe0\xa4\xb2\xe0\xa4"
"\xbe\xe0\xa4\x88;\xe0\xa4\x85\xe0\xa4\x97\xe0\xa4\xb8\xe0\xa5\x8d\xe0\xa4\xa4;\xe0"
"\xa4\xb8\xe0\xa5\x87\xe0\xa4\xaa\xe0\xa5\x8d\xe0\xa4\x9f\xe0\xa5\x87\xe0\xa4\xae\xe0"
"\xa5\x8d\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\x85\xe0\xa4\x95\xe0\xa5\x8d\xe0\xa4\x9f"
"\xe0\xa5\x8b\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\xa8\xe0\xa5\x8b\xe0\xa4\xad\xe0\xa5"
"\x87\xe0\xa4\xae\xe0\xa5\x8d\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\xa1\xe0\xa4\xbf\xe0"
"\xa4\xb8\xe0\xa5\x87\xe0\xa4\xae\xe0\xa5\x8d\xe0\xa4\xac\xe0\xa4\xb0;\0"
"jan.;feb.;mars;april;mai;juni;juli;aug.;sep.;okt.;nov.;des.;\0"
"januar;februar;mars;april;mai;juni;juli;august;september;oktober;november;desembe"
"r;\0"
"\xe0\xac\x9c\xe0\xac\xbe\xe0\xac\xa8\xe0\xad\x81\xe0\xac\x86\xe0\xac\xb0\xe0\xad\x80"
";\xe0\xac\xab\xe0\xad\x87\xe0\xac\xac\xe0\xad\x8d\xe0\xac\xb0\xe0\xad\x81\xe0\xad"
"\x9f\xe0\xac\xbe\xe0\xac\xb0\xe0\xad\x80;\xe0\xac\xae\xe0\xac\xbe\xe0\xac\xb0\xe0"
"\xad\x8d\xe0\xac\x9a\xe0\xad\x8d\xe0\xac\x9a;\xe0\xac\x85\xe0\xac\xaa\xe0\xad\x8d"
"\xe0\xac\xb0\xe0\xad\x87\xe0\xac\xb2;\xe0\xac\xae\xe0\xad\x87;\xe0\xac\x9c\xe0\xad"
"\x81\xe0\xac\xa8;\xe0\xac\x9c\xe0\xad\x81\xe0\xac\xb2\xe0\xac\xbe\xe0\xac\x87;\xe0"
"\xac\x85\xe0\xac\x97\xe0\xac\xb7\xe0\xad\x8d\xe0\xac\x9f;\xe0\xac\xb8\xe0\xad\x87"
"\xe0\xac\xaa\xe0\xad\x8d\xe0\xac\x9f\xe0\xad\x87\xe0\xac\xae\xe0\xad\x8d\xe0\xac\xac"
"\xe0\xac\xb0;\xe0\xac\x85\xe0\xac\x95\xe0\xad\x8d\xe0\xac\x9f\xe0\xad\x8b\xe0\xac"
"\xac\xe0\xac\xb0;\xe0\xac\xa8\xe0\xac\xad\xe0\xad\x87\xe0\xac\xae\xe0\xad\x8d\xe0"
"\xac\xac\xe0\xac\xb0;\xe0\xac\xa1\xe0\xac\xbf\xe0\xac\xb8\xe0\xad\x87\xe0\xac\xae"
"\xe0\xad\x8d\xe0\xac\xac\xe0\xac\xb0;\0"
";;;;\xd9\x85\xd9\x80\xdb\x8c;\xd8\xac\xd9\x88\xd9\x86;;;;;;;\0"
"\xd8\xac\xd9\x86\xd9\x88\xd8\xb1\xd9\x8a;\xd9\x81\xd8\xa8\xd8\xb1\xd9\x88\xd8\xb1"
"\xd9\x8a;\xd9\x85\xd8\xa7\xd8\xb1\xda\x86;\xd8\xa7\xd9\xbe\xd8\xb1\xdb\x8c\xd9\x84"
";\xd9\x85\xdb\x8c;\xd8\xac\xd9\x88\xd9\x86;\xd8\xac\xd9\x88\xd9\x84\xd8\xa7\xdb\x8c"
";\xd8\xa7\xda\xab\xd8\xb3\xd8\xaa;\xd8\xb3\xd9\xbe\xd8\xaa\xd9\x85\xd8\xa8\xd8\xb1"
";\xd8\xa7\xda\xa9\xd8\xaa\xd9\x88\xd8\xa8\xd8\xb1;\xd9\x86\xd9\x88\xd9\x85\xd8\xa8"
"\xd8\xb1;\xd8\xaf\xd8\xb3\xd9\x85\xd8\xa8\xd8\xb1;\0"
"\xda\x98\xd8\xa7\xd9\x86\xd9\x88\xdb\x8c\xd9\x87\xd9\x94;\xd9\x81\xd9\x88\xd8\xb1"
"\xdb\x8c\xd9\x87\xd9\x94;\xd9\x85\xd8\xa7\xd8\xb1\xd8\xb3;\xd8\xa2\xd9\x88\xd8\xb1"
"\xdb\x8c\xd9\x84;\xd9\x85\xd9\x87\xd9\x94;\xda\x98\xd9\x88\xd8\xa6\xd9\x86;\xda\x98"
"\xd9\x88\xd8\xa6\xdb\x8c\xd9\x87\xd9\x94;\xd8\xa7\xd9\x88\xd8\xaa;\xd8\xb3\xd9\xbe"
"\xd8\xaa\xd8\xa7\xd9\x85\xd8\xa8\xd8\xb1;\xd8\xa7\xda\xa9\xd8\xaa\xd8\xa8\xd8\xb1"
";\xd9\x86\xd9\x88\xd8\xa7\xd9\x85\xd8\xa8\xd8\xb1;\xd8\xaf\xd8\xb3\xd8\xa7\xd9\x85"
"\xd8\xa8\xd8\xb1;\0"
"\xd8\xac\xd9\x86\xd9\x88;;;;\xd9\x85\xd9\x80\xdb\x8c;\xd8\xac\xd9\x88\xd9\x86;\xd8"
"\xac\xd9\x88\xd9\x84;;;;;\xd8\xaf\xd8\xb3\xd9\x85;\0"
"\xd8\xac\xd9\x86\xd9\x88\xd8\xb1\xdb\x8c;\xd9\x81\xd8\xa8\xd8\xb1\xd9\x88\xd8\xb1"
"\xdb\x8c;\xd9\x85\xd8\xa7\xd8\xb1\xda\x86;\xd8\xa7\xd9\xbe\xd8\xb1\xdb\x8c\xd9\x84"
";\xd9\x85\xdb\x8c;\xd8\xac\xd9\x88\xd9\x86;\xd8\xac\xd9\x88\xd9\x84\xd8\xa7\xdb\x8c"
";\xd8\xa7\xda\xaf\xd8\xb3\xd8\xaa;\xd8\xb3\xd9\xbe\xd8\xaa\xd9\x85\xd8\xa8\xd8\xb1"
";\xd8\xa7\xda\xa9\xd8\xaa\xd9\x88\xd8\xa8\xd8\xb1;\xd9\x86\xd9\x88\xd9\x85\xd8\xa8"
"\xd8\xb1;\xd8\xaf\xd8\xb3\xd9\x85\xd8\xa8\xd8\xb1;\0"
"sty;lut;mar;kwi;maj;cze;lip;sie;wrz;pa\xc5\xba;lis;gru;\0"
"stycznia;lutego;marca;kwietnia;maja;czerwca;lipca;sierpnia;wrze\xc5\x9bnia;pa\xc5"
"\xba\x64ziernika;listopada;grudnia;\0"
"jan;fev;mar;abr;mai;jun;jul;ago;set;out;nov;dez;\0"
"janeiro;fevereiro;mar\xc3\xa7o;abril;maio;junho;julho;agosto;setembro;outubro;nov"
"embro;dezembro;\0"
"\xe0\xa8\x9c\xe0\xa8\xa8\xe0\xa8\xb5\xe0\xa8\xb0\xe0\xa9\x80;\xe0\xa8\xab\xe0\xa8"
"\xbc\xe0\xa8\xb0\xe0\xa8\xb5\xe0\xa8\xb0\xe0\xa9\x80;\xe0\xa8\xae\xe0\xa8\xbe\xe0"
"\xa8\xb0\xe0\xa8\x9a;\xe0\xa8\x85\xe0\xa8\xaa\xe0\xa9\x8d\xe0\xa8\xb0\xe0\xa9\x88"
"\xe0\xa8\xb2;\xe0\xa8\xae\xe0\xa8\x88;\xe0\xa8\x9c\xe0\xa9\x82\xe0\xa8\xa8;\xe0\xa8"
"\x9c\xe0\xa9\x81\xe0\xa8\xb2\xe0\xa8\xbe\xe0\xa8\x88;\xe0\xa8\x85\xe0\xa8\x97\xe0"
"\xa8\xb8\xe0\xa8\xa4;\xe0\xa8\xb8\xe0\xa8\xa4\xe0\xa9\xb0\xe0\xa8\xac\xe0\xa8\xb0"
";\xe0\xa8\x85\xe0\xa8\x95\xe0\xa8\xa4\xe0\xa9\x82\xe0\xa8\xac\xe0\xa8\xb0;\xe0\xa8"
"\xa8\xe0\xa8\xb5\xe0\xa9\xb0\xe0\xa8\xac\xe0\xa8\xb0;\xe0\xa8\xa6\xe0\xa8\xb8\xe0"
"\xa9\xb0\xe0\xa8\xac\xe0\xa8\xb0;\0"
"Ian;Feb;Mar;Apr;Mai;Iun;Iul;Aug;Sep;Oct;Nov;Dec;\0"
"ianuarie;februarie;martie;aprilie;mai;iunie;iulie;august;septembrie;octombrie;noi"
"embrie;decembrie;\0"
"\xd1\x8f\xd0\xbd\xd0\xb2.;\xd1\x84\xd0\xb5\xd0\xb2\xd1\x80.;\xd0\xbc\xd0\xb0\xd1\x80"
"\xd1\x82\xd0\xb0;\xd0\xb0\xd0\xbf\xd1\x80.;\xd0\xbc\xd0\xb0\xd1\x8f;\xd0\xb8\xd1\x8e"
"\xd0\xbd\xd1\x8f;\xd0\xb8\xd1\x8e\xd0\xbb\xd1\x8f;\xd0\xb0\xd0\xb2\xd0\xb3.;\xd1\x81"
"\xd0\xb5\xd0\xbd\xd1\x82.;\xd0\xbe\xd0\xba\xd1\x82.;\xd0\xbd\xd0\xbe\xd1\x8f\xd0\xb1"
".;\xd0\xb4\xd0\xb5\xd0\xba.;\0"
"\xd1\x8f\xd0\xbd\xd0\xb2\xd0\xb0\xd1\x80\xd1\x8f;\xd1\x84\xd0\xb5\xd0\xb2\xd1\x80"
"\xd0\xb0\xd0\xbb\xd1\x8f;\xd0\xbc\xd0\xb0\xd1\x80\xd1\x82\xd0\xb0;\xd0\xb0\xd0\xbf"
"\xd1\x80\xd0\xb5\xd0\xbb\xd1\x8f;\xd0\xbc\xd0\xb0\xd1\x8f;\xd0\xb8\xd1\x8e\xd0\xbd"
"\xd1\x8f;\xd0\xb8\xd1\x8e\xd0\xbb\xd1\x8f;\xd0\xb0\xd0\xb2\xd0\xb3\xd1\x83\xd1\x81"
"\xd1\x82\xd0\xb0;\xd1\x81\xd0\xb5\xd0\xbd\xd1\x82\xd1\x8f\xd0\xb1\xd1\x80\xd1\x8f"
";\xd0\xbe\xd0\xba\xd1\x82\xd1\x8f\xd0\xb1\xd1\x80\xd1\x8f;\xd0\xbd\xd0\xbe\xd1\x8f"
"\xd0\xb1\xd1\x80\xd1\x8f;\xd0\xb4\xd0\xb5\xd0\xba\xd0\xb0\xd0\xb1\xd1\x80\xd1\x8f"
";\0"
"\xd1\x98\xd0\xb0\xd0\xbd;\xd1\x84\xd0\xb5\xd0\xb1;\xd0\xbc\xd0\xb0\xd1\x80;\xd0\xb0"
"\xd0\xbf\xd1\x80;\xd0\xbc\xd0\xb0\xd1\x98;\xd1\x98\xd1\x83\xd0\xbd;\xd1\x98\xd1\x83"
"\xd0\xbb;\xd0\xb0\xd0\xb2\xd0\xb3;\xd1\x81\xd0\xb5\xd0\xbf;\xd0\xbe\xd0\xba\xd1\x82"
";\xd0\xbd\xd0\xbe\xd0\xb2;\xd0\xb4\xd0\xb5\xd1\x86;\0"
"\xd1\x98\xd0\xb0\xd0\xbd\xd1\x83\xd0\xb0\xd1\x80;\xd1\x84\xd0\xb5\xd0\xb1\xd1\x80"
"\xd1\x83\xd0\xb0\xd1\x80;\xd0\xbc\xd0\xb0\xd1\x80\xd1\x82;\xd0\xb0\xd0\xbf\xd1\x80"
"\xd0\xb8\xd0\xbb;\xd0\xbc\xd0\xb0\xd1\x98;\xd1\x98\xd1\x83\xd0\xbd;\xd1\x98\xd1\x83"
"\xd0\xbb;\xd0\xb0\xd0\xb2\xd0\xb3\xd1\x83\xd1\x81\xd1\x82;\xd1\x81\xd0\xb5\xd0\xbf"
"\xd1\x82\xd0\xb5\xd0\xbc\xd0\xb1\xd0\xb0\xd1\x80;\xd0\xbe\xd0\xba\xd1\x82\xd0\xbe"
"\xd0\xb1\xd0\xb0\xd1\x80;\xd0\xbd\xd0\xbe\xd0\xb2\xd0\xb5\xd0\xbc\xd0\xb1\xd0\xb0"
"\xd1\x80;\xd0\xb4\xd0\xb5\xd1\x86\xd0\xb5\xd0\xbc\xd0\xb1\xd0\xb0\xd1\x80;\0"
"\xd1\x98\xd0\xb0\xd0\xbd\xd1\x83\xd0\xb0\xd1\x80;\xd1\x84\xd0\xb5\xd0\xb1\xd1\x80"
"\xd1\x83\xd0\xb0\xd1\x80;\xd0\xbc\xd0\xb0\xd1\x80\xd1\x82;\xd0\xb0\xd0\xbf\xd1\x80"
"\xd0\xb8\xd0\xbb;\xd0\xbc\xd0\xb0\xd1\x98;\xd1\x98\xd1\x83\xd0\xbd\xd0\xb8;\xd1\x98"
"\xd1\x83\xd0\xbb\xd0\xb8;\xd0\xb0\xd0\xb2\xd0\xb3\xd1\x83\xd1\x81\xd1\x82;\xd1\x81"
"\xd0\xb5\xd0\xbf\xd1\x82\xd0\xb5\xd0\xbc\xd0\xb1\xd0\xb0\xd1\x80;\xd0\xbe\xd0\xba"
"\xd1\x82\xd0\xbe\xd0\xb1\xd0\xb0\xd1\x80;\xd0\xbd\xd0\xbe\xd0\xb2\xd0\xb5\xd0\xbc"
"\xd0\xb1\xd0\xb0\xd1\x80;\xd0\xb4\xd0\xb5\xd1\x86\xd0\xb5\xd0\xbc\xd0\xb1\xd0\xb0"
"\xd1\x80;\0"
"jan;feb;mar;apr;maj;jun;jul;avg;sep;okt;nov;dec;\0"
"januar;februar;mart;april;maj;jun;jul;avgust;septembar;oktobar;novembar;decembar;"
"\0"
"januar;februar;mart;april;maj;juni;juli;avgust;septembar;oktobar;novembar;decemba"
"r;\0"
"Phe;Kol;Ube;Mme;Mot;Jan;Upu;Pha;Leo;Mph;Pun;Tsh;\0"
"Phesekgong;Hlakola;Hlakubele;Mmese;Motsheanong;Phupjane;Phupu;Phata;Leotshe;Mphal"
"ane;Pundungwane;Tshitwe;\0"
"Fer;Tlh;Mop;Mor;Mot;See;Phu;Pha;Lwe;Dip;Ngw;Sed;\0"
"Ferikgong;Tlhakole;Mopitlo;Moranang;Motsheganang;Seetebosigo;Phukwi;Phatwe;Lwetse"
";Diphalane;Ngwanatsele;Sedimonthole;\0"
"Bhi;Van;Vol;Mab;Nkh;Nhl;Kho;Ngc;Nyo;Mph;Lwe;Ngo;\0"
"Bhimbidvwane;iNdlovana;iNdlovu-lenkhulu;Mabasa;iNkhwekhweti;iNhlaba;Kholwane;iNgc"
"i;iNyoni;iMphala;Lweti;iNgongoni;\0"
"jan;feb;mar;apr;m\xc3\xa1j;j\xc3\xban;j\xc3\xbal;aug;sep;okt;nov;dec;\0"
"janu\xc3\xa1r;febru\xc3\xa1r;marec;apr\xc3\xadl;m\xc3\xa1j;j\xc3\xban;j\xc3\xbal;"
"august;september;okt\xc3\xb3\x62\x65r;november;december;\0"
"januar;februar;marec;april;maj;junij;julij;avgust;september;oktober;november;dece"
"mber;\0"
"Kob;Lab;Sad;Afr;Sha;Lix;Tod;Sid;Sag;Tob;KIT;LIT;\0"
"Bisha Koobaad;Bisha Labaad;Bisha Saddexaad;Bisha Afraad;Bisha Shanaad;Bisha Lixaa"
"d;Bisha Todobaad;Bisha Sideedaad;Bisha Sagaalaad;Bisha Tobnaad;Bisha Kow iyo Tobn"
"aad;Bisha Laba iyo Tobnaad;\0"
"ene;feb;mar;abr;may;jun;jul;ago;sep;oct;nov;dic;\0"
"enero;febrero;marzo;abril;mayo;junio;julio;agosto;septiembre;octubre;noviembre;di"
"ciembre;\0"
"Jan;Feb;Mar;Apr;Mei;Jun;Jul;Ago;Sep;Okt;Nov;Des;\0"
"Januari;Februari;Machi;Aprili;Mei;Juni;Julai;Agosti;Septemba;Oktoba;Novemba;Desem"
"ba;\0"
"januari;februari;mars;april;maj;juni;juli;augusti;september;oktober;november;dece"
"mber;\0"
"\xd0\xaf\xd0\xbd\xd0\xb2;\xd0\xa4\xd0\xb5\xd0\xb2;\xd0\x9c\xd0\xb0\xd1\x80;\xd0\x90"
"\xd0\xbf\xd1\x80;\xd0\x9c\xd0\xb0\xd0\xb9;\xd0\x98\xd1\x8e\xd0\xbd;\xd0\x98\xd1\x8e"
"\xd0\xbb;\xd0\x90\xd0\xb2\xd0\xb3;\xd0\xa1\xd0\xb5\xd0\xbd;\xd0\x9e\xd0\xba\xd1\x82"
";\xd0\x9d\xd0\xbe\xd1\x8f;\xd0\x94\xd0\xb5\xd0\xba;\0"
"\xd0\xaf\xd0\xbd\xd0\xb2\xd0\xb0\xd1\x80;\xd0\xa4\xd0\xb5\xd0\xb2\xd1\x80\xd0\xb0"
"\xd0\xbb;\xd0\x9c\xd0\xb0\xd1\x80\xd1\x82;\xd0\x90\xd0\xbf\xd1\x80\xd0\xb5\xd0\xbb"
";\xd0\x9c\xd0\xb0\xd0\xb9;\xd0\x98\xd1\x8e\xd0\xbd;\xd0\x98\xd1\x8e\xd0\xbb;\xd0\x90"
"\xd0\xb2\xd0\xb3\xd1\x83\xd1\x81\xd1\x82;\xd0\xa1\xd0\xb5\xd0\xbd\xd1\x82\xd1\x8f"
"\xd0\xb1\xd1\x80;\xd0\x9e\xd0\xba\xd1\x82\xd1\x8f\xd0\xb1\xd1\x80;\xd0\x9d\xd0\xbe"
"\xd1\x8f\xd0\xb1\xd1\x80;\xd0\x94\xd0\xb5\xd0\xba\xd0\xb0\xd0\xb1\xd1\x80;\0"
"\xe0\xae\x9c\xe0\xae\xa9.;\xe0\xae\xaa\xe0\xae\xbf\xe0\xae\xaa\xe0\xaf\x8d.;\xe0\xae"
"\xae\xe0\xae\xbe\xe0\xae\xb0\xe0\xaf\x8d.;\xe0\xae\x8f\xe0\xae\xaa\xe0\xaf\x8d.;\xe0"
"\xae\xae\xe0\xaf\x87;\xe0\xae\x9c\xe0\xaf\x82\xe0\xae\xa9\xe0\xaf\x8d;\xe0\xae\x9c"
"\xe0\xaf\x82\xe0\xae\xb2\xe0\xaf\x88;\xe0\xae\x86\xe0\xae\x95.;\xe0\xae\x9a\xe0\xaf"
"\x86\xe0\xae\xaa\xe0\xaf\x8d.;\xe0\xae\x85\xe0\xae\x95\xe0\xaf\x8d.;\xe0\xae\xa8\xe0"
"\xae\xb5.;\xe0\xae\x9f\xe0\xae\xbf\xe0\xae\x9a.;\0"
"\xe0\xae\x9c\xe0\xae\xa9\xe0\xae\xb5\xe0\xae\xb0\xe0\xae\xbf;\xe0\xae\xaa\xe0\xae"
"\xbf\xe0\xae\xaa\xe0\xaf\x8d\xe0\xae\xb0\xe0\xae\xb5\xe0\xae\xb0\xe0\xae\xbf;\xe0"
"\xae\xae\xe0\xae\xbe\xe0\xae\xb0\xe0\xaf\x8d\xe0\xae\x9a\xe0\xaf\x8d;\xe0\xae\x8f"
"\xe0\xae\xaa\xe0\xaf\x8d\xe0\xae\xb0\xe0\xae\xb2\xe0\xaf\x8d;\xe0\xae\xae\xe0\xaf"
"\x87;\xe0\xae\x9c\xe0\xaf\x82\xe0\xae\xa9\xe0\xaf\x8d;\xe0\xae\x9c\xe0\xaf\x82\xe0"
"\xae\xb2\xe0\xaf\x88;\xe0\xae\x86\xe0\xae\x95\xe0\xae\xb8\xe0\xaf\x8d\xe0\xae\x9f"
"\xe0\xaf\x8d;\xe0\xae\x9a\xe0\xaf\x86\xe0\xae\xaa\xe0\xaf\x8d\xe0\xae\x9f\xe0\xae"
"\xae\xe0\xaf\x8d\xe0\xae\xaa\xe0\xae\xb0\xe0\xaf\x8d;\xe0\xae\x85\xe0\xae\x95\xe0"
"\xaf\x8d\xe0\xae\x9f\xe0\xaf\x8b\xe0\xae\xaa\xe0\xae\xb0\xe0\xaf\x8d;\xe0\xae\xa8"
"\xe0\xae\xb5\xe0\xae\xae\xe0\xaf\x8d\xe0\xae\xaa\xe0\xae\xb0\xe0\xaf\x8d;\xe0\xae"
"\x9f\xe0\xae\xbf\xe0\xae\x9a\xe0\xae\xae\xe0\xaf\x8d\xe0\xae\xaa\xe0\xae\xb0\xe0\xaf"
"\x8d;\0"
"\xe0\xb0\x9c\xe0\xb0\xa8\xe0\xb0\xb5\xe0\xb0\xb0\xe0\xb0\xbf;\xe0\xb0\xab\xe0\xb0"
"\xbf\xe0\xb0\xac\xe0\xb1\x8d\xe0\xb0\xb0\xe0\xb0\xb5\xe0\xb0\xb0\xe0\xb0\xbf;\xe0"
"\xb0\xae\xe0\xb0\xbe\xe0\xb0\xb0\xe0\xb1\x8d\xe0\xb0\x9a\xe0\xb0\xbf;\xe0\xb0\x8f"
"\xe0\xb0\xaa\xe0\xb1\x8d\xe0\xb0\xb0\xe0\xb0\xbf\xe0\xb0\xb2\xe0\xb1\x8d;\xe0\xb0"
"\xae\xe0\xb1\x87;\xe0\xb0\x9c\xe0\xb1\x82\xe0\xb0\xa8\xe0\xb1\x8d;\xe0\xb0\x9c\xe0"
"\xb1\x82\xe0\xb0\xb2\xe0\xb1\x88;\xe0\xb0\x86\xe0\xb0\x97\xe0\xb0\xb8\xe0\xb1\x8d"
"\xe0\xb0\x9f\xe0\xb1\x81;\xe0\xb0\xb8\xe0\xb1\x86\xe0\xb0\xaa\xe0\xb1\x8d\xe0\xb0"
"\x9f\xe0\xb1\x86\xe0\xb0\x82\xe0\xb0\xac\xe0\xb0\xb0\xe0\xb1\x8d;\xe0\xb0\x85\xe0"
"\xb0\x95\xe0\xb1\x8d\xe0\xb0\x9f\xe0\xb1\x8b\xe0\xb0\xac\xe0\xb0\xb0\xe0\xb1\x8d;"
"\xe0\xb0\xa8\xe0\xb0\xb5\xe0\xb0\x82\xe0\xb0\xac\xe0\xb0\xb0\xe0\xb1\x8d;\xe0\xb0"
"\xa1\xe0\xb0\xbf\xe0\xb0\xb8\xe0\xb1\x86\xe0\xb0\x82\xe0\xb0\xac\xe0\xb0\xb0\xe0\xb1"
"\x8d;\0"
"\xe0\xb8\xa1.\xe0\xb8\x84.;\xe0\xb8\x81.\xe0\xb8\x9e.;\xe0\xb8\xa1\xe0\xb8\xb5.\xe0"
"\xb8\x84.;\xe0\xb9\x80\xe0\xb8\xa1.\xe0\xb8\xa2.;\xe0\xb8\x9e.\xe0\xb8\x84.;\xe0\xb8"
"\xa1\xe0\xb8\xb4.\xe0\xb8\xa2.;\xe0\xb8\x81.\xe0\xb8\x84.;\xe0\xb8\xaa.\xe0\xb8\x84"
".;\xe0\xb8\x81.\xe0\xb8\xa2.;\xe0\xb8\x95.\xe0\xb8\x84.;\xe0\xb8\x9e.\xe0\xb8\xa2"
".;\xe0\xb8\x98.\xe0\xb8\x84.;\0"
"\xe0\xb8\xa1\xe0\xb8\x81\xe0\xb8\xa3\xe0\xb8\xb2\xe0\xb8\x84\xe0\xb8\xa1;\xe0\xb8"
"\x81\xe0\xb8\xb8\xe0\xb8\xa1\xe0\xb8\xa0\xe0\xb8\xb2\xe0\xb8\x9e\xe0\xb8\xb1\xe0\xb8"
"\x99\xe0\xb8\x98\xe0\xb9\x8c;\xe0\xb8\xa1\xe0\xb8\xb5\xe0\xb8\x99\xe0\xb8\xb2\xe0"
"\xb8\x84\xe0\xb8\xa1;\xe0\xb9\x80\xe0\xb8\xa1\xe0\xb8\xa9\xe0\xb8\xb2\xe0\xb8\xa2"
"\xe0\xb8\x99;\xe0\xb8\x9e\xe0\xb8\xa4\xe0\xb8\xa9\xe0\xb8\xa0\xe0\xb8\xb2\xe0\xb8"
"\x84\xe0\xb8\xa1;\xe0\xb8\xa1\xe0\xb8\xb4\xe0\xb8\x96\xe0\xb8\xb8\xe0\xb8\x99\xe0"
"\xb8\xb2\xe0\xb8\xa2\xe0\xb8\x99;\xe0\xb8\x81\xe0\xb8\xa3\xe0\xb8\x81\xe0\xb8\x8e"
"\xe0\xb8\xb2\xe0\xb8\x84\xe0\xb8\xa1;\xe0\xb8\xaa\xe0\xb8\xb4\xe0\xb8\x87\xe0\xb8"
"\xab\xe0\xb8\xb2\xe0\xb8\x84\xe0\xb8\xa1;\xe0\xb8\x81\xe0\xb8\xb1\xe0\xb8\x99\xe0"
"\xb8\xa2\xe0\xb8\xb2\xe0\xb8\xa2\xe0\xb8\x99;\xe0\xb8\x95\xe0\xb8\xb8\xe0\xb8\xa5"
"\xe0\xb8\xb2\xe0\xb8\x84\xe0\xb8\xa1;\xe0\xb8\x9e\xe0\xb8\xa4\xe0\xb8\xa8\xe0\xb8"
"\x88\xe0\xb8\xb4\xe0\xb8\x81\xe0\xb8\xb2\xe0\xb8\xa2\xe0\xb8\x99;\xe0\xb8\x98\xe0"
"\xb8\xb1\xe0\xb8\x99\xe0\xb8\xa7\xe0\xb8\xb2\xe0\xb8\x84\xe0\xb8\xa1;\0"
"\xe1\x8c\xa5\xe1\x88\xaa;\xe1\x88\x88\xe1\x8a\xab\xe1\x89\xb2;\xe1\x88\x98\xe1\x8c"
"\x8b\xe1\x89\xa2;\xe1\x88\x9a\xe1\x8b\xab\xe1\x8b\x9d;\xe1\x8c\x8d\xe1\x8a\x95\xe1"
"\x89\xa6;\xe1\x88\xb0\xe1\x8a\x90;\xe1\x88\x93\xe1\x88\x9d\xe1\x88\x88;\xe1\x8a\x90"
"\xe1\x88\x93\xe1\x88\xb0;\xe1\x88\x98\xe1\x88\xb5\xe1\x8a\xa8;\xe1\x8c\xa5\xe1\x89"
"\x85\xe1\x88\x9d;\xe1\x88\x95\xe1\x8b\xb3\xe1\x88\xad;\xe1\x89\xb3\xe1\x88\x95\xe1"
"\x88\xb3;\0"
"\xe1\x8c\xa5\xe1\x88\xaa;\xe1\x88\x88\xe1\x8a\xab\xe1\x89\xb2\xe1\x89\xb5;\xe1\x88"
"\x98\xe1\x8c\x8b\xe1\x89\xa2\xe1\x89\xb5;\xe1\x88\x9a\xe1\x8b\xab\xe1\x8b\x9d\xe1"
"\x8b\xab;\xe1\x8c\x8d\xe1\x8a\x95\xe1\x89\xa6\xe1\x89\xb5;\xe1\x88\xb0\xe1\x8a\x90"
";\xe1\x88\x93\xe1\x88\x9d\xe1\x88\x88;\xe1\x8a\x90\xe1\x88\x93\xe1\x88\xb0;\xe1\x88"
"\x98\xe1\x88\xb5\xe1\x8a\xa8\xe1\x88\xa8\xe1\x88\x9d;\xe1\x8c\xa5\xe1\x89\x85\xe1"
"\x88\x9d\xe1\x89\xb2;\xe1\x88\x95\xe1\x8b\xb3\xe1\x88\xad;\xe1\x89\xb3\xe1\x88\x95"
"\xe1\x88\xb3\xe1\x88\xb5;\0"
"Sun;Yan;Kul;Dzi;Mud;Kho;Maw;Mha;Ndz;Nhl;Huk;N'w;\0"
"Sunguti;Nyenyenyani;Nyenyankulu;Dzivamisoko;Mudyaxihi;Khotavuxika;Mawuwani;Mhawur"
"i;Ndzhati;Nhlangula;Hukuri;N'wendzamhala;\0"
"Oca;\xc5\x9eub;Mar;Nis;May;Haz;Tem;A\xc4\x9fu;Eyl;Eki;Kas;Ara;\0"
"Ocak;\xc5\x9eubat;Mart;Nisan;May\xc4\xb1s;Haziran;Temmuz;A\xc4\x9fustos;Eyl\xc3\xbc"
"l;Ekim;Kas\xc4\xb1m;Aral\xc4\xb1k;\0"
"\xd0\xa1\xd1\x96\xd1\x87;\xd0\x9b\xd1\x8e\xd1\x82;\xd0\x91\xd0\xb5\xd1\x80;\xd0\x9a"
"\xd0\xb2\xd1\x96;\xd0\xa2\xd1\x80\xd0\xb0;\xd0\xa7\xd0\xb5\xd1\x80;\xd0\x9b\xd0\xb8"
"\xd0\xbf;\xd0\xa1\xd0\xb5\xd1\x80;\xd0\x92\xd0\xb5\xd1\x80;\xd0\x96\xd0\xbe\xd0\xb2"
";\xd0\x9b\xd0\xb8\xd1\x81;\xd0\x93\xd1\x80\xd1\x83;\0"
"\xd1\x81\xd1\x96\xd1\x87\xd0\xbd\xd1\x8f;\xd0\xbb\xd1\x8e\xd1\x82\xd0\xbe\xd0\xb3"
"\xd0\xbe;\xd0\xb1\xd0\xb5\xd1\x80\xd0\xb5\xd0\xb7\xd0\xbd\xd1\x8f;\xd0\xba\xd0\xb2"
"\xd1\x96\xd1\x82\xd0\xbd\xd1\x8f;\xd1\x82\xd1\x80\xd0\xb0\xd0\xb2\xd0\xbd\xd1\x8f"
";\xd1\x87\xd0\xb5\xd1\x80\xd0\xb2\xd0\xbd\xd1\x8f;\xd0\xbb\xd0\xb8\xd0\xbf\xd0\xbd"
"\xd1\x8f;\xd1\x81\xd0\xb5\xd1\x80\xd0\xbf\xd0\xbd\xd1\x8f;\xd0\xb2\xd0\xb5\xd1\x80"
"\xd0\xb5\xd1\x81\xd0\xbd\xd1\x8f;\xd0\xb6\xd0\xbe\xd0\xb2\xd1\x82\xd0\xbd\xd1\x8f"
";\xd0\xbb\xd0\xb8\xd1\x81\xd1\x82\xd0\xbe\xd0\xbf\xd0\xb0\xd0\xb4\xd0\xb0;\xd0\xb3"
"\xd1\x80\xd1\x83\xd0\xb4\xd0\xbd\xd1\x8f;\0"
"\xd0\x9c\xd1\x83\xd2\xb3\xd0\xb0\xd1\x80\xd1\x80\xd0\xb0\xd0\xbc;\xd0\xa1\xd0\xb0"
"\xd1\x84\xd0\xb0\xd1\x80;\xd0\xa0\xd0\xb0\xd0\xb1\xd0\xb8\xd1\x83\xd0\xbb-\xd0\xb0"
"\xd0\xb2\xd0\xb2\xd0\xb0\xd0\xbb;\xd0\xa0\xd0\xb0\xd0\xb1\xd0\xb8\xd1\x83\xd0\xbb"
"-\xd0\xbe\xd1\x85\xd0\xb8\xd1\x80;\xd0\x96\xd1\x83\xd0\xbc\xd0\xbe\xd0\xb4\xd0\xb8"
"\xd1\x83\xd0\xbb-\xd1\x83\xd0\xbb\xd0\xbe;\xd0\x96\xd1\x83\xd0\xbc\xd0\xbe\xd0\xb4"
"\xd0\xb8\xd1\x83\xd0\xbb-\xd1\x83\xd1\x85\xd1\x80\xd0\xbe;\xd0\xa0\xd0\xb0\xd0\xb6"
"\xd0\xb0\xd0\xb1;\xd0\xa8\xd0\xb0\xd1\x8a\xd0\xb1\xd0\xbe\xd0\xbd;\xd0\xa0\xd0\xb0"
"\xd0\xbc\xd0\xb0\xd0\xb7\xd0\xbe\xd0\xbd;\xd0\xa8\xd0\xb0\xd0\xb2\xd0\xb2\xd0\xbe"
"\xd0\xbb;\xd0\x97\xd0\xb8\xd0\xbb-\xd2\x9b\xd0\xb0\xd1\x8a\xd0\xb4\xd0\xb0;\xd0\x97"
"\xd0\xb8\xd0\xbb-\xd2\xb3\xd0\xb8\xd0\xb6\xd0\xb6\xd0\xb0;\0"
"thg 1;thg 2;thg 3;thg 4;thg 5;thg 6;thg 7;thg 8;thg 9;thg 10;thg 11;thg 12;\0"
"th\xc3\xa1ng m\xe1\xbb\x99t;th\xc3\xa1ng hai;th\xc3\xa1ng ba;th\xc3\xa1ng t\xc6\xb0"
";th\xc3\xa1ng n\xc4\x83m;th\xc3\xa1ng s\xc3\xa1u;th\xc3\xa1ng b\xe1\xba\xa3y;th\xc3"
"\xa1ng t\xc3\xa1m;th\xc3\xa1ng ch\xc3\xadn;th\xc3\xa1ng m\xc6\xb0\xe1\xbb\x9di;th"
"\xc3\xa1ng m\xc6\xb0\xe1\xbb\x9di m\xe1\xbb\x99t;th\xc3\xa1ng m\xc6\xb0\xe1\xbb\x9d"
"i hai;\0"
"Ion;Chwef;Mawrth;Ebrill;Mai;Meh;Gorff;Awst;Medi;Hyd;Tach;Rhag;\0"
"Ionawr;Chwefror;Mawrth;Ebrill;Mai;Mehefin;Gorffenaf;Awst;Medi;Hydref;Tachwedd;Rha"
"gfyr;\0"
"Jan;Feb;Mat;Epr;Mey;Jun;Jul;Aga;Sep;Okt;Nov;Dis;\0"
"Janyuwari;Februwari;Matshi;Epreli;Meyi;Juni;Julayi;Agasti;Septemba;Okthoba;Novemb"
"a;Disemba;\0"
"Sere;Erele;Erena;Igbe;Ebibi;Okudu;Agemo;Ogun;Owewe;Owara;Belu;Ope;\0"
"Osukini;Osukeji;Osuketa;Osukerin;Osukarun;Osukefa;Osukeje;Osukejo;Osukesan;Osukew"
"a;Osukokanla;Osukejila;\0"
"Jan;Feb;Mas;Apr;Mey;Jun;Jul;Aga;Sep;Okt;Nov;Dis;\0"
"Januwari;Februwari;Mashi;Apreli;Meyi;Juni;Julayi;Agasti;Septemba;Okthoba;Novemba;"
"Disemba;\0"
"Jan;Feb;Mar;Apr;Maj;Jun;Jul;Avg;Sep;Okt;Nov;Dec;\0"
"Januar;Februar;Mart;April;Maj;Juni;Juli;Avgust;Septembar;Oktobar;Novembar;Decemba"
"r;\0"
"J-guer;T-arree;Mayrnt;Avrril;Boaldyn;M-souree;J-souree;Luanistyn;M-fouyir;J-fouyi"
"r;M.Houney;M.Nollick;\0"
"Jerrey-geuree;Toshiaght-arree;Mayrnt;Averil;Boaldyn;Mean-souree;Jerrey-souree;Lua"
"nistyn;Mean-fouyir;Jerrey-fouyir;Mee Houney;Mee ny Nollick;\0"
"Gen;Whe;Mer;Ebr;Me;Efn;Gor;Est;Gwn;Hed;Du;Kev;\0"
"Mys Genver;Mys Whevrel;Mys Merth;Mys Ebrel;Mys Me;Mys Efan;Mys Gortheren;Mye Est;"
"Mys Gwyngala;Mys Hedra;Mys Du;Mys Kevardhu;\0"
"S-\xc6\x86;K-\xc6\x86;E-\xc6\x86;E-O;E-K;O-A;A-K;D-\xc6\x86;F-\xc6\x90;\xc6\x86-A"
";\xc6\x86-O;M-\xc6\x86;\0"
"Sanda-\xc6\x86p\xc9\x9bp\xc9\x94n;Kwakwar-\xc6\x86gyefuo;Eb\xc9\x94w-\xc6\x86\x62"
"\x65nem;Eb\xc9\x94\x62ira-Oforisuo;Esusow Aketseaba-K\xc9\x94t\xc9\x94nimba;Obira"
"de-Ay\xc9\x9bwohomumu;Ay\xc9\x9bwoho-Kitawonsa;Difuu-\xc6\x86sandaa;Fankwa-\xc6\x90"
"\x62\xc9\x94;\xc6\x86\x62\xc9\x9bs\xc9\x9b-Ahinime;\xc6\x86\x62\x65r\xc9\x9b\x66\xc9"
"\x9bw-Obubuo;Mumu-\xc6\x86p\xc9\x9bnimba;\0"
"\xe0\xa4\x9c\xe0\xa4\xbe\xe0\xa4\xa8\xe0\xa5\x87\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0"
"\xe0\xa5\x80;\xe0\xa4\xab\xe0\xa5\x87\xe0\xa4\xac\xe0\xa5\x8d\xe0\xa4\xb0\xe0\xa5"
"\x81\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0\xe0\xa5\x80;\xe0\xa4\xae\xe0\xa4\xbe\xe0"
"\xa4\xb0\xe0\xa5\x8d\xe0\xa4\x9a;\xe0\xa4\x8f\xe0\xa4\xaa\xe0\xa5\x8d\xe0\xa4\xb0"
"\xe0\xa4\xbf\xe0\xa4\xb2;\xe0\xa4\xae\xe0\xa5\x87;\xe0\xa4\x9c\xe0\xa5\x82\xe0\xa4"
"\xa8;\xe0\xa4\x9c\xe0\xa5\x81\xe0\xa4\xb2\xe0\xa5\x88;\xe0\xa4\x93\xe0\xa4\x97\xe0"
"\xa4\xb8\xe0\xa5\x8d\xe0\xa4\x9f;\xe0\xa4\xb8\xe0\xa5\x87\xe0\xa4\xaa\xe0\xa5\x8d"
"\xe0\xa4\x9f\xe0\xa5\x87\xe0\xa4\x82\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\x93\xe0\xa4"
"\x95\xe0\xa5\x8d\xe0\xa4\x9f\xe0\xa5\x8b\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\xa8\xe0"
"\xa5\x8b\xe0\xa4\xb5\xe0\xa5\x8d\xe0\xa4\xb9\xe0\xa5\x87\xe0\xa4\x82\xe0\xa4\xac\xe0"
"\xa4\xb0;\xe0\xa4\xa1\xe0\xa4\xbf\xe0\xa4\xb8\xe0\xa5\x87\xe0\xa4\x82\xe0\xa4\xac"
"\xe0\xa4\xb0;\0"
"Aha;Ofl;Och;Abe;Agb;Otu;Maa;Man;Gbo;Ant;Ale;Afu;\0"
"Aharabata;Oflo;Ochokrikri;Abeibee;Agbeinaa;Otukwadan;Maawe;Manyawale;Gbo;Anton;Al"
"emle;Afuabee;\0"
"Jen;Feb;Maa;Epr;Mee;Juu;Jul;\xe1\xbb\x8cg\xe1\xbb\x8d;Sep;\xe1\xbb\x8ckt;Nov;Dis;"
"\0"
"Jen\xe1\xbb\xa5war\xe1\xbb\x8b;Febr\xe1\xbb\xa5war\xe1\xbb\x8b;Maach\xe1\xbb\x8b;"
"Eprel;Mee;Juun;Jula\xe1\xbb\x8b;\xe1\xbb\x8cg\xe1\xbb\x8d\xe1\xbb\x8dst;Septemba;"
"\xe1\xbb\x8cktoba;Novemba;Disemba;\0"
"Mwei wa mbee;Mwei wa keli;Mwei wa katatu;Mwei wa kanne;Mwei wa katano;Mwei wa tha"
"nthatu;Mwei wa muonza;Mwei wa nyanya;Mwei wa kenda;Mwei wa ikumi;Mwei wa ikumi na"
" imwe;Mwei wa ikumi na ili;\0"
"\xdc\x8f\xdc\x9f\xdc\xa2\xc2\xa0\xdc\x8f\xdc\x92;\xdc\xab\xdc\x92\xdc\x9b;\xdc\x90"
"\xdc\x95\xdc\xaa;\xdc\xa2\xdc\x9d\xdc\xa3\xdc\xa2;\xdc\x90\xdc\x9d\xdc\xaa;\xdc\x9a"
"\xdc\x99\xdc\x9d\xdc\xaa\xdc\xa2;\xdc\xac\xdc\xa1\xdc\x98\xdc\x99;\xdc\x90\xdc\x92"
";\xdc\x90\xdc\x9d\xdc\xa0\xdc\x98\xdc\xa0;\xdc\x8f\xdc\xac\xdc\xab\xc2\xa0\xdc\x8f"
"\xdc\x90;\xdc\x8f\xdc\xac\xdc\xab\xc2\xa0\xdc\x8f\xdc\x92;\xdc\x8f\xdc\x9f\xdc\xa2"
"\xc2\xa0\xdc\x8f\xdc\x90;\0"
"\xe1\x88\x8d\xe1\x8b\xb0\xe1\x89\xb5;\xe1\x8a\xab\xe1\x89\xa5\xe1\x8a\xbd;\xe1\x8a"
"\xad\xe1\x89\xa5\xe1\x88\x8b;\xe1\x8d\x8b\xe1\x8c\x85\xe1\x8a\xba;\xe1\x8a\xad\xe1"
"\x89\xa2\xe1\x89\x85;\xe1\x88\x9d/\xe1\x89\xb5;\xe1\x8a\xb0\xe1\x88\xad;\xe1\x88\x9b"
"\xe1\x88\xad\xe1\x8b\xab;\xe1\x8b\xab\xe1\x8a\xb8\xe1\x8a\x92;\xe1\x88\x98\xe1\x89"
"\xb0\xe1\x88\x89;\xe1\x88\x9d/\xe1\x88\x9d;\xe1\x89\xb0\xe1\x88\x95\xe1\x88\xb3;\0"
"\xe1\x88\x8d\xe1\x8b\xb0\xe1\x89\xb5\xe1\x88\xaa;\xe1\x8a\xab\xe1\x89\xa5\xe1\x8a"
"\xbd\xe1\x89\xa5\xe1\x89\xb2;\xe1\x8a\xad\xe1\x89\xa5\xe1\x88\x8b;\xe1\x8d\x8b\xe1"
"\x8c\x85\xe1\x8a\xba\xe1\x88\xaa;\xe1\x8a\xad\xe1\x89\xa2\xe1\x89\x85\xe1\x88\xaa"
";\xe1\x88\x9d\xe1\x8a\xaa\xe1\x8a\xa4\xe1\x88\x8d \xe1\x89\xb5\xe1\x8c\x93\xcc\x85"
"\xe1\x8a\x92\xe1\x88\xaa;\xe1\x8a\xb0\xe1\x88\xad\xe1\x8a\xa9;\xe1\x88\x9b\xe1\x88"
"\xad\xe1\x8b\xab\xe1\x88\x9d \xe1\x89\xb5\xe1\x88\xaa;\xe1\x8b\xab\xe1\x8a\xb8\xe1"
"\x8a\x92 \xe1\x88\x98\xe1\x88\xb3\xe1\x89\x85\xe1\x88\x88\xe1\x88\xaa;\xe1\x88\x98"
"\xe1\x89\xb0\xe1\x88\x89;\xe1\x88\x9d\xe1\x8a\xaa\xe1\x8a\xa4\xe1\x88\x8d \xe1\x88"
"\x98\xe1\x88\xbd\xe1\x8b\x88\xe1\x88\xaa;\xe1\x89\xb0\xe1\x88\x95\xe1\x88\xb3\xe1"
"\x88\xb5\xe1\x88\xaa;\0"
"\xe1\x8c\xa0\xe1\x88\x90\xe1\x88\xa8;\xe1\x8a\xa8\xe1\x89\xb0\xe1\x89\xb0;\xe1\x88"
"\x98\xe1\x8c\x88\xe1\x89\xa0;\xe1\x8a\xa0\xe1\x8a\x80\xe1\x8b\x98;\xe1\x8c\x8d\xe1"
"\x8a\x95\xe1\x89\xa3;\xe1\x88\xa0\xe1\x8a\x95\xe1\x8b\xa8;\xe1\x88\x90\xe1\x88\x98"
"\xe1\x88\x88;\xe1\x8a\x90\xe1\x88\x90\xe1\x88\xb0;\xe1\x8a\xa8\xe1\x88\xa8\xe1\x88"
"\x98;\xe1\x8c\xa0\xe1\x89\x80\xe1\x88\x98;\xe1\x8a\x80\xe1\x8b\xb0\xe1\x88\xa8;\xe1"
"\x8a\x80\xe1\x88\xa0\xe1\x88\xa0;\0"
"\xe1\x8c\xa0\xe1\x88\x90\xe1\x88\xa8;\xe1\x8a\xa8\xe1\x89\xb0\xe1\x89\xb0;\xe1\x88"
"\x98\xe1\x8c\x88\xe1\x89\xa0;\xe1\x8a\xa0\xe1\x8a\x80\xe1\x8b\x98;\xe1\x8c\x8d\xe1"
"\x8a\x95\xe1\x89\xa3\xe1\x89\xb5;\xe1\x88\xa0\xe1\x8a\x95\xe1\x8b\xa8;\xe1\x88\x90"
"\xe1\x88\x98\xe1\x88\x88;\xe1\x8a\x90\xe1\x88\x90\xe1\x88\xb0;\xe1\x8a\xa8\xe1\x88"
"\xa8\xe1\x88\x98;\xe1\x8c\xa0\xe1\x89\x80\xe1\x88\x98;\xe1\x8a\x80\xe1\x8b\xb0\xe1"
"\x88\xa8;\xe1\x8a\x80\xe1\x88\xa0\xe1\x88\xa0;\0"
"Wey;Fan;Tat;Nan;Tuy;Tso;Taf;War;Kun;Ban;Kom;Sau;\0"
"Fai Weyene;Fai Fani;Fai Tataka;Fai Nangra;Fai Tuyo;Fai Tsoyi;Fai Tafaka;Fai Warac"
"hi;Fai Kunobok;Fai Bansok;Fai Kom;Fai Sauk;\0"
"Dyon;Baa;Atat;Anas;Atyo;Achi;Atar;Awur;Shad;Shak;Naba;Nata;\0"
"Pen Dyon;Pen Ba'a;Pen Atat;Pen Anas;Pen Atyon;Pen Achirim;Pen Atariba;Pen Awurr;P"
"en Shadon;Pen Shakur;Pen Kur Naba;Pen Kur Natat;\0"
"A\xcc\xb1yr;A\xcc\xb1hw;A\xcc\xb1ta;A\xcc\xb1na;A\xcc\xb1pf;A\xcc\xb1ki;A\xcc\xb1"
"ty;A\xcc\xb1ni;A\xcc\xb1ku;Swa;Sby;Sbh;\0"
"Hywan A\xcc\xb1yrnig;Hywan A\xcc\xb1hwa;Hywan A\xcc\xb1tat;Hywan A\xcc\xb1naai;Hy"
"wan A\xcc\xb1pfwon;Hywan A\xcc\xb1kitat;Hywan A\xcc\xb1tyirin;Hywan A\xcc\xb1nina"
"i;Hywan A\xcc\xb1kumviriyin;Hywan Swak;Hywan Swak B'a\xcc\xb1yrnig;Hywan Swak B'a"
"\xcc\xb1hwa;\0"
"Zen;Fev;Mar;Avr;Mai;Jug;Lui;Avo;Set;Otu;Nov;Dic;\0"
"Zen\xc3\xa2r;Fevr\xc3\xa2r;Mar\xc3\xa7;Avr\xc3\xael;Mai;Jugn;Lui;Avost;Setembar;O"
"tubar;Novembar;Dicembar;\0"
"Pha;Luh;\xe1\xb9\xb0ha;Lam;Shu;Lwi;Lwa;\xe1\xb9\xb0ha;Khu;Tsh;\xe1\xb8\xbc\x61r;N"
"ye;\0"
"Phando;Luhuhi;\xe1\xb9\xb0hafamuhwe;Lambamai;Shundunthule;Fulwi;Fulwana;\xe1\xb9\xb0"
"hangule;Khubvumedzi;Tshimedzi;\xe1\xb8\xbc\x61ra;Nyendavhusiku;\0"
"Dzv;Dzd;Ted;Af\xc9\x94;Dam;Mas;Sia;Dea;Any;Kel;Ade;Dzm;\0"
"Dzove;Dzodze;Tedoxe;Af\xc9\x94\x66i\xc9\x9b;Dama;Masa;Siaml\xc9\x94m;Deasiamime;A"
"ny\xc9\x94ny\xc9\x94;Kele;Ade\xc9\x9bmekp\xc9\x94xe;Dzome;\0"
"Ian.;Pep.;Mal.;\xca\xbb\x41p.;Mei;Iun.;Iul.;\xca\xbb\x41u.;Kep.;\xca\xbbOk.;Now.;"
"Kek.;\0"
"Ianuali;Pepeluali;Malaki;\xca\xbb\x41pelila;Mei;Iune;Iulai;\xca\xbb\x41ukake;Kepa"
"kemapa;\xca\xbbOkakopa;Nowemapa;Kekemapa;\0"
"Juw;Swi;Tsa;Nya;Tsw;Ata;Ana;Ari;Aku;Swa;Man;Mas;\0"
"Zwat Juwung;Zwat Swiyang;Zwat Tsat;Zwat Nyai;Zwat Tswon;Zwat Ataah;Zwat Anatat;Zw"
"at Arinai;Zwat Akubunyung;Zwat Swag;Zwat Mangjuwang;Zwat Swag-Ma-Suyang;\0"
"Jan;Feb;Mal;Epu;Mei;Jun;Jul;Oga;Sep;Oku;Nov;Dis;\0"
"Januwale;Febuluwale;Malichi;Epulo;Mei;Juni;Julai;Ogasiti;Seputemba;Okutoba;Novemb"
"a;Disemba;\0"
;

static const char days_data[] =
"Sun;Mon;Tue;Wed;Thu;Fri;Sat;\0"
"Sunday;Monday;Tuesday;Wednesday;Thursday;Friday;Saturday;\0"
"Dil;Wix;Qib;Rob;Kam;Jim;San;\0"
"Dilbata;Wiixata;Qibxata;Roobii;Kamiisa;Jimaata;Sanbata;\0"
"Aca;Etl;Tal;Arb;Kam;Gum;Sab;\0"
"Acaada;Etleeni;Talaata;Arbaqa;Kamiisi;Gumqata;Sabti;\0"
"So;Ma;Di;Wo;Do;Vr;Sa;\0"
"Sondag;Maandag;Dinsdag;Woensdag;Donderdag;Vrydag;Saterdag;\0"
"Die;H\xc3\xabn;Mar;M\xc3\xabr;Enj;Pre;Sht;\0"
"e diel;e h\xc3\xabn\xc3\xab;e mart\xc3\xab;e m\xc3\xabrkur\xc3\xab;e enjte;e prem"
"te;e shtun\xc3\xab;\0"
"\xe1\x8a\xa5\xe1\x88\x91\xe1\x8b\xb5;\xe1\x88\xb0\xe1\x8a\x9e;\xe1\x88\x9b\xe1\x8a"
"\xad\xe1\x88\xb0;\xe1\x88\xa8\xe1\x89\xa1\xe1\x8b\x95;\xe1\x88\x90\xe1\x88\x99\xe1"
"\x88\xb5;\xe1\x8b\x93\xe1\x88\xad\xe1\x89\xa5;\xe1\x89\x85\xe1\x8b\xb3\xe1\x88\x9c"
";\0"
"\xe1\x8a\xa5\xe1\x88\x91\xe1\x8b\xb5;\xe1\x88\xb0\xe1\x8a\x9e;\xe1\x88\x9b\xe1\x8a"
"\xad\xe1\x88\xb0\xe1\x8a\x9e;\xe1\x88\xa8\xe1\x89\xa1\xe1\x8b\x95;\xe1\x88\x90\xe1"
"\x88\x99\xe1\x88\xb5;\xe1\x8b\x93\xe1\x88\xad\xe1\x89\xa5;\xe1\x89\x85\xe1\x8b\xb3"
"\xe1\x88\x9c;\0"
"\xd8\xa7\xd9\x84\xd8\xa3\xd8\xad\xd8\xaf;\xd8\xa7\xd9\x84\xd8\xa7\xd8\xab\xd9\x86"
"\xd9\x8a\xd9\x86;\xd8\xa7\xd9\x84\xd8\xab\xd9\x84\xd8\xa7\xd8\xab\xd8\xa7\xd8\xa1"
";\xd8\xa7\xd9\x84\xd8\xa3\xd8\xb1\xd8\xa8\xd8\xb9\xd8\xa7\xd8\xa1;\xd8\xa7\xd9\x84"
"\xd8\xae\xd9\x85\xd9\x8a\xd8\xb3;\xd8\xa7\xd9\x84\xd8\xac\xd9\x85\xd8\xb9\xd8\xa9"
";\xd8\xa7\xd9\x84\xd8\xb3\xd8\xa8\xd8\xaa;\0"
"\xd8\xad;\xd9\x86;\xd8\xab;\xd8\xb1;\xd8\xae;\xd8\xac;\xd8\xb3;\0"
"\xd4\xbf\xd5\xab\xd6\x80;\xd4\xb5\xd6\x80\xd5\xaf;\xd4\xb5\xd6\x80\xd6\x84;\xd5\x89"
"\xd5\xb8\xd6\x80;\xd5\x80\xd5\xb6\xd5\xa3;\xd5\x88\xd6\x82\xd6\x80;\xd5\x87\xd5\xa1"
"\xd5\xa2;\0"
"\xd4\xbf\xd5\xab\xd6\x80\xd5\xa1\xd5\xaf\xd5\xab;\xd4\xb5\xd6\x80\xd5\xaf\xd5\xb8"
"\xd6\x82\xd5\xb7\xd5\xa1\xd5\xa2\xd5\xa9\xd5\xab;\xd4\xb5\xd6\x80\xd5\xa5\xd6\x84"
"\xd5\xb7\xd5\xa1\xd5\xa2\xd5\xa9\xd5\xab;\xd5\x89\xd5\xb8\xd6\x80\xd5\xa5\xd6\x84"
"\xd5\xb7\xd5\xa1\xd5\xa2\xd5\xa9\xd5\xab;\xd5\x80\xd5\xab\xd5\xb6\xd5\xa3\xd5\xb7"
"\xd5\xa1\xd5\xa2\xd5\xa9\xd5\xab;\xd5\x88\xd6\x82\xd6\x80\xd5\xa2\xd5\xa1\xd5\xa9"
";\xd5\x87\xd5\xa1\xd5\xa2\xd5\xa1\xd5\xa9;\0"
"\xe0\xa7\xb0\xe0\xa6\xac\xe0\xa6\xbf;\xe0\xa6\xb8\xe0\xa7\x8b\xe0\xa6\xae;\xe0\xa6"
"\xae\xe0\xa6\x99\xe0\xa7\x8d\xe0\xa6\x97\xe0\xa6\xb2;\xe0\xa6\xac\xe0\xa7\x81\xe0"
"\xa6\xa7;\xe0\xa6\xac\xe0\xa7\x83\xe0\xa6\xb9\xe0\xa6\xb7\xe0\xa7\x8d\xe0\xa6\xaa"
"\xe0\xa6\xa4\xe0\xa6\xbf;\xe0\xa6\xb6\xe0\xa7\x81\xe0\xa6\x95\xe0\xa7\x8d\xe0\xa7"
"\xb0;\xe0\xa6\xb6\xe0\xa6\xa8\xe0\xa6\xbf;\0"
"\xe0\xa6\xa6\xe0\xa7\x87\xe0\xa6\x93\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa7\xb0;\xe0\xa6"
"\xb8\xe0\xa7\x8b\xe0\xa6\xae\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa7\xb0;\xe0\xa6\xae\xe0"
"\xa6\x99\xe0\xa7\x8d\xe0\xa6\x97\xe0\xa6\xb2\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa7\xb0;"
"\xe0\xa6\xac\xe0\xa7\x81\xe0\xa6\xa7\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa7\xb0;\xe0\xa6"
"\xac\xe0\xa7\x83\xe0\xa6\xb9\xe0\xa6\xb7\xe0\xa7\x8d\xe0\xa6\xaa\xe0\xa6\xa4\xe0\xa6"
"\xbf\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa7\xb0;\xe0\xa6\xb6\xe0\xa7\x81\xe0\xa6\x95\xe0"
"\xa7\x8d\xe0\xa7\xb0\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa7\xb0;\xe0\xa6\xb6\xe0\xa6\xa8"
"\xe0\xa6\xbf\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa7\xb0;\0"
"B.;B.e.;\xc3\x87.a.;\xc3\x87.;C.a.;C.;\xc5\x9e.;\0"
"bazar;bazar ert\xc9\x99si;\xc3\xa7\xc9\x99r\xc5\x9f\xc9\x99nb\xc9\x99 ax\xc5\x9f\x61"
"m;\xc3\xa7\xc9\x99r\xc5\x9f\xc9\x99nb\xc9\x99;c\xc3\xbcm\xc9\x99 ax\xc5\x9f\x61m\xc4"
"\xb1;c\xc3\xbcm\xc9\x99 ax\xc5\x9f\x61m\xc4\xb1;\xc5\x9f\xc9\x99nb\xc9\x99;\0"
"ig;al;as;az;og;or;lr;\0"
"igandea;astelehena;asteartea;asteazkena;osteguna;ostirala;larunbata;\0"
"\xe0\xa6\xb0\xe0\xa6\xac\xe0\xa6\xbf;\xe0\xa6\xb8\xe0\xa7\x8b\xe0\xa6\xae;\xe0\xa6"
"\xae\xe0\xa6\x99\xe0\xa7\x8d\xe0\xa6\x97\xe0\xa6\xb2;\xe0\xa6\xac\xe0\xa7\x81\xe0"
"\xa6\xa7;\xe0\xa6\xac\xe0\xa7\x83\xe0\xa6\xb9\xe0\xa6\xb8\xe0\xa7\x8d\xe0\xa6\xaa"
"\xe0\xa6\xa4\xe0\xa6\xbf;\xe0\xa6\xb6\xe0\xa7\x81\xe0\xa6\x95\xe0\xa7\x8d\xe0\xa6"
"\xb0;\xe0\xa6\xb6\xe0\xa6\xa8\xe0\xa6\xbf;\0"
"\xe0\xa6\xb0\xe0\xa6\xac\xe0\xa6\xbf\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa6\xb0;\xe0\xa6"
"\xb8\xe0\xa7\x8b\xe0\xa6\xae\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa6\xb0;\xe0\xa6\xae\xe0"
"\xa6\x99\xe0\xa7\x8d\xe0\xa6\x97\xe0\xa6\xb2\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa6\xb0;"
"\xe0\xa6\xac\xe0\xa7\x81\xe0\xa6\xa7\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa6\xb0;\xe0\xa6"
"\xac\xe0\xa7\x83\xe0\xa6\xb9\xe0\xa6\xb7\xe0\xa7\x8d\xe0\xa6\xaa\xe0\xa6\xa4\xe0\xa6"
"\xbf\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa6\xb0;\xe0\xa6\xb6\xe0\xa7\x81\xe0\xa6\x95\xe0"
"\xa7\x8d\xe0\xa6\xb0\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa6\xb0;\xe0\xa6\xb6\xe0\xa6\xa8"
"\xe0\xa6\xbf\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa6\xb0;\0"
"\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b;\xe0\xbd\x98\xe0\xbd\xb2\xe0\xbd\xa2\xe0\xbc"
"\x8b;\xe0\xbd\xa3\xe0\xbe\xb7\xe0\xbd\x82\xe0\xbc\x8b;\xe0\xbd\x95\xe0\xbd\xb4\xe0"
"\xbd\xa2\xe0\xbc\x8b;\xe0\xbd\xa6\xe0\xbd\x84\xe0\xbd\xa6\xe0\xbc\x8b;\xe0\xbd\xa6"
"\xe0\xbe\xa4\xe0\xbd\xba\xe0\xbd\x93\xe0\xbc\x8b;\xe0\xbd\x89\xe0\xbd\xb2\xe0\xbc"
"\x8b;\0"
"\xe0\xbd\x82\xe0\xbd\x9f\xe0\xbd\xa0\xe0\xbc\x8b\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b"
"\xe0\xbd\x96\xe0\xbc\x8b;\xe0\xbd\x82\xe0\xbd\x9f\xe0\xbd\xa0\xe0\xbc\x8b\xe0\xbd"
"\x98\xe0\xbd\xb2\xe0\xbd\x82\xe0\xbc\x8b\xe0\xbd\x91\xe0\xbd\x98\xe0\xbd\xa2\xe0\xbc"
"\x8b;\xe0\xbd\x82\xe0\xbd\x9f\xe0\xbd\xa0\xe0\xbc\x8b\xe0\xbd\xa3\xe0\xbe\xb7\xe0"
"\xbd\x82\xe0\xbc\x8b\xe0\xbd\x94\xe0\xbc\x8b;\xe0\xbd\x82\xe0\xbd\x9f\xe0\xbd\xa0"
"\xe0\xbc\x8b\xe0\xbd\x95\xe0\xbd\xb4\xe0\xbd\xa2\xe0\xbc\x8b\xe0\xbd\x96\xe0\xbd\xb4"
"\xe0\xbc\x8b;\xe0\xbd\x82\xe0\xbd\x9f\xe0\xbd\xa0\xe0\xbc\x8b\xe0\xbd\x94\xe0\xbc"
"\x8b\xe0\xbd\xa6\xe0\xbd\x84\xe0\xbd\xa6\xe0\xbc\x8b;\xe0\xbd\x82\xe0\xbd\x9f\xe0"
"\xbd\xa0\xe0\xbc\x8b\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbd\xba\xe0\xbd\x93\xe0\xbc\x8b\xe0"
"\xbd\x94\xe0\xbc\x8b;\xe0\xbd\x82\xe0\xbd\x9f\xe0\xbd\xa0\xe0\xbc\x8b\xe0\xbd\x89"
"\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x98\xe0\xbc\x8b;\0"
"\xd0\xbd\xd0\xb4;\xd0\xbf\xd0\xbd;\xd0\xb2\xd1\x82;\xd1\x81\xd1\x80;\xd1\x87\xd1\x82"
";\xd0\xbf\xd1\x82;\xd1\x81\xd0\xb1;\0"
"\xd0\xbd\xd0\xb5\xd0\xb4\xd0\xb5\xd0\xbb\xd1\x8f;\xd0\xbf\xd0\xbe\xd0\xbd\xd0\xb5"
"\xd0\xb4\xd0\xb5\xd0\xbb\xd0\xbd\xd0\xb8\xd0\xba;\xd0\xb2\xd1\x82\xd0\xbe\xd1\x80"
"\xd0\xbd\xd0\xb8\xd0\xba;\xd1\x81\xd1\x80\xd1\x8f\xd0\xb4\xd0\xb0;\xd1\x87\xd0\xb5"
"\xd1\x82\xd0\xb2\xd1\x8a\xd1\x80\xd1\x82\xd1\x8a\xd0\xba;\xd0\xbf\xd0\xb5\xd1\x82"
"\xd1\x8a\xd0\xba;\xd1\x81\xd1\x8a\xd0\xb1\xd0\xbe\xd1\x82\xd0\xb0;\0"
"\xd0\xbd\xd0\xb4;\xd0\xbf\xd0\xbd;\xd0\xb0\xd1\x9e;\xd1\x81\xd1\x80;\xd1\x87\xd1\x86"
";\xd0\xbf\xd1\x82;\xd1\x81\xd0\xb1;\0"
"\xd0\xbd\xd1\x8f\xd0\xb4\xd0\xb7\xd0\xb5\xd0\xbb\xd1\x8f;\xd0\xbf\xd0\xb0\xd0\xbd"
"\xd1\x8f\xd0\xb4\xd0\xb7\xd0\xb5\xd0\xbb\xd0\xb0\xd0\xba;\xd0\xb0\xd1\x9e\xd1\x82"
"\xd0\xbe\xd1\x80\xd0\xb0\xd0\xba;\xd1\x81\xd0\xb5\xd1\x80\xd0\xb0\xd0\xb4\xd0\xb0"
";\xd1\x87\xd0\xb0\xd1\x86\xd0\xb2\xd0\xb5\xd1\x80;\xd0\xbf\xd1\x8f\xd1\x82\xd0\xbd"
"\xd1\x96\xd1\x86\xd0\xb0;\xd1\x81\xd1\x83\xd0\xb1\xd0\xbe\xd1\x82\xd0\xb0;\0"
"\xe1\x9e\xa2\xe1\x9e\xb6;\xe1\x9e\x85;\xe1\x9e\xa2;\xe1\x9e\x96\xe1\x9e\xbb;\xe1\x9e"
"\x96\xe1\x9f\x92\xe1\x9e\x9a;\xe1\x9e\x9f\xe1\x9e\xbb;\xe1\x9e\x9f;\0"
"\xe1\x9e\x90\xe1\x9f\x92\xe1\x9e\x84\xe1\x9f\x83\xe1\x9e\xa2\xe1\x9e\xb6\xe1\x9e\x91"
"\xe1\x9e\xb7\xe1\x9e\x8f\xe1\x9f\x92\xe1\x9e\x99;\xe2\x80\x8b\xe1\x9e\x90\xe1\x9f"
"\x92\xe1\x9e\x84\xe1\x9f\x83\xe1\x9e\x85\xe1\x9f\x90\xe1\x9e\x93\xe1\x9f\x92\xe1\x9e"
"\x91;\xe1\x9e\x90\xe1\x9f\x92\xe1\x9e\x84\xe1\x9f\x83\xe1\x9e\xa2\xe1\x9e\x84\xe1"
"\x9f\x92\xe1\x9e\x82\xe1\x9e\xb6\xe1\x9e\x9a;\xe1\x9e\x90\xe1\x9f\x92\xe1\x9e\x84"
"\xe1\x9f\x83\xe1\x9e\x96\xe1\x9e\xbb\xe1\x9e\x92;\xe1\x9e\x90\xe1\x9f\x92\xe1\x9e"
"\x84\xe1\x9f\x83\xe1\x9e\x96\xe1\x9f\x92\xe1\x9e\x9a\xe1\x9e\xa0\xe1\x9e\x9f\xe1\x9f"
"\x92\xe1\x9e\x94\xe1\x9e\x8f\xe1\x9e\xb7\xe1\x9f\x8d;\xe1\x9e\x90\xe1\x9f\x92\xe1"
"\x9e\x84\xe1\x9f\x83\xe1\x9e\x9f\xe1\x9e\xbb\xe1\x9e\x80\xe1\x9f\x92\xe1\x9e\x9a;"
"\xe1\x9e\x90\xe1\x9f\x92\xe1\x9e\x84\xe1\x9f\x83\xe1\x9e\x9f\xe1\x9f\x85\xe1\x9e\x9a"
"\xe1\x9f\x8d;\0"
"dg.;dl.;dt.;dc.;dj.;dv.;ds.;\0"
"diumenge;dilluns;dimarts;dimecres;dijous;divendres;dissabte;\0"
"\xe5\x91\xa8\xe6\x97\xa5;\xe5\x91\xa8\xe4\xb8\x80;\xe5\x91\xa8\xe4\xba\x8c;\xe5\x91"
"\xa8\xe4\xb8\x89;\xe5\x91\xa8\xe5\x9b\x9b;\xe5\x91\xa8\xe4\xba\x94;\xe5\x91\xa8\xe5"
"\x85\xad;\0"
"\xe6\x98\x9f\xe6\x9c\x9f\xe6\x97\xa5;\xe6\x98\x9f\xe6\x9c\x9f\xe4\xb8\x80;\xe6\x98"
"\x9f\xe6\x9c\x9f\xe4\xba\x8c;\xe6\x98\x9f\xe6\x9c\x9f\xe4\xb8\x89;\xe6\x98\x9f\xe6"
"\x9c\x9f\xe5\x9b\x9b;\xe6\x98\x9f\xe6\x9c\x9f\xe4\xba\x94;\xe6\x98\x9f\xe6\x9c\x9f"
"\xe5\x85\xad;\0"
"\xe9\x80\xb1\xe6\x97\xa5;\xe9\x80\xb1\xe4\xb8\x80;\xe5\x91\xa8\xe4\xba\x8c;\xe9\x80"
"\xb1\xe4\xb8\x89;\xe9\x80\xb1\xe5\x9b\x9b;\xe9\x80\xb1\xe4\xba\x94;\xe9\x80\xb1\xe5"
"\x85\xad;\0"
"ned;pon;uto;sri;\xc4\x8d\x65t;pet;sub;\0"
"nedjelja;ponedjeljak;utorak;srijeda;\xc4\x8d\x65tvrtak;petak;subota;\0"
"ne;po;\xc3\xbat;st;\xc4\x8dt;p\xc3\xa1;so;\0"
"ned\xc4\x9ble;pond\xc4\x9bl\xc3\xad;\xc3\xbater\xc3\xbd;st\xc5\x99\x65\x64\x61;\xc4"
"\x8dtvrtek;p\xc3\xa1tek;sobota;\0"
"s\xc3\xb8n;man;tir;ons;tor;fre;l\xc3\xb8r;\0"
"s\xc3\xb8ndag;mandag;tirsdag;onsdag;torsdag;fredag;l\xc3\xb8rdag;\0"
"zo;ma;di;wo;do;vr;za;\0"
"zondag;maandag;dinsdag;woensdag;donderdag;vrijdag;zaterdag;\0"
"P;E;T;K;N;R;L;\0"
"p\xc3\xbchap\xc3\xa4\x65v;esmasp\xc3\xa4\x65v;teisip\xc3\xa4\x65v;kolmap\xc3\xa4\x65"
"v;neljap\xc3\xa4\x65v;reede;laup\xc3\xa4\x65v;\0"
"sun;m\xc3\xa1n;t\xc3\xbds;mik;h\xc3\xb3s;fr\xc3\xad;ley;\0"
"sunnudagur;m\xc3\xa1nadagur;t\xc3\xbdsdagur;mikudagur;h\xc3\xb3sdagur;fr\xc3\xadg"
"gjadagur;leygardagur;\0"
"su;ma;ti;ke;to;pe;la;\0"
"sunnuntai;maanantai;tiistai;keskiviikko;torstai;perjantai;lauantai;\0"
"dim.;lun.;mar.;mer.;jeu.;ven.;sam.;\0"
"dimanche;lundi;mardi;mercredi;jeudi;vendredi;samedi;\0"
"Dom;Lun;Mar;M\xc3\xa9r;Xov;Ven;S\xc3\xa1\x62;\0"
"Domingo;Luns;Martes;M\xc3\xa9rcores;Xoves;Venres;S\xc3\xa1\x62\x61\x64o;\0"
"\xe1\x83\x99\xe1\x83\x95\xe1\x83\x98;\xe1\x83\x9d\xe1\x83\xa0\xe1\x83\xa8;\xe1\x83"
"\xa1\xe1\x83\x90\xe1\x83\x9b;\xe1\x83\x9d\xe1\x83\x97\xe1\x83\xae;\xe1\x83\xae\xe1"
"\x83\xa3\xe1\x83\x97;\xe1\x83\x9e\xe1\x83\x90\xe1\x83\xa0;\xe1\x83\xa8\xe1\x83\x90"
"\xe1\x83\x91;\0"
"\xe1\x83\x99\xe1\x83\x95\xe1\x83\x98\xe1\x83\xa0\xe1\x83\x90;\xe1\x83\x9d\xe1\x83"
"\xa0\xe1\x83\xa8\xe1\x83\x90\xe1\x83\x91\xe1\x83\x90\xe1\x83\x97\xe1\x83\x98;\xe1"
"\x83\xa1\xe1\x83\x90\xe1\x83\x9b\xe1\x83\xa8\xe1\x83\x90\xe1\x83\x91\xe1\x83\x90\xe1"
"\x83\x97\xe1\x83\x98;\xe1\x83\x9d\xe1\x83\x97\xe1\x83\xae\xe1\x83\xa8\xe1\x83\x90"
"\xe1\x83\x91\xe1\x83\x90\xe1\x83\x97\xe1\x83\x98;\xe1\x83\xae\xe1\x83\xa3\xe1\x83"
"\x97\xe1\x83\xa8\xe1\x83\x90\xe1\x83\x91\xe1\x83\x90\xe1\x83\x97\xe1\x83\x98;\xe1"
"\x83\x9e\xe1\x83\x90\xe1\x83\xa0\xe1\x83\x90\xe1\x83\xa1\xe1\x83\x99\xe1\x83\x94\xe1"
"\x83\x95\xe1\x83\x98;\xe1\x83\xa8\xe1\x83\x90\xe1\x83\x91\xe1\x83\x90\xe1\x83\x97"
"\xe1\x83\x98;\0"
"So;Mo;Di;Mi;Do;Fr;Sa;\0"
"Sonntag;Montag;Dienstag;Mittwoch;Donnerstag;Freitag;Samstag;\0"
"Son;Mon;Die;Mit;Don;Fre;Sam;\0"
"\xce\x9a\xcf\x85\xcf\x81;\xce\x94\xce\xb5\xcf\x85;\xce\xa4\xcf\x81\xce\xb9;\xce\xa4"
"\xce\xb5\xcf\x84;\xce\xa0\xce\xb5\xce\xbc;\xce\xa0\xce\xb1\xcf\x81;\xce\xa3\xce\xb1"
"\xce\xb2;\0"
"\xce\x9a\xcf\x85\xcf\x81\xce\xb9\xce\xb1\xce\xba\xce\xae;\xce\x94\xce\xb5\xcf\x85"
"\xcf\x84\xce\xad\xcf\x81\xce\xb1;\xce\xa4\xcf\x81\xce\xaf\xcf\x84\xce\xb7;\xce\xa4"
"\xce\xb5\xcf\x84\xce\xac\xcf\x81\xcf\x84\xce\xb7;\xce\xa0\xce\xad\xce\xbc\xcf\x80"
"\xcf\x84\xce\xb7;\xce\xa0\xce\xb1\xcf\x81\xce\xb1\xcf\x83\xce\xba\xce\xb5\xcf\x85"
"\xce\xae;\xce\xa3\xce\xac\xce\xb2\xce\xb2\xce\xb1\xcf\x84\xce\xbf;\0"
"sab;ata;mar;pin;sis;tal;arf;\0"
"sabaat;ataasinngorneq;marlunngorneq;pingasunngorneq;sisamanngorneq;tallimanngorne"
"q;arfininngorneq;\0"
"\xe0\xaa\xb0\xe0\xaa\xb5\xe0\xaa\xbf;\xe0\xaa\xb8\xe0\xab\x8b\xe0\xaa\xae;\xe0\xaa"
"\xae\xe0\xaa\x82\xe0\xaa\x97\xe0\xaa\xb3;\xe0\xaa\xac\xe0\xab\x81\xe0\xaa\xa7;\xe0"
"\xaa\x97\xe0\xab\x81\xe0\xaa\xb0\xe0\xab\x81;\xe0\xaa\xb6\xe0\xab\x81\xe0\xaa\x95"
"\xe0\xab\x8d\xe0\xaa\xb0;\xe0\xaa\xb6\xe0\xaa\xa8\xe0\xaa\xbf;\0"
"\xe0\xaa\xb0\xe0\xaa\xb5\xe0\xaa\xbf\xe0\xaa\xb5\xe0\xaa\xbe\xe0\xaa\xb0;\xe0\xaa"
"\xb8\xe0\xab\x8b\xe0\xaa\xae\xe0\xaa\xb5\xe0\xaa\xbe\xe0\xaa\xb0;\xe0\xaa\xae\xe0"
"\xaa\x82\xe0\xaa\x97\xe0\xaa\xb3\xe0\xaa\xb5\xe0\xaa\xbe\xe0\xaa\xb0;\xe0\xaa\xac"
"\xe0\xab\x81\xe0\xaa\xa7\xe0\xaa\xb5\xe0\xaa\xbe\xe0\xaa\xb0;\xe0\xaa\x97\xe0\xab"
"\x81\xe0\xaa\xb0\xe0\xab\x81\xe0\xaa\xb5\xe0\xaa\xbe\xe0\xaa\xb0;\xe0\xaa\xb6\xe0"
"\xab\x81\xe0\xaa\x95\xe0\xab\x8d\xe0\xaa\xb0\xe0\xaa\xb5\xe0\xaa\xbe\xe0\xaa\xb0;"
"\xe0\xaa\xb6\xe0\xaa\xa8\xe0\xaa\xbf\xe0\xaa\xb5\xe0\xaa\xbe\xe0\xaa\xb0;\0"
"Lah;Lit;Tal;Lar;Alh;Jum;Asa;\0"
"Lahadi;Littinin;Talata;Laraba;Alhamis;Jumma'a;Asabar;\0"
"\xd7\x90;\xd7\x91;\xd7\x92;\xd7\x93;\xd7\x94;\xd7\x95;\xd7\xa9;\0"
"\xd7\x99\xd7\x95\xd7\x9d \xd7\xa8\xd7\x90\xd7\xa9\xd7\x95\xd7\x9f;\xd7\x99\xd7\x95"
"\xd7\x9d \xd7\xa9\xd7\xa0\xd7\x99;\xd7\x99\xd7\x95\xd7\x9d \xd7\xa9\xd7\x9c\xd7\x99"
"\xd7\xa9\xd7\x99;\xd7\x99\xd7\x95\xd7\x9d \xd7\xa8\xd7\x91\xd7\x99\xd7\xa2\xd7\x99"
";\xd7\x99\xd7\x95\xd7\x9d \xd7\x97\xd7\x9e\xd7\x99\xd7\xa9\xd7\x99;\xd7\x99\xd7\x95"
"\xd7\x9d \xd7\xa9\xd7\x99\xd7\xa9\xd7\x99;\xd7\xa9\xd7\x91\xd7\xaa;\0"
"\xe0\xa4\xb0\xe0\xa4\xb5\xe0\xa4\xbf;\xe0\xa4\xb8\xe0\xa5\x8b\xe0\xa4\xae;\xe0\xa4"
"\xae\xe0\xa4\x82\xe0\xa4\x97\xe0\xa4\xb2;\xe0\xa4\xac\xe0\xa5\x81\xe0\xa4\xa7;\xe0"
"\xa4\x97\xe0\xa5\x81\xe0\xa4\xb0\xe0\xa5\x81;\xe0\xa4\xb6\xe0\xa5\x81\xe0\xa4\x95"
"\xe0\xa5\x8d\xe0\xa4\xb0;\xe0\xa4\xb6\xe0\xa4\xa8\xe0\xa4\xbf;\0"
"\xe0\xa4\xb0\xe0\xa4\xb5\xe0\xa4\xbf\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4"
"\xb8\xe0\xa5\x8b\xe0\xa4\xae\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\xae\xe0"
"\xa4\x82\xe0\xa4\x97\xe0\xa4\xb2\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\xac"
"\xe0\xa5\x81\xe0\xa4\xa7\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\x97\xe0\xa5"
"\x81\xe0\xa4\xb0\xe0\xa5\x81\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\xb6\xe0"
"\xa5\x81\xe0\xa4\x95\xe0\xa5\x8d\xe0\xa4\xb0\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;"
"\xe0\xa4\xb6\xe0\xa4\xa8\xe0\xa4\xbf\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\0"
"V;H;K;Sze;Cs;P;Szo;\0"
"vas\xc3\xa1rnap;h\xc3\xa9tf\xc5\x91;kedd;szerda;cs\xc3\xbct\xc3\xb6rt\xc3\xb6k;p\xc3"
"\xa9ntek;szombat;\0"
"sun;m\xc3\xa1n;\xc3\xberi;mi\xc3\xb0;fim;f\xc3\xb6s;lau;\0"
"sunnudagur;m\xc3\xa1nudagur;\xc3\xberi\xc3\xb0judagur;mi\xc3\xb0vikudagur;fimmtud"
"agur;f\xc3\xb6studagur;laugardagur;\0"
"Min;Sen;Sel;Rab;Kam;Jum;Sab;\0"
"Minggu;Senin;Selasa;Rabu;Kamis;Jumat;Sabtu;\0"
"Domh;Luan;M\xc3\xa1irt;C\xc3\xa9\x61\x64;D\xc3\xa9\x61r;Aoine;Sath;\0"
"D\xc3\xa9 Domhnaigh;D\xc3\xa9 Luain;D\xc3\xa9 M\xc3\xa1irt;D\xc3\xa9 C\xc3\xa9\x61"
"\x64\x61oin;D\xc3\xa9\x61rdaoin;D\xc3\xa9 hAoine;D\xc3\xa9 Sathairn;\0"
"dom;lun;mar;mer;gio;ven;sab;\0"
"domenica;luned\xc3\xac;marted\xc3\xac;mercoled\xc3\xac;gioved\xc3\xac;venerd\xc3\xac"
";sabato;\0"
"\xe6\x97\xa5;\xe6\x9c\x88;\xe7\x81\xab;\xe6\xb0\xb4;\xe6\x9c\xa8;\xe9\x87\x91;\xe5"
"\x9c\x9f;\0"
"\xe6\x97\xa5\xe6\x9b\x9c\xe6\x97\xa5;\xe6\x9c\x88\xe6\x9b\x9c\xe6\x97\xa5;\xe7\x81"
"\xab\xe6\x9b\x9c\xe6\x97\xa5;\xe6\xb0\xb4\xe6\x9b\x9c\xe6\x97\xa5;\xe6\x9c\xa8\xe6"
"\x9b\x9c\xe6\x97\xa5;\xe9\x87\x91\xe6\x9b\x9c\xe6\x97\xa5;\xe5\x9c\x9f\xe6\x9b\x9c"
"\xe6\x97\xa5;\0"
"\xe0\xb2\xb0.;\xe0\xb2\xb8\xe0\xb3\x8b.;\xe0\xb2\xae\xe0\xb2\x82.;\xe0\xb2\xac\xe0"
"\xb3\x81.;\xe0\xb2\x97\xe0\xb3\x81.;\xe0\xb2\xb6\xe0\xb3\x81.;\xe0\xb2\xb6\xe0\xb2"
"\xa8\xe0\xb2\xbf.;\0"
"\xe0\xb2\xb0\xe0\xb2\xb5\xe0\xb2\xbf\xe0\xb2\xb5\xe0\xb2\xbe\xe0\xb2\xb0;\xe0\xb2"
"\xb8\xe0\xb3\x8b\xe0\xb2\xae\xe0\xb2\xb5\xe0\xb2\xbe\xe0\xb2\xb0;\xe0\xb2\xae\xe0"
"\xb2\x82\xe0\xb2\x97\xe0\xb2\xb3\xe0\xb2\xb5\xe0\xb2\xbe\xe0\xb2\xb0;\xe0\xb2\xac"
"\xe0\xb3\x81\xe0\xb2\xa7\xe0\xb2\xb5\xe0\xb2\xbe\xe0\xb2\xb0;\xe0\xb2\x97\xe0\xb3"
"\x81\xe0\xb2\xb0\xe0\xb3\x81\xe0\xb2\xb5\xe0\xb2\xbe\xe0\xb2\xb0;\xe0\xb2\xb6\xe0"
"\xb3\x81\xe0\xb2\x95\xe0\xb3\x8d\xe0\xb2\xb0\xe0\xb2\xb5\xe0\xb2\xbe\xe0\xb2\xb0;"
"\xe0\xb2\xb6\xe0\xb2\xa8\xe0\xb2\xbf\xe0\xb2\xb5\xe0\xb2\xbe\xe0\xb2\xb0;\0"
"\xd0\xb6\xd1\x81.;\xd0\xb4\xd1\x81.;\xd1\x81\xd1\x81.;\xd1\x81\xd1\x80.;\xd0\xb1\xd1"
"\x81.;\xd0\xb6\xd0\xbc.;\xd1\x81\xd2\xbb.;\0"
"\xd0\xb6\xd0\xb5\xd0\xba\xd1\x81\xd0\xb5\xd0\xbd\xd1\x96;\xd0\xb4\xd1\x83\xd0\xb9"
"\xd1\x81\xd0\xb5\xd0\xbd\xd0\xb1\xd1\x96;\xd1\x81\xd0\xb5\xd0\xb9\xd1\x81\xd0\xb5"
"\xd0\xbd\xd0\xb1\xd1\x96;\xd1\x81\xd3\x99\xd1\x80\xd0\xb5\xd0\xbd\xd0\xb1\xd1\x96"
";\xd0\xb1\xd0\xb5\xd0\xb9\xd1\x81\xd0\xb5\xd0\xbd\xd0\xb1\xd1\x96;\xd0\xb6\xd2\xb1"
"\xd0\xbc\xd0\xb0;\xd1\x81\xd0\xb5\xd0\xbd\xd0\xb1\xd1\x96;\0"
"cyu.;mbe.;kab.;gtu.;kan.;gnu.;gnd.;\0"
"Ku cyumweru;Kuwa mbere;Kuwa kabiri;Kuwa gatatu;Kuwa kane;Kuwa gatanu;Kuwa gatanda"
"tu;\0"
"1;2;3;4;5;6;7;\0"
"\xec\x9d\xbc;\xec\x9b\x94;\xed\x99\x94;\xec\x88\x98;\xeb\xaa\xa9;\xea\xb8\x88;\xed"
"\x86\xa0;\0"
"\xec\x9d\xbc\xec\x9a\x94\xec\x9d\xbc;\xec\x9b\x94\xec\x9a\x94\xec\x9d\xbc;\xed\x99"
"\x94\xec\x9a\x94\xec\x9d\xbc;\xec\x88\x98\xec\x9a\x94\xec\x9d\xbc;\xeb\xaa\xa9\xec"
"\x9a\x94\xec\x9d\xbc;\xea\xb8\x88\xec\x9a\x94\xec\x9d\xbc;\xed\x86\xa0\xec\x9a\x94"
"\xec\x9d\xbc;\0"
"y\xc5\x9f;d\xc5\x9f;s\xc5\x9f;\xc3\xa7\xc5\x9f;p\xc5\x9f;\xc3\xaen;\xc5\x9f;\0"
"yek\xc5\x9f\x65m;du\xc5\x9f\x65m;\xc5\x9f\xc3\xaa;\xc3\xa7\x61r\xc5\x9f\x65m;p\xc3"
"\xaanc\xc5\x9f\x65m;\xc3\xaen;\xc5\x9f\x65m\xc3\xae;\0"
"\xe0\xba\xad\xe0\xba\xb2.;\xe0\xba\x88.;\xe0\xba\xad.;\xe0\xba\x9e.;\xe0\xba\x9e\xe0"
"\xba\xab.;\xe0\xba\xaa\xe0\xba\x81.;\xe0\xba\xaa.;\0"
"\xe0\xba\xa7\xe0\xba\xb1\xe0\xba\x99\xe0\xba\xad\xe0\xba\xb2\xe0\xba\x97\xe0\xba\xb4"
"\xe0\xba\x94;\xe0\xba\xa7\xe0\xba\xb1\xe0\xba\x99\xe0\xba\x88\xe0\xba\xb1\xe0\xba"
"\x99;\xe0\xba\xa7\xe0\xba\xb1\xe0\xba\x99\xe0\xba\xad\xe0\xba\xb1\xe0\xba\x87\xe0"
"\xba\x84\xe0\xba\xb2\xe0\xba\x99;\xe0\xba\xa7\xe0\xba\xb1\xe0\xba\x99\xe0\xba\x9e"
"\xe0\xba\xb8\xe0\xba\x94;\xe0\xba\xa7\xe0\xba\xb1\xe0\xba\x99\xe0\xba\x9e\xe0\xba"
"\xb0\xe0\xba\xab\xe0\xba\xb1\xe0\xba\x94;\xe0\xba\xa7\xe0\xba\xb1\xe0\xba\x99\xe0"
"\xba\xaa\xe0\xba\xb8\xe0\xba\x81;\xe0\xba\xa7\xe0\xba\xb1\xe0\xba\x99\xe0\xbb\x80"
"\xe0\xba\xaa\xe0\xba\xbb\xe0\xba\xb2;\0"
"Sv;P;O;T;C;Pk;S;\0"
"sv\xc4\x93tdiena;pirmdiena;otrdiena;tre\xc5\xa1\x64iena;ceturtdiena;piektdiena;se"
"stdiena;\0"
"eye;m1;m2;m3;m4;m5;mps;\0"
"eyenga;mok\xc9\x94l\xc9\x94 ya libos\xc3\xb3;mok\xc9\x94l\xc9\x94 ya m\xc3\xad\x62"
"\x61l\xc3\xa9;mok\xc9\x94l\xc9\x94 ya m\xc3\xads\xc3\xa1to;mok\xc9\x94l\xc9\x94 y"
"a m\xc3\xadn\xc3\xa9i;mok\xc9\x94l\xc9\x94 ya m\xc3\xadt\xc3\xa1no;mp\xc9\x94\xcc"
"\x81s\xc9\x94;\0"
"Sk;Pr;An;Tr;Kt;Pn;\xc5\xa0t;\0"
"sekmadienis;pirmadienis;antradienis;tre\xc4\x8diadienis;ketvirtadienis;penktadien"
"is;\xc5\xa1\x65\xc5\xa1tadienis;\0"
"\xd0\xbd\xd0\xb5\xd0\xb4.;\xd0\xbf\xd0\xbe\xd0\xbd.;\xd0\xb2\xd1\x82.;\xd1\x81\xd1"
"\x80\xd0\xb5.;\xd1\x87\xd0\xb5\xd1\x82.;\xd0\xbf\xd0\xb5\xd1\x82.;\xd1\x81\xd0\xb0"
"\xd0\xb1.;\0"
"\xd0\xbd\xd0\xb5\xd0\xb4\xd0\xb5\xd0\xbb\xd0\xb0;\xd0\xbf\xd0\xbe\xd0\xbd\xd0\xb5"
"\xd0\xb4\xd0\xb5\xd0\xbb\xd0\xbd\xd0\xb8\xd0\xba;\xd0\xb2\xd1\x82\xd0\xbe\xd1\x80"
"\xd0\xbd\xd0\xb8\xd0\xba;\xd1\x81\xd1\x80\xd0\xb5\xd0\xb4\xd0\xb0;\xd1\x87\xd0\xb5"
"\xd1\x82\xd0\xb2\xd1\x80\xd1\x82\xd0\xbe\xd0\xba;\xd0\xbf\xd0\xb5\xd1\x82\xd0\xbe"
"\xd0\xba;\xd1\x81\xd0\xb0\xd0\xb1\xd0\xbe\xd1\x82\xd0\xb0;\0"
"Ahd;Isn;Sel;Rab;Kha;Jum;Sab;\0"
"Ahad;Isnin;Selasa;Rabu;Khamis;Jumaat;Sabtu;\0"
"\xe0\xb4\x9e\xe0\xb4\xbe;\xe0\xb4\xa4\xe0\xb4\xbf;\xe0\xb4\x9a\xe0\xb5\x8a;\xe0\xb4"
"\xac\xe0\xb5\x81;\xe0\xb4\xb5\xe0\xb5\x8d\xe0\xb4\xaf;\xe0\xb4\xb5\xe0\xb5\x86;\xe0"
"\xb4\xb6;\0"
"\xe0\xb4\x9e\xe0\xb4\xbe\xe0\xb4\xaf\xe0\xb4\xb1\xe0\xb5\x8d\xe0\xb4\x85;\xe0\xb4"
"\xa4\xe0\xb4\xbf\xe0\xb4\x99\xe0\xb5\x8d\xe0\xb4\x95\xe0\xb4\xb3\xe0\xb5\x8d\xe0\xb4"
"\x85;\xe0\xb4\x9a\xe0\xb5\x8a\xe0\xb4\xb5\xe0\xb5\x8d\xe0\xb4\xb5;\xe0\xb4\xac\xe0"
"\xb5\x81\xe0\xb4\xa8\xe0\xb4\xad\xe0\xb5\x8d\xe0\xb4\x85;\xe0\xb4\xb5\xe0\xb5\x8d"
"\xe0\xb4\xaf\xe0\xb4\xbe\xe0\xb4\xb4\xe0\xb4\x82;\xe0\xb4\xb5\xe0\xb5\x86\xe0\xb4"
"\xb3\xe0\xb5\x8d\xe0\xb4\xb3\xe0\xb4\xbf;\xe0\xb4\xb6\xe0\xb4\xa8\xe0\xb4\xbf;\0"
"\xc4\xa6\x61\x64;Tne;Tli;Erb;\xc4\xa6\x61m;\xc4\xa0im;Sib;\0"
"Il-\xc4\xa6\x61\x64\x64;It-Tnejn;It-Tlieta;L-Erbg\xc4\xa7\x61;Il-\xc4\xa6\x61mis;"
"Il-\xc4\xa0img\xc4\xa7\x61;Is-Sibt;\0"
"\xe0\xa4\xb0\xe0\xa4\xb5\xe0\xa4\xbf;\xe0\xa4\xb8\xe0\xa5\x8b\xe0\xa4\xae;\xe0\xa4"
"\xae\xe0\xa4\x82\xe0\xa4\x97\xe0\xa4\xb3;\xe0\xa4\xac\xe0\xa5\x81\xe0\xa4\xa7;\xe0"
"\xa4\x97\xe0\xa5\x81\xe0\xa4\xb0\xe0\xa5\x81;\xe0\xa4\xb6\xe0\xa5\x81\xe0\xa4\x95"
"\xe0\xa5\x8d\xe0\xa4\xb0;\xe0\xa4\xb6\xe0\xa4\xa8\xe0\xa4\xbf;\0"
"\xe0\xa4\xb0\xe0\xa4\xb5\xe0\xa4\xbf\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4"
"\xb8\xe0\xa5\x8b\xe0\xa4\xae\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\xae\xe0"
"\xa4\x82\xe0\xa4\x97\xe0\xa4\xb3\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\xac"
"\xe0\xa5\x81\xe0\xa4\xa7\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\x97\xe0\xa5"
"\x81\xe0\xa4\xb0\xe0\xa5\x81\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\xb6\xe0"
"\xa5\x81\xe0\xa4\x95\xe0\xa5\x8d\xe0\xa4\xb0\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;"
"\xe0\xa4\xb6\xe0\xa4\xa8\xe0\xa4\xbf\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\0"
"\xd0\x9d\xd1\x8f;\xd0\x94\xd0\xb0;\xd0\x9c\xd1\x8f;\xd0\x9b\xd1\x85;\xd0\x9f\xd2\xaf"
";\xd0\x91\xd0\xb0;\xd0\x91\xd1\x8f;\0"
"\xd0\xbd\xd1\x8f\xd0\xbc;\xd0\xb4\xd0\xb0\xd0\xb2\xd0\xb0\xd0\xb0;\xd0\xbc\xd1\x8f"
"\xd0\xb3\xd0\xbc\xd0\xb0\xd1\x80;\xd0\xbb\xd1\x85\xd0\xb0\xd0\xb3\xd0\xb2\xd0\xb0"
";\xd0\xbf\xd2\xaf\xd1\x80\xd1\x8d\xd0\xb2;\xd0\xb1\xd0\xb0\xd0\xb0\xd1\x81\xd0\xb0"
"\xd0\xbd;\xd0\xb1\xd1\x8f\xd0\xbc\xd0\xb1\xd0\xb0;\0"
"\xe0\xa4\x86\xe0\xa4\x87\xe0\xa4\xa4;\xe0\xa4\xb8\xe0\xa5\x8b\xe0\xa4\xae;\xe0\xa4"
"\xae\xe0\xa4\x99\xe0\xa5\x8d\xe0\xa4\x97\xe0\xa4\xb2;\xe0\xa4\xac\xe0\xa5\x81\xe0"
"\xa4\xa7;\xe0\xa4\xac\xe0\xa4\xbf\xe0\xa4\xb9\xe0\xa5\x80;\xe0\xa4\xb6\xe0\xa5\x81"
"\xe0\xa4\x95\xe0\xa5\x8d\xe0\xa4\xb0;\xe0\xa4\xb6\xe0\xa4\xa8\xe0\xa4\xbf;\0"
"\xe0\xa4\x86\xe0\xa4\x87\xe0\xa4\xa4\xe0\xa4\xac\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4"
"\xb8\xe0\xa5\x8b\xe0\xa4\xae\xe0\xa4\xac\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\xae\xe0"
"\xa4\x99\xe0\xa5\x8d\xe0\xa4\x97\xe0\xa4\xb2\xe0\xa4\xac\xe0\xa4\xbe\xe0\xa4\xb0;"
"\xe0\xa4\xac\xe0\xa5\x81\xe0\xa4\xa7\xe0\xa4\xac\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4"
"\xac\xe0\xa4\xbf\xe0\xa4\xb9\xe0\xa5\x80\xe0\xa4\xac\xe0\xa4\xbe\xe0\xa4\xb0;\xe0"
"\xa4\xb6\xe0\xa5\x81\xe0\xa4\x95\xe0\xa5\x8d\xe0\xa4\xb0\xe0\xa4\xac\xe0\xa4\xbe\xe0"
"\xa4\xb0;\xe0\xa4\xb6\xe0\xa4\xa8\xe0\xa4\xbf\xe0\xa4\xac\xe0\xa4\xbe\xe0\xa4\xb0"
";\0"
"s\xc3\xb8.;ma.;ti.;on.;to.;fr.;l\xc3\xb8.;\0"
"\xe0\xac\xb0\xe0\xac\xac\xe0\xac\xbf;\xe0\xac\xb8\xe0\xad\x8b\xe0\xac\xae;\xe0\xac"
"\xae\xe0\xac\x99\xe0\xad\x8d\xe0\xac\x97\xe0\xac\xb3;\xe0\xac\xac\xe0\xad\x81\xe0"
"\xac\xa7;\xe0\xac\x97\xe0\xad\x81\xe0\xac\xb0\xe0\xad\x81;\xe0\xac\xb6\xe0\xad\x81"
"\xe0\xac\x95\xe0\xad\x8d\xe0\xac\xb0;\xe0\xac\xb6\xe0\xac\xa8\xe0\xac\xbf;\0"
"\xe0\xac\xb0\xe0\xac\xac\xe0\xac\xbf\xe0\xac\xac\xe0\xac\xbe\xe0\xac\xb0;\xe0\xac"
"\xb8\xe0\xad\x8b\xe0\xac\xae\xe0\xac\xac\xe0\xac\xbe\xe0\xac\xb0;\xe0\xac\xae\xe0"
"\xac\x99\xe0\xad\x8d\xe0\xac\x97\xe0\xac\xb3\xe0\xac\xac\xe0\xac\xbe\xe0\xac\xb0;"
"\xe0\xac\xac\xe0\xad\x81\xe0\xac\xa7\xe0\xac\xac\xe0\xac\xbe\xe0\xac\xb0;\xe0\xac"
"\x97\xe0\xad\x81\xe0\xac\xb0\xe0\xad\x81\xe0\xac\xac\xe0\xac\xbe\xe0\xac\xb0;\xe0"
"\xac\xb6\xe0\xad\x81\xe0\xac\x95\xe0\xad\x8d\xe0\xac\xb0\xe0\xac\xac\xe0\xac\xbe\xe0"
"\xac\xb0;\xe0\xac\xb6\xe0\xac\xa8\xe0\xac\xbf\xe0\xac\xac\xe0\xac\xbe\xe0\xac\xb0"
";\0"
"\xdb\x8c\xda\xa9\xd8\xb4\xd9\x86\xd8\xa8\xd9\x87;\xd8\xaf\xd9\x88\xd8\xb4\xd9\x86"
"\xd8\xa8\xd9\x87;\xd8\xb3\xd9\x87\xe2\x80\x8c\xd8\xb4\xd9\x86\xd8\xa8\xd9\x87;\xda"
"\x86\xd9\x87\xd8\xa7\xd8\xb1\xd8\xb4\xd9\x86\xd8\xa8\xd9\x87;\xd9\xbe\xd9\x86\xd8"
"\xac\xd8\xb4\xd9\x86\xd8\xa8\xd9\x87;\xd8\xac\xd9\x85\xd8\xb9\xd9\x87;\xd8\xb4\xd9"
"\x86\xd8\xa8\xd9\x87;\0"
"niedz.;pon.;wt.;\xc5\x9br.;czw.;pt.;sob.;\0"
"niedziela;poniedzia\xc5\x82\x65k;wtorek;\xc5\x9broda;czwartek;pi\xc4\x85tek;sobot"
"a;\0"
"dom;seg;ter;qua;qui;sex;s\xc3\xa1\x62;\0"
"domingo;segunda-feira;ter\xc3\xa7\x61-feira;quarta-feira;quinta-feira;sexta-feira"
";s\xc3\xa1\x62\x61\x64o;\0"
"\xe0\xa8\x90\xe0\xa8\xa4.;\xe0\xa8\xb8\xe0\xa9\x8b\xe0\xa8\xae.;\xe0\xa8\xae\xe0\xa9"
"\xb0\xe0\xa8\x97\xe0\xa8\xb2.;\xe0\xa8\xac\xe0\xa9\x81\xe0\xa8\xa7.;\xe0\xa8\xb5\xe0"
"\xa9\x80\xe0\xa8\xb0.;\xe0\xa8\xb8\xe0\xa8\xbc\xe0\xa9\x81\xe0\xa8\x95\xe0\xa8\xb0"
".;\xe0\xa8\xb8\xe0\xa8\xbc\xe0\xa8\xa8\xe0\xa9\x80.;\0"
"\xe0\xa8\x90\xe0\xa8\xa4\xe0\xa8\xb5\xe0\xa8\xbe\xe0\xa8\xb0;\xe0\xa8\xb8\xe0\xa9"
"\x8b\xe0\xa8\xae\xe0\xa8\xb5\xe0\xa8\xbe\xe0\xa8\xb0;\xe0\xa8\xae\xe0\xa9\xb0\xe0"
"\xa8\x97\xe0\xa8\xb2\xe0\xa8\xb5\xe0\xa8\xbe\xe0\xa8\xb0;\xe0\xa8\xac\xe0\xa9\x81"
"\xe0\xa8\xa7\xe0\xa8\xb5\xe0\xa8\xbe\xe0\xa8\xb0;\xe0\xa8\xb5\xe0\xa9\x80\xe0\xa8"
"\xb0\xe0\xa8\xb5\xe0\xa8\xbe\xe0\xa8\xb0;\xe0\xa8\xb8\xe0\xa8\xbc\xe0\xa9\x81\xe0"
"\xa9\xb1\xe0\xa8\x95\xe0\xa8\xb0\xe0\xa8\xb5\xe0\xa8\xbe\xe0\xa8\xb0;\xe0\xa8\xb8"
"\xe0\xa8\xbc\xe0\xa8\xa8\xe0\xa9\x80\xe0\xa8\x9a\xe0\xa8\xb0\xe0\xa8\xb5\xe0\xa8\xbe"
"\xe0\xa8\xb0;\0"
"D;L;Ma;Mi;J;V;S;\0"
"duminic\xc4\x83;luni;mar\xc8\x9bi;miercuri;joi;vineri;s\xc3\xaemb\xc4\x83t\xc4\x83"
";\0"
"\xd0\x92\xd1\x81;\xd0\x9f\xd0\xbd;\xd0\x92\xd1\x82;\xd0\xa1\xd1\x80;\xd0\xa7\xd1\x82"
";\xd0\x9f\xd1\x82;\xd0\xa1\xd0\xb1;\0"
"\xd0\xb2\xd0\xbe\xd1\x81\xd0\xba\xd1\x80\xd0\xb5\xd1\x81\xd0\xb5\xd0\xbd\xd1\x8c\xd0"
"\xb5;\xd0\xbf\xd0\xbe\xd0\xbd\xd0\xb5\xd0\xb4\xd0\xb5\xd0\xbb\xd1\x8c\xd0\xbd\xd0"
"\xb8\xd0\xba;\xd0\xb2\xd1\x82\xd0\xbe\xd1\x80\xd0\xbd\xd0\xb8\xd0\xba;\xd1\x81\xd1"
"\x80\xd0\xb5\xd0\xb4\xd0\xb0;\xd1\x87\xd0\xb5\xd1\x82\xd0\xb2\xd0\xb5\xd1\x80\xd0"
"\xb3;\xd0\xbf\xd1\x8f\xd1\x82\xd0\xbd\xd0\xb8\xd1\x86\xd0\xb0;\xd1\x81\xd1\x83\xd0"
"\xb1\xd0\xb1\xd0\xbe\xd1\x82\xd0\xb0;\0"
"\xd0\xbd\xd0\xb5\xd0\xb4;\xd0\xbf\xd0\xbe\xd0\xbd;\xd1\x83\xd1\x82\xd0\xbe;\xd1\x81"
"\xd1\x80\xd0\xb5;\xd1\x87\xd0\xb5\xd1\x82;\xd0\xbf\xd0\xb5\xd1\x82;\xd1\x81\xd1\x83"
"\xd0\xb1;\0"
"\xd0\xbd\xd0\xb5\xd0\xb4\xd0\xb5\xd1\x99\xd0\xb0;\xd0\xbf\xd0\xbe\xd0\xbd\xd0\xb5"
"\xd0\xb4\xd0\xb5\xd1\x99\xd0\xb0\xd0\xba;\xd1\x83\xd1\x82\xd0\xbe\xd1\x80\xd0\xb0"
"\xd0\xba;\xd1\x81\xd1\x80\xd0\xb5\xd0\xb4\xd0\xb0;\xd1\x87\xd0\xb5\xd1\x82\xd0\xb2"
"\xd1\x80\xd1\x82\xd0\xb0\xd0\xba;\xd0\xbf\xd0\xb5\xd1\x82\xd0\xb0\xd0\xba;\xd1\x81"
"\xd1\x83\xd0\xb1\xd0\xbe\xd1\x82\xd0\xb0;\0"
"\xd0\xbd\xd0\xb5\xd0\xb4;\xd0\xbf\xd0\xbe\xd0\xbd;\xd1\x83\xd1\x82\xd0\xbe;\xd1\x81"
"\xd1\x80\xd0\xb8;\xd1\x87\xd0\xb5\xd1\x82;\xd0\xbf\xd0\xb5\xd1\x82;\xd1\x81\xd1\x83"
"\xd0\xb1;\0"
"\xd0\xbd\xd0\xb5\xd0\xb4\xd0\xb5\xd1\x99\xd0\xb0;\xd0\xbf\xd0\xbe\xd0\xbd\xd0\xb5"
"\xd0\xb4\xd0\xb5\xd1\x99\xd0\xb0\xd0\xba;\xd1\x83\xd1\x82\xd0\xbe\xd1\x80\xd0\xb0"
"\xd0\xba;\xd1\x81\xd1\x80\xd0\xb8\xd1\x98\xd0\xb5\xd0\xb4\xd0\xb0;\xd1\x87\xd0\xb5"
"\xd1\x82\xd0\xb2\xd1\x80\xd1\x82\xd0\xb0\xd0\xba;\xd0\xbf\xd0\xb5\xd1\x82\xd0\xb0"
"\xd0\xba;\xd1\x81\xd1\x83\xd0\xb1\xd0\xbe\xd1\x82\xd0\xb0;\0"
"ned;pon;uto;sre;\xc4\x8d\x65t;pet;sub;\0"
"nedelja;ponedeljak;utorak;sreda;\xc4\x8d\x65tvrtak;petak;subota;\0"
"nedelja;ponedeljak;utorak;srijeda;\xc4\x8d\x65tvrtak;petak;subota;\0"
"Son;Mma;Bed;Rar;Ne;Hla;Moq;\0"
"Sontaha;Mmantaha;Labobedi;Laboraru;Labone;Labohlane;Moqebelo;\0"
"Tsh;Mos;Bed;Rar;Ne;Tla;Mat;\0"
"Tshipi;Mosopulogo;Labobedi;Laboraro;Labone;Labotlhano;Matlhatso;\0"
"Son;Mso;Bil;Tsa;Ne;Hla;Mgc;\0"
"Lisontfo;uMsombuluko;Lesibili;Lesitsatfu;Lesine;Lesihlanu;uMgcibelo;\0"
"Ne;Po;Ut;St;\xc5\xa0t;Pi;So;\0"
"Nede\xc4\xbe\x61;Pondelok;Utorok;Streda;\xc5\xa0tvrtok;Piatok;Sobota;\0"
"ned;pon;tor;sre;\xc4\x8d\x65t;pet;sob;\0"
"nedelja;ponedeljek;torek;sreda;\xc4\x8d\x65trtek;petek;sobota;\0"
"Axa;Isn;Sal;Arb;Kha;Jim;Sab;\0"
"Axad;Isniin;Salaaso;Arbaco;Khamiis;Jimco;Sabti;\0"
"dom;lun;mar;mi\xc3\xa9;jue;vie;s\xc3\xa1\x62;\0"
"domingo;lunes;martes;mi\xc3\xa9rcoles;jueves;viernes;s\xc3\xa1\x62\x61\x64o;\0"
"Jpi;Jtt;Jnn;Jtn;Alh;Iju;Jmo;\0"
"Jumapili;Jumatatu;Jumanne;Jumatano;Alhamisi;Ijumaa;Jumamosi;\0"
"s\xc3\xb6;m\xc3\xa5;ti;on;to;fr;l\xc3\xb6;\0"
"s\xc3\xb6ndag;m\xc3\xa5ndag;tisdag;onsdag;torsdag;fredag;l\xc3\xb6rdag;\0"
"\xd0\xaf\xd1\x88\xd0\xb1;\xd0\x94\xd1\x88\xd0\xb1;\xd0\xa1\xd1\x88\xd0\xb1;\xd0\xa7"
"\xd1\x88\xd0\xb1;\xd0\x9f\xd1\x88\xd0\xb1;\xd2\xb6\xd0\xbc\xd1\x8a;\xd0\xa8\xd0\xbd"
"\xd0\xb1;\0"
"\xd0\xaf\xd0\xba\xd1\x88\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb5;\xd0\x94\xd1\x83\xd1\x88"
"\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb5;\xd0\xa1\xd0\xb5\xd1\x88\xd0\xb0\xd0\xbd\xd0\xb1"
"\xd0\xb5;\xd0\xa7\xd0\xbe\xd1\x80\xd1\x88\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb5;\xd0\x9f"
"\xd0\xb0\xd0\xbd\xd2\xb7\xd1\x88\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb5;\xd2\xb6\xd1\x83"
"\xd0\xbc\xd1\x8a\xd0\xb0;\xd0\xa8\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb5;\0"
"\xe0\xae\x9e\xe0\xae\xbe;\xe0\xae\xa4\xe0\xae\xbf;\xe0\xae\x9a\xe0\xaf\x86;\xe0\xae"
"\xaa\xe0\xaf\x81;\xe0\xae\xb5\xe0\xae\xbf;\xe0\xae\xb5\xe0\xaf\x86;\xe0\xae\x9a;\0"
"\xe0\xae\x9e\xe0\xae\xbe\xe0\xae\xaf\xe0\xae\xbf\xe0\xae\xb1\xe0\xaf\x81;\xe0\xae"
"\xa4\xe0\xae\xbf\xe0\xae\x99\xe0\xaf\x8d\xe0\xae\x95\xe0\xae\xb3\xe0\xaf\x8d;\xe0"
"\xae\x9a\xe0\xaf\x86\xe0\xae\xb5\xe0\xaf\x8d\xe0\xae\xb5\xe0\xae\xbe\xe0\xae\xaf\xe0"
"\xaf\x8d;\xe0\xae\xaa\xe0\xaf\x81\xe0\xae\xa4\xe0\xae\xa9\xe0\xaf\x8d;\xe0\xae\xb5"
"\xe0\xae\xbf\xe0\xae\xaf\xe0\xae\xbe\xe0\xae\xb4\xe0\xae\xa9\xe0\xaf\x8d;\xe0\xae"
"\xb5\xe0\xaf\x86\xe0\xae\xb3\xe0\xaf\x8d\xe0\xae\xb3\xe0\xae\xbf;\xe0\xae\x9a\xe0"
"\xae\xa9\xe0\xae\xbf;\0"
"\xe0\xb0\x86\xe0\xb0\xa6\xe0\xb0\xbf;\xe0\xb0\xb8\xe0\xb1\x8b\xe0\xb0\xae;\xe0\xb0"
"\xae\xe0\xb0\x82\xe0\xb0\x97\xe0\xb0\xb3;\xe0\xb0\xac\xe0\xb1\x81\xe0\xb0\xa7;\xe0"
"\xb0\x97\xe0\xb1\x81\xe0\xb0\xb0\xe0\xb1\x81;\xe0\xb0\xb6\xe0\xb1\x81\xe0\xb0\x95"
"\xe0\xb1\x8d\xe0\xb0\xb0;\xe0\xb0\xb6\xe0\xb0\xa8\xe0\xb0\xbf;\0"
"\xe0\xb0\x86\xe0\xb0\xa6\xe0\xb0\xbf\xe0\xb0\xb5\xe0\xb0\xbe\xe0\xb0\xb0\xe0\xb0\x82"
";\xe0\xb0\xb8\xe0\xb1\x8b\xe0\xb0\xae\xe0\xb0\xb5\xe0\xb0\xbe\xe0\xb0\xb0\xe0\xb0"
"\x82;\xe0\xb0\xae\xe0\xb0\x82\xe0\xb0\x97\xe0\xb0\xb3\xe0\xb0\xb5\xe0\xb0\xbe\xe0"
"\xb0\xb0\xe0\xb0\x82;\xe0\xb0\xac\xe0\xb1\x81\xe0\xb0\xa7\xe0\xb0\xb5\xe0\xb0\xbe"
"\xe0\xb0\xb0\xe0\xb0\x82;\xe0\xb0\x97\xe0\xb1\x81\xe0\xb0\xb0\xe0\xb1\x81\xe0\xb0"
"\xb5\xe0\xb0\xbe\xe0\xb0\xb0\xe0\xb0\x82;\xe0\xb0\xb6\xe0\xb1\x81\xe0\xb0\x95\xe0"
"\xb1\x8d\xe0\xb0\xb0\xe0\xb0\xb5\xe0\xb0\xbe\xe0\xb0\xb0\xe0\xb0\x82;\xe0\xb0\xb6"
"\xe0\xb0\xa8\xe0\xb0\xbf\xe0\xb0\xb5\xe0\xb0\xbe\xe0\xb0\xb0\xe0\xb0\x82;\0"
"\xe0\xb8\xad\xe0\xb8\xb2.;\xe0\xb8\x88.;\xe0\xb8\xad.;\xe0\xb8\x9e.;\xe0\xb8\x9e\xe0"
"\xb8\xa4.;\xe0\xb8\xa8.;\xe0\xb8\xaa.;\0"
"\xe0\xb8\xa7\xe0\xb8\xb1\xe0\xb8\x99\xe0\xb8\xad\xe0\xb8\xb2\xe0\xb8\x97\xe0\xb8\xb4"
"\xe0\xb8\x95\xe0\xb8\xa2\xe0\xb9\x8c;\xe0\xb8\xa7\xe0\xb8\xb1\xe0\xb8\x99\xe0\xb8"
"\x88\xe0\xb8\xb1\xe0\xb8\x99\xe0\xb8\x97\xe0\xb8\xa3\xe0\xb9\x8c;\xe0\xb8\xa7\xe0"
"\xb8\xb1\xe0\xb8\x99\xe0\xb8\xad\xe0\xb8\xb1\xe0\xb8\x87\xe0\xb8\x84\xe0\xb8\xb2\xe0"
"\xb8\xa3;\xe0\xb8\xa7\xe0\xb8\xb1\xe0\xb8\x99\xe0\xb8\x9e\xe0\xb8\xb8\xe0\xb8\x98"
";\xe0\xb8\xa7\xe0\xb8\xb1\xe0\xb8\x99\xe0\xb8\x9e\xe0\xb8\xa4\xe0\xb8\xab\xe0\xb8"
"\xb1\xe0\xb8\xaa\xe0\xb8\x9a\xe0\xb8\x94\xe0\xb8\xb5;\xe0\xb8\xa7\xe0\xb8\xb1\xe0"
"\xb8\x99\xe0\xb8\xa8\xe0\xb8\xb8\xe0\xb8\x81\xe0\xb8\xa3\xe0\xb9\x8c;\xe0\xb8\xa7"
"\xe0\xb8\xb1\xe0\xb8\x99\xe0\xb9\x80\xe0\xb8\xaa\xe0\xb8\xb2\xe0\xb8\xa3\xe0\xb9\x8c"
";\0"
"\xe1\x88\xb0\xe1\x8a\x95\xe1\x89\xa0;\xe1\x88\xb0\xe1\x8a\x91\xe1\x8b\xad;\xe1\x88"
"\xb0\xe1\x88\x89\xe1\x88\xb5;\xe1\x88\xa8\xe1\x89\xa1\xe1\x8b\x95;\xe1\x88\x93\xe1"
"\x88\x99\xe1\x88\xb5;\xe1\x8b\x93\xe1\x88\xad\xe1\x89\xa2;\xe1\x89\x80\xe1\x8b\xb3"
"\xe1\x88\x9d;\0"
"\xe1\x88\xb0\xe1\x8a\x95\xe1\x89\xa0\xe1\x89\xb5;\xe1\x88\xb0\xe1\x8a\x91\xe1\x8b"
"\xad;\xe1\x88\xb0\xe1\x88\x89\xe1\x88\xb5;\xe1\x88\xa8\xe1\x89\xa1\xe1\x8b\x95;\xe1"
"\x88\x93\xe1\x88\x99\xe1\x88\xb5;\xe1\x8b\x93\xe1\x88\xad\xe1\x89\xa2;\xe1\x89\x80"
"\xe1\x8b\xb3\xe1\x88\x9d;\0"
"\xe1\x88\xb0\xe1\x8a\x95\xe1\x89\xa0;\xe1\x88\xb0\xe1\x8a\x91\xe1\x8b\xad;\xe1\x88"
"\xa0\xe1\x88\x89\xe1\x88\xb5;\xe1\x88\xa8\xe1\x89\xa1\xe1\x8b\x95;\xe1\x8a\x83\xe1"
"\x88\x99\xe1\x88\xb5;\xe1\x8b\x93\xe1\x88\xad\xe1\x89\xa2;\xe1\x89\x80\xe1\x8b\xb3"
"\xe1\x88\x9d;\0"
"\xe1\x88\xb0\xe1\x8a\x95\xe1\x89\xa0\xe1\x89\xb5;\xe1\x88\xb0\xe1\x8a\x91\xe1\x8b"
"\xad;\xe1\x88\xa0\xe1\x88\x89\xe1\x88\xb5;\xe1\x88\xa8\xe1\x89\xa1\xe1\x8b\x95;\xe1"
"\x8a\x83\xe1\x88\x99\xe1\x88\xb5;\xe1\x8b\x93\xe1\x88\xad\xe1\x89\xa2;\xe1\x89\x80"
"\xe1\x8b\xb3\xe1\x88\x9d;\0"
"Son;Mus;Bir;Har;Ne;Tlh;Mug;\0"
"Sonto;Musumbhunuku;Ravumbirhi;Ravunharhu;Ravumune;Ravuntlhanu;Mugqivela;\0"
"Paz;Pzt;Sal;\xc3\x87\x61r;Per;Cum;Cmt;\0"
"Pazar;Pazartesi;Sal\xc4\xb1;\xc3\x87\x61r\xc5\x9f\x61mba;Per\xc5\x9f\x65mbe;Cuma;"
"Cumartesi;\0"
"\xd0\x9d\xd0\xb4;\xd0\x9f\xd0\xbd;\xd0\x92\xd1\x82;\xd0\xa1\xd1\x80;\xd0\xa7\xd1\x82"
";\xd0\x9f\xd1\x82;\xd0\xa1\xd0\xb1;\0"
"\xd0\x9d\xd0\xb5\xd0\xb4\xd1\x96\xd0\xbb\xd1\x8f;\xd0\x9f\xd0\xbe\xd0\xbd\xd0\xb5"
"\xd0\xb4\xd1\x96\xd0\xbb\xd0\xbe\xd0\xba;\xd0\x92\xd1\x96\xd0\xb2\xd1\x82\xd0\xbe"
"\xd1\x80\xd0\xbe\xd0\xba;\xd0\xa1\xd0\xb5\xd1\x80\xd0\xb5\xd0\xb4\xd0\xb0;\xd0\xa7"
"\xd0\xb5\xd1\x82\xd0\xb2\xd0\xb5\xd1\x80;\xd0\x9f\xca\xbc\xd1\x8f\xd1\x82\xd0\xbd"
"\xd0\xb8\xd1\x86\xd1\x8f;\xd0\xa1\xd1\x83\xd0\xb1\xd0\xbe\xd1\x82\xd0\xb0;\0"
"\xd0\xaf\xd0\xba\xd1\x88;\xd0\x94\xd1\x83\xd1\x88;\xd0\xa1\xd0\xb5\xd1\x88;\xd0\xa7"
"\xd0\xbe\xd1\x80;\xd0\x9f\xd0\xb0\xd0\xb9;\xd0\x96\xd1\x83\xd0\xbc;\xd0\xa8\xd0\xb0"
"\xd0\xbd;\0"
"\xd1\x8f\xd0\xba\xd1\x88\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb0;\xd0\xb4\xd1\x83\xd1\x88"
"\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb0;\xd1\x81\xd0\xb5\xd1\x88\xd0\xb0\xd0\xbd\xd0\xb1"
"\xd0\xb0;\xd1\x87\xd0\xbe\xd1\x80\xd1\x88\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb0;\xd0\xbf"
"\xd0\xb0\xd0\xb9\xd1\x88\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb0;\xd0\xb6\xd1\x83\xd0\xbc"
"\xd0\xb0;\xd1\x88\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb0;\0"
"CN;Th 2;Th 3;Th 4;Th 5;Th 6;Th 7;\0"
"Ch\xe1\xbb\xa7 nh\xe1\xba\xadt;Th\xe1\xbb\xa9 hai;Th\xe1\xbb\xa9 ba;Th\xe1\xbb\xa9"
" t\xc6\xb0;Th\xe1\xbb\xa9 n\xc4\x83m;Th\xe1\xbb\xa9 s\xc3\xa1u;Th\xe1\xbb\xa9 b\xe1"
"\xba\xa3y;\0"
"Sul;Llun;Maw;Mer;Iau;Gwen;Sad;\0"
"Dydd Sul;Dydd Llun;Dydd Mawrth;Dydd Mercher;Dydd Iau;Dydd Gwener;Dydd Sadwrn;\0"
"Caw;Mvu;Bin;Tha;Sin;Hla;Mgq;\0"
"Cawe;Mvulo;Lwesibini;Lwesithathu;Lwesine;Lwesihlanu;Mgqibelo;\0"
"Aiku;Aje;Isegun;Ojoru;Ojobo;Eti;Abameta;\0"
"Ojoaiku;Ojoaje;Ojoisegun;Ojoru;Ojobo;Ojoeti;Ojoabameta;\0"
"Son;Mso;Bil;Tha;Sin;Hla;Mgq;\0"
"Sonto;Msombuluko;Lwesibili;Lwesithathu;Lwesine;Lwesihlanu;Mgqibelo;\0"
"su;m\xc3\xa5;ty;on;to;fr;la;\0"
"sundag;m\xc3\xa5ndag;tysdag;onsdag;torsdag;fredag;laurdag;\0"
"Ned;Pon;Uto;Sri;\xc4\x8c\x65t;Pet;Sub;\0"
"Nedjelja;Ponedjeljak;Utorak;Srijeda;\xc4\x8c\x65tvrtak;Petak;Subota;\0"
"Jed;Jel;Jem;Jerc;Jerd;Jeh;Jes;\0"
"Jedoonee;Jelhein;Jemayrt;Jercean;Jerdein;Jeheiney;Jesarn;\0"
"Sul;Lun;Mth;Mhr;Yow;Gwe;Sad;\0"
"De Sul;De Lun;De Merth;De Merher;De Yow;De Gwener;De Sadorn;\0"
"Kwe;Dwo;Ben;Wuk;Yaw;Fia;Mem;\0"
"Kwesida;Dwowda;Benada;Wukuda;Yawda;Fida;Memeneda;\0"
"\xe0\xa4\x86\xe0\xa4\xa6\xe0\xa4\xbf\xe0\xa4\xa4\xe0\xa5\x8d\xe0\xa4\xaf\xe0\xa4\xb5"
"\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\xb8\xe0\xa5\x8b\xe0\xa4\xae\xe0\xa4\xb5\xe0\xa4"
"\xbe\xe0\xa4\xb0;\xe0\xa4\xae\xe0\xa4\x82\xe0\xa4\x97\xe0\xa4\xb3\xe0\xa4\xbe\xe0"
"\xa4\xb0;\xe0\xa4\xac\xe0\xa5\x81\xe0\xa4\xa7\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0"
";\xe0\xa4\x97\xe0\xa5\x81\xe0\xa4\xb0\xe0\xa5\x81\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4"
"\xb0;\xe0\xa4\xb6\xe0\xa5\x81\xe0\xa4\x95\xe0\xa5\x8d\xe0\xa4\xb0\xe0\xa4\xb5\xe0"
"\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\xb6\xe0\xa4\xa8\xe0\xa4\xbf\xe0\xa4\xb5\xe0\xa4\xbe"
"\xe0\xa4\xb0;\0"
"Ho;Dzu;Dzf;Sho;Soo;Soh;Ho;\0"
"Hogbaa;Dzu;Dzufo;Sho;Soo;Sohaa;Ho;\0"
"\xe1\xbb\xa4ka;M\xe1\xbb\x8dn;Tiu;Wen;T\xe1\xbb\x8d\xe1\xbb\x8d;Fra\xe1\xbb\x8b;S"
"at;\0"
"Mb\xe1\xbb\x8ds\xe1\xbb\x8b \xe1\xbb\xa4ka;M\xe1\xbb\x8dnde;Tiuzdee;Wenezdee;T\xe1"
"\xbb\x8d\xe1\xbb\x8dzdee;Fra\xe1\xbb\x8b\x64\x65\x65;Sat\xe1\xbb\x8d\x64\x65\x65;"
"\0"
"Jpl;Jtt;Jnn;Jtn;Alh;Ijm;Jms;\0"
"Jumapili;Jumatatu;Jumanne;Jumatano;Alamisi;Ijumaa;Jumamosi;\0"
"\xe1\x88\xb0/\xe1\x89\x85;\xe1\x88\xb0\xe1\x8a\x91;\xe1\x88\xb0\xe1\x88\x8a\xe1\x8c"
"\x9d;\xe1\x88\x88\xe1\x8c\x93;\xe1\x8a\xa3\xe1\x88\x9d\xe1\x8b\xb5;\xe1\x8a\xa3\xe1"
"\x88\xad\xe1\x89\xa5;\xe1\x88\xb0/\xe1\x88\xbd;\0"
"\xe1\x88\xb0\xe1\x8a\x95\xe1\x89\xa0\xe1\x88\xad \xe1\x89\x85\xe1\x8b\xb3\xe1\x8b"
"\x85;\xe1\x88\xb0\xe1\x8a\x91;\xe1\x88\xb0\xe1\x88\x8a\xe1\x8c\x9d;\xe1\x88\x88\xe1"
"\x8c\x93 \xe1\x8b\x88\xe1\x88\xaa \xe1\x88\x88\xe1\x89\xa5\xe1\x8b\x8b;\xe1\x8a\xa3"
"\xe1\x88\x9d\xe1\x8b\xb5;\xe1\x8a\xa3\xe1\x88\xad\xe1\x89\xa5;\xe1\x88\xb0\xe1\x8a"
"\x95\xe1\x89\xa0\xe1\x88\xad \xe1\x88\xbd\xe1\x8c\x93\xe1\x8b\x85;\0"
"\xe1\x8a\xa5\xe1\x8a\x81\xe1\x8b\xb5;\xe1\x88\xb0\xe1\x8a\x91\xe1\x8b\xad;\xe1\x88"
"\xa0\xe1\x88\x89\xe1\x88\xb5;\xe1\x88\xab\xe1\x89\xa5\xe1\x8b\x95;\xe1\x88\x90\xe1"
"\x88\x99\xe1\x88\xb5;\xe1\x8b\x93\xe1\x88\xad\xe1\x89\xa0;\xe1\x89\x80\xe1\x8b\xb3"
"\xe1\x88\x9a;\0"
"\xe1\x8a\xa5\xe1\x8a\x81\xe1\x8b\xb5;\xe1\x88\xb0\xe1\x8a\x91\xe1\x8b\xad;\xe1\x88"
"\xa0\xe1\x88\x89\xe1\x88\xb5;\xe1\x88\xab\xe1\x89\xa5\xe1\x8b\x95;\xe1\x88\x90\xe1"
"\x88\x99\xe1\x88\xb5;\xe1\x8b\x93\xe1\x88\xad\xe1\x89\xa0;\xe1\x89\x80\xe1\x8b\xb3"
"\xe1\x88\x9a\xe1\x89\xb5;\0"
"Lah;Kub;Gba;Tan;Yei;Koy;Sat;\0"
"Lahadi;Je-Kubacha;Je-Gbai;Tansati;Je-Yei;Je-Koye;Sati;\0"
"Sam;San;Mak;Row;Ham;Arb;Qid;\0"
"Sambata;Sanyo;Maakisanyo;Roowe;Hamuse;Arbe;Qidaame;\0"
"Yok;Tung;T. Tung;Tsan;Nas;Nat;Chir;\0"
"Wai Yoka Bawai;Wai Tunga;Toki Gitung;Tsam Kasuwa;Wai Na Nas;Wai Na Tiyon;Wai Na C"
"hirim;\0"
"\xe1\x88\xb0/\xe1\x8b\x93;\xe1\x88\xb0\xe1\x8a\x96;\xe1\x89\xb3\xe1\x88\x8b\xe1\x88"
"\xb8;\xe1\x8a\xa3\xe1\x88\xa8\xe1\x88\xad;\xe1\x8a\xa8\xe1\x88\x9a\xe1\x88\xbd;\xe1"
"\x8c\x85\xe1\x88\x9d\xe1\x8b\x93;\xe1\x88\xb0/\xe1\x8a\x95;\0"
"\xe1\x88\xb0\xe1\x8a\x95\xe1\x89\xa0\xe1\x89\xb5 \xe1\x8b\x93\xe1\x89\xa3\xe1\x8b"
"\xad;\xe1\x88\xb0\xe1\x8a\x96;\xe1\x89\xb3\xe1\x88\x8b\xe1\x88\xb8\xe1\x8a\x96;\xe1"
"\x8a\xa3\xe1\x88\xa8\xe1\x88\xad\xe1\x89\xa3\xe1\x8b\x93;\xe1\x8a\xa8\xe1\x88\x9a"
"\xe1\x88\xbd;\xe1\x8c\x85\xe1\x88\x9d\xe1\x8b\x93\xe1\x89\xb5;\xe1\x88\xb0\xe1\x8a"
"\x95\xe1\x89\xa0\xe1\x89\xb5 \xe1\x8a\x95\xe1\x8a\xa2\xe1\x88\xbd;\0"
"Lad;Lin;Tal;Lar;Lam;Jum;Asa;\0"
"Ladi;Lintani;Talata;Larba;Lamit;Juma;Asabar;\0"
"dom;lun;mar;mie;joi;vin;sab;\0"
"domenie;lunis;martars;miercus;joibe;vinars;sabide;\0"
"Swo;Mus;Vhi;Rar;\xe1\xb9\x8a\x61;\xe1\xb9\xb0\x61n;Mug;\0"
"Swondaha;Musumbuluwo;\xe1\xb8\xbc\x61vhuvhili;\xe1\xb8\xbc\x61vhuraru;\xe1\xb8\xbc"
"\x61vhu\xe1\xb9\x8b\x61;\xe1\xb8\xbc\x61vhu\xe1\xb9\xb1\x61nu;Mugivhela;\0"
"K\xc9\x94s Kwe;Dzo;Bra;Ku\xc9\x96;Yaw;Fi\xc9\x96;Mem;\0"
"K\xc9\x94si\xc9\x96\x61;Dzo\xc9\x96\x61;Bra\xc9\x96\x61;Ku\xc9\x96\x61;Yawo\xc9\x96"
"\x61;Fi\xc9\x96\x61;Memle\xc9\x96\x61;\0"
"LP;P1;P2;P3;P4;P5;P6;\0"
"L\xc4\x81pule;Po\xca\xbb\x61kahi;Po\xca\xbb\x61lua;Po\xca\xbb\x61kolu;Po\xca\xbb\x61"
"h\xc4\x81;Po\xca\xbb\x61lima;Po\xca\xbb\x61ono;\0"
"Lad;Tan;Tal;Lar;Lam;Jum;Asa;\0"
"Ladi;Tanii;Talata;Larba;Lamit;Juma;Asabat;\0"
"Mul;Lem;Wir;Tat;Nai;San;Wer;\0"
"Lamulungu;Lolemba;Lachiwiri;Lachitatu;Lachinayi;Lachisanu;Loweruka;\0"
;

static const char language_name_list[] =
"Default\0"
"C\0"
"Abkhazian\0"
"Afan\0"
"Afar\0"
"Afrikaans\0"
"Albanian\0"
"Amharic\0"
"Arabic\0"
"Armenian\0"
"Assamese\0"
"Aymara\0"
"Azerbaijani\0"
"Bashkir\0"
"Basque\0"
"Bengali\0"
"Bhutani\0"
"Bihari\0"
"Bislama\0"
"Breton\0"
"Bulgarian\0"
"Burmese\0"
"Byelorussian\0"
"Cambodian\0"
"Catalan\0"
"Chinese\0"
"Corsican\0"
"Croatian\0"
"Czech\0"
"Danish\0"
"Dutch\0"
"English\0"
"Esperanto\0"
"Estonian\0"
"Faroese\0"
"Fiji\0"
"Finnish\0"
"French\0"
"Frisian\0"
"Gaelic\0"
"Galician\0"
"Georgian\0"
"German\0"
"Greek\0"
"Greenlandic\0"
"Guarani\0"
"Gujarati\0"
"Hausa\0"
"Hebrew\0"
"Hindi\0"
"Hungarian\0"
"Icelandic\0"
"Indonesian\0"
"Interlingua\0"
"Interlingue\0"
"Inuktitut\0"
"Inupiak\0"
"Irish\0"
"Italian\0"
"Japanese\0"
"Javanese\0"
"Kannada\0"
"Kashmiri\0"
"Kazakh\0"
"Kinyarwanda\0"
"Kirghiz\0"
"Korean\0"
"Kurdish\0"
"Kurundi\0"
"Laothian\0"
"Latin\0"
"Latvian\0"
"Lingala\0"
"Lithuanian\0"
"Macedonian\0"
"Malagasy\0"
"Malay\0"
"Malayalam\0"
"Maltese\0"
"Maori\0"
"Marathi\0"
"Moldavian\0"
"Mongolian\0"
"Nauru\0"
"Nepali\0"
"Norwegian\0"
"Occitan\0"
"Oriya\0"
"Pashto\0"
"Persian\0"
"Polish\0"
"Portuguese\0"
"Punjabi\0"
"Quechua\0"
"RhaetoRomance\0"
"Romanian\0"
"Russian\0"
"Samoan\0"
"Sangho\0"
"Sanskrit\0"
"Serbian\0"
"SerboCroatian\0"
"Sesotho\0"
"Setswana\0"
"Shona\0"
"Sindhi\0"
"Singhalese\0"
"Siswati\0"
"Slovak\0"
"Slovenian\0"
"Somali\0"
"Spanish\0"
"Sundanese\0"
"Swahili\0"
"Swedish\0"
"Tagalog\0"
"Tajik\0"
"Tamil\0"
"Tatar\0"
"Telugu\0"
"Thai\0"
"Tibetan\0"
"Tigrinya\0"
"Tonga\0"
"Tsonga\0"
"Turkish\0"
"Turkmen\0"
"Twi\0"
"Uigur\0"
"Ukrainian\0"
"Urdu\0"
"Uzbek\0"
"Vietnamese\0"
"Volapuk\0"
"Welsh\0"
"Wolof\0"
"Xhosa\0"
"Yiddish\0"
"Yoruba\0"
"Zhuang\0"
"Zulu\0"
"Nynorsk\0"
"Bosnian\0"
"Divehi\0"
"Manx\0"
"Cornish\0"
"Akan\0"
"Konkani\0"
"Ga\0"
"Igbo\0"
"Kamba\0"
"Syriac\0"
"Blin\0"
"Geez\0"
"Koro\0"
"Sidamo\0"
"Atsam\0"
"Tigre\0"
"Jju\0"
"Friulian\0"
"Venda\0"
"Ewe\0"
"Walamo\0"
"Hawaiian\0"
"Tyap\0"
"Chewa\0"
;

static const uint language_name_index[] = {
     0, // Unused
     8, // C
    10, // Abkhazian
    20, // Afan
    25, // Afar
    30, // Afrikaans
    40, // Albanian
    49, // Amharic
    57, // Arabic
    64, // Armenian
    73, // Assamese
    82, // Aymara
    89, // Azerbaijani
   101, // Bashkir
   109, // Basque
   116, // Bengali
   124, // Bhutani
   132, // Bihari
   139, // Bislama
   147, // Breton
   154, // Bulgarian
   164, // Burmese
   172, // Byelorussian
   185, // Cambodian
   195, // Catalan
   203, // Chinese
   211, // Corsican
   220, // Croatian
   229, // Czech
   235, // Danish
   242, // Dutch
   248, // English
   256, // Esperanto
   266, // Estonian
   275, // Faroese
   283, // Fiji
   288, // Finnish
   296, // French
   303, // Frisian
   311, // Gaelic
   318, // Galician
   327, // Georgian
   336, // German
   343, // Greek
   349, // Greenlandic
   361, // Guarani
   369, // Gujarati
   378, // Hausa
   384, // Hebrew
   391, // Hindi
   397, // Hungarian
   407, // Icelandic
   417, // Indonesian
   428, // Interlingua
   440, // Interlingue
   452, // Inuktitut
   462, // Inupiak
   470, // Irish
   476, // Italian
   484, // Japanese
   493, // Javanese
   502, // Kannada
   510, // Kashmiri
   519, // Kazakh
   526, // Kinyarwanda
   538, // Kirghiz
   546, // Korean
   553, // Kurdish
   561, // Kurundi
   569, // Laothian
   578, // Latin
   584, // Latvian
   592, // Lingala
   600, // Lithuanian
   611, // Macedonian
   622, // Malagasy
   631, // Malay
   637, // Malayalam
   647, // Maltese
   655, // Maori
   661, // Marathi
   669, // Moldavian
   679, // Mongolian
   689, // Nauru
   695, // Nepali
   702, // Norwegian
   712, // Occitan
   720, // Oriya
   726, // Pashto
   733, // Persian
   741, // Polish
   748, // Portuguese
   759, // Punjabi
   767, // Quechua
   775, // RhaetoRomance
   789, // Romanian
   798, // Russian
   806, // Samoan
   813, // Sangho
   820, // Sanskrit
   829, // Serbian
   837, // SerboCroatian
   851, // Sesotho
   859, // Setswana
   868, // Shona
   874, // Sindhi
   881, // Singhalese
   892, // Siswati
   900, // Slovak
   907, // Slovenian
   917, // Somali
   924, // Spanish
   932, // Sundanese
   942, // Swahili
   950, // Swedish
   958, // Tagalog
   966, // Tajik
   972, // Tamil
   978, // Tatar
   984, // Telugu
   991, // Thai
   996, // Tibetan
  1004, // Tigrinya
  1013, // Tonga
  1019, // Tsonga
  1026, // Turkish
  1034, // Turkmen
  1042, // Twi
  1046, // Uigur
  1052, // Ukrainian
  1062, // Urdu
  1067, // Uzbek
  1073, // Vietnamese
  1084, // Volapuk
  1092, // Welsh
  1098, // Wolof
  1104, // Xhosa
  1110, // Yiddish
  1118, // Yoruba
  1125, // Zhuang
  1132, // Zulu
  1137, // Nynorsk
  1145, // Bosnian
  1153, // Divehi
  1160, // Manx
  1165, // Cornish
  1173, // Akan
  1178, // Konkani
  1186, // Ga
  1189, // Igbo
  1194, // Kamba
  1200, // Syriac
  1207, // Blin
  1212, // Geez
  1217, // Koro
  1222, // Sidamo
  1229, // Atsam
  1235, // Tigre
  1241, // Jju
  1245, // Friulian
  1254, // Venda
  1260, // Ewe
  1264, // Walamo
  1271, // Hawaiian
  1280, // Tyap
  1285, // Chewa
};

static const char country_name_list[] =
"Default\0"
"Afghanistan\0"
"Albania\0"
"Algeria\0"
"AmericanSamoa\0"
"Andorra\0"
"Angola\0"
"Anguilla\0"
"Antarctica\0"
"AntiguaAndBarbuda\0"
"Argentina\0"
"Armenia\0"
"Aruba\0"
"Australia\0"
"Austria\0"
"Azerbaijan\0"
"Bahamas\0"
"Bahrain\0"
"Bangladesh\0"
"Barbados\0"
"Belarus\0"
"Belgium\0"
"Belize\0"
"Benin\0"
"Bermuda\0"
"Bhutan\0"
"Bolivia\0"
"BosniaAndHerzegowina\0"
"Botswana\0"
"BouvetIsland\0"
"Brazil\0"
"BritishIndianOceanTerritory\0"
"BruneiDarussalam\0"
"Bulgaria\0"
"BurkinaFaso\0"
"Burundi\0"
"Cambodia\0"
"Cameroon\0"
"Canada\0"
"CapeVerde\0"
"CaymanIslands\0"
"CentralAfricanRepublic\0"
"Chad\0"
"Chile\0"
"China\0"
"ChristmasIsland\0"
"CocosIslands\0"
"Colombia\0"
"Comoros\0"
"DemocraticRepublicOfCongo\0"
"PeoplesRepublicOfCongo\0"
"CookIslands\0"
"CostaRica\0"
"IvoryCoast\0"
"Croatia\0"
"Cuba\0"
"Cyprus\0"
"CzechRepublic\0"
"Denmark\0"
"Djibouti\0"
"Dominica\0"
"DominicanRepublic\0"
"EastTimor\0"
"Ecuador\0"
"Egypt\0"
"ElSalvador\0"
"EquatorialGuinea\0"
"Eritrea\0"
"Estonia\0"
"Ethiopia\0"
"FalklandIslands\0"
"FaroeIslands\0"
"Fiji\0"
"Finland\0"
"France\0"
"MetropolitanFrance\0"
"FrenchGuiana\0"
"FrenchPolynesia\0"
"FrenchSouthernTerritories\0"
"Gabon\0"
"Gambia\0"
"Georgia\0"
"Germany\0"
"Ghana\0"
"Gibraltar\0"
"Greece\0"
"Greenland\0"
"Grenada\0"
"Guadeloupe\0"
"Guam\0"
"Guatemala\0"
"Guinea\0"
"GuineaBissau\0"
"Guyana\0"
"Haiti\0"
"HeardAndMcDonaldIslands\0"
"Honduras\0"
"HongKong\0"
"Hungary\0"
"Iceland\0"
"India\0"
"Indonesia\0"
"Iran\0"
"Iraq\0"
"Ireland\0"
"Israel\0"
"Italy\0"
"Jamaica\0"
"Japan\0"
"Jordan\0"
"Kazakhstan\0"
"Kenya\0"
"Kiribati\0"
"DemocraticRepublicOfKorea\0"
"RepublicOfKorea\0"
"Kuwait\0"
"Kyrgyzstan\0"
"Lao\0"
"Latvia\0"
"Lebanon\0"
"Lesotho\0"
"Liberia\0"
"LibyanArabJamahiriya\0"
"Liechtenstein\0"
"Lithuania\0"
"Luxembourg\0"
"Macau\0"
"Macedonia\0"
"Madagascar\0"
"Malawi\0"
"Malaysia\0"
"Maldives\0"
"Mali\0"
"Malta\0"
"MarshallIslands\0"
"Martinique\0"
"Mauritania\0"
"Mauritius\0"
"Mayotte\0"
"Mexico\0"
"Micronesia\0"
"Moldova\0"
"Monaco\0"
"Mongolia\0"
"Montserrat\0"
"Morocco\0"
"Mozambique\0"
"Myanmar\0"
"Namibia\0"
"Nauru\0"
"Nepal\0"
"Netherlands\0"
"NetherlandsAntilles\0"
"NewCaledonia\0"
"NewZealand\0"
"Nicaragua\0"
"Niger\0"
"Nigeria\0"
"Niue\0"
"NorfolkIsland\0"
"NorthernMarianaIslands\0"
"Norway\0"
"Oman\0"
"Pakistan\0"
"Palau\0"
"PalestinianTerritory\0"
"Panama\0"
"PapuaNewGuinea\0"
"Paraguay\0"
"Peru\0"
"Philippines\0"
"Pitcairn\0"
"Poland\0"
"Portugal\0"
"PuertoRico\0"
"Qatar\0"
"Reunion\0"
"Romania\0"
"RussianFederation\0"
"Rwanda\0"
"SaintKittsAndNevis\0"
"StLucia\0"
"StVincentAndTheGrenadines\0"
"Samoa\0"
"SanMarino\0"
"SaoTomeAndPrincipe\0"
"SaudiArabia\0"
"Senegal\0"
"Seychelles\0"
"SierraLeone\0"
"Singapore\0"
"Slovakia\0"
"Slovenia\0"
"SolomonIslands\0"
"Somalia\0"
"SouthAfrica\0"
"SouthGeorgiaAndTheSouthSandwichIslands\0"
"Spain\0"
"SriLanka\0"
"StHelena\0"
"StPierreAndMiquelon\0"
"Sudan\0"
"Suriname\0"
"SvalbardAndJanMayenIslands\0"
"Swaziland\0"
"Sweden\0"
"Switzerland\0"
"SyrianArabRepublic\0"
"Taiwan\0"
"Tajikistan\0"
"Tanzania\0"
"Thailand\0"
"Togo\0"
"Tokelau\0"
"Tonga\0"
"TrinidadAndTobago\0"
"Tunisia\0"
"Turkey\0"
"Turkmenistan\0"
"TurksAndCaicosIslands\0"
"Tuvalu\0"
"Uganda\0"
"Ukraine\0"
"UnitedArabEmirates\0"
"UnitedKingdom\0"
"UnitedStates\0"
"UnitedStatesMinorOutlyingIslands\0"
"Uruguay\0"
"Uzbekistan\0"
"Vanuatu\0"
"VaticanCityState\0"
"Venezuela\0"
"VietNam\0"
"BritishVirginIslands\0"
"USVirginIslands\0"
"WallisAndFutunaIslands\0"
"WesternSahara\0"
"Yemen\0"
"Yugoslavia\0"
"Zambia\0"
"Zimbabwe\0"
"SerbiaAndMontenegro\0"
;

static const uint country_name_index[] = {
     0, // AnyCountry
     8, // Afghanistan
    20, // Albania
    28, // Algeria
    36, // AmericanSamoa
    50, // Andorra
    58, // Angola
    65, // Anguilla
    74, // Antarctica
    85, // AntiguaAndBarbuda
   103, // Argentina
   113, // Armenia
   121, // Aruba
   127, // Australia
   137, // Austria
   145, // Azerbaijan
   156, // Bahamas
   164, // Bahrain
   172, // Bangladesh
   183, // Barbados
   192, // Belarus
   200, // Belgium
   208, // Belize
   215, // Benin
   221, // Bermuda
   229, // Bhutan
   236, // Bolivia
   244, // BosniaAndHerzegowina
   265, // Botswana
   274, // BouvetIsland
   287, // Brazil
   294, // BritishIndianOceanTerritory
   322, // BruneiDarussalam
   339, // Bulgaria
   348, // BurkinaFaso
   360, // Burundi
   368, // Cambodia
   377, // Cameroon
   386, // Canada
   393, // CapeVerde
   403, // CaymanIslands
   417, // CentralAfricanRepublic
   440, // Chad
   445, // Chile
   451, // China
   457, // ChristmasIsland
   473, // CocosIslands
   486, // Colombia
   495, // Comoros
   503, // DemocraticRepublicOfCongo
   529, // PeoplesRepublicOfCongo
   552, // CookIslands
   564, // CostaRica
   574, // IvoryCoast
   585, // Croatia
   593, // Cuba
   598, // Cyprus
   605, // CzechRepublic
   619, // Denmark
   627, // Djibouti
   636, // Dominica
   645, // DominicanRepublic
   663, // EastTimor
   673, // Ecuador
   681, // Egypt
   687, // ElSalvador
   698, // EquatorialGuinea
   715, // Eritrea
   723, // Estonia
   731, // Ethiopia
   740, // FalklandIslands
   756, // FaroeIslands
   769, // Fiji
   774, // Finland
   782, // France
   789, // MetropolitanFrance
   808, // FrenchGuiana
   821, // FrenchPolynesia
   837, // FrenchSouthernTerritories
   863, // Gabon
   869, // Gambia
   876, // Georgia
   884, // Germany
   892, // Ghana
   898, // Gibraltar
   908, // Greece
   915, // Greenland
   925, // Grenada
   933, // Guadeloupe
   944, // Guam
   949, // Guatemala
   959, // Guinea
   966, // GuineaBissau
   979, // Guyana
   986, // Haiti
   992, // HeardAndMcDonaldIslands
  1016, // Honduras
  1025, // HongKong
  1034, // Hungary
  1042, // Iceland
  1050, // India
  1056, // Indonesia
  1066, // Iran
  1071, // Iraq
  1076, // Ireland
  1084, // Israel
  1091, // Italy
  1097, // Jamaica
  1105, // Japan
  1111, // Jordan
  1118, // Kazakhstan
  1129, // Kenya
  1135, // Kiribati
  1144, // DemocraticRepublicOfKorea
  1170, // RepublicOfKorea
  1186, // Kuwait
  1193, // Kyrgyzstan
  1204, // Lao
  1208, // Latvia
  1215, // Lebanon
  1223, // Lesotho
  1231, // Liberia
  1239, // LibyanArabJamahiriya
  1260, // Liechtenstein
  1274, // Lithuania
  1284, // Luxembourg
  1295, // Macau
  1301, // Macedonia
  1311, // Madagascar
  1322, // Malawi
  1329, // Malaysia
  1338, // Maldives
  1347, // Mali
  1352, // Malta
  1358, // MarshallIslands
  1374, // Martinique
  1385, // Mauritania
  1396, // Mauritius
  1406, // Mayotte
  1414, // Mexico
  1421, // Micronesia
  1432, // Moldova
  1440, // Monaco
  1447, // Mongolia
  1456, // Montserrat
  1467, // Morocco
  1475, // Mozambique
  1486, // Myanmar
  1494, // Namibia
  1502, // Nauru
  1508, // Nepal
  1514, // Netherlands
  1526, // NetherlandsAntilles
  1546, // NewCaledonia
  1559, // NewZealand
  1570, // Nicaragua
  1580, // Niger
  1586, // Nigeria
  1594, // Niue
  1599, // NorfolkIsland
  1613, // NorthernMarianaIslands
  1636, // Norway
  1643, // Oman
  1648, // Pakistan
  1657, // Palau
  1663, // PalestinianTerritory
  1684, // Panama
  1691, // PapuaNewGuinea
  1706, // Paraguay
  1715, // Peru
  1720, // Philippines
  1732, // Pitcairn
  1741, // Poland
  1748, // Portugal
  1757, // PuertoRico
  1768, // Qatar
  1774, // Reunion
  1782, // Romania
  1790, // RussianFederation
  1808, // Rwanda
  1815, // SaintKittsAndNevis
  1834, // StLucia
  1842, // StVincentAndTheGrenadines
  1868, // Samoa
  1874, // SanMarino
  1884, // SaoTomeAndPrincipe
  1903, // SaudiArabia
  1915, // Senegal
  1923, // Seychelles
  1934, // SierraLeone
  1946, // Singapore
  1956, // Slovakia
  1965, // Slovenia
  1974, // SolomonIslands
  1989, // Somalia
  1997, // SouthAfrica
  2009, // SouthGeorgiaAndTheSouthSandwichIslands
  2048, // Spain
  2054, // SriLanka
  2063, // StHelena
  2072, // StPierreAndMiquelon
  2092, // Sudan
  2098, // Suriname
  2107, // SvalbardAndJanMayenIslands
  2134, // Swaziland
  2144, // Sweden
  2151, // Switzerland
  2163, // SyrianArabRepublic
  2182, // Taiwan
  2189, // Tajikistan
  2200, // Tanzania
  2209, // Thailand
  2218, // Togo
  2223, // Tokelau
  2231, // Tonga
  2237, // TrinidadAndTobago
  2255, // Tunisia
  2263, // Turkey
  2270, // Turkmenistan
  2283, // TurksAndCaicosIslands
  2305, // Tuvalu
  2312, // Uganda
  2319, // Ukraine
  2327, // UnitedArabEmirates
  2346, // UnitedKingdom
  2360, // UnitedStates
  2373, // UnitedStatesMinorOutlyingIslands
  2406, // Uruguay
  2414, // Uzbekistan
  2425, // Vanuatu
  2433, // VaticanCityState
  2450, // Venezuela
  2460, // VietNam
  2468, // BritishVirginIslands
  2489, // USVirginIslands
  2505, // WallisAndFutunaIslands
  2528, // WesternSahara
  2542, // Yemen
  2548, // Yugoslavia
  2559, // Zambia
  2566, // Zimbabwe
  2575, // SerbiaAndMontenegro
};

static const unsigned char language_code_list[] =
"  \0" // Unused
"  \0" // C
"ab\0" // Abkhazian
"om\0" // Afan
"aa\0" // Afar
"af\0" // Afrikaans
"sq\0" // Albanian
"am\0" // Amharic
"ar\0" // Arabic
"hy\0" // Armenian
"as\0" // Assamese
"ay\0" // Aymara
"az\0" // Azerbaijani
"ba\0" // Bashkir
"eu\0" // Basque
"bn\0" // Bengali
"dz\0" // Bhutani
"bh\0" // Bihari
"bi\0" // Bislama
"br\0" // Breton
"bg\0" // Bulgarian
"my\0" // Burmese
"be\0" // Byelorussian
"km\0" // Cambodian
"ca\0" // Catalan
"zh\0" // Chinese
"co\0" // Corsican
"hr\0" // Croatian
"cs\0" // Czech
"da\0" // Danish
"nl\0" // Dutch
"en\0" // English
"eo\0" // Esperanto
"et\0" // Estonian
"fo\0" // Faroese
"fj\0" // Fiji
"fi\0" // Finnish
"fr\0" // French
"fy\0" // Frisian
"gd\0" // Gaelic
"gl\0" // Galician
"ka\0" // Georgian
"de\0" // German
"el\0" // Greek
"kl\0" // Greenlandic
"gn\0" // Guarani
"gu\0" // Gujarati
"ha\0" // Hausa
"he\0" // Hebrew
"hi\0" // Hindi
"hu\0" // Hungarian
"is\0" // Icelandic
"id\0" // Indonesian
"ia\0" // Interlingua
"ie\0" // Interlingue
"iu\0" // Inuktitut
"ik\0" // Inupiak
"ga\0" // Irish
"it\0" // Italian
"ja\0" // Japanese
"jv\0" // Javanese
"kn\0" // Kannada
"ks\0" // Kashmiri
"kk\0" // Kazakh
"rw\0" // Kinyarwanda
"ky\0" // Kirghiz
"ko\0" // Korean
"ku\0" // Kurdish
"rn\0" // Kurundi
"lo\0" // Laothian
"la\0" // Latin
"lv\0" // Latvian
"ln\0" // Lingala
"lt\0" // Lithuanian
"mk\0" // Macedonian
"mg\0" // Malagasy
"ms\0" // Malay
"ml\0" // Malayalam
"mt\0" // Maltese
"mi\0" // Maori
"mr\0" // Marathi
"mo\0" // Moldavian
"mn\0" // Mongolian
"na\0" // Nauru
"ne\0" // Nepali
"nb\0" // Norwegian
"oc\0" // Occitan
"or\0" // Oriya
"ps\0" // Pashto
"fa\0" // Persian
"pl\0" // Polish
"pt\0" // Portuguese
"pa\0" // Punjabi
"qu\0" // Quechua
"rm\0" // RhaetoRomance
"ro\0" // Romanian
"ru\0" // Russian
"sm\0" // Samoan
"sg\0" // Sangho
"sa\0" // Sanskrit
"sr\0" // Serbian
"sh\0" // SerboCroatian
"st\0" // Sesotho
"tn\0" // Setswana
"sn\0" // Shona
"sd\0" // Sindhi
"si\0" // Singhalese
"ss\0" // Siswati
"sk\0" // Slovak
"sl\0" // Slovenian
"so\0" // Somali
"es\0" // Spanish
"su\0" // Sundanese
"sw\0" // Swahili
"sv\0" // Swedish
"tl\0" // Tagalog
"tg\0" // Tajik
"ta\0" // Tamil
"tt\0" // Tatar
"te\0" // Telugu
"th\0" // Thai
"bo\0" // Tibetan
"ti\0" // Tigrinya
"to\0" // Tonga
"ts\0" // Tsonga
"tr\0" // Turkish
"tk\0" // Turkmen
"tw\0" // Twi
"ug\0" // Uigur
"uk\0" // Ukrainian
"ur\0" // Urdu
"uz\0" // Uzbek
"vi\0" // Vietnamese
"vo\0" // Volapuk
"cy\0" // Welsh
"wo\0" // Wolof
"xh\0" // Xhosa
"yi\0" // Yiddish
"yo\0" // Yoruba
"za\0" // Zhuang
"zu\0" // Zulu
"nn\0" // Nynorsk
"bs\0" // Bosnian
"dv\0" // Divehi
"gv\0" // Manx
"kw\0" // Cornish
"ak\0" // Akan
"kok" // Konkani
"gaa" // Ga
"ig\0" // Igbo
"kam" // Kamba
"syr" // Syriac
"byn" // Blin
"gez" // Geez
"kfo" // Koro
"sid" // Sidamo
"cch" // Atsam
"tig" // Tigre
"kaj" // Jju
"fur" // Friulian
"ve\0" // Venda
"ee\0" // Ewe
"wa\0" // Walamo
"haw" // Hawaiian
"kcg" // Tyap
"ny\0" // Chewa
;

static const unsigned char country_code_list[] =
"  " // AnyCountry
"AF" // Afghanistan
"AL" // Albania
"DZ" // Algeria
"AS" // AmericanSamoa
"AD" // Andorra
"AO" // Angola
"AI" // Anguilla
"AQ" // Antarctica
"AG" // AntiguaAndBarbuda
"AR" // Argentina
"AM" // Armenia
"AW" // Aruba
"AU" // Australia
"AT" // Austria
"AZ" // Azerbaijan
"BS" // Bahamas
"BH" // Bahrain
"BD" // Bangladesh
"BB" // Barbados
"BY" // Belarus
"BE" // Belgium
"BZ" // Belize
"BJ" // Benin
"BM" // Bermuda
"BT" // Bhutan
"BO" // Bolivia
"BA" // BosniaAndHerzegowina
"BW" // Botswana
"BV" // BouvetIsland
"BR" // Brazil
"IO" // BritishIndianOceanTerritory
"BN" // BruneiDarussalam
"BG" // Bulgaria
"BF" // BurkinaFaso
"BI" // Burundi
"KH" // Cambodia
"CM" // Cameroon
"CA" // Canada
"CV" // CapeVerde
"KY" // CaymanIslands
"CF" // CentralAfricanRepublic
"TD" // Chad
"CL" // Chile
"CN" // China
"CX" // ChristmasIsland
"CC" // CocosIslands
"CO" // Colombia
"KM" // Comoros
"CD" // DemocraticRepublicOfCongo
"CG" // PeoplesRepublicOfCongo
"CK" // CookIslands
"CR" // CostaRica
"CI" // IvoryCoast
"HR" // Croatia
"CU" // Cuba
"CY" // Cyprus
"CZ" // CzechRepublic
"DK" // Denmark
"DJ" // Djibouti
"DM" // Dominica
"DO" // DominicanRepublic
"TL" // EastTimor
"EC" // Ecuador
"EG" // Egypt
"SV" // ElSalvador
"GQ" // EquatorialGuinea
"ER" // Eritrea
"EE" // Estonia
"ET" // Ethiopia
"FK" // FalklandIslands
"FO" // FaroeIslands
"FJ" // Fiji
"FI" // Finland
"FR" // France
"FX" // MetropolitanFrance
"GF" // FrenchGuiana
"PF" // FrenchPolynesia
"TF" // FrenchSouthernTerritories
"GA" // Gabon
"GM" // Gambia
"GE" // Georgia
"DE" // Germany
"GH" // Ghana
"GI" // Gibraltar
"GR" // Greece
"GL" // Greenland
"GD" // Grenada
"GP" // Guadeloupe
"GU" // Guam
"GT" // Guatemala
"GN" // Guinea
"GW" // GuineaBissau
"GY" // Guyana
"HT" // Haiti
"HM" // HeardAndMcDonaldIslands
"HN" // Honduras
"HK" // HongKong
"HU" // Hungary
"IS" // Iceland
"IN" // India
"ID" // Indonesia
"IR" // Iran
"IQ" // Iraq
"IE" // Ireland
"IL" // Israel
"IT" // Italy
"JM" // Jamaica
"JP" // Japan
"JO" // Jordan
"KZ" // Kazakhstan
"KE" // Kenya
"KI" // Kiribati
"KP" // DemocraticRepublicOfKorea
"KR" // RepublicOfKorea
"KW" // Kuwait
"KG" // Kyrgyzstan
"LA" // Lao
"LV" // Latvia
"LB" // Lebanon
"LS" // Lesotho
"LR" // Liberia
"LY" // LibyanArabJamahiriya
"LI" // Liechtenstein
"LT" // Lithuania
"LU" // Luxembourg
"MO" // Macau
"MK" // Macedonia
"MG" // Madagascar
"MW" // Malawi
"MY" // Malaysia
"MV" // Maldives
"ML" // Mali
"MT" // Malta
"MH" // MarshallIslands
"MQ" // Martinique
"MR" // Mauritania
"MU" // Mauritius
"YT" // Mayotte
"MX" // Mexico
"FM" // Micronesia
"MD" // Moldova
"MC" // Monaco
"MN" // Mongolia
"MS" // Montserrat
"MA" // Morocco
"MZ" // Mozambique
"MM" // Myanmar
"NA" // Namibia
"NR" // Nauru
"NP" // Nepal
"NL" // Netherlands
"AN" // NetherlandsAntilles
"NC" // NewCaledonia
"NZ" // NewZealand
"NI" // Nicaragua
"NE" // Niger
"NG" // Nigeria
"NU" // Niue
"NF" // NorfolkIsland
"MP" // NorthernMarianaIslands
"NO" // Norway
"OM" // Oman
"PK" // Pakistan
"PW" // Palau
"PS" // PalestinianTerritory
"PA" // Panama
"PG" // PapuaNewGuinea
"PY" // Paraguay
"PE" // Peru
"PH" // Philippines
"PN" // Pitcairn
"PL" // Poland
"PT" // Portugal
"PR" // PuertoRico
"QA" // Qatar
"RE" // Reunion
"RO" // Romania
"RU" // RussianFederation
"RW" // Rwanda
"KN" // SaintKittsAndNevis
"LC" // StLucia
"VC" // StVincentAndTheGrenadines
"WS" // Samoa
"SM" // SanMarino
"ST" // SaoTomeAndPrincipe
"SA" // SaudiArabia
"SN" // Senegal
"SC" // Seychelles
"SL" // SierraLeone
"SG" // Singapore
"SK" // Slovakia
"SI" // Slovenia
"SB" // SolomonIslands
"SO" // Somalia
"ZA" // SouthAfrica
"GS" // SouthGeorgiaAndTheSouthSandwichIslands
"ES" // Spain
"LK" // SriLanka
"SH" // StHelena
"PM" // StPierreAndMiquelon
"SD" // Sudan
"SR" // Suriname
"SJ" // SvalbardAndJanMayenIslands
"SZ" // Swaziland
"SE" // Sweden
"CH" // Switzerland
"SY" // SyrianArabRepublic
"TW" // Taiwan
"TJ" // Tajikistan
"TZ" // Tanzania
"TH" // Thailand
"TG" // Togo
"TK" // Tokelau
"TO" // Tonga
"TT" // TrinidadAndTobago
"TN" // Tunisia
"TR" // Turkey
"TM" // Turkmenistan
"TC" // TurksAndCaicosIslands
"TV" // Tuvalu
"UG" // Uganda
"UA" // Ukraine
"AE" // UnitedArabEmirates
"GB" // UnitedKingdom
"US" // UnitedStates
"UM" // UnitedStatesMinorOutlyingIslands
"UY" // Uruguay
"UZ" // Uzbekistan
"VU" // Vanuatu
"VA" // VaticanCityState
"VE" // Venezuela
"VN" // VietNam
"VG" // BritishVirginIslands
"VI" // USVirginIslands
"WF" // WallisAndFutunaIslands
"EH" // WesternSahara
"YE" // Yemen
"YU" // Yugoslavia
"ZM" // Zambia
"ZW" // Zimbabwe
"CS" // SerbiaAndMontenegro
;

#endif
